; environment.scm
;
; Defines the global environment of the substitution model.
;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                        ;;;
;;; The Global Environment ;;;
;;;                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define the-global-environment

;  math
  '((+ <<+>>)                  (- <<->>)                 (* <<*>>)
   (/ <</>>)                   (= <<=>>)                 (< <<_<_>>) 
   (> <<_>_>>)                 (>= <<_>=_>>)             (<= <<_<=_>>)
   (1+ <<1+>>)                 (-1+ <<-1+>>)

   (sqrt <<sqrt>>)             (expt <<expt>>)           (round <<round>>)
   (abs <<abs>>)               (gcd <<gcd>>)             (max <<max>>) 
   (min <<min>>)               (zero? <<zero?>>)         (positive? <<positive?>>)
   (negative? <<negative?>>)   (odd? <<odd?>>)           (even? <<even?>>) 
   (exp <<exp>>)               (log <<log>>)             (sin <<sin>>)
   (cos <<cos>>)               (tan <<tan>>)             (asin <<asin>>)
   (acos <<acos>>)             (atan <<atan>>)           (quotient <<quotient>>)

;  logic
   (not <<not>>)       

;  predicates
   (equal? <<equal?>>)         (boolean? <<boolean?>>)   (symbol? <<symbol?>>)
   (char? <<char?>>)           (pair? <<pair?>>)         (number? <<number?>>)
   (procedure? <<procedure?>>) (list? <<list?>>)
   
;  list-related
   (car <<car>>)               (cdr <<cdr>>)             (cons <<cons>>)
   (list <<list>>)             (null? <<null?>>)         (length <<length>>)   
   (append <<append>>)         (reverse <<reverse>>)     (list-tail <<list-tail>>)
   (list-ref <<list-ref>>)     (member <<member>>)       (assoc <<assoc>>)
   (delete <<delete>>)         (map <<map>>)             (nil #())
   (apply <<apply>>)

;  stringops

   (string? <<string?>>)       (make-string <<make-string>>)
   (string <<string>>)         (string-length <<string-length>>)
   (string-ref <<string-ref>>) (string=? <<string=?>>)   (string<? <<string<?>>)
   (string>? <<string>?>>)     (string<=? <<string<=?>>) (string>=? <<string>=?>>)
   (string-ci=? <<string-ci=?>>)    (string-ci<? <<string-ci<?>>)
   (string-ci>? <<string-ci>?>>)    (string-ci<=? <<string-ci<=?>>)
   (string-ci>=? <<string-ci>=?>>)
   (substring <<substring>>)   (string-append <<string-append>>)
   (string->list <<string->list>>)  (list->string <<list->string>>)

;  side-fx
   (display <<display>>)       (newline <<newline>>)     (error <<error>>)))
; The following definitions are used to define our 
; primitive procedure objects (denoted by angle brackets)

(define <<list>> (lambda lst (if (nil-builtin? lst) '() (apply list lst))))
(define <<cons>> cons)
(define <<error>> (lambda z (apply sm-error z)))
(define <<display>> (lambda (x) (begin (display x) undefined-value)))
(define <<newline>> (lambda ()(begin (newline) undefined-value)))
(define <<+>> +)
(define <<->> -)
(define <<*>> *)
(define <</>> /)
(define <<=>> =)
(define <<_<_>> <)
(define <<_>_>> >)
(define <<_>=_>> >=)
(define <<_<=_>> <=)
(define <<1+>> 1+)
(define <<-1+>> -1+)
(define <<quotient>> quotient)
(define <<sqrt>> sqrt)
(define <<expt>> expt)
(define <<round>> round)
(define <<abs>> abs)
(define <<gcd>> gcd)
(define <<max>> max)
(define <<min>> min)
(define <<zero?>> zero?)
(define <<positive?>> positive?)
(define <<negative?>> negative?)
(define <<odd?>> odd?)
(define <<even?>> even?)
(define <<exp>> exp)
(define <<log>> log)
(define <<sin>> sin)
(define <<cos>> cos)
(define <<tan>> tan)
(define <<asin>> asin)
(define <<acos>> acos)
(define <<atan>> atan)
(define <<not>> not)
(define <<eqv?>> eqv?)
(define <<eq?>> eq?)
(define <<boolean?>> boolean?)
(define <<symbol?>> symbol?)
(define <<char?>> char?)
(define <<number?>> number?)
(define <<procedure?>> procedure?)      
(define <<length>> length)
(define <<pair?>> pair?)
(define (<<map>> proc lst) (if (nil-builtin? lst) '() (map proc lst)))
(define (<<append>> l1 l2) (append (if (nil-builtin? l1) '() l1) (if (nil-builtin? l2) '() l2)))
(define <<delete>> delete)              ;REVISE these definable listops similarly:
(define <<reverse>> reverse)
(define <<list-tail>> list-tail)
(define <<list-ref>> list-ref)
(define <<member>> member)
(define <<assoc>> assoc)               ;;REVISE to here
(define <<string?>> string?)
(define <<make-string>> make-string)
(define <<string>> string)
(define <<string-length>> string-length)
(define <<string-ref>> string-ref) 
(define <<string=?>> string=?)
(define <<string<?>> string<?)
(define <<string>?>> string>?)
(define <<string<=?>> string<=?)
(define <<string>=?>> string>=?)
(define <<string-ci=?>> string-ci=?)
(define <<string-ci<?>> string-ci<?)
(define <<string-ci>?>> string-ci>?)
(define <<string-ci<=?>> string-ci<=?)
(define <<string-ci>=?>> string-ci>=?)
(define <<substring>> substring)
(define <<string-append>> string-append)
(define <<string->list>> string->list)
(define <<list->string>> list->string)

(define null?-def
  '(lambda (exp) (<<equal?>> exp #())))

(define append-def
  '(lambda (l1 l2)
    (if (<<null?>> l1)
        l2
        (<<cons>> (<<car>> l1) (<<append>> (<<cdr>> l1) l2)))))

(define delete-def
  '(lambda (lst sym)
    (cond ((<<null?>> lst) #())
          ((<<equal?>> (<<car>> lst) sym)
           (<<delete>> (<<cdr>> lst) sym))
          (else
           (<<cons>> (<<car>> lst) (<<delete>> (<<cdr>> lst) sym))))))

(define reverse-def
  '(lambda (lst)
    (if
     (<<null?>> lst)
     #()
     (<<append>> (<<reverse>> (<<cdr>> lst)) (<<list>> (<<car>> lst))))))

(define list-ref-def
  '(lambda (lst index)
    (<<car>> (<<list-tail>> lst index))))

(define list-tail-def
  '(lambda (lst index)
    (if (<<zero?>> index)
        (car lst)
        (<<list-tail>> (<<cdr>> lst) (<<-1+>> index)))))

(define map-def
  '(lambda (f lst)
     (if (<<null?>> lst)
         #()
         (<<cons>> (f (<<car>> lst))
                   (<<map>> f (<<cdr>> lst))))))

(define (definable-op? exp)
  (memq (car exp) definable-ops))

(define definable-ops '(<<append>> <<map>> <<delete>>
	      <<reverse>> <<list-ref>> <<list-tail>>))
;; <<member>> <<assoc>>  REVISE?: add these, maybe appendmap too

(define (definable-op-expand exp)
  (cons
   (case (car exp)
     ((<<append>>) append-def)
     ((<<delete>>) delete-def)
     ((<<reverse>>) reverse-def)
     ((<<list-ref>>) list-ref-def)
     ((<<list-tail>>) list-tail-def)
     ((<<map>>) map-def))
   (cdr exp)))
;REVISE: add <<member>> <<assoc>>, or maybe drop them all exceot for map


;;; RULE-DEFINED LIST OPERATIONS
;;; These operators mimic certain primitive list
;;; operators, necessitated by our different
;;; representations of lists and cons pairs.

(define (rule-defined-listop? exp)
  (memq (car exp) rule-defined-listops))

(define rule-defined-listops
  '(<<cons>> <<list>> <<car>> <<cdr>> <<apply>>
    <<list?>> <<null?>> <<boolean?>> <<equal?>>))
 
(define (apply-rule-defined-listop exp)
  (case (car exp)
    ((<<cons>>) (applycons exp))
    ((<<list>>) (applylist exp))
    ((<<car>>) (applycar (cadr exp)))
    ((<<cdr>>) (applycdr (cadr exp)))
    ((<<apply>>) (applyapply exp))
    ((<<list?>>)
     (cond ((not (= (length exp) 2))
	    (sm-error "ERROR: Wrong number of arguments passed to <<list?>>" exp))
	   (else (or (listexp? (cadr exp))
		     (nil-builtin? (cadr exp))))))
    ((<<null?>>)
     (cond ((not (= (length exp) 2))
	    (sm-error "ERROR: <<null?>> takes one arg" exp))
	   (else (nil-builtin? (cadr exp)))))
    ((<<boolean?>>)
     (cond ((not (= (length exp) 2))
	    (sm-error "ERROR: <<boolean?>> takes one arg"
		   exp))
	   (else (and (boolean? (cadr exp))
		      (not (nil-builtin? (cadr exp)))))))
    ((<<equal?>>)
     (if (not (= (length exp) 3))
	 (sm-error "ERROR: <<equal?>> takes 2 args" exp)
	 (let ((x (cadr exp))
	       (y (caddr exp)))
	   (cond ((and (number? x)
		       (number? y))
		  (= x y))
		 (else (equal? x y))))))))


  

; CONS-APPLY and LIST-APPLY

(define (consexp? exp) 
  (tagged-list? exp '<<cons>>))

(define (listexp? exp)
  (tagged-list? exp '<<list>>))

(define (applycons cons-exp)
  (cond ((not (= 3 (length cons-exp)))
	 (sm-error "ERROR: <<cons>> takes 2 args"
		cons-exp))
	((listexp? (caddr cons-exp))
	 (set! display-variable #t)
	 (cons '<<list>> (cons (cadr cons-exp) (cdaddr cons-exp))))
	((nil-builtin? (caddr cons-exp))
	 (set! display-variable #t)
	 (list '<<list>> (cadr cons-exp)))
	(else cons-exp)))

(define (applylist list-exp)
  (set! display-variable #f)
  (if (equal? list-exp '(<<list>>))
      nil-builtin
      list-exp))

; CAR AND CDR

(define (carexp? exp)
  (tagged-list? exp '<<car>>))

(define (cdrexp? exp)
  (tagged-list? exp '<<cdr>>))

(define (applycar car-exp)
  (cond ((or (consexp? car-exp) (listexp? car-exp))
	 (cadr car-exp))
	(else (sm-error "ERROR: <<car>> arg not a pair" car-exp))))

(define (applycdr cdr-exp)
  (cond ((consexp? cdr-exp)
	 (caddr cdr-exp))
	((listexp? cdr-exp)
	 (cons '<<list>> (cddr cdr-exp)))
	(else (sm-error "ERROR: <<cdr>> arg not a pair" cdr-exp))))

; APPLY

(define (applyapply exp)
  (let ((arglist (arglist-apply exp)))
    (cond ((not (listexp? arglist))
	 (sm-error "ERROR: <<apply>> nonlist 2nd arg" arglist))
	(else (cons (procedure-apply exp) (cdr arglist))))))

; ANGLED-PRIMITIVE? checks an expression to see if it is
; one of our model's primitive procedure objects
;
(define (angled-primitive? exp)
  (and (symbol? exp)
       (let* ((str (symbol->string exp))
	      (len (string-length str)))
	 (and (string=? (string-tail str (- len 2)) ">>")
	      (string=? (substring str 0 2) "<<")))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
; lookup a variable in the global environment                          ;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (lookup var)
  (let ((binding (assq var the-global-environment)))
    (if binding
        (cadr binding)
        (call/cc
         (lambda(c)
           (newline)
           (display "Unbound variable: ")
           (display var)
           (driver-loop))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
; Change or add a binding to the global environments.                  ;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (do-bindings def-variable def-value)
  (let ((assn1 (assq def-variable the-global-environment)))
    (if assn1
        (set-car! (cdr assn1) def-value)
        (let ((binding (list def-variable def-value)))
          (set! the-global-environment
                (cons binding the-global-environment))))))
