// This may look like C code, but it is really -*- C++ -*-

#include "cellList.h"

#ifndef SPACE_SAVER
void cellList::insert( Cell *cell, PointList* boundary, int contactLength,
		      FPoint directionToNeighbor)
{ //Add to the back of the list, if it does not already exist in the list

  neighborInfo* tmp = startOfList;

  // traverse list
  while (tmp != NULL)
    if ( tmp->cell != cell)
      tmp=tmp->next;
    else {  // if neighbor already present in list
      tmp->contact += contactLength;
      tmp->directionToNeighbor += directionToNeighbor;
      // The direction to neighbor gets screwed up here, may get doubled if
      // there is only one boundary point
      // see if the two boundaries wraparound
      if ( boundary->getLastPoint() == tmp->boundary->getFirstPoint() ) { 
	// wraparound
	// delete the duplicate element
	tmp->boundary->delget();
	if (! tmp->boundary->contiguous()) // >1 chunk of boundary
	  tmp->direction += boundary->perpendicular();
	boundary->append( *tmp->boundary);
	delete tmp->boundary;
	tmp->boundary = boundary;
	if (tmp->boundary->contiguous()) 
	  tmp->direction = tmp->boundary->perpendicular();
      }
      else {// 2 disjoint segments
	tmp->direction += boundary->perpendicular();
	tmp->boundary->append( *boundary); 
	delete boundary;
      }
      if ( tmp->direction == FPoint(0,0)) tmp->direction = directionToNeighbor;
      if ( tmp->direction == FPoint(0,0))error(":zero direction to neighbor ");
      return;
    }

  // if neighbor not present in list
  neighborInfo *pc = new neighborInfo( cell);
  pc->contact = contactLength;
  pc->boundary = boundary;
  pc->directionToNeighbor = directionToNeighbor;
  pc->direction = boundary->perpendicular();
  if ( pc->direction == FPoint(0,0))  pc->direction = directionToNeighbor;
  if ( pc->direction == FPoint(0,0))  error(" zero direction to neighbor ");
  // If the boundary is a single contact point, then impossible to determine
  // perpendicular but in that case directionToNeighbor has the CORRECT value
  if ( startOfList == 0) 
    {startOfList = end = list = pc;}
  else
    {end->next = pc;  end=pc; }
  end->next = (neighborInfo *) NULL;
}

neighborInfo* cellList::nextItemInList()
{
  // storage is not returned
  if ( !emptyList() ){
    neighborInfo* temp = list;
    list = list->next;
    return( temp);
  }
  else {
    error("error in cellList::nextItemInList, attempt to delete item from\
empty list"); 
    return (new neighborInfo( 0)); // dummy return to avoid return value
				   // warning 
  }
}

void
cellList::display( ostream& s) const
{
  neighborInfo *temp = startOfList;
  s << "Start: ";
  while (temp!=0) {
    s << " N:" << temp->cell->cellNumber << " d: " << temp->direction << 
	" dTN: " << temp->directionToNeighbor; 
    temp->boundary->display( s);
    temp=temp->next;
  }
}

cellList::cellList(const cellList& cl)
{
  startOfList = cl.startOfList;
  list = cl.list;
  end = cl.end;
}

void
neighborInfo::print(ostream& s)
{
  s << cell->cellNumber << ": contact = " << contact << ", direction = " <<
    direction << directionToNeighbor << '\n';
  cell->printInfo();
}

#endif SPACE_SAVER (not)
