// This may look like C code, but it is really -*- C++ -*-
#ifndef POINT_H
#define POINT_H
#ifdef __GNUG__
#pragma interface
#endif
#include "header.h"

class Point{
friend class PointList;
friend class FPoint;
public:
  Point(int x1, int y1) { x_ = x1; y_ = y1; next = (Point *)NULL;}
  Point(const Point& p) {  x_ = p.x_; y_ = p.y_; next = (Point *)NULL;}
//  Point( class FPoint p) {x_ = floatToInt( p.x) y_ = floatToInt( p.y); next = (Point *)NULL;}
  Point() {x_ = y_ = 0; next = (Point *)NULL;}
  ~Point() {}
//  Point& operator=( const Point& p) //a bitwise copy is fine 
  void zeroPoint() { x_ = y_ = 0;} // sets point to (0,0)
  friend Point random6Direction(); // Find a random direction from the 6
				  // possible ones
  class FPoint directionFloat(Point p) const;
    // returns the point  p as a floating point, wrt to the Point
  // thus (2,2).directionFloat( (1,3)) = (1.5,2+sin60/2)
  class FPoint relDirectionFloat(Point p) const;
    // returns the Point - p as a floating point
  // thus (2,2).reldirectionFloat( (1,3)) = (0.5,sin60/2)
  void print( ostream& s = cout) const 
    {s << '('  << x_ << ',' << y_ << ')';}
  void display( ostream& s = cout) const 
    {s << '('  << x_ << ',' << y_ << ')'<<'\n';}
  int arrayindex(Int width) const {return( y_ * width + x_ );}
  // Returns the index into the array with width of point (x,y)  
  Point nextPointInRotation( Point p);
   // Returns the next point in rotation of the vector Point->p
   // a & b must be neighbors
  bool ifNeighbor(Point p);  // Check if point p is a neighbor
  void swap( Point& p); // swap contents with point p, except for next pointer
  friend ostream& operator<<( ostream& s, const Point& p)
    { return s << '(' << p.x_ << ',' << p.y_ << ')' ; }
  friend int operator!=( const Point a, const Point b) 
    {return ((a.x_ != b.x_) || (a.y_ != b.y_));}
  friend int operator==( const Point a, const Point b) 
    {return ((a.x_ == b.x_) && (a.y_ == b.y_));}
  Point& operator/=(const Point p) { x_ /= p.x_; y_ /= p.y_; return *this;}
  Point& operator-=(const Point& p) { x_ -= p.x_; y_ -= p.y_; return *this;}
  Point& operator+=(const Point& p) { x_ += p.x_; y_ += p.y_; return *this;}
  friend Point operator-(Point p) //unary minus
    { return Point( -p.x_, -p.y_);}
  friend Point operator-(Point a, Point b) //binary minus
    { return Point( a.x_ - b.x_, a.y_ - b.y_);}
  friend Point operator+(Point a, Point b) // plus
    { return Point( a.x_ + b.x_, a.y_ + b.y_);}
  friend Point operator*( Point p, int k) // scaling
    { return Point( k * p.x_, k * p.y_);}
  friend Point operator*( int k, Point p) // scaling
    { return Point( k * p.x_, k * p.y_);}
  friend Point operator/( Point p, int k) // scaling
    { return Point( p.x_ / k, p.y_ / k);}
  int dotProduct( Point p) // dot product
    { return (x_ * p.x_ + y_ * p.y_); }
  long distanceSquared( Point p) // gives the square of the distance between
                          // the point and p
    { return ( (x_ - p.x_) * (x_ - p.x_) + (y_ - p.y_) * (y_-p.y_));}
  Point perpendicular()
    // rotate anticlockwise by 90 (cos sin; -sin cos)
    { return ( Point( -y_, x_ ));}
  void saveState( ostream& s);
  void recoverState( istream& s);

private:
  int x_, y_;
  Point *next;

};

class PointList{
public:
  PointList(Int x, Int y) { end = list = new Point(x,y);}
  PointList( Point p) { end = list = new Point(p);}
  PointList() { list = end = (Point *)NULL;}
  ~PointList();
  PointList(const PointList& pl);
  void addNeighbors(const Point&); 
  // appends to the point list all the neighbors of the point 
  void addNeighborsInReverse(const Point&); 
  // appends to the point list all the neighbors of the point in reverse order
  void addNonDuplicateNeighbors(const Point&); 
  // appends to the point list all the neighbors of the point, not already in
  // the list 
  void insert(Int , Int);
  void insert(const Point& p) { insert(p.x_,p.y_);}
  bool insertNonDuplicate(const Point&); // return true if it increased length
					 // of list 
  Point delget();  // delete and return front of list 
  bool emptyList() const { if (list == 0) return TRUE; else return FALSE;} // Is the list empty;
  void display( ostream& s = cout)  const; // Display the list
  Point middle() const; // returns the middle element of the list
  int length() const; // returns the length of the list
  PointList& operator=(const PointList& pl);
  void empty() { deleteList();}
  void deleteList();
  void append(const PointList&);
  bool contiguous(); // Are the points in the list neighborly in turn?
  FPoint perpendicular(); // Find the perpendicular to the given adjoining list
			 // of points
  Point getFirstPoint() {
    if (!emptyList()) return ( *list); 
    else {error("get first point"); return Point(0,0);}
  }
  Point getLastPoint() {
    if (!emptyList()) return ( *end);
    else {error("get last point"); return Point(0,0);}
  }
  void AddTriangle( int x1, int y1,int x2, int y2, int x3, int y3);
      // returns a list of point which are inside the triangle specified 
  void AddCircle( int cx, int cy,int r);
      // returns a list of point which are inside the circle specified 
  void AddHexagon( int cx, int cy,int r);
      // returns a list of point which are inside the hexagon specified 
  void AddRectangle( int x1, int y1, int x2, int y2);
      // returns a list of point which are inside the rectangle specified 
private:
  void swap( int& a, int& b) { int temp = a; a = b; b = temp;}
  Point *list; 
  Point *end;
  void diskPoints( int , int , unsigned char* , int ) ;
  void line( int x1, int y1, int x2, int y2, unsigned char* , int r);
};

class FPoint{
friend class Point;
  // represents a floating point
public:
  FPoint( float a, float b) { x = a; y = b;}
  FPoint(const FPoint& p) {x = p.x; y = p.y;}
  FPoint(const Point& p) { x = p.x_; y = p.y_;}
//  FPoint(const FPoint& p) {x = p.x; y = p.y;}
  FPoint() { x = 0; y = 0;}
  ~FPoint() {}
  Point convert() {return Point( floatToInt(x), floatToInt(y));}
  Float distanceSquared(Point p) // gives the square of the distance between
    // the Fpoint and p
    { return ( (x - p.x_) * (x - p.x_) + (y - p.y_) * (y - p.y_));}
  Float distanceSquared(FPoint p) const// gives the square of the distance between
    // the Fpoint and p
    { return ( (x - p.x) * (x - p.x) + (y - p.y) * (y - p.y));}
  Point closestPoint() const;
  void zeroPoint() { x = y = 0;} // sets point to (0,0)
  float dotProduct( FPoint p) // dot product
    { return (x * p.x + y * p.y); }
  FPoint perpendicular()
    // rotate anticlockwise by 90 (cos sin; -sin cos)
    { return ( FPoint( -y, x ));}
  void print( ostream& s = cout) const 
    {s << '('  << x << ',' << y << ')';}
  void display( ostream& s = cout) const 
    {s << '('  << x << ',' << y << ')'<<'\n';}
  friend ostream& operator<<( ostream& s, const FPoint& p)
    { return s << '(' << p.x << ',' << p.y << ')' ; }
  friend int operator!=( const FPoint a, const FPoint b) 
    {return ((a.x != b.x) || (a.y != b.y));}
  friend int operator==( const FPoint a, const FPoint b) 
    {return ((a.x == b.x) && (a.y == b.y));}
  friend int operator<=( const FPoint a, const FPoint b) 
    {return ((a.x <= b.x) && (a.y <= b.y));}
  friend int operator>=( const FPoint a, const FPoint b) 
    {return ((a.x >= b.x) && (a.y >= b.y));}
  friend int operator<( const FPoint a, const FPoint b) 
    {return ((a.x < b.x) && (a.y < b.y));}
  friend int operator>( const FPoint a, const FPoint b) 
    {return ((a.x > b.x) && (a.y > b.y));}
  FPoint& operator/=(const FPoint p) { x /= p.x; y /= p.y; return *this;}
  FPoint& operator-=(const FPoint& p) { x -= p.x; y -= p.y; return *this;}
  FPoint& operator+=(const FPoint& p) { x += p.x; y  += p.y; return *this;}
  friend FPoint operator-(FPoint p) //unary minus
    { return FPoint( -p.x, -p.y);}
  friend FPoint operator-(FPoint a, FPoint b) //binary minus
    { return FPoint( a.x - b.x, a.y - b.y);}
  friend FPoint operator+(FPoint a, FPoint b) // plus
    { return FPoint( a.x + b.x, a.y + b.y);}
  friend float operator*( FPoint a, FPoint b) // dot product
    { return (a.x*b.x+a.y*b.y); }
  friend FPoint operator*( FPoint p, int k) // scaling
    { return FPoint( k * p.x, k * p.y);}
  friend FPoint operator*( int k, FPoint p) // scaling
    { return FPoint( k * p.x, k * p.y);}
  friend FPoint operator*( FPoint p, float k) // scaling
    { return FPoint( k * p.x, k * p.y);}
  friend FPoint operator*( float k, FPoint p) // scaling
    { return FPoint( k * p.x, k * p.y);}
  friend FPoint operator/( FPoint p, int k) // scaling
    { return FPoint( p.x / k, p.y / k);}
  friend FPoint operator/( FPoint a, FPoint b) // scaling
    { return FPoint( a.x / b.x, a.y / b.y);}
  friend FPoint operator/( FPoint p, float k) // scaling
    { return FPoint( p.x / k, p.y / k);}
  void saveState( ostream& s);
  void recoverState( istream& s);

private:
  Float x,y;
};

#endif POINT_H
