// This may look like C code, but it is really -*- C++ -*-
#ifndef CELLLIST_H
#define CELLLIST_H
#ifdef __GNUG__
#pragma interface
#endif

#include "header.h"
#include "point.h"
#include "cell.h"

#ifdef SPACE_SAVER

class neighborInfo{  // Collects information about neighbors
friend class cellList;
friend class Cell;
private:
  neighborInfo( Cell* c, FPoint d)
    { cell = c; direction = d; }
  ~neighborInfo() {};
  Cell* cell;  // Pointer to the neighbor
  class FPoint direction; // Direction to this cell  
};

class cellList{
public:
  cellList() { count=0;}
  ~cellList() {
    for (int i =0; i< NumberOfNeighbors; i++) delete neighbors[i];
  };
  neighborInfo* nextItemInList(){  // return front of list, and advance pointer
    return( neighbors[ count++]);
  }
  void insert( Cell* cell, class FPoint direction){
    neighbors[ count++] = new neighborInfo( cell, direction);
  }
  void display( ostream& s = cout) const {}; // Display the list
  bool emptyList() const { 
    if (count == NumberOfNeighbors) return TRUE; else return FALSE;
  } // Is the list empty?
  void resetList() { count = 0;}
private:
  neighborInfo* neighbors[ NumberOfNeighbors];
  int count;
  // count keeps track of where we  are currently in the list
};

#else SPACE_SAVER NOT

class neighborInfo{  // Collects information about neighbors
friend class cellList;
friend class Cell;
private:
  neighborInfo( Cell* c)
    { cell = c; next = (neighborInfo *)NULL; contact =0; direction.zeroPoint();}
  ~neighborInfo() { delete boundary; }
  Cell* cell;  // Pointer to the neighbor
  class PointList* boundary; // list of all the boundary points between these two
		       // cells 
  class FPoint direction; // Direction of the cell interface, perpendicular to
		   // boundary, does not work with size 1 boundary, using this
		   // one right  now  
  class FPoint directionToNeighbor; // The direction to this neighbor,
				    // dynamically calculated with each each
				    // step in determining boundary
  int contact; // The contact length with this neighbor = size (boundary)
  neighborInfo *next;
  void print( ostream& s = cout); 
};

class cellList{
public:
  cellList() {startOfList = list = end = 0;}
  cellList(const cellList& cl);
  ~cellList() {list=startOfList; 
	       neighborInfo *tmp;
	       while (list != NULL) {
		 tmp = list;
		 list =list->next;
		 delete tmp;
	       }
	     };
  void insert( Cell*, class PointList* boundary, int contactLength, 
	      class FPoint directionToNeighbor); 
  // additive insert, if it already exists in list then adjust parameters
  neighborInfo* nextItemInList();  // return front of list, and advance pointer
  bool emptyList() const { if (list == NULL) return TRUE; else return FALSE;} // Is the list empty?
  void resetList() { list = startOfList;}
  void display( ostream& s = cout) const; // Display the list
private:
  neighborInfo* startOfList;
  neighborInfo *list, *end;
  // startOfList always points to the first node, list keeps track of where we
  // are currently in the list
};
#endif SPACE_SAVER
#endif CELLLIST_H
