 /*This file parses the input program and produces C++ intermediate */
 /*code for CPL */
%{
# include <stdio.h>
# include <malloc.h>
# include <sys/param.h>
# include "parse.h"
float timeInterval=1;
int realFactor=1;  /* keeps track of the fraction the number after the */
		   /* decimal should be divided by, to obtain the */
		   /* real value. thus for 2.0356, it will be 10000. */
unsigned char  unitArea; /* if the cell is defiend as a unit area cell */
unsigned char firstPass;
int height, width;
char* unnamedStateCount = "a"; /* counter to keep track of unnamed states */
char errMsg[ STR_SIZE];
char tmpString[ STR_SIZE];
char unnmdStateStr[ STR_SIZE];
char inputFile[ STR_SIZE];
char likeTissue[ STR_SIZE]; /* The tissue which this tissue is like */
void addtotissuelist_def( );
void addtostatelist_def( );
void addToVarTable( );
char* getwd();
void error();
void yyerror();
FILE* cCode;
%}

%start program

%union{
  int ival;
  float rval;
}

%token BIOCHEMICAL VECTOR INTEGER FLOAT GLOBAL POINT SQRT MOD SIN60 LIKE
%token DUMMY TRACE INTERVAL STEPS SIZE WRITE WECHO STRING IMAGE SAVE DIE ATTACH
%token ID DIGIT CONSTANT IF THEN ELSE NEIGHBOR_VAR NEIGHBOR_BC NEIGHBOR_AREA
%token NEIGHBOR_CELLNUMBER CONTACT_LENGTH DIRECTION NEIGHBOR_PERIMETER
%token NEIGHBOR_TISS_TYP NEIGHBOR_STATE TISSUE_NAME TISSUE_TYPE
%token TISSUE STATE
%token RANDOM_INT RANDOM_DIR WITH_NEIGHBOR_DO POINT
%token GOTO DIFFERENTIATE_TO DIVIDE AREA PERIMETER CELLNUMBER LOCATION
%token GROW SWAP MOVE TIME CONFIGURE DERIV FOR_EACH_NEIGHBOR_DO
%token UNION RECTANGLE CIRCLE HEXAGON TRIANGLE CELL TYPE START_UP_AREA
  ARRAY UNIT_AREA
%token AND OR NOT EQ NE LE GE INT PLUS MINUS MULT DIVISION EXPONENTIAL LT GT INT_EXP
/* Dummy tokens to get #define numbers for them */
%token ASSIGNMENT ASSIGNMENT_DERIV ASSIGNMENT_PLUS ASSIGNMENT_MINUS
%token JUMP END TEMP_VAR LOCAL NOTBIOCHEM
  /* JUMP is for internal jumps within the same state, needed due to */
  /* if-then etc */
%token OPERATOR END_FOR END_WITH EXIT VARIABLE 
%token HORIZONTAL VERTICAL SHORTEST ANY PERPENDICULAR

%left AND OR
%left EQ NE
%left '<' LE '>' GE
%left '+' '-'
%left '*' '/' 
%right '^'
%left UMINUS UPLUS NOT

%type <ival> int variable variableLHS n_variable state_name_def else
%type <ival> state_name_use tissue_name_use 
%type <ival> one_state value
%token <ival> DIGIT ID NEIGHBOR_VAR
%type <rval> real

%{
# include "lex.yy.c"
%}

%% /* Beginning of rules section */

program
  : size interv global_d tissue_d cell_d
  ;


size
  : SIZE '(' int ',' int ')' ';'
    {
      height = $5; width = $3;
    }

interv
  :        /* empty */
    {	
     timeInterval= 1;
    }
  | INTERVAL real ';'
    {	
      timeInterval= $2;
    }
  ;

global_d
  :	/* empty */
  |	global_d global_const
	;

global_const
  : BIOCHEMICAL ID
     {
       addToVarTable(UNDEFINED,LOCAL,BIOCHEMICAL);
     }
    biochem
  | INTEGER ID
     {
       addToVarTable(INTEGER,UNDEFINED,UNDEFINED);
     }
    intege
  | FLOAT ID
     {
       addToVarTable(FLOAT,UNDEFINED,UNDEFINED);
     }
    floa
  | VECTOR ID
     {
       addToVarTable(VECTOR,UNDEFINED,NOTBIOCHEM);
     }
    vecto
  | GLOBAL ID
     {
       addToVarTable(UNDEFINED,GLOBAL,NOTBIOCHEM);
     }
    globa
  | LOCAL ID
     {
       addToVarTable(UNDEFINED,LOCAL,UNDEFINED);
     }
    loca
  ;

biochem
  : ';'
  | ',' ID
     {
       addToVarTable(UNDEFINED,LOCAL,BIOCHEMICAL);
     }
     biochem
  ;

intege
  : ';'
  | ',' ID
     {
       addToVarTable(INTEGER,UNDEFINED,UNDEFINED);
     }
    intege
  ;

floa
  :  ';'
  | ',' ID
     {
       addToVarTable(FLOAT,UNDEFINED,UNDEFINED);
     }
     floa
  ;

vecto
  : ';'
  | ',' ID
     {
       addToVarTable(VECTOR,UNDEFINED,NOTBIOCHEM);
     }
    vecto
  ;

globa
  :  ';'
  | ',' ID
     {
       addToVarTable(UNDEFINED,GLOBAL,NOTBIOCHEM);
     }
     globa
  ;

loca
  :  ';'
  | ',' ID
     {
       addToVarTable(UNDEFINED,LOCAL,UNDEFINED);
     }
    loca
  ;

tissue_d
  :  
     {
       fclose(cCode); /* close the garbage file and produce the C++ file */
       cCode = fopen("cplCode.cc","a");
       fprintf(cCode,"void Cell::_CPLdoNothing() {}\n\n");
     }
    one_tissue
     {
       tissue_being_defined=UNDEFINED;
       /* not defining a tissue any more */
     }
  |  tissue_d one_tissue
  ;

one_tissue
  :  TISSUE tissue_name_def '{' state_d '}'
  ;

tissue_name_def
  :  ID
      {
	strcpy(likeTissue,"");
	addtotissuelist_def(addtosymboltable(),0);
        /*sets current tissue */
      }
  |  ID ':' DUMMY
      {
	strcpy(likeTissue,"");
	addtotissuelist_def(addtosymboltable(),1);
	/*sets current tissue */
      }
  |  tissue_name_def ':' LIKE tissue_name_use
      { /* Not part of language definition 8/93 */
	strcpy(likeTissue,"");
  	sprintf(likeTissue,"_CPL%s();\n",symbol_table[$4].name);
      }
  ;

tissue_name_use
 :  ID
     {
       $$=addtotissuelist_use(addtosymboltable());
     }
 ;

state_d	
  :  one_state
      {
	if (symbol_table[tissue_being_defined].type !=  TISSUE)
	  error(" Incorrect value of tissue being defined");
      }
  |  state_d one_state  /* The first state defined is the start state */
  |  unnamed_state  /* If a tissue has a single state */
                    /* doesn't have to be named */
  ;

one_state
  :  STATE state_name_def '{' statement_list '}'
      {
	$$=$2; /* Propogate start of the program for this state */
	fprintf(cCode,"}\n\n");
      }
  ;

unnamed_state
  :
      {
	if (symbol_table[tissue_being_defined].type !=  TISSUE)
	  error(" Incorrect value of tissue being defined");
	strcpy(unnmdStateStr,"unnamedState_");
	strcpy(unnmdStateStr+strlen(unnmdStateStr),unnamedStateCount);
	unnamedStateCount[0]++;
	addtostatelist_def( (symbol_table[tissue_being_defined].firstState =  
			     addtosymboltable2( unnmdStateStr)));
      }
     statement_list
      {
	fprintf(cCode,"}\n\n");
      }
  ;

state_name_def
  :  ID
      {
	addtostatelist_def(addtosymboltable());
      }
  |  state_name_def ':' LIKE state_name_use
      {
  	fprintf(cCode,"_CPL%s();\n",symbol_table[$4].name);
      }
  ;

state_name_use
  :  ID
      {
	$$=addtostatelist_use(addtosymboltable());
      }
  ;

statement_list
  : /*empty*/
  | statement
  |  statement_list statement
  ;

if_part
  :  IF
      {
	fprintf(cCode,"if (");
      }
     value statement
      {
	fprintf(cCode,"}\n");
      }
  ;

else
  : ELSE
     {
       fprintf(cCode," else {\n");
     }
  ;

statement
  :  elementary_statement
  |  if_part else statement
      {
	fprintf(cCode,"}\n");
      }
  |  if_part
  |
     {
       fprintf(cCode,"// for each neighbor do\n");
       fprintf(cCode,"if (neighborListCurrent) \n");
       fprintf(cCode,"// old list of neighbors exists, use it\n");
       fprintf(cCode,"neighbor->resetList();\n   else {\n");
       fprintf(cCode,"  if (neighbor != NULL) delete neighbor;\n");
       fprintf(cCode,"neighbor = matrix->neighborList( cellNumber, perimeter);\n");
       fprintf(cCode,"if (DEBUG || debug) neighbor->display(cerr);\n");
       fprintf(cCode,"neighborListCurrent = TRUE;\n");
       fprintf(cCode,"  }\n\n");
       fprintf(cCode,"while (!neighbor->emptyList()) {\n");
       fprintf(cCode,"currentNeighbor = neighbor->nextItemInList();\n");
       fprintf(cCode,"// cpl statements in for loop\n");
       valid_neighbor_variables=TRUE;
     }
    FOR_EACH_NEIGHBOR_DO statement
     {
       fprintf(cCode,"}; // end for each neighbor do\n\n");
       valid_neighbor_variables=FALSE;
     }
  |
     {
       fprintf(cCode,"{// with neighbor do \n");
       fprintf(cCode," FPoint _CPLdirection = matrix->getLocation( cellNumber) +");
       valid_neighbor_variables=TRUE;
     }
    WITH_NEIGHBOR_DO expression 
     {
       fprintf(cCode,";\n int neighb = matrix->findNeighborInDirection( ");
       fprintf(cCode,"cellNumber, _CPLdirection);\n if (neighborListCurrent)\n");
       fprintf(cCode,"neighbor->resetList();\n");
       fprintf(cCode,"else {\n // reconstruct neighbor list\n");
       fprintf(cCode,"  if (neighbor != NULL) delete neighbor;\n");
       fprintf(cCode,"neighbor = matrix->neighborList( cellNumber, perimeter);\n");
       fprintf(cCode,"neighborListCurrent = TRUE;\n}\n");
       fprintf(cCode,"while (!neighbor->emptyList() && neighb != \n");
       fprintf(cCode,"(currentNeighbor = neighbor->nextItemInList() )->cell->cellNumber);\n");
       fprintf(cCode,"if ( neighb != currentNeighbor->cell->cellNumber){\n");
       fprintf(cCode,"error(\"Error:cplCode.cc-> Shouldn't be in this part of the code, In with neighbor do, mistakenly thought neighbors were current\");\n");
       fprintf(cCode,"}\n// with neighbor do cpl statements\n");
     }
    statement
     {
       fprintf(cCode,"currentNeighbor = (neighborInfo* ) Undefined;\n");
       fprintf(cCode,"}// end with neighbor do \n");
       valid_neighbor_variables=FALSE;
     }
  ;

elementary_statement	
  :  error ';'
      {
	yyerrok;yyerror("Invalid statement");
      }
  |  variableLHS '='
      {
	fprintf(cCode,"= ");
      }
     expression ';'
      {
	fprintf(cCode,";\n");
      }
  |  DERIV variableLHS '='
      {
	fprintf(cCode,"+= (%e *",timeInterval);
      }
     expression ';'
      {
	if (variableTable[$2].biochemical != BIOCHEMICAL) 
	  error("deriv assignments may only be used for declared biochemicals");
	fprintf(cCode,");\n");
      }
  |  variableLHS '+' '='
      {
	fprintf(cCode,"+= ");
      }
     expression ';'
      {
	fprintf(cCode,";\n");
      }
  |  variableLHS '-' '='
      {
	fprintf(cCode,"-= ");
      }
     expression ';'
      {
	fprintf(cCode,";\n");
      }
  |  GOTO state_name_use ';'
      {
	fprintf(cCode,"code = &_CPL%s", symbol_table[$2].name);
	fprintf(cCode,";\n stateCounter = %d;\n return;\n", 
		symbol_table[$2].count);
      }
  |  DIFFERENTIATE_TO tissue_name_use  ';'
      {
	fprintf(cCode," code = &_CPL%s;\n tissueType = %d;\n", 
		symbol_table[symbol_table[$2].firstState].name,
		symbol_table[$2].part_of);
	fprintf(cCode,"stateCounter = %d;\n return;\n", 
		symbol_table[ symbol_table[$2].firstState].count);
      }
  |  DIVIDE ANY ';'
      {
	fprintf(cCode,"divide(ANY);\n");
      }
  |  DIVIDE HORIZONTAL ';'
      {
	fprintf(cCode,"divide(HORIZONTAL);\n");
      }
  |  DIVIDE VERTICAL ';'
      {
	fprintf(cCode,"divide(VERTICAL);\n");
      }
  |  DIVIDE SHORTEST ';'
      {
	fprintf(stderr,"Shortest division not implemented, using random instead\n");
	fprintf(cCode,"divide(SHORTEST);\n");
      }
  |  DIVIDE PERPENDICULAR ';'
      {
	fprintf(cCode,"divide(PERPENDICULAR);\n");
      }
  |  GROW
      {
	fprintf(cCode,"{\n int _CPLareaInc = ");
      }
     expression
      {
	fprintf(cCode,";\n");
	fprintf(cCode,"matrix->growCell( cellNumber, _CPLareaInc, ");
      }
     expression ';'
      {
	fprintf(cCode,")");
	fprintf(cCode,";\n");
	fprintf(cCode,"area += _CPLareaInc;\n neighborListCurrent = FALSE;\n}\n");
      }
  |  MOVE
      {
	fprintf(cCode,"matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +");
      }
     expression ';'
      {
	fprintf(cCode,")");
	fprintf(cCode,";\n");
	fprintf(cCode,"neighborListCurrent = FALSE;\n");
      }
  |  SWAP
      {
	fprintf(cCode,"matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +");
      }
     expression ';'
      {
	fprintf(cCode,")");
	fprintf(cCode,";\n");
	fprintf(cCode,"neighborListCurrent = FALSE;\n");
      }
  |  ATTACH
      {
	fprintf(cCode,"matrix->attach( cellNumber");
      }
     expression ';'
      {
	fprintf(cCode,")");
	fprintf(cCode,";\n");
	fprintf(cCode,"neighborListCurrent = FALSE;\n");
      }
  |  EXIT ';'
      {
	if (!valid_neighbor_variables)
	  error("Exit: outside \"for each variable do\"");
	else {
	  fprintf(cCode,"break;// Exit from for each neighbor do\n");
	}
      }
  |  CONFIGURE ';'
      {
	fprintf(cCode,"matrix->configure( cellNumber)");
	fprintf(cCode,";\n");
      }
  |  TRACE ';'
      {
	fprintf(cCode,"printInfo( cout)");
	fprintf(cCode,";\n");
      }
  |  IMAGE variable ';'
      {
	if (variableTable[$2].global == GLOBAL)
	  error("Can only image non global variables");
	fprintf(cCode,"{\n");
	fprintf(cCode,"cout << \"Time = \" << time << \"\\n\";\n");
	fprintf(cCode,"for (int y = height - 1; y >= 0; y--)\n");
	fprintf(cCode,"{\n");
	fprintf(cCode,"cout << \"@ \" << y << ':';\n");
	fprintf(cCode,"for(int x = 0; x < width; x++)\n");
	fprintf(cCode,"cout << cell[ matrix->getCell(x,y)]->_CPL%s << ' ';\n",variableTable[ $2].name);
	fprintf(cCode,"cout << ':' << y << '\\n';\n");
	fprintf(cCode,"}\n");
	fprintf(cCode,"}\n");
      }
  |  IMAGE CELLNUMBER ';'
      {
	fprintf(cCode,"{\n");
	fprintf(cCode,"cout << \"Time = \" << time << \"\\n\";\n");
	fprintf(cCode,"for (int y = height - 1; y >= 0; y--)\n");
	fprintf(cCode,"{\n");
	fprintf(cCode,"cout << \"@ \" << y << ':';\n");
	fprintf(cCode,"for(int x = 0; x < width; x++)\n");
	fprintf(cCode,"cout << cell[ matrix->getCell(x,y)]->cellNumber << ' ';\n");
	fprintf(cCode,"cout << ':' << y << '\\n';\n");
	fprintf(cCode,"}\n");
	fprintf(cCode,"}\n");
      }
  |  IMAGE TISSUE ';'
      {
	fprintf(cCode,"matrix->tissueImage()");
	fprintf(cCode,";\n");
      }
  |  IMAGE STATE ';'
      {
	fprintf(cCode,"matrix->stateImage()");
	fprintf(cCode,";\n");
      }
  |  SAVE ';'
      {
	fprintf(cCode,"saveSimulation( time)");
	fprintf(cCode,";\n");
      }
  |  WRITE
      {
	fprintf(cCode,"cout <<");
      }
     expression ';'
      {
	fprintf(cCode," << ' ';\n");
      }
  |  WRITE STATE ';'
      {
	fprintf(cCode,"cout << getState();\n");
      }
  |  WRITE NEIGHBOR_STATE ';'
      {
	fprintf(cCode,"cout << currentNeighbor->cell->getState();\n");
      }
  |  WRITE TISSUE_TYPE  ';'
      {
	fprintf(cCode,"cout <<  getTissueType(); \n");
      }
  |  WRITE NEIGHBOR_TISS_TYP  ';'
      {
	fprintf(cCode,"cout << currentNeighbor->cell->getTissueType() ;\n");
      }
  |  WECHO STRING ';' /* write string */
      {
	fprintf(cCode,"cout << %s",tmpString);
	fprintf(cCode,";\n");
      }
  |  DIE ';' /* cell death */
     {
       fprintf(cCode,"code = &_CPLdoNothing;\n");
       fprintf(cCode,"return;\n");
     }
  |  compound_statement
  ;

compound_statement	
  : '{' statement_list '}'
  | error '}'
     {
       yyerrok;
       yyerror("Invalid statement block");
     }
  ;

n_variable
  :  NEIGHBOR_VAR
      {
	if (!valid_neighbor_variables)
	  error("Neighbor variables used outside \"for/with neighbor do\"");
	else {
	  int varType = VarOrBiochem($$=checkInVarTable());
	  if (varType == BIOCHEMICAL) {
	    fprintf(cCode,"currentNeighbor->cell->_CPL%s",
		    variableTable[ checkInVarTable()].name);
	  }	
	  else if (varType == VARIABLE) {
	    fprintf(cCode,"currentNeighbor->cell->_CPL%s",
		    variableTable[checkInVarTable()].name); 
	  }
	  else {
	    fprintf(cCode,"_CPL%s", variableTable[$1].name);
	  }
	}
      }
  ;


variable
  :  ID
      {
	$$=checkInVarTable(); /* only put cplCode if rvalue used */
      }
  ;

variableLHS
  :  ID
      {
	int VarTableIndex;
	fprintf(cCode,"_CPL%s",variableTable[ VarTableIndex =
					     checkInVarTable()].name); 
	if (VarOrBiochem(VarTableIndex) == BIOCHEMICAL)
	  fprintf(cCode,"Next");
	fprintf(cCode," ");
	$$= VarTableIndex;
      }	
   ;

value
  : expression
     {
       fprintf(cCode,") {\n");
     }
  ;

expression	
  :  expression OR 
      {
	fprintf(cCode," || ");
      }
     expression
  |  expression AND 
      {
	fprintf(cCode," && ");
      }
     expression
  |  '(' 
      {
	fprintf(cCode,"(");
      }
     expression ')'
      {
	fprintf(cCode,")");
      }
  |  expression LE 
      {
	fprintf(cCode," <= ");
      }
     expression
  |  expression GE 
      {
	fprintf(cCode," >= ");
      }
     expression
  |  expression EQ 
      {
	fprintf(cCode," == ");
      }
     expression
  |  expression NE 
      {
	fprintf(cCode," != ");
      }
     expression
  |  expression '<' 
      {
	fprintf(cCode," < ");
      }
     expression
  |  expression '>' 
      {
	fprintf(cCode," > ");
      }
     expression
  |  expression '+' 
      {
	fprintf(cCode," + ");
      }
     expression
  |  expression '-' 
      {
	fprintf(cCode," - ");
      }
     expression
  |  expression '*' 
      {
	fprintf(cCode," * ");
      }
     expression
  |  expression '/' 
      {
	fprintf(cCode," / ");
      }
     expression
  |  expression MOD 
      {
	fprintf(cCode," %% ");
      }
     expression
  |  
      {
	fprintf(cCode," power(");
      }
     expression '^' 
      {
	fprintf(cCode,",");
      }
     expression
      {
	fprintf(cCode,") ");
      }
  |   SQRT
      {
	fprintf(cCode," sqrt(");
      }
      expression
      {
	fprintf(cCode,") ");
      }
  | 	NOT 
      {
	fprintf(cCode,"!");
      }
     expression
  |  int
     {}
  |  real
     {}
  |  SIN60
     { 
       fprintf(cCode,"0.866025");
     }
  |  '+' 
      {
	fprintf(cCode," +");
      }
     expression %prec UPLUS
  |  '-' 
      {
	fprintf(cCode," -");
      }
     expression %prec UMINUS
  |  POINT '(' 
      {
	fprintf(cCode,"Point(");
      }
     expression ',' 
      {
	fprintf(cCode,",");
      }
     expression ')'
      {
	fprintf(cCode,")");
      }
  |  INT_EXP 
      {
	fprintf(cCode,"int(");
      }
     '(' expression  ')'
      {
	fprintf(cCode,")");
      }
  |  TIME
      {
	fprintf(cCode,"time");
      }
  |  RANDOM_INT '(' 
      {
	fprintf(cCode,"randBetween(");
      }
     expression ',' 
      {
	fprintf(cCode,",");
      }
     expression ')'
      {
	fprintf(cCode,")");
      }
  |  PERIMETER
      {
	fprintf(cCode,"perimeter");
      }
  |  CONTACT_LENGTH
      {
	if (!valid_neighbor_variables)
	  error("Contact length used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->contact");
	}
      }
  |  AREA
      {
	fprintf(cCode,"area");
      }
  |  CELLNUMBER
      {
	fprintf(cCode,"cellNumber");
      }
  |  NEIGHBOR_CELLNUMBER
      {
	if (!valid_neighbor_variables)
	  error("Neighbor's cell number used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->cell->cellNumber");
	}
      }
  |  LOCATION
      {
	fprintf(cCode,"matrix->getLocation( cellNumber)");
      }
  |  INTERVAL
      {
	fprintf(cCode," %e ",timeInterval);
      }
  |  STEPS
      {
	fprintf(cCode,"int(time/intervalf)");
      }
  |  NEIGHBOR_AREA
      {
	if (!valid_neighbor_variables)
	  error("Neighbor area used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->cell->area)");
	}
      }
  |  NEIGHBOR_PERIMETER
      {
	if (!valid_neighbor_variables)
	  error("Neighbor perimeter used outside \"for each variable do\"");
	else{
	  fprintf(cCode,"currentNeighbor->cell->perimeter)");
	}
      }
  |  NEIGHBOR_STATE EQ state_name_use /* actually this is for */
				    /* neighbor.state */ 
      {
	if (!valid_neighbor_variables)
	  error("Neighbor state used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->cell->getState() == %d",
		  symbol_table[$3].count); 
	}
      }
  |  NEIGHBOR_STATE NE state_name_use /* actually this is for */
				    /* neighbor.state */ 
      {
	if (!valid_neighbor_variables)
	  error("Neighbor state used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->cell->getState() != %d",
		  symbol_table[$3].count); 
	}
      }
  |  NEIGHBOR_TISS_TYP EQ tissue_name_use /* actually this is for */
				    /* neighbor.tissue_type */ 
      {
	if (!valid_neighbor_variables)
	  error("Neighbor tissue type used outside \"for each variable do\"");
	else {
	  fprintf(cCode,"currentNeighbor->cell->getTissueType() == %d",
		  symbol_table[$3].part_of); 
	}
      }
  |  NEIGHBOR_TISS_TYP NE tissue_name_use
      {
	if (!valid_neighbor_variables)
	  error("Neighbor tissue type used outside \"for each variable do\"");
	else{
	  fprintf(cCode,"currentNeighbor->cell->getTissueType() != %d",
		  symbol_table[$3].part_of); 
	}
      }
  |  variable
      {
	fprintf(cCode,"_CPL%s", variableTable[$1].name);
      }
  |  n_variable
     {}
  |  DIRECTION
      {
	if (!valid_neighbor_variables)
	  error("Neighbor direction used outside \"for each variable do\"");
	else{
	  fprintf(cCode,"currentNeighbor->direction");
	}
      }
  |  RANDOM_DIR
      {
	fprintf(cCode,"matrix->randomDirection()");
      }
  |  error
      {
	yyerror("Invalid expression");
      }
  ;

int	
  :  DIGIT
      {
	$$=$1;
	realFactor=10;
	fprintf(cCode,"%1d",$1);
      }
  |  int DIGIT
      {
	$$=$1*10+$2;
	realFactor *= 10;
	fprintf(cCode,"%1d",$2);
      }
  ;

real	
  :  int
      {
	$$=$1;
      }
  |  '.' 
      {
	fprintf(cCode,".");
      }
     int
      {
	$$=(float)$3/ realFactor;
      }
  |  int '.' 
      {
	fprintf(cCode,".");
      }
     int
      {
	$$=$1+(float)$4/ realFactor;
      }
  ;

cell_d
  :     { 
          int obsSymTab;
	  fprintf(cCode," void Cell::_cellInitialize()\n {\n");
	  fprintf(cCode,"PointList InFigure; \n");
          /* if no observer tissue is defined, define a dummy observer */
          saveStr("observer");
	  if ( ! symbol_table[ obsSymTab = addtosymboltable()].defined) {
	    addtotissuelist_def( addtosymboltable(), 0);
	  }
	  /* add instructions for predefined observer cell, this */
	  /* makes it the first cell */
	  obsSymTab = symbol_table[ obsSymTab].part_of;
	  fprintf(cCode,"// Define the observer cell\n");
	  fprintf(cCode,"cell[ 1] = new Cell( cell[0], FALSE);\n");
	  fprintf(cCode,"cell[ 1]->area = 0;\n");
	  fprintf(cCode,"cell[ 1]->dummy = TRUE;\n");
	  fprintf(cCode,"cell[ 1]->tissueType = %d;\n",obsSymTab);
	  fprintf(cCode,"cell[ 1]->stateCounter  = tissue[ %d]->state;\n",obsSymTab);
	  fprintf(cCode,"cell[ 1]->code = stateCode[ cell[ 1]->stateCounter];\n");
	}
     cell_ds
         {
	   fprintf(cCode,"cellNumber = 0;\n} // end _cellInitialize()\n");
	 }
  ;

cell_ds
  :  one_cell
  |  cell_ds one_cell
  ;

one_cell
  :  
    {
      fprintf(cCode,"\n");
    }
     CELL  '{' unit_area TYPE tissue_name_use 
    {
      if ( ! symbol_table[$6].defined) {
	sprintf(errMsg,"%d %s tissue type should be defined before cell declarations", $6, symbol_table[ $6].name);
	error(errMsg);
      }
    }
     ';' START_UP_AREA cell_location ';' 
     {
       fprintf(cCode,"cell[ cellNumber] = new Cell( cell[0], FALSE);\n");
       fprintf(cCode,"cell[ cellNumber]->area = matrix->getArea( cellNumber);\n");
       fprintf(cCode,"\ncell[ cellNumber]->tissueType = %d;\n",
	       symbol_table[ $6].part_of);
       fprintf(cCode,"cell[ cellNumber]->stateCounter  = tissue[ %d]->state;\n",symbol_table[ $6].part_of);
       fprintf(cCode,"cell[ cellNumber]->code = stateCode[ cell[ cellNumber]->stateCounter];\n");
     }
     initializations '}'
     {  
       if (unitArea) fprintf(cCode,"}\n");
     }
    ;

unit_area
  : UNIT_AREA ';'
     {
       unitArea = TRUE;
     }
  | /*empty */
     {
       unitArea = FALSE;
     }
  ;

cell_location	
  :  object
      {
	fprintf(cCode,");\n");
	fprintf(cCode,"while ( !InFigure.emptyList()) {\n");
	fprintf(cCode,"cellNumber = Cell::numberDefined;\n");
	fprintf(cCode,"matrix->markCell( InFigure.delget(), cellNumber);\n");
	if (!unitArea) 
	  fprintf(cCode,"}\n matrix->setLocationToCentreofCell( cellNumber);\n");
      }
  |  cell_location UNION object
      {
	if (unitArea)
	  error("Union of objects not allowed for unit area collection of cells");
	fprintf(cCode,");\n");
	fprintf(cCode,"while ( !InFigure.emptyList()) {\n");
	fprintf(cCode,"matrix->putCell( InFigure.delget(), cellNumber);\n");
	if (!unitArea) 
	  fprintf(cCode,"}\n matrix->setLocationToCentreofCell( cellNumber);\n");
      }
;

COMMA
  :  ','
  {
    fprintf(cCode,",");
  }

object	
  :  RECTANGLE '(' 
      /* rect(a,b)--(c,d) */
      {
	fprintf(cCode,"InFigure.AddRectangle(");
      }
     int COMMA int COMMA int COMMA int ')'
  | CIRCLE  '(' 
     /* circle (cx,cy,radius) */
     {
	fprintf(cCode,"InFigure.AddCircle(");
     }
    int COMMA int COMMA int ')'
  |  HEXAGON  '(' 
      /* hexagon  (cx,cy,radius) */
      {
	fprintf(cCode,"InFigure.AddHexagon(");
      }
     int COMMA int COMMA int ')'
  |  TRIANGLE  '(' 
      /* triangle  (x1,y1,x2,y2,x3,y3) */
      {
	fprintf(cCode,"InFigure.AddTriangle(");
      }
     int COMMA int COMMA int COMMA int COMMA int COMMA int ')'
  ;

initializations	
  :  /* empty */
  |  initializations 
  {
    fprintf(cCode,"cell[ cellNumber]->");
  }
  variableLHS '=' 
      {
	fprintf(cCode,"= ");
      }
      expression  ';'
      {
	fprintf(cCode,";\n");
      }
;

%%/* start of programs */
FILE *yyin;
int CPL_ERROR= FALSE;

void addToVarTable(storageType, global, biochemical)
     int storageType, global, biochemical;
{
  int i;
  char* name = tmpString;
  if (var_tb_counter==VAR_TB_SIZE) error("Variable table overflow");
  /* Check if name already exists in variable table */
  for(i=0;i<var_tb_counter;i++)
    if (!strcmp(variableTable[i].name,name))
      {
	if (variableTable[ i].storageType == UNDEFINED)
	  variableTable[ i].storageType = storageType;
	if (variableTable[ i].global == UNDEFINED)
	  /* do not over ride if it has already been declared as */
	  /* global */
	  variableTable[ i].global = global;
	if (variableTable[ i].biochemical == UNDEFINED)
	  variableTable[ i].biochemical = biochemical;
	return;
      }
  /*No match place in symbol table */
  strcpy(variableTable[var_tb_counter].name,name);
  variableTable[var_tb_counter].storageType = storageType;
  variableTable[var_tb_counter].global = global;
  variableTable[var_tb_counter].biochemical = biochemical;
  var_tb_counter++;
}

int checkInVarTable()
{
  int i;
  char* name = tmpString;

  for(i=0;i<var_tb_counter;i++)
    if (!strcmp(variableTable[i].name,name))
      {
	return(i);
        /* Match found return index */
      }
  /*No match place in symbol table */
  error(name);error("Undeclared variable (in checkInVarTable)");
  return(0);
}

int VarOrBiochem(index)
     int index;
{
  if (variableTable[index].biochemical == BIOCHEMICAL) return BIOCHEMICAL;
  else if ( variableTable[index].global == GLOBAL) return GLOBAL;
  else return VARIABLE;
}

void saveStr(name)
     char *name;
{
  strcpy(tmpString,name);
}

int addtosymboltable()
{
  return addtosymboltable2(tmpString);
}

int addtosymboltable2(name)
     char *name;
{
  int i;

  if (sym_tb_counter==SYM_TB_SIZE) error("Symbol table overflow");
  /* Check if name already exists in symbol table */
  for(i=0;i<sym_tb_counter;i++)
    if (!strcmp(symbol_table[i].name,name))
      {
	return(i);
        /* Match found return index */
      }
  /*No match place in symbol table */
  strcpy(symbol_table[sym_tb_counter].name,name);
  symbol_table[sym_tb_counter].type=UNDEFINED; /*type undefined at present */
  symbol_table[sym_tb_counter].defined = FALSE; /*instr undefined at present */
  symbol_table[sym_tb_counter].firstState = UNDEFINED; 
  i=sym_tb_counter;
  sym_tb_counter++;
  return(sym_tb_counter-1);
}

void yyerror(s)
	char *s;
{
  int i;
  FILE *cplcode;
  char token[ STR_SIZE];

  if ((cplcode =
       fopen("cpl.code","r")) == NULL) { 
    fprintf(stderr,"File cpl.code required for error messages.\n");
    fprintf(stderr,"\"%s\", line %d: %s", inputFile, line_number, s);
    if (strcmp(yytext,""))
      fprintf(stderr,", while scanning %s.\n",yytext);
    else
      fprintf(stderr,".\n");
  }
   else {
     while ((fscanf(cplcode,"%d  is %s\n",&i,token)!=EOF)&& (i!=yychar));
     if (i==yychar)
       fprintf(stderr,"\"%s\", line %d: %s, unexpected token %s\n",
	       inputFile, line_number,s,token);
     else 
       fprintf(stderr,"\"%s\", line %d: %s",inputFile,line_number,s);
    if (strcmp(yytext,""))
       fprintf(stderr,", while scanning %s.\n",yytext);
     else
       fprintf(stderr,".\n");
   }
}

void error(text)
     char *text;
{
  extern int line_number;

  if (firstPass) {
    yyerror(text);
    CPL_ERROR = TRUE;
  }
}

static int tissueNumber =0; /* Count of number of tissues defined or */
			    /* used */

/* during addition if the same name already exists of the same kind */
/* (tissue,state,variable) then there is no error */

void addtotissuelist_def( sym_tb_index, dummy)
     int sym_tb_index, dummy;
{
  int i;
  if ( symbol_table[sym_tb_index].defined &&
      symbol_table[sym_tb_index].type == TISSUE && firstPass)
    error("Redefinition of tissue name, its already been defined as something else");
  else
    if (symbol_table[sym_tb_index].type != UNDEFINED &&
	symbol_table[sym_tb_index].type != TISSUE)
      error("Redefinition of symbol, its already been used in some other context");
  if (symbol_table[sym_tb_index].type == UNDEFINED){
    symbol_table[sym_tb_index].type=TISSUE;
    symbol_table[sym_tb_index].part_of=tissueNumber++;
  }
  symbol_table[sym_tb_index].dummy = dummy;
  symbol_table[sym_tb_index].defined = TRUE;
  tissue_being_defined=sym_tb_index;
}

int addtotissuelist_use(sym_tb_index)
     int sym_tb_index;
{
  int i;
  if (symbol_table[sym_tb_index].type!=UNDEFINED &&
      symbol_table[sym_tb_index].type!=TISSUE)
    error("Redefinition of tissue name");
  else if (symbol_table[sym_tb_index].type==UNDEFINED) /* Not yet defined */
    {
      symbol_table[sym_tb_index].type= TISSUE;
      symbol_table[sym_tb_index].defined = FALSE;
      symbol_table[sym_tb_index].part_of=tissueNumber++;
    }
  return(sym_tb_index);
}

void addtostatelist_def(sym_tb_index)
     int sym_tb_index;
{
  if ( symbol_table[sym_tb_index].defined &&
      symbol_table[sym_tb_index].type == STATE && firstPass)
    error("Redefinition of state name, already defined as something else");
  else
    if (symbol_table[sym_tb_index].type != UNDEFINED &&
	symbol_table[sym_tb_index].type != STATE)
      error("Invalid state name: Redefinition of symbol, already used as something else:");
  symbol_table[sym_tb_index].type=STATE;
  symbol_table[sym_tb_index].part_of=tissue_being_defined;
  symbol_table[sym_tb_index].defined = TRUE;
  state_being_defined = sym_tb_index;
  fprintf(cCode,"void Cell::_CPL%s() {\n",symbol_table[sym_tb_index].name);
}

int addtostatelist_use(sym_tb_index)
     int sym_tb_index;
{
  if (symbol_table[sym_tb_index].type!=UNDEFINED &&
      symbol_table[sym_tb_index].type!=STATE)
    error("Redefinition of state name");
  else if (symbol_table[sym_tb_index].type==UNDEFINED) /* Not yet defined */
    {
      symbol_table[sym_tb_index].type= STATE;
      symbol_table[sym_tb_index].defined = FALSE;
      symbol_table[sym_tb_index].part_of=tissue_being_defined;
    }
  return(sym_tb_index);
}

void after_parse_cleanup()
{
  int i;
  int bc_count=0, global_count=0, other_count=0;
  int state_count=0;
  struct sym_tab st;
  int tissue_count=0;
  FILE* cCodeh;

  /* Fix variable table */
  for(i=0;i<var_tb_counter;i++)
    {
      if ( variableTable[i].storageType == UNDEFINED)
	variableTable[i].storageType = INTEGER;
      if ( variableTable[i].global == UNDEFINED)
	variableTable[i].global = LOCAL;
      if ( variableTable[i].biochemical == UNDEFINED)
	variableTable[i].biochemical = NOTBIOCHEM;
      
      if ( variableTable[i].biochemical == BIOCHEMICAL)
	variableTable[i].count = bc_count++;
      else if ( variableTable[i].global == GLOBAL)
	variableTable[i].count = global_count++;
      else variableTable[i].count = other_count++;
    }

  cCodeh = fopen("cplCode.h","w");
  
  for(i=0;i<sym_tb_counter;i++)
    {
      if ( ! symbol_table[i].defined) {
	sprintf(errMsg,"%s undefined",symbol_table[i].name);
	error(errMsg);
      }
      if (symbol_table[i].type == STATE) {
	symbol_table[ i].count= state_count++;
	if (symbol_table[ symbol_table[i].part_of].firstState == UNDEFINED) 
	  symbol_table[ symbol_table[i].part_of].firstState = i;
	fprintf(cCodeh,"  void _CPL%s();\n",symbol_table[i].name);
      }
    }

  for(i=0;i<var_tb_counter;i++) {
    if (variableTable[ i].global==GLOBAL)
	fprintf(cCodeh,"  static ");
    switch (variableTable[ i].storageType)  {
    case INTEGER:
      fprintf(cCodeh,"  int ");break;
    case FLOAT:
      fprintf(cCodeh,"  float ");break;
    case VECTOR:
      fprintf(cCodeh,"  FPoint ");break;
    }
    fprintf(cCodeh," _CPL%s;\n",variableTable[ i].name);
    if (variableTable[ i].biochemical == BIOCHEMICAL) {
      switch (variableTable[ i].storageType)  {
      case INTEGER:
	fprintf(cCodeh,"  int ");break;
      case FLOAT:
	fprintf(cCodeh,"  float ");break;
      }
      fprintf(cCodeh," _CPL%sNext;\n",variableTable[ i].name);
    }
  }
  fclose(cCodeh);

  system("rm cplCode.cc");
  cCode = fopen("cplCode.cc","w");
  printf("rewriting cplCode.cc\n");
  fprintf(cCode,"#include \"cell.h\"\n");
  fprintf(cCode,"#include \"tissue.h\"\n\n");
  fprintf(cCode,"extern Tissue* tissue[];\n");
  fprintf(cCode,"extern Cell* cell[];\n");

  for(i=0;i<var_tb_counter;i++) 
    if (variableTable[ i].global == GLOBAL) 
      if ( variableTable[i].storageType == VECTOR)
	fprintf(cCode,"FPoint Cell::_CPL%s;\n",variableTable[ i].name);
      else if ( variableTable[i].storageType == INTEGER)
	fprintf(cCode,"int Cell::_CPL%s = 0;\n",variableTable[ i].name);
      else fprintf(cCode,"float Cell::_CPL%s = 0;\n",variableTable[ i].name);
  fprintf(cCode,"\n");

  fprintf(cCode,"void initializeTissue(){\n");
  for(i=0;i<sym_tb_counter;i++)
    {
      st=symbol_table[i];
      if (st.type == TISSUE) {
	fprintf(cCode,"tissue[ %d] = new Tissue( \"%s\",%d);\n",
		tissue_count++, st.name, symbol_table[ st.firstState].count);
      }
    }
  fprintf(cCode,"Cell::intervalf = %f;\n",timeInterval);
  fprintf(cCode,"Cell::height = %d;\n",height+1);
  fprintf(cCode,"Cell::width = %d;\n",width+1);
  fprintf(cCode,"cell[ 0] = new Cell( (Cell*) 0, FALSE);\n");
  fprintf(cCode,"}\n\n");

  fprintf(cCode,"void Cell::endTimeStep()\n");
  fprintf(cCode,"//  Set all the cell variables to the new values \n{\n");

  for(i=0;i<var_tb_counter;i++) 
    if (variableTable[ i].biochemical == BIOCHEMICAL) 
      fprintf(cCodeh," _CPL%s = _CPL%sNext;\n",variableTable[ i].name,
	      variableTable[ i].name);
  fprintf(cCode,"}\n\n");

  fprintf(cCode,"void Cell::divideCopyVar( Cell* p)\n");
  fprintf(cCode,"// Copy all the cell variables from p after a division \n{\n");

  for(i=0;i<var_tb_counter;i++) 
    if (variableTable[ i].global != GLOBAL) 
      if (variableTable[ i].biochemical != BIOCHEMICAL) 
	fprintf(cCodeh," _CPL%s = p->_CPL%s;\n",variableTable[ i].name,
		variableTable[ i].name);
      else {
	fprintf(cCodeh," _CPL%s = p->_CPL%s/2;\n",
		variableTable[ i].name, variableTable[ i].name);
	fprintf(cCodeh," _CPL%sNext = p->_CPL%sNext/2;\n",
		variableTable[ i].name, variableTable[ i].name);
      }
  fprintf(cCode,"}\n\n");

  fprintf(cCode,"void Cell::saveVar(ofstream& s)\n");
  fprintf(cCode,"//  Save the user defined variables and biochemicals \n{\n");
  for(i=0;i<var_tb_counter;i++) 
    if (variableTable[ i].biochemical == BIOCHEMICAL) 
      fprintf(cCodeh,"s << _CPL%s << ' ' <<  _CPL%sNext <<'\\n';\n ",
	      variableTable[ i].name,variableTable[ i].name);
    else if (variableTable[ i].global == GLOBAL) 
      if ( variableTable[i].storageType == VECTOR)
      fprintf(cCodeh,"if (cellNumber == 0) _CPL%s.saveState(s);\n",
	      variableTable[ i].name);
      else
	fprintf(cCodeh,"if (cellNumber == 0) s << _CPL%s <<'\\n';\n",
		variableTable[ i].name);
    else 
      if ( variableTable[i].storageType == VECTOR)
	fprintf(cCodeh,"_CPL%s.saveState(s);\n",variableTable[ i].name);
      else
	fprintf(cCodeh,"s << _CPL%s <<'\\n';\n",
		variableTable[ i].name,variableTable[ i].name);
  fprintf(cCode,"}\n\n");

  fprintf(cCode,"void Cell::recoverVar(ifstream& s)\n");
  fprintf(cCode,"//  recover the user defined variables and biochemicals \n{\n");
  for(i=0;i<var_tb_counter;i++) 
    if (variableTable[ i].biochemical == BIOCHEMICAL) 
      fprintf(cCodeh,"s >> _CPL%s >>  _CPL%sNext;\n",
	      variableTable[ i].name,variableTable[ i].name);
    else if (variableTable[ i].global == GLOBAL)
      if ( variableTable[i].storageType == VECTOR)
	fprintf(cCodeh,"if (cellNumber == 0) _CPL%s.recoverState(s);\n",
		variableTable[ i].name);
      else
	fprintf(cCodeh,"if (cellNumber == 0) s >> _CPL%s;\n",
		variableTable[ i].name);
    else  
      if ( variableTable[i].storageType == VECTOR)
	fprintf(cCodeh,"_CPL%s.recoverState(s);\n",variableTable[ i].name);
      else
	fprintf(cCodeh,"s >> _CPL%s;\n",variableTable[ i].name);
  fprintf(cCode,"}\n\n");
}


void setCodePointers()
{
  int i;

  cCode = fopen("cplCode.cc","a");
  fprintf(cCode,"\nvoid Cell::setCodePointers()\n");
  fprintf(cCode,"//link the code function in each state to its correct code\n{\n");
  for(i=0;i<sym_tb_counter;i++)
    if (symbol_table[i].type == STATE) 
      fprintf(cCode,"  stateCode[ %d] = &_CPL%s;\n",
	      symbol_table[i].count, symbol_table[ i].name);
  fprintf(cCode,"}\n");
  fclose(cCode);
}

main(argc,argv)
int argc;
char *argv[];
{
  extern int yydebug;
  extern int yy_init;
  yydebug=0;
  if (argc == 2) {
    strcpy(inputFile,argv[1]);
    if (fopen(inputFile,"r")==NULL){
      fprintf(stderr,"%s: file does not exist\n",inputFile);
      exit(1);
    }
  }
  else strcpy(inputFile, "stdin");
  strcpy(tmpString,"/lib/cpp ");
  if (argc == 2) strcpy(tmpString + strlen(tmpString),inputFile);
  strcpy(tmpString + strlen(tmpString)," > ");
  strcpy(tmpString + strlen(tmpString),"cpl.input");
  system(tmpString);
  cCode = fopen("/dev/null","w");
  yyin = fopen("cpl.input","r");
  saveStr("environment");
  addtotissuelist_def( addtosymboltable(), 1);
  saveStr("doNothing");
  addtostatelist_def( addtosymboltable());
  saveStr("observer");
  addtotissuelist_use( addtosymboltable());
  firstPass = TRUE;
  yyparse();
  fclose(yyin);
  after_parse_cleanup();
  fclose(cCode);

  firstPass = FALSE; 
  if (yydebug) printf("First pass over\n");
  yyin = fopen("cpl.input","r");
  cCode = fopen("/dev/null","w");
  unnamedStateCount = "a"; /* counter to keep track of unnamed states */
  yy_init = 1;
  line_number=1;
  yyparse();
  fclose(cCode);
  setCodePointers();
  system(" rm -f cpl.input");
  if (CPL_ERROR) {
    fprintf(stderr,"Errors detected during compilation\n");
    exit(3);
  }
  else {
    printf("Code generated.\n");
   exit(0);
  }
  return(1);
}
