#define SYM_TB_SIZE 100
#define VAR_TB_SIZE 100
#define STR_SIZE 80
#define UNDEFINED -1
#define TRUE 1
#define FALSE 0

struct variableTab{
  char name[STR_SIZE]; /* Stored as strings ended by '\0' */
  int storageType; /* INTEGER, FLOAT, VECTOR */
  int global; /* if all cells access the same value GLOBAL,LOCAL,UNDEFINED */
  int biochemical; /* if it is a biochemical BIOCHEMICAL, NOTBIOCHEM,*/
		   /* UNDEFINED */
  int count; /* Independent count of biochemical / variable */
} variableTable[VAR_TB_SIZE];

struct sym_tab{
  char name[STR_SIZE]; /* Stored as strings ended by '\0' */
  int type; /* = TISSUE, STATE, VARIABLE, BIOCHEM, CELL or UNDEFINED */
  int defined; /* if defined = 1 else =  0 just used so far */
  int dummy; /* used to keep track if tissue is dummy, 0 if it is not */
  int part_of; /* If this is a state or cell then which */
	       /* tissue does it belong to, if variable then its count*/
               /* if tissue then the number of the tissue defined */
  int count; /* keeps track of the serial number of the state */
  int firstState; /* index in symbol table of the first state of this tissue,
		  /* used only for TISSUE */
} symbol_table[SYM_TB_SIZE];

int sym_tb_counter=0; /* Counter to index into symbol_table*/
int var_tb_counter=0; /* Counter to index into variableTable*/
int tissue_being_defined; /* Contains symbol table counter for the */
			  /* tissue being defined */
int state_being_defined; /* Contains symbol table counter for the */
			  /* state being defined */
int valid_neighbor_variables=FALSE; /* Keeps track if it is ok to use */
				    /* "neighbor.var" variables */
