      SUBROUTINE NUMOUT (NRW,RW,NIW,IW,NCW,CW,KFLAG)                     
C*********************************************************************** 
C                                                                      * 
C DATE OF LATEST CHANGE: JANUARY 12, '86                               * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  NUMOUT IS AN INTERFACE ROUTINE FOR SUBROUTINE LIST, WHICH LISTS     * 
C  THE SIMULATION OUTPUT AS NUMERICAL DATA.                            * 
C  (FOR DESCRIPTION OF PARAMETER LIST SEE SUBROUTINE LIST)             * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
      CHARACTER*1 CW(NCW)                                                
C                                                                        
      REAL RW(NRW)                                                       
C  (NO DOUBLE PRECISION ARRAYS ARE USED WITHIN  NUMOUT AND LIST)         
C                                                                        
CI4       INTEGER IW(NIW)                                                
      INTEGER*2 IW(NIW)                                                  
      INTEGER IELH,MH,N,N2,N3,N4,N5,N6,N7,N8,NIWH,NRW8,NSPN              
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      SAVE /LUNIT/                                                                        
C                                                                        
C      NAMELIST / DIM  / NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM              
      INTEGER NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM,KFOUND                  
C                                                                        
C  READ DIMENSIONS                                                       
C-----------------                                                       
      REWIND DOUT 
C      READ(DOUT,DIM)                                                    
      CALL NLDIM(DOUT,NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM,KFOUND)         
      IF(KFOUND.LT.0) GOTO 997                                           
      N=NSP                                                              
      IF(MODEL.GT.1) N=NSP+2                                             
C                                                                        
C  COMPUTE ARRAY POINTERS                                                
      NSPN=NSP+NTB                                                       
      IF(NSPN.LT.30) NSPN=30                                             
      IELH=IEL                                                           
      IF(IEL.EQ.0) IELH=1                                                
      N2=1+NSPN                                                          
      N3=N2+NSPN                                                         
      N4=N3+NSPN                                                         
      N5=N4+NSP                                                          
      N6=N5+IELH                                                         
      N7=N6+IELH                                                         
      N8=N7+IELH                                                         
C                                                                        
      NRW8=NCEQ+NSP                                                      
      MH=N8+NRW8                                                         
      IF(MH.GT.NRW) GOTO 999                                             
      NIWH=3*NCEQ                                                        
      IF(NIWH.GT.NIW) GOTO 998                                           
C                                                                        
      CALL LIST (N,NSP,NSPN,NCEQ,IEL,MODEL,NTB,NCW,CW,                   
     & RW(N4),RW(N7),RW(N8),NRW8,NIW,IW,IELH,NLR,ITPM,KFLAG)             
C                                                                        
C----------------------------------------------------------------------- 
C  NORMAL RETURN , NO ERROR                                              
C----------------------------------------------------------------------- 
C                                                                        
      RETURN                                                             
C----------------------------------------------------------------------- 
C  ERROR EXIT                                                            
C----------------------------------------------------------------------- 
997   WRITE(ITOUT,1000)                                                  
      GOTO 2000                                                          
998   WRITE(ITOUT,1001)                                                  
      GOTO 2000                                                          
999   WRITE(ITOUT,1002)                                                  
1000  FORMAT(/,' ERROR ON FILE DOUT OCCURRED DURING READ OF DIMENSIONS') 
1001  FORMAT(/,' INTEGER WORK SPACE EXHAUSTED, ENLARGE IWP',/)           
1002  FORMAT(/,' REAL WORK SPACE EXHAUSTED, ENLARGE NRW',/)              
2000  KFLAG=-1                                                           
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C               END OF SUBROUTINE NUMOUT                                 
C----------------------------------------------------------------------- 
C                                                                        
      END                                                                
      SUBROUTINE LIST (N,NSP,NSPN,NCEQ,IEL,MODEL,NTB,NCW,CW,             
     &        SPATW,ELATW,RW1,NRW1,NIW,IW,IELH,NLR,ITPM,KFLAG)           
C                                                                        
C*********************************************************************** 
C                                                                      * 
C DATE OF LATEST CHANGE: MARCH 1, '86                                  * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  SUBROUTINE LIST LISTS NUMERICAL DATA STORED ON DATABASE 'OUT'       * 
C  AND PERFORMS A TEST FOR INSIGNIFICANT CHEMICAL REACTIONS.           * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  INPUT PARAMETERS                                                    * 
C------------------                                                    * 
C    NSP:  MAXIMUM NUMBER OF SPECIES TO BE HANDLED                     * 
C    NTB:  NUMBER OF THIRD BODIES DEFINED IN REACTION SYSTEM           * 
C    N:    MAXIMUM NUMBER OF DIFFERENTIAL EQUATIONS ( .LE. NSP+2 )     * 
C    NSPN: = MAX ( 30 , NSP+NTB )                                      * 
C    NCEQ:  MAXIMUM NUMBER OF CHEMICAL EQUATIONS TO BE HANDLED         * 
C    IEL:  MAXIMUM NUMBER OF ELEMENTS TO BE HANDELD                    * 
C    IELH: = MAX ( 1 , IEL )                                           * 
C    MODEL: MODEL PARAMETER (SEE DRIVER)                               * 
C    ITPM: NUMBER OF OUTPUT POINTS                                     * 
C                                                                      * 
C    CW(NSP*10):                                                       * 
C            WORK ARRAYS INTERNALLY USED FOR STORAGE OF SPECIES NAMES  * 
C                                                                      * 
C    SPATW(NSP):                                                       * 
C            WORK ARRAY INTERNALLY USED FOR SPECIES MOLECULAR WEIGHTS  * 
C                                                                      * 
C    ELN1(IEL),ELN2(IEL),ELN3(IEL):                                    * 
C            WORK ARRAYS FOR ELEMENT NAMES                             * 
C                                                                      * 
C    ELATW(IEL):                                                       * 
C             WORK ARRAY FOR ELEMENT ATOMIC WEIGHTS                    * 
C                                                                      * 
C    RW1(NRW1):  NRW1 = NCEQ + NSP                                     * 
C             WORK ARRAY USED IN SUBROUTINE SIGNIF                     * 
C                                                                      * 
C    IW(NIW):    NIW = 3*NCEQ                                          * 
C             WORK ARRAY USED IN SUBROUTINE SIGNIF                     * 
C                                                                      * 
C    KFLAG:  PRINT PARAMETER                                           * 
C            = 0:   ONLY FIXED STANDARD OUTPUT (WRITTEN ON TERMINAL)   * 
C            = 1/2: OUTPUT SELECTION BY DIALOG (OUTPUT ON TERMINAL)    * 
C                                                                      * 
C            = 10/11/12:  AS 0/1/2 BUT OUTPUT WRITTEN ON PRINTER       * 
C                                                                      * 
C                                                                      * 
C  OUTPUT PARAMETERS                                                   * 
C-------------------                                                   * 
C    KFLAG: ERROR FLAG                                                 * 
C           = 0: SUCCESSFULL OUTPUT                                    * 
C           =-1: LIST ENDED DUE TO ERROR                               * 
C                                                                      * 
C  COMMON BLOCKS                                                       * 
C---------------                                                       * 
C                                                                      * 
C     INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT* 
C     COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT* 
C                                                                      * 
C   LOGICAL UNITS (SEE DESCRIPTION OF LARKIN DRIVING ROUTINE)          * 
C                                                                      * 
C     COMMON / RATE1  / C(NSP)                                         * 
C     COMMON / KINPAR / RK(NCEQ)                                       * 
C     COMMON / DELHR  / DHR(NCEQ)                                      * 
C   PROVIDE REAL WORK SPACE FOR NAMELIST STATEMENTS                    * 
C                                                                      * 
C     COMMON / LARK1  / LR(NLR)                                        * 
C     COMMON / LARK2  / PLR(2*NCEQ)                                    * 
C   PROVIDE INTEGER WORK SPACE (FOR DIMENSIONS SEE DRIVER)             * 
C                                                                      * 
C*********************************************************************** 
C                                                                      * 
C  IMPLEMENTED STANDARD OPTIONS FOR OUTPUT                             * 
C  (MAY BE ALTERED BY THE SKILLFULL USER)                              * 
C                                                                      * 
C   - FOR COMPOSITION OF FIXED STANDARD OUTPUT LISTING:                * 
C     FOLLOWING OUTPUT IS LISTED (IF AVAILABLE IN DATABASE 'OUT'):     * 
C       1.) ELEMENT AND SPECIES INFO                                   * 
C       2.) MOLAR CONCENTRATIONS                                       * 
C       3.) SUM OF MOLAR CONCENTRATIONS                                * 
C       4.) GAS CONDITIONS (TEMP.,PRESS.,DENSITY,VOLUME)               * 
C           (TOP AND HEAD ARE ALWAYS WRITTEN)                          * 
C                                                                      * 
C  IMPLEMENTATION BY SETTING:                                          * 
C  STDMAX = 4 (NUMBER OF OUTPUT BLOCKS)                                * 
C  STD(L) = FLAG  (L=1,..,STDMAX)                                      * 
C                                                                      * 
C   FLAG: INTERNALLY USED FLAG TO IDENTIFY OUTPUT BLOCKS               * 
C                                                                      * 
C                                                                      * 
C     ALLOWED FLAGS              ASSOCIATED OUTPUT BLOCK               * 
C     -------------              -----------------------               * 
C          2                       ELEMENT AND SPECIES INFO            * 
C          3                       MOLAR CONCENTRATIONS                * 
C          4                       SUM OF MOLAR CONCENTRATIONS         * 
C          5                       GAS CONDITIONS                      * 
C          6                       RATES                               * 
C          7                       INTEGRATED RATES                    * 
C          8                       KINETIC PARAMETERS                  * 
C         11                       TEST FOR INSIGNIFICANT REACTIONS    * 
C                                  (WITH STANDARD SETTINGS)            * 
C                                                                      * 
C  -FOR SELECTION OF OUTPUT POINTS (CONTROLLED BY PARAMETER IOP):      * 
C     THE FOLLOWING OPTIONS ARE POSSIBLE:                              * 
C     IOP=0:  OUTPUT AT TP(1) AND TP(ITPM) (STARTING AND FINAL         * 
C             POINT OF INTEGRATION)                                    * 
C     IOP=1:  OUTPUT AT ALL PRESCRIBED OUTPUT POINTS TP(I)             * 
C             ( I=1,...,ITPM )                                         * 
C     IOP=2:  OUTPUT AT ALL INTEGRATION POINTS                         * 
C                                                                      * 
C                                                                      * 
C  STANDARD VALUE: IOP = 1                                             * 
C                  -------                                             * 
C  (MAY BE TEMPORARY OVERWRITTEN IN DIALOG SESSION)                    * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
      DOUBLE PRECISION XX                                                
CSP       REAL XX                                                        
      REAL SPATW(NSP),                                                   
     &     ELATW(IELH),RW1(NRW1)                                         
C                                                                        
      REAL TP(50),T,SUM,CHAR,C,RK,TEMP,DENSY,PRESS,VOLUME,DHR            
C                                                                        
      INTEGER LOUT                                                       
      INTEGER NUM(2),STD(10),STDMAX                                      
      CHARACTER*1 TAB(2,12),AC,CC,EC,FC,IC,KC,OC,QC,RC,SC,TC,GC,         
     & ALC,CLC,ELC,FLC,ILC,KLC,OLC,QLC,RLC,SLC,TLC,GLC                   
      CHARACTER*1 PLUS,EQUAL,CW(NCW),ELEM(10,5)                          
CI4       INTEGER LR,PLR,IW(NIW)                                         
      INTEGER*2 LR,PLR,IW(NIW)                                           
      REAL G                                                             
      INTEGER I, ICW, IFLAG, IH, IHEAD, ILMAX, ILOOP, IND, IOP, ITB,     
     & ITP, J, JFLAG, K, KF, KF1, KFOUND, KH1, KTB, L, L1, L2, LFLAG,    
     & LTB, NCEQ2, NCTB, NH1, NH2, NSPCW, T0, T1, TAUG, TAUL, TEND, TH   
      LOGICAL LMW                                                        
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
C                                                                        
      COMMON / RATE1  / C(1000)                                          
      COMMON / DELHR  / DHR(1000)                                        
      COMMON / KINPAR / RK(1000)                                         
      COMMON / LARK1  / LR(5000)                                         
      COMMON / LARK2  / PLR(2000)  
      SAVE /LUNIT/, /RATE1/, /DELHR/, /KINPAR/, /LARK1/, /LARK2/
C                                                                        
C1      NAMELIST / FCN1  / LR                                            
C1      NAMELIST / FCN2  / PLR                                           
C1      NAMELIST / TOUT  / TP                                            
C1      NAMELIST / EATW  / RK                                            
C1      NAMELIST / SATW  / RK                                            
C1      NAMELIST / CONC  / T,C                                           
C1      NAMELIST / KIPA  / T,RK                                          
C1      NAMELIST / SUMC  / T,SUM                                         
C1      NAMELIST / RATE  / T,RK                                          
C      NAMELIST / IRATE / T,RK            WIRD NICHT ZITIERT             
C1      NAMELIST / RECO  / T,TEMP,DENSY,PRESS,VOLUME                     
C1      NAMELIST / TBO1  / LR                                            
C1      NAMELIST / TBO2  / C                                             
C1      NAMELIST / DHRE  / T,DHR                                         
C                                                                        
      DATA AC/'A'/ , CC/'C'/ , EC/'E'/ , FC/'F'/ , IC/'I'/ , KC/'K'/ ,   
     &     OC/'O'/ , QC/'Q'/ , RC/'R'/ , SC/'S'/ , TC/'T'/ , GC/'G'/ ,   
     &     PLUS/'+'/ , EQUAL/'='/                                        
      DATA ALC/'a'/, CLC/'c'/, ELC/'e'/, FLC/'f'/, ILC/'i'/, KLC/'k'/,   
     &     OLC/'o'/, QLC/'q'/, RLC/'r'/, SLC/'s'/, TLC/'t'/, GLC/'g'/    
C                                                                        
C                                                                        
C  REWIND INPUT FILE                                                     
C-------------------                                                     
      REWIND DOUT
C                                                                        
C  DEFINE OUTPUT FILE                                                    
C--------------------                                                    
      LOUT=ITOUT                                                         
      IF(KFLAG.LT.10) GOTO 10                                            
      LOUT=POUT                                                          
      KFLAG=KFLAG-10                                                     
10    CONTINUE                                                           
C                                                                        
C  PREPARATIONS                                                          
C--------------                                                          
      KF=KFLAG                                                           
      KF1=KFLAG                                                          
      DO 100 I=1,NSP                                                     
100   SPATW(I)=0.                                                        
      DO 110 I=1,IELH                                                    
110   ELATW(I)=0.                                                        
C                                                                        
C  SET STANDARD VALUES FOR FIXED STANDARD OUTPUT                         
C-----------------------------------------------                         
C                                                                        
      STDMAX=4                                                           
      STD(1)=2                                                           
      STD(2)=3                                                           
      STD(3)=4                                                           
      STD(4)=5                                                           
      STD(5)=11                                                          
      STD(6)=5                                                           
      STD(7)=6                                                           
      STD(8)=7                                                           
C                                                                        
C                                                                        
C  SET STANDARD VALUE FOR OUTPUT POINT SELECTION                         
C-----------------------------------------------                         
C                                                                        
      IOP=1                                                              
      IND=IOP                                                            
C                                                                        
C  WRITE TOP                                                             
C-----------                                                             
      WRITE(LOUT,8100)                                                   
8100  FORMAT(//,19X,'SIMULATION DATA',/,19X,15('-'))                     
C                                                                        
C  READ/WRITE HEAD                                                       
C-----------------                                                       
      READ(DOUT,8101) IHEAD                                              
      IH=IHEAD*72                                                        
8101  FORMAT(15X,I3)                                                     
      IF(IHEAD.GT.0) READ(DOUT,8102) (CW(L),L=1,IH)                      
8102  FORMAT(1X,72A1)                                                    
      WRITE(LOUT,8105)                                                   
8105  FORMAT(//,19X,'ACTUAL MODEL:',/,19X,13('-'),/)                     
      IF(IH.GT.0) WRITE(LOUT,8102) (CW(L),L=1,IH)                        
      READ(DOUT,8110) CHAR                                               
      IF(MODEL.EQ.1) WRITE(ITOUT,9100)                                   
      IF(MODEL.EQ.2) WRITE(ITOUT,9150)                                   
      IF(MODEL.EQ.3) WRITE(ITOUT,9200)                                   
      IF(MODEL.EQ.4) WRITE(ITOUT,9250)                                   
      IF(MODEL.EQ.5) WRITE(ITOUT,9300)                                   
      IF(MODEL.EQ.6) WRITE(ITOUT,9350)                                   
9100  FORMAT(/,10X,' *** ISOTHERMIC MODEL ***')                          
9150  FORMAT(/,10X,' *** PRESCRIBED TEMPERATURE MODEL ***')              
9200  FORMAT(/,10X,' *** CONSTANT DENSITY MODEL ***')                    
9250  FORMAT(/,10X,' *** PRESCRIBED DENSITY MODEL ***')                  
9300  FORMAT(/,10X,' *** CONSTANT PRESSURE MODEL ***')                   
9350  FORMAT(/,10X,' *** PRESCRIBED PRESSURE MODEL ***')                 
C                                                                        
C READ OUTPUT POINTS                                                     
C-------------------                                                     
C      READ(DOUT,TOUT)                                                   
      CALL NLTOUT(DOUT,TP,ITPM,KFOUND)                                   
C                                                                        
C READ (OPTIONAL) ELEMENT NAMES                                          
C------------------------------                                          
      IF(IEL.LE.0) GOTO 1400                                             
      READ(DOUT,8110) CHAR                                               
      READ(DOUT,8111) ((ELEM(I,L),L=1,5),I=1,IEL)                        
8111  FORMAT(7(1X,5A1,4X))                                               
      READ(DOUT,8110) CHAR                                               
C                                                                        
C READ (OPTIONAL) ELEMENT ATOMIC WEIGHTS                                 
C---------------------------------------                                 
C (IF IEL.GT.0 BUT NO ATOMIC W. ARE GIVEN IN CHEMICAL INPUT: ELATW(I)=0) 
C      READ(DOUT,EATW)                                                   
      CALL NLEATW(DOUT,RK,IEL,KFOUND)                                    
      DO 1420 I=1,IEL                                                    
1420  ELATW(I)=RK(I)                                                     
1400  CONTINUE                                                           
C                                                                        
C  READ SPECIES NAMES                                                    
C--------------------                                                    
      READ(DOUT,8110) CHAR                                               
8110  FORMAT(A4)                                                         
      READ(DOUT,8112) (CW(L),L=1,NSPN*10)                                
8112  FORMAT(5(1X,10A1,3X))                                              
      READ(DOUT,8110) CHAR                                               
C                                                                        
C  READ SPECIES MOLECULAR WEIGHTS                                        
C--------------------------------                                        
C?????????? NAMELIST &SATW WIRD IN DER LAENGE NSP  GESCHRIEBEN          
      IF(IEL.LE.0) GOTO 1460                                             
C      READ(DOUT,SATW)                                                   
      CALL NLSATW(DOUT,SPATW,NSP,KFOUND)                                 
      DO 1450 I=1,NSP                                                    
1450  SPATW(I)=RK(I)                                                     
1460  CONTINUE                                                           
C                                                                        
C  CHECK IF THERE IS A ZERO MOLECULAR WEIGHT                             
      LMW=.TRUE.                                                         
      DO 1470 I=1,NSP                                                    
1470  IF(SPATW(I).EQ.0.) LMW=.FALSE.                                     
C                                                                        
C  SET STANDARD VALUES FOR TEST OF INSIGNIFICANT REACTIONS               
C---------------------------------------------------------               
      TAUL=1.                                                            
      TAUG=1.                                                            
      T0=TP(1)                                                           
      T1=TP(ITPM)                                                        
C                                                                        
      ILMAX=STDMAX                                                       
C                                                                        
C------------------------------------------------------------------      
C  IF ONLY FIXED STANDARD OUTPUT IS DESIRED (KFLAG=0/10): GOTO 1600      
      IF(KF.EQ.0) GOTO 1600                                              
C                                                                        
C------------------------------------------------------------------      
C                                                                        
C-------------------                                                     
C  MAIN DIALOG BLOCK                                                     
C-------------------                                                     
C                                                                        
1500  WRITE(ITOUT,9000)                                                  
9000  FORMAT(//,' SELECT OUTPUT DATA:',/,1X,19('-'),/,                   
     &' FIXED STANDARD OUTPUT (INFO, MOLAR CONC., GAS COND.)'            
     &,/,' ELEMENT AND SPECIES INFO',/,' CONCENTRATIONS (MOLAR CONC.)'   
     &,/,' SUM OF MOLAR CONCENTRATIONS',/,                               
     &' GAS CONDITIONS (TEMP.,DENS.,PRESS.,VOL.)',/,                     
     &' RATES',/,' INTEGRATED RATES',/,' KINETIC PARAMETERS',/,          
     &' OPTIONS (CONVERSION MOLAR CONC. TO MASS/MOLE FRACTION)',/,       
     &' TEST FOR INSIGNIFICANCE OF REACTIONS')                           
      WRITE(ITOUT,9001)                                                  
9001  FORMAT('   OR',/,                                                  
     &' ALTER OUTPUT ALLOCATION ( TERMINAL <-> PRINTER )',/,'   OR',/,   
     &' QUIT')                                                           
      TAB(1,1)=FC                                                        
      TAB(1,2)=EC                                                        
      TAB(1,3)=CC                                                        
      TAB(1,4)=SC                                                        
      TAB(1,5)=GC                                                        
      TAB(1,6)=RC                                                        
      TAB(1,7)=IC                                                        
      TAB(1,8)=KC                                                        
      TAB(1,9)=OC                                                        
      TAB(1,10)=AC                                                       
      TAB(1,11)=TC                                                       
      TAB(1,12)=QC                                                       
      TAB(2,1)=FLC                                                       
      TAB(2,2)=ELC                                                       
      TAB(2,3)=CLC                                                       
      TAB(2,4)=SLC                                                       
      TAB(2,5)=GLC                                                       
      TAB(2,6)=RLC                                                       
      TAB(2,7)=ILC                                                       
      TAB(2,8)=KLC                                                       
      TAB(2,9)=OLC                                                       
      TAB(2,10)=ALC                                                      
      TAB(2,11)=TLC                                                      
      TAB(2,12)=QLC                                                      
C                                                                        
C  SET DEFAULT FOR INDICATOR OF OUTPUT POINT SELECTION                   
      IND=IOP                                                            
C                                                                        
      CALL ANSNUM (TAB,12,NUM,1,XX,IFLAG,100)                            
      IF(NUM(1).GE.0.AND.NUM(1).LE.2) IND=NUM(1)                         
C                                                                        
      ILMAX=1                                                            
      IF(IFLAG.EQ.1) ILMAX=STDMAX                                        
      KF1=KF                                                             
      IF(IFLAG.EQ.1) KF1=0                                               
C                                                                        
C-----------------------------------------------------------             
C  LOOP FOR STANDARD OUTPUT                                              
C                                                                        
C  IF THE STANDARD OUTPUT IS NOT CHOSEN THIS IS A DUMMY LOOP             
C  (ILMAX=1)                                                             
C                                                                        
1600  DO 5000 ILOOP=1,ILMAX                                              
C-----------------------------------------------------------             
C                                                                        
      IF(ILMAX.NE.1) IFLAG=STD(ILOOP)                                    
      IF(STDMAX.EQ.1.AND.IFLAG.EQ.1) IFLAG=STD(ILOOP)                    
C                                                                        
      REWIND DOUT
      GOTO (6050,2000,2100,2200,3500,2300,2400,2500,3000,4000,           
     &      7500,7000) , IFLAG                                           
C                                                                        
      GOTO 6050                                                          
C                                                                        
C  WRITE ELEMENT/SPECIES INFO                                            
C----------------------------                                            
C                                                                        
2000  WRITE(LOUT,2001)                                                   
2001  FORMAT(//,1X,70('-'),/,' *',18X,' ELEMENT AND SPECIES INFO',       
     &         25X,'*',/,1X,70('-'))                                     
      IF(IEL.GT.0) GOTO 2011                                             
      WRITE(LOUT,8201)                                                   
8201  FORMAT(//,' NO ELEMENTS IN CHEMICAL INPUT DEFINED',/)              
      GOTO 2012                                                          
2011  WRITE(LOUT,8202)                                                   
      WRITE(LOUT,8203) (I,(ELEM(I,L),L=1,5),ELATW(I),I=1,IEL)            
8202  FORMAT(/,'  NO    ELEMENT      ATOMIC WEIGHT')                     
8203  FORMAT(I4,4X,5A1,8X,E12.6)                                         
2012  WRITE(LOUT,8204)                                                   
8204  FORMAT(//,'  NO    SPECIES          MOLECULAR WEIGHT')             
      L1=1                                                               
      DO 2020 L=1,NSP                                                    
      L2=L1+9                                                            
      WRITE(LOUT,8205) L,(CW(J),J=L1,L2),SPATW(L)                        
8205  FORMAT(I4,4X,10A1,7X,E12.6)                                        
      L1=L2+1                                                            
2020  CONTINUE                                                           
      IF(NTB.EQ.0) GOTO 2050                                             
C      READ(DOUT,TBO1)                                                   
      CALL NLTBO1(DOUT,LR,NLR,NCTB,KFOUND)                               
C      READ(DOUT,TBO2)                                                   
      CALL NLTBO2(DOUT,C,NCTB,KFOUND)                                    
      WRITE(LOUT,2031) NTB                                               
2031  FORMAT(/,I2,' THIRD BODIES DEFINED IN REACTION')                   
      KTB=0                                                              
      DO 2030 ITB=1,NTB                                                  
      LTB=LR(ITB)                                                        
      NH2=(NSP+ITB)*10                                                   
      NH1=NH2-9                                                          
      KH1=KTB+5                                                          
      IF(LTB.LT.0) GOTO 2032                                             
      L2=LR(KH1+1)*10                                                    
      L1=L2-9                                                            
      WRITE(LOUT,2047) (CW(J),J=NH1,NH2),                                
     &  EQUAL,C(1+KTB),(CW(I),I=L1,L2)                                   
2047  FORMAT(1X,10A1,2X,A1,F6.2,' ',10A1)                                
      IF(LTB.LE.1) GOTO 2035                                             
      DO 2034 L=2,LTB                                                    
      L2=LR(KH1+L)*10                                                    
      L1=L2-9                                                            
      WRITE(LOUT,2049) PLUS,C(L+KTB),(CW(I),I=L1,L2)                     
2049  FORMAT(13X,A1,F6.2,' ',10A1)                                       
2034  CONTINUE                                                           
2035  KTB=KTB+LTB                                                        
      GOTO 2030                                                          
2032  WRITE(LOUT,2048) (CW(J),J=NH1,NH2)                                 
2048  FORMAT(1X,10A1,'=    SUM OF ALL CONCENTRATIONS')                   
2030  CONTINUE                                                           
      GOTO 5000                                                          
2050  WRITE(LOUT,2051)                                                   
2051  FORMAT(/,' NO THIRD BODIES USED IN REACTION')                      
      GOTO 5000                                                          
C                                                                        
C  WRITE MOLAR CONCENTRATIONS                                            
C------------------------------                                          
C                                                                        
C 2100  READ(DOUT,CONC,END=2180)                                         
2100  CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 2180                                          
      WRITE(LOUT,2101)                                                   
2101  FORMAT(//,1X,70('-'),/,' *',19X,' MOLAR CONCENTRATIONS',           
     &             28X,'*',/,1X,70('-'))                                 
      WRITE(LOUT,8211) T                                                 
       WRITE(LOUT,8212)                                                  
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
8211  FORMAT(//,' TIME =',E14.6,/)                                       
8212  FORMAT(1X,10A1,2X,E14.6,15X,10A1,2X,E14.6)                         
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 2150  READ(DOUT,CONC,END=2180)                                         
2150  CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 2180                                          
      IF(T.EQ.TEND) GOTO 2160                                            
      IF(IND.EQ.0) GOTO 2150                                             
      IF(IND.EQ.2) GOTO 2155                                             
      IF(T.NE.TP(I)) GOTO 2150                                           
      I=I+1                                                              
2155  WRITE(LOUT,8211) T                                                 
       WRITE(LOUT,8212)                                                  
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 2150                                                          
2160  WRITE(LOUT,8211) T                                                 
       WRITE(LOUT,8212)                                                  
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 5000                                                          
2180  WRITE(LOUT,8218)                                                   
8218  FORMAT(/,' NO DATA FOR CONCENTRATION AVAILABLE')                   
      GOTO 5000                                                          
C                                                                        
C  WRITE SUM OF MOLAR CONCENTRATIONS                                     
C-----------------------------------                                     
C                                                                        
C 2200  READ(DOUT,SUMC,END=2280)                                         
2200  CALL NLSUMC(DOUT,T,SUM,KFOUND)                                     
      IF(KFOUND.LT.0) GOTO 2280                                          
      WRITE(LOUT,2201)                                                   
2201  FORMAT(//,1X,70('-'),/,' *',16X,' SUM OF MOLAR CONCENTRATIONS',    
     &  24X,'*',/,1X,70('-'))                                            
      WRITE(LOUT,8220)                                                   
8220  FORMAT(/,18X,'TIME',21X,'SUM',/)                                   
      WRITE(LOUT,8221) T,SUM                                             
8221  FORMAT(14X,E14.7,8X,E14.7)                                         
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 2250  READ(DOUT,SUMC,END=2280)                                         
2250  CALL NLSUMC(DOUT,T,SUM,KFOUND)                                     
      IF(KFOUND.LT.0) GOTO 2280                                          
      IF(T.EQ.TEND) GOTO 2260                                            
      IF(IND.EQ.0) GOTO 2250                                             
      IF(IND.EQ.2) GOTO 2255                                             
      IF(T.NE.TP(I)) GOTO 2250                                           
      I=I+1                                                              
2255  WRITE(LOUT,8221) T,SUM                                             
      GOTO 2250                                                          
2260  WRITE(LOUT,8221) T,SUM                                             
      GOTO 5000                                                          
2280  WRITE(LOUT,8228)                                                   
8228  FORMAT(/,' NO DATA FOR SUM OF CONCENTRATION AVAILABLE')            
      GOTO 5000                                                          
C                                                                        
C  WRITE GAS CONDITIONS                                                  
C----------------------                                                  
C                                                                        
C 3500  READ(DOUT,RECO,END=3590)                                         
3500  CALL NLRECO(DOUT,T,TEMP,DENSY,PRESS,VOLUME,KFOUND)                 
      IF(KFOUND.LT.0) GOTO 3590                                          
      WRITE(LOUT,3510)                                                   
3510  FORMAT(//,1X,70('-'),/,' *',23X,' GAS CONDITIONS',                 
     & 30X,'*',/,1X,70('-'),//,' TIME',11X,'TEMP.',5X,'DENSITY',6X,      
     & 'PRESSURE',5X,'VOLUME',/)                                         
      WRITE(LOUT,3501) T,TEMP,DENSY,PRESS,VOLUME                         
3501  FORMAT(1X,E10.4,5X,F7.2,3X,E10.4,3X,E10.4,3X,F5.2)                 
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 3550  READ(DOUT,RECO,END=3590)                                         
3550  CALL NLRECO(DOUT,T,TEMP,DENSY,PRESS,VOLUME,KFOUND)                 
      IF(KFOUND.LT.0) GOTO 3590                                          
      IF(T.EQ.TEND) GOTO 3560                                            
      IF(IND.EQ.0) GOTO 3550                                             
      IF(IND.EQ.2) GOTO 3555                                             
      IF(T.NE.TP(I)) GOTO 3550                                           
      I=I+1                                                              
3555  WRITE(LOUT,3501) T,TEMP,DENSY,PRESS,VOLUME                         
      GOTO 3550                                                          
3560  WRITE(LOUT,3501) T,TEMP,DENSY,PRESS,VOLUME                         
      GOTO 5000                                                          
3590  WRITE(LOUT,3591)                                                   
3591  FORMAT(/,' NO DATA FOR GAS CONDITIONS AVAILABLE')                  
      GOTO 5000                                                          
C                                                                        
C  WRITE RATES                                                           
C-------------                                                           
C                                                                        
C 2300  READ(DOUT,RATE,END=2380)                                         
2300  CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2380                                          
      WRITE(LOUT,2301)                                                   
2301  FORMAT(//,1X,70('-'),/,' *',26X,' RATES',                          
     &         36X,'*',/,1X,70('-'))                                     
      WRITE(LOUT,8231) T                                                 
      WRITE(LOUT,8232) (L,RK(L),L=1,NCEQ)                                
8231  FORMAT(//,' TIME =',E14.6,/,' EQUATION          VALUE',            
     &       13X,' EQUATION          VALUE')                             
8232  FORMAT(4X,I5,5X,E12.6,13X,I5,5X,E12.6)                             
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 2350  READ(DOUT,RATE,END=2380)                                         
2350  CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2380                                          
      IF(T.EQ.TEND) GOTO 2360                                            
      IF(IND.EQ.0) GOTO 2350                                             
      IF(IND.EQ.2) GOTO 2355                                             
      IF(T.NE.TP(I)) GOTO 2350                                           
      I=I+1                                                              
2355  WRITE(LOUT,8231) T                                                 
      WRITE(LOUT,8232) (L,RK(L),L=1,NCEQ)                                
      GOTO 2350                                                          
2360  WRITE(LOUT,8231) T                                                 
      WRITE(LOUT,8232) (L,RK(L),L=1,NCEQ)                                
      GOTO 5000                                                          
2380  WRITE(LOUT,8238)                                                   
8238  FORMAT(/,' NO DATA FOR RATES AVAILABLE')                           
      GOTO 5000                                                          
C                                                                        
C  COMPUTE/WRITE INTEGRATED RATES                                        
C--------------------------------                                        
C                                                                        
2400  TEND=TP(ITPM)                                                      
      DO 2401 I=1,NCEQ                                                   
2401  RW1(I)=0.                                                          
C      READ(DOUT,RATE,END=2480)                                          
      CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2480                                          
      WRITE(LOUT,2410)                                                   
2410  FORMAT(//,1X,70('-'),/,' *',22X,' INTEGRATED RATES',               
     &         29X,'*',/,1X,70('-'))                                     
      WRITE(LOUT,8241) T                                                 
2402  WRITE(LOUT,8232) (L,RW1(L),L=1,NCEQ)                               
8241  FORMAT(//,' TIME =',E14.6,/,                                       
     &       ' EQUATION        VALUE',13X,' EQUATION        VALUE')      
2403  DO 2404 I=1,NCEQ                                                   
2404  C(I)=RK(I)                                                         
      TH=T                                                               
      ITP=2                                                              
C      READ(DOUT,RATE,END=2480)                                          
      CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2480                                          
      G=(T-TH)/2.                                                        
      DO 2405 I=1,NCEQ                                                   
2405  RW1(I)=RW1(I) + G*(C(I)+RK(I))                                     
      IF(T.EQ.TEND) GOTO 2460                                            
      IF(IND.EQ.0) GOTO 2403                                             
      IF(IND.EQ.2) GOTO 2402                                             
      IF(T.NE.TP(ITP)) GOTO 2403                                         
      ITP=ITP+1                                                          
      WRITE(LOUT,8241) T                                                 
      WRITE(LOUT,8232) (L,RW1(L),L=1,NCEQ)                               
      GOTO 2403                                                          
2460  WRITE(LOUT,8241) T                                                 
      WRITE(LOUT,8232) (L,RW1(L),L=1,NCEQ)                               
      GOTO 5000                                                          
2480  WRITE(LOUT,8238)                                                   
      WRITE(LOUT,8248)                                                   
8248  FORMAT(' COMPUTATION OF INTEGRATED RATES NOT POSSIBLE')            
      GOTO 5000                                                          
C                                                                        
C  WRITE KINETIC PARAMETERS                                              
C--------------------------                                              
C                                                                        
C 2500  READ(DOUT,KIPA,END=2580)                                         
2500  CALL NLKIPA(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2580                                          
      WRITE(LOUT,2501)                                                   
2501  FORMAT(//,1X,70('-'),/,' *',21X,' KINETIC PARAMETERS',             
     &         28X,'*',/,1X,70('-'))                                     
      WRITE(LOUT,8250) T                                                 
8250  FORMAT(//,7H TIME =,D15.8,/,                                       
     &   ' EQUATION        VALUE',13X,' EQUATION        VALUE')          
      WRITE(LOUT,8232) (I,RK(I),I=1,NCEQ)                                
      IF(MODEL.EQ.1) GOTO 5000                                           
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 2550  READ(DOUT,KIPA,END=2580)                                         
2550  CALL NLKIPA(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 2580                                          
      IF(T.EQ.TEND) GOTO 2560                                            
      IF(IND.EQ.0) GOTO 2550                                             
      IF(IND.EQ.2) GOTO 2555                                             
      IF(T.NE.TP(I)) GOTO 2550                                           
      I=I+1                                                              
2555  WRITE(LOUT,8250) T                                                 
      WRITE(LOUT,8232) (L,RK(L),L=1,NCEQ)                                
      GOTO 2550                                                          
2560  WRITE(LOUT,8250) T                                                 
      WRITE(LOUT,8232) (L,RK(L),L=1,NCEQ)                                
      GOTO 5000                                                          
2580  WRITE(LOUT,8252)                                                   
8252  FORMAT(/,' NO DATA FOR KINETIC PARAMETERS AVAILABLE')              
      GOTO 5000                                                          
C                                                                        
C----------------------------------------------------------------------- 
C OPTIONS: DIALOG BLOCK FOR ADDITIONAL OUTPUT OPTIONS                    
C----------------------------------------------------------------------- 
C                                                                        
3000  CONTINUE                                                           
C                                                                        
3200  WRITE(ITOUT,9003)                                                  
9003  FORMAT(/,' CHOOSE OPTION:',/,                                      
     &' CONVERT MOLAR CONCENTRATIONS IN MOLE FRACTIONS   ENTER: O',/,    
     &' CONVERT MOLAR CONCENTRATIONS IN MASS FRACTIONS  ENTER: A',/,     
     &' RETURN    ( LEAVE SUBSYSTEM ''NUMERICAL OUTPUT'' )',/,           
     &' QUIT')                                                           
      TAB(1,1)=OC                                                        
      TAB(1,2)=AC                                                        
      TAB(1,3)=RC                                                        
      TAB(1,4)=QC                                                        
      TAB(2,1)=OLC                                                       
      TAB(2,2)=ALC                                                       
      TAB(2,3)=RLC                                                       
      TAB(2,4)=QLC                                                       
      IND=IOP                                                            
      CALL ANSNUM (TAB,4,NUM,1,XX,JFLAG,100)                             
      IF(NUM(1).GE.0.AND.NUM(1).LE.2) IND=NUM(1)                         
      REWIND DOUT
C                                                                        
      GOTO (3300,3400,7000,5000) , JFLAG                                 
C                                                                        
      GOTO 6050                                                          
C                                                                        
C  COMPUTE AND WRITE MOLE FRACTIONS                                      
C----------------------------------                                      
C                                                                        
C 3300  READ(DOUT,CONC,END=3380)                                         
3300  CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 3380                                          
C      READ(DOUT,SUMC,END=3380)                                          
      CALL NLSUMC(DOUT,T,SUM,KFOUND)                                     
      IF(KFOUND.LT.0) GOTO 2380                                          
      DO 3310 K=1,NSP                                                    
3310  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8331) T                                                 
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
8331  FORMAT(//,' MOLE FRACTIONS AT T=',E14.6,/)                         
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 3350  READ(DOUT,CONC,END=3380)                                         
3350  CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 3380                                          
C      READ(DOUT,SUMC,END=3380)                                          
      CALL NLSUMC(DOUT,T,SUM,KFOUND)                                     
      IF(KFOUND.LT.0) GOTO 2380                                          
      IF(T.EQ.TEND) GOTO 3360                                            
      IF(IND.EQ.0) GOTO 3350                                             
      IF(IND.EQ.2) GOTO 3355                                             
      IF(T.NE.TP(I)) GOTO 3350                                           
      I=I+1                                                              
3355  WRITE(LOUT,8331) T                                                 
      DO 3356 K=1,NSP                                                    
3356  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 3350                                                          
3360  WRITE(LOUT,8331) T                                                 
      DO 3370 K=1,NSP                                                    
3370  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 3200                                                          
3380  WRITE(LOUT,8218)                                                   
      GOTO 3200                                                          
C                                                                        
C  COMPUTE AND WRITE MASS FRACTIONS                                      
C----------------------------------                                      
C                                                                        
3400  IF(.NOT.LMW) GOTO 3900                                             
C       READ(DOUT,CONC,END=3380)                                         
      CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 3380                                          
      SUM=0.                                                             
      DO 3410 K=1,NSP                                                    
      C(K)=C(K)*SPATW(K)                                                 
3410  SUM=SUM+C(K)                                                       
      DO 3411 K=1,NSP                                                    
3411  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8431) T                                                 
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
8431  FORMAT(//,' MASS FRACTIONS AT T=',E14.6,/)                         
      TEND=TP(ITPM)                                                      
      I=2                                                                
C 3450  READ(DOUT,CONC,END=3380)                                         
3450  CALL NLCONC(DOUT,T,C,NSP,KFOUND)                                   
      IF(KFOUND.LT.0) GOTO 3380                                          
      SUM=0.                                                             
      IF(T.EQ.TEND) GOTO 3460                                            
      IF(IND.EQ.0) GOTO 3450                                             
      IF(IND.EQ.2) GOTO 3455                                             
      IF(T.NE.TP(I)) GOTO 3450                                           
      I=I+1                                                              
3455  WRITE(LOUT,8431) T                                                 
      DO 3456 K=1,NSP                                                    
      C(K)=C(K)*SPATW(K)                                                 
3456  SUM=SUM+C(K)                                                       
      DO 3457 K=1,NSP                                                    
3457  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 3450                                                          
3460  WRITE(LOUT,8431) T                                                 
      DO 3470 K=1,NSP                                                    
      C(K)=C(K)*SPATW(K)                                                 
3470  SUM=SUM+C(K)                                                       
      DO 3471 K=1,NSP                                                    
3471  C(K)=C(K)/SUM                                                      
      WRITE(LOUT,8212)                                                   
     & ((CW(J),J=L*10-9,L*10),C(L),L=1,NSP)                              
      GOTO 3200                                                          
3900  WRITE(LOUT,8319)                                                   
8319  FORMAT(//,' ZERO MOLECULAR WEIGHT FOUND, CONVERSION NOT POSSIBLE'  
     &       ,/,' ENTER COMPLETE ELEMENT ATOMIC WEIGHT LIST AND',/,      
     &       ' SPECIES ELEMENT COMPOSITION LIST AS CHEMICAL INPUT')      
      GOTO 3200                                                          
C                                                                        
C----------------------------------------------------------------------- 
C  END DIALOG BLOCK FOR OPTIONS                                          
C----------------------------------------------------------------------- 
C                                                                        
C----------------------------------------------------------------------- 
C  DIALOG BLOCK FOR TEST OF INSIGNIFICANT REACTIONS                      
C----------------------------------------------------------------------- 
7500  CONTINUE                                                           
C                                                                        
C  READ SYMBOLIC REPRESENTAION OF FCN                                    
C------------------------------------                                    
C      READ(DOUT,FCN1,END=7702)                                          
      CALL NLFCN1(DOUT,LR,NLR,KFOUND)                                    
      IF(KFOUND.LT.0) GOTO 7702                                          
C      READ(DOUT,FCN2,END=7702)                                          
      NCEQ2=NCEQ+NCEQ                                                    
      CALL NLFCN2(DOUT,PLR,NCEQ2,KFOUND)                                 
C      IF(KFOUND.LT.0) GOTO 7702                                         
C                                                                        
C  SET STANDARD VALUE FOR PRINT OUTPUT OF SUBROUTINE SIGNIF              
C  (SEE DESCRIPTION OF SIGNIF)                                           
      LFLAG=1                                                            
C                                                                        
      IF(KF1.EQ.0) GOTO 7700                                             
7600  WRITE(ITOUT,7501) TAUL,TAUG,T0,T1                                  
7501  FORMAT(/,' PLEASE , ENTER',/,                                      
     & '     G  FOR TEST',/,                                             
     & '     T  TO CHANGE TOLERANCES FOR TEST',/,                        
     & '        (ACTUAL : ',F5.2,' % LOCAL, ',F5.2,' % INTEGRAL),'/,     
     & '     I  TO CHANGE TIME - RANGE FOR TEST',/,                      
     & '        (ACTUAL : T0 = ',E8.2,', T1 = ',E8.2,')',/,              
     & '     E  FOR TEST WITH EXTENDED TEST-OUTPUT',/,                   
     & '     Q  FOR QUIT',/,                                             
     & '     R  TO LEAVE SUBSYSTEM ''NUM. OUTPUT''')                     
C                                                                        
      TAB(1,1)=GC                                                        
      TAB(1,2)=TC                                                        
      TAB(1,3)=IC                                                        
      TAB(1,4)=EC                                                        
      TAB(1,5)=QC                                                        
      TAB(1,6)=RC                                                        
      TAB(2,1)=GLC                                                       
      TAB(2,2)=TLC                                                       
      TAB(2,3)=ILC                                                       
      TAB(2,4)=ELC                                                       
      TAB(2,5)=QLC                                                       
      TAB(2,6)=RLC                                                       
      CALL ANSNUM (TAB,6,NUM,1,XX,JFLAG,100)                             
      LFLAG=0                                                            
      IF(JFLAG.EQ.4) LFLAG=JFLAG                                         
      REWIND DOUT
C                                                                        
      GOTO (7700,7520,7530,7700,5000,7000) , JFLAG                       
      GOTO 6050                                                          
C                                                                        
C  CHANGE TOLERANCES BY DIALOG                                           
7520  CONTINUE                                                           
      TAB(1,1)=QC                                                        
      TAB(2,1)=QLC                                                       
      WRITE(ITOUT,7521)                                                  
7521  FORMAT(' ENTER TOLERANCE FOR LOCAL TEST    OR  QUIT :')            
      CALL ANSNUM (TAB,1,NUM,-1,XX,JFLAG,100)                            
      IF(JFLAG.NE.1) TAUL=XX                                             
      WRITE(ITOUT,7522)                                                  
7522  FORMAT(' ENTER TOLERANCE FOR INTEGRAL TEST    OR  QUIT :')         
      CALL ANSNUM (TAB,1,NUM,-1,XX,JFLAG,100)                            
      IF(JFLAG.NE.1) TAUG=XX                                             
      GOTO 7600                                                          
C                                                                        
C  CHANGE INTERVAL BY DIALOG                                             
7530  CONTINUE                                                           
      TAB(1,1)=QC                                                        
      TAB(2,1)=QLC                                                       
      WRITE(ITOUT,7531)                                                  
7531  FORMAT(' ENTER T0 (REAL NUMBER)    OR  QUIT :')                    
      CALL ANSNUM (TAB,1,NUM,-1,XX,JFLAG,100)                            
      IF(JFLAG.NE.1) T0=XX                                               
      WRITE(ITOUT,7532)                                                  
7532  FORMAT(' ENTER T1 (REAL NUMBER > T0)    OR  QUIT :')               
      CALL ANSNUM (TAB,1,NUM,-1,XX,JFLAG,100)                            
      IF(JFLAG.NE.1) T1=XX                                               
      GOTO 7600                                                          
C                                                                        
7700  NSPCW=(NSP+NTB)*10                                                 
      ICW=NCW-NSPCW                                                      
      CALL SIGNIF (NSP,NCEQ,MODEL,TAUL,TAUG,T0,T1,TP(1),TP(ITPM),        
     & NSPCW,CW(1),RW1(1),RW1(NCEQ+1),IW(1),IW(NCEQ+1),IW(2*NCEQ+1),     
     & ICW,CW(NSPCW+1),LOUT,LFLAG)                                       
C                                                                        
      IF(LFLAG.LT.0) WRITE(LOUT,7701)                                    
7701  FORMAT(/,' TEST NOT POSSIBLE',/)                                   
      IF(KF1.EQ.0) GOTO 5000                                             
      GOTO 7600                                                          
C                                                                        
7702  WRITE(LOUT,7703)                                                   
7703  FORMAT(/,' NO DATA FOR SYMBOLIC FCN AVAILABLE')                    
      GOTO 5000                                                          
C                                                                        
C----------------------------------------------------------------------- 
C  END OF DIALOG BLOCK FOR TEST OF INSIGNIFICANT REACTIONS               
C----------------------------------------------------------------------- 
C                                                                        
C  ALTER LOGICAL OUTPUT UNIT 'LOUT'                                      
C----------------------------------                                      
C                                                                        
4000  IF(LOUT.NE.POUT) GOTO 4100                                         
      LOUT=ITOUT                                                         
      GOTO 4030                                                          
4100  LOUT=POUT                                                          
4030  IF(LOUT.EQ.ITOUT) WRITE(ITOUT,4010)                                
4010  FORMAT(/,' OUTPUT UNIT IS NOW TERMINAL')                           
      IF(LOUT.EQ.POUT) WRITE(ITOUT,4020)                                 
4020  FORMAT(/,' OUTPUT UNIT IS NOW PRINTER')                            
C                                                                        
C------------------------------                                          
C  END LOOP FOR STANDARD OUTPUT                                          
5000  CONTINUE                                                           
C------------------------------                                          
C                                                                        
C------------------------------------                                    
C  CONTINUE DIALOG IF KFLAG=1/2/11/12                                    
      IF(KF.NE.0) GOTO 1500                                              
C------------------------------------                                    
      GOTO 7000                                                          
C                                                                        
C  ERROR RETURN                                                          
C--------------                                                          
C                                                                        
6050  WRITE(ITOUT,9991)                                                  
9991  FORMAT(//,' ERROR: POSSIBLY WRONG DEFAULTS FOR STANDARD OUTPUT')   
6099  KFLAG=-1                                                           
      REWIND DOUT
      RETURN                                                             
C                                                                        
C  NORMAL RETURN                                                         
C---------------                                                         
C                                                                        
7000  REWIND DOUT 
      KFLAG=0                                                            
      RETURN                                                             
C                                                                        
C              END OF SUBROUTINE LIST                                    
C                                                                        
      END                                                                
      SUBROUTINE SIGNIF (NSP,NCEQ,MODEL,TAUL,TAUG,T0,T1,TMIN,TMAX,       
     &  NSPCW,SPCW,RINT,PERC,IMPORT,IMPALL,IMPT,NCW,CW,LOUT,LFLAG)       
C                                                                        
C*********************************************************************** 
C                                                                      * 
C  INPUT PARAMETERS                                                    * 
C------------------                                                    * 
C                                                                      * 
C    NSP           NUMBER OF CHEMICAL SPECIES                          * 
C    NCEQ          NUMBER OF CHEMICAL EQUATIONS                        * 
C    TAUL          TOLERANCE FOR LOCAL TEST                            * 
C    TAUG          TOLERANCE FOR INTEGRAL TEST                         * 
C    T0,T1         TIME RANGE (T0.LT.T1) FOR INTEGRAL TEST             * 
C    TMIN,TMAX     MAXIMUM TIME RANGE                                  * 
C    SPN1(NSP)     !                                                   * 
C    SPN2(NSP)     ! SPECIES NAMES                                     * 
C    SPN3(NSP)     !                                                   * 
C    LOUT          LOGICAL UNIT FOR OUTPUT                             * 
C    LFLAG         PRINT PARAMETER                                     * 
C                  = 0: ONLY NUMBERS OF INSIGNIFICANT REACTIONS ARE    * 
C                       LISTED                                         * 
C                  > 0: EXTENDED OUTPUT (FORMATION AND CONSUMPTION OF  * 
C                       SPECIES PER REACTION, GRAPHIC OF LOCAL TEST)   * 
C  COMMON BLOCKS                                                       * 
C---------------                                                       * 
C                                                                      * 
C     INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT* 
C     COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT* 
C*                                                                       
C       LOGICAL UNITS ( FOR DESCRIPTION SEE LARKIN DRIVER ROUTINE)     * 
C                                                                      * 
C    COMMON / LARK1 / LR(NLR)                                          * 
C    COMMON / LARK2 / PLR(2*NCEQ)                                      * 
C       SYMBOLIC REPRESENTATION OF THE DIFFERENTIAL EQUATIONS (LR)     * 
C       AND ASSOCIATED POINTERS (PLR) , FOR DIMENSIONS SEE DRIVER      * 
C                                                                      * 
C    COMMON / RATE1  / RTMP(NCEQ)                                      * 
C    COMMON / KINPAR / RK(NCEQ)                                        * 
C    COMMON / DELHR  / DHR(NCEQ)                                       * 
C       USED AS REAL WORK SPACES                                       * 
C                                                                      * 
C  WORK SPACES                                                         * 
C-------------                                                         * 
C                                                                      * 
C  REAL : RINT(NCEQ),PERC(NSP)                                         * 
C  INTEGER OR INTEGER*2 : IMPORT(NCEQ),IMPALL(NCEQ),IMPT(NCEQ)         * 
C  CHARACTER*1 : CW(NCW)                                               * 
C                                                                      * 
C  OUTPUT PARAMETERS                                                   * 
C-------------------                                                   * 
C                                                                      * 
C    LFLAG  = 0    NORMAL RETURN, NO ERROR                             * 
C           < 0    ERROR FLAG (MISSING DATA OR INVALID TIME RANGE)     * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
      REAL RINT(NCEQ),PERC(NSP),DHR                                      
C                                                                        
CI4       INTEGER LR,PLR,IMPT(NCEQ),IMPORT(NCEQ),IMPALL(NCEQ)            
      INTEGER*2 LR,PLR,IMPT(NCEQ),IMPORT(NCEQ),IMPALL(NCEQ)              
      CHARACTER*1 BLANK,PLUS,TAB(11),LC,CW(NCW),SPCW(NSPCW)              
      REAL DHSYS,G,H,RT,T,TAULH,TAUTST,TH,U,V,X                          
      INTEGER I,IL,IL1,IL2,ILO,IR,IR1,IR2,ISPAC1,ISPAC2,ITST,            
     & IUNSIG,J,JTST,K,KFOUND,KT,KTST,L,LRI,M,NCEQP1,NK1,NK2,NLOOP       
C                                                                        
      INTEGER LOUT                                                       
C                                                                        
      LOGICAL LPRINT,LPOUT,LTERM                                         
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
C                                                                        
      COMMON / RATE1  / RTMP(1000)                                       
      COMMON / KINPAR / RK(1000)                                         
      COMMON / LARK1  / LR(5000)                                         
      COMMON / LARK2  / PLR(2000)                                        
      COMMON / DELHR  / DHR(1000) 
      SAVE /LUNIT/, /RATE1/, /KINPAR/, /LARK1/, /LARK2/, /DELHR/
C                                                                        
C1      NAMELIST / RATE  / T,RK                                          
C1      NAMELIST / DHRE  / T,DHR                                         
C                                                                        
      DATA BLANK/' '/ , PLUS/'+'/ , LC/'L'/ ,                            
     &   TAB(1)/'0'/ , TAB(2)/'1'/ , TAB(3)/'2'/ , TAB(4)/'3'/ ,         
     &   TAB(5)/'4'/ , TAB(6)/'5'/ , TAB(7)/'6'/ , TAB(8)/'7'/ ,         
     &   TAB(9)/'8'/ , TAB(10)/'9'/ , TAB(11)/'*'/                       
C                                                                        
C  CONTROL OUTPUT                                                        
      LPRINT=.FALSE.                                                     
      LPOUT=.FALSE.                                                      
      LTERM=.FALSE.                                                      
      IF(LFLAG.GT.0) LPRINT=.TRUE.                                       
      IF(LOUT.EQ.POUT) LPOUT=.TRUE.                                      
      IF(LOUT.NE.POUT) LTERM=.TRUE.                                      
      REWIND HDS 
C                                                                        
      NCEQP1=NCEQ+1                                                      
      ISPAC2=30                                                          
      IF(LPOUT) ISPAC2=50                                                
      ISPAC1=60                                                          
      IF(LPOUT) ISPAC1=110                                               
C                                                                        
C  CHECK FOR CORRECT TIME RANGE                                          
      IF(T0.LT.TMIN) T0=TMIN                                             
      IF(T1.GT.TMAX) T1=TMAX                                             
      IF(T0.GE.T1) GOTO 299                                              
      IF(T0.GE.TMAX) GOTO 299                                            
      IF(T1.LE.TMIN) GOTO 299                                            
C                                                                        
C ---------------------------------------------------------------------- 
C  TEST FOR INSIGNIFICANT REACTIONS DUE TO LOCAL CRITERIUM               
C ---------------------------------------------------------------------- 
C                                                                        
C  WRITE HEAD                                                            
      WRITE(LOUT,8000)                                                   
C                                                                        
      DO 100 I=1,NCEQ                                                    
      IMPT(I)=0                                                          
100   IMPALL(I)=0                                                        
C                                                                        
C READ TIME, RATES AND DELTAH(REACTION)                                  
      ITST=0                                                             
C 105   READ(DOUT,RATE,END=135)                                          
105   CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(KFOUND.LT.0) GOTO 135                                           
      IF(T.LT.T0) GOTO 105                                               
C      IF(MODEL.GT.2) READ(DOUT,DHRE,END=135)                            
      KFOUND=0                                                           
      IF(MODEL.GT.2) CALL NLDHRE(DOUT,T,DHR,NCEQ,KFOUND)                 
      IF(KFOUND.LT.0) GOTO 135                                           
      ITST=ITST+1                                                        
C                                                                        
      DO 110 I=1,NSP                                                     
110   RTMP(I)=0.                                                         
      IR2=0                                                              
      DO 120 K=1,NCEQ                                                    
      RT=RK(K)                                                           
      IL1=IR2+1                                                          
      IL2=PLR(K)                                                         
      IR2=PLR(NCEQ+K)                                                    
      DO 115 I=IL1,IR2                                                   
      LRI=LR(I)                                                          
      IF(I.GT.IL2) GOTO 116                                              
      RTMP(LRI)=RTMP(LRI) - RT                                           
      GOTO 115                                                           
116   RTMP(LRI)=RTMP(LRI) + RT                                           
115   CONTINUE                                                           
      DO 117 I=1,NSP                                                     
117   RTMP(I)=ABS(RTMP(I))                                               
120   CONTINUE                                                           
C                                                                        
C  TEST FOR LOCAL INSIGNIFICANCE                                         
      TAULH=TAUL*1.E-2                                                   
      DHSYS=0.                                                           
      IF(MODEL.LE.2) GOTO 124                                            
      DO 121 K=1,NCEQ                                                    
121   DHSYS=DHSYS + RK(K)*DHR(K)                                         
      DHSYS=ABS(DHSYS)                                                   
      DO 122 K=1,NCEQ                                                    
      X=ABS(RK(K)*DHR(K))                                                
122   IF(X.GT.TAULH*DHSYS) IMPT(K)=1                                     
C                                                                        
124   IR=0                                                               
      DO 130 K=1,NCEQ                                                    
      CW(K)=BLANK                                                        
      U=RK(K)                                                            
      IL=IR+1                                                            
      IR=PLR(NCEQ+K)                                                     
      DO 125 I=IL,IR                                                     
      LRI=LR(I)                                                          
      TAUTST=TAULH*RTMP(LRI)                                             
      IF(U.LE.TAUTST) GOTO 125                                           
      IF(IMPT(K).NE.0) CW(K)=PLUS                                        
      IMPALL(K)=1                                                        
      GOTO 130                                                           
125   CONTINUE                                                           
130   CONTINUE                                                           
      IF(LPRINT) WRITE(HDS,8003) T,(CW(L),L=1,NCEQ)                      
      IF(T.GE.T1) GOTO 135                                               
      GOTO 105                                                           
135   IF(ITST.LE.0) GOTO 199                                             
C                                                                        
C  EXTENDED OUTPUT OF LOCAL TEST FOR LPRINT=.TRUE.                       
      IF(.NOT.LPRINT) GOTO 155                                           
      NLOOP=NCEQ/ISPAC1 + 1                                              
      DO 150 ILO=1,NLOOP                                                 
      NK1=(ILO-1)*ISPAC1 + 1                                             
      NK2=ILO*ISPAC1                                                     
      IF(NK2.GT.NCEQ) NK2=NCEQ                                           
      IF(LTERM) WRITE(LOUT,8004) NK1,NK2                                 
      IF(LPOUT) WRITE(LOUT,7004) NK1,NK2                                 
      REWIND HDS 
140   READ(HDS,8003,END=145) T,(CW(L),L=1,NCEQ)                          
      IF(LTERM) WRITE(LOUT,8001) T,(CW(L),L=NK1,NK2)                     
      IF(LPOUT) WRITE(LOUT,7001) T,(CW(L),L=NK1,NK2)                     
      GOTO 140                                                           
145   IF(LTERM) WRITE(LOUT,8007)                                         
      IF(LPOUT) WRITE(LOUT,7007)                                         
150   CONTINUE                                                           
C                                                                        
155   IUNSIG=0                                                           
      DO 160 I=1,NCEQ                                                    
      KTST=IMPALL(I)+IMPT(I)                                             
      IF(KTST.GT.0) GOTO 160                                             
      IUNSIG=IUNSIG+1                                                    
      IMPORT(IUNSIG)=I                                                   
160   CONTINUE                                                           
      WRITE(LOUT,7777) IUNSIG                                            
7777  FORMAT(' NACH LABEL 160, VOR AUSGABE VON IMPORT IN DER LAENGE',    
     & ' IUNSIG=',I9)                                                    
      IF(IUNSIG.GT.0) WRITE(LOUT,8002) TAUL,(IMPORT(L),L=1,IUNSIG)       
      IF(IUNSIG.LE.0) WRITE(LOUT,8005) TAUL                              
C                                                                        
162   REWIND DOUT
      REWIND HDS
C                                                                        
C ---------------------------------------------------------------------- 
C  TEST FOR INSIGNIFICANT REACTIONS DUE TO INTEGRAL CRITERIUM            
C ---------------------------------------------------------------------- 
C                                                                        
C  WRITE HEAD                                                            
      WRITE(LOUT,8010) T0,T1                                             
      IF(LPRINT) WRITE(LOUT,8020) (L,(SPCW(I),I=L*10-9,L*10),L=1,NSP)    
C                                                                        
C  COMPUTE INTEGRATED RATES OF TIME-INTERVAL (T0,T1)                     
      DO 200 K=1,NCEQ                                                    
200   RINT(K)=0.                                                         
C      READ(DOUT,RATE)                                                   
      CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
205   DO 210 K=1,NCEQ                                                    
210   RTMP(K)=RK(K)                                                      
      TH=T                                                               
C      READ(DOUT,RATE)                                                   
      CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(T.LE.T0) GOTO 205                                               
      IF(T.LE.T1) GOTO 215                                               
      H=(T1-T0)/2.                                                       
      G=(T0+T1-TH-TH)/(T-TH)                                             
      GOTO 255                                                           
215   H=(T-T0)/2.                                                        
      IF(TH.EQ.T0) GOTO 225                                              
      G=(T0-TH)/(T-TH)                                                   
      DO 220 K=1,NCEQ                                                    
220   RINT(K)=RINT(K) + H * ( RTMP(K)+RK(K) + G*(RK(K)-RTMP(K)) )        
      GOTO 235                                                           
225   DO 230 K=1,NCEQ                                                    
230   RINT(K)=RINT(K) + H * (RTMP(K) + RK(K))                            
235   IF(T.EQ.T1) GOTO 265                                               
C                                                                        
      DO 240 K=1,NCEQ                                                    
240   RTMP(K)=RK(K)                                                      
      TH=T                                                               
C      READ(DOUT,RATE)                                                   
      CALL NLRATE(DOUT,T,RK,NCEQ,KFOUND)                                 
      IF(T1.LT.T) GOTO 250                                               
      H=(T-TH)/2.                                                        
      DO 245 K=1,NCEQ                                                    
245   RINT(K)=RINT(K) + H*(RK(K)+RTMP(K))                                
      GOTO 235                                                           
250   H=(T1-TH)/2.                                                       
      G=(T1-TH)/(T-TH)                                                   
255   DO 260 K=1,NCEQ                                                    
260   RINT(K)=RINT(K) + H* ( RTMP(K)+RTMP(K) + G*(RK(K)-RTMP(K)) )       
C                                                                        
C  COMPUTE RSUMC(=RK) AND RSUMF(=RTMP)                                   
265   DO 270 I=1,NSP                                                     
      RTMP(I)=0.                                                         
270   RK(I)=0.                                                           
      IR2=0                                                              
      DO 290 K=1,NCEQ                                                    
      IMPORT(K)=0                                                        
      U=RINT(K)                                                          
      IL1=IR2+1                                                          
      IL2=PLR(K)                                                         
      IR2=PLR(NCEQ+K)                                                    
      DO 280 I=IL1,IR2                                                   
      LRI=LR(I)                                                          
      IF(I.GT.IL2) GOTO 275                                              
      RK(LRI)=RK(LRI) + U                                                
      GOTO 280                                                           
275   RTMP(LRI)=RTMP(LRI) + U                                            
280   CONTINUE                                                           
290   CONTINUE                                                           
C                                                                        
      IF(.NOT.LPRINT) GOTO 480                                           
C                                                                        
C  CONSUMPTION OF SPECIES                                                
C-------------------------                                               
      IF(LPRINT) WRITE(LOUT,8015) T0,T1                                  
C                                                                        
      IR2=0                                                              
      DO 330 K=1,NCEQ                                                    
      DO 300 J=1,NSP                                                     
      CW(J)=BLANK                                                        
300   PERC(J)=0.                                                         
      U=RINT(K)*1.E2                                                     
      IL1=IR2+1                                                          
      IL2=PLR(K)                                                         
      IR2=PLR(NCEQ+K)                                                    
      DO 310 I=IL1,IL2                                                   
      LRI=LR(I)                                                          
      IF(RK(LRI).GT.0.) PERC(LRI)=PERC(LRI) + U/RK(LRI)                  
310   CONTINUE                                                           
      IF(.NOT.LPRINT) GOTO 330                                           
      JTST=0                                                             
      DO 320 I=IL1,IL2                                                   
      LRI=LR(I)                                                          
      CW(LRI)=LC                                                         
      IF(PERC(LRI).LE.TAUG) GOTO 320                                     
      JTST=JTST+1                                                        
      J=INT(PERC(LRI)/10.+0.5) + 1                                       
      CW(LRI)=TAB(J)                                                     
320   CONTINUE                                                           
      IF(LPRINT.AND.JTST.GT.0) WRITE(HDS,8022) K,(CW(L),L=1,NSP)         
330   CONTINUE                                                           
C                                                                        
C  EXTENDED OUTPUT OF CONSUMPTION OF SPECIES FOR LPRINT=.TRUE.           
      IF(.NOT.LPRINT.OR.JTST.LE.0) GOTO 400                              
      NLOOP=NSP/ISPAC2 + 1                                               
      DO 360 ILO=1,NLOOP                                                 
      NK1=(ILO-1)*ISPAC2 + 1                                             
      NK2=ILO*ISPAC2                                                     
      IF(NK2.GT.NSP) NK2=NSP                                             
      IF(LTERM) WRITE(LOUT,8021) NK1,NK2                                 
      IF(LPOUT) WRITE(LOUT,7021) NK1,NK2                                 
      REWIND HDS 
      M=0                                                                
340   READ(HDS,8022,END=350) K,(CW(L),L=1,NSP)                           
      M=M+1                                                              
      IF(LTERM) WRITE(LOUT,8019) K,(CW(L),L=NK1,NK2)                     
      IF(LPOUT) WRITE(LOUT,7019) K,(CW(L),L=NK1,NK2)                     
      KT=MOD(M,10)                                                       
      IF(KT.EQ.0.AND.LTERM) WRITE(LOUT,8008)                             
      IF(KT.EQ.0.AND.LPOUT) WRITE(LOUT,7008)                             
      GOTO 340                                                           
350   IF(LTERM) WRITE(LOUT,8008)                                         
      IF(LPOUT) WRITE(LOUT,7008)                                         
360   CONTINUE                                                           
C                                                                        
      REWIND HDS 
C                                                                        
C  FORMATION OF SPECIES                                                  
C----------------------                                                  
400   IF(LPRINT) WRITE(LOUT,8016) T0,T1                                  
C                                                                        
      IR2=0                                                              
      DO 440 K=1,NCEQ                                                    
      DO 410 J=1,NSP                                                     
      CW(J)=BLANK                                                        
410   PERC(J)=0.                                                         
      U=RINT(K)*1.E2                                                     
      IL2=PLR(K)                                                         
      IR2=PLR(NCEQ+K)                                                    
      IR1=IL2+1                                                          
      IF(IR1.GT.IR2) IR1=IR2                                             
      DO 420 I=IR1,IR2                                                   
      LRI=LR(I)                                                          
      IF(RTMP(LRI).GT.0.) PERC(LRI)=PERC(LRI) + U/RTMP(LRI)              
420   CONTINUE                                                           
      IF(.NOT.LPRINT) GOTO 440                                           
      JTST=0                                                             
      DO 430 I=IR1,IR2                                                   
      LRI=LR(I)                                                          
      CW(LRI)=LC                                                         
      IF(PERC(LRI).LE.TAUG) GOTO 430                                     
      JTST=JTST+1                                                        
      J=INT(PERC(LRI)/10.+0.5) + 1                                       
      CW(LRI)=TAB(J)                                                     
430   CONTINUE                                                           
      IF(LPRINT.AND.JTST.GT.0) WRITE(HDS,8022) K,(CW(L),L=1,NSP)         
440   CONTINUE                                                           
C                                                                        
C  EXTENDED OUTPUT OF SPECIES-FORMATION FOR LPRINT=.TRUE.                
      IF(.NOT.LPRINT.OR.JTST.LE.0) GOTO 480                              
      NLOOP=NSP/ISPAC2 + 1                                               
      DO 470 ILO=1,NLOOP                                                 
      NK1=(ILO-1)*ISPAC2 + 1                                             
      NK2=ILO*ISPAC2                                                     
      IF(NK2.GT.NSP) NK2=NSP                                             
      IF(LTERM) WRITE(LOUT,8021) NK1,NK2                                 
      IF(LPOUT) WRITE(LOUT,7021) NK1,NK2                                 
      REWIND HDS 
      M=0                                                                
450   READ(HDS,8022,END=460) K,(CW(L),L=1,NSP)                           
      M=M+1                                                              
      IF(LTERM) WRITE(LOUT,8019) K,(CW(L),L=NK1,NK2)                     
      IF(LPOUT) WRITE(LOUT,7019) K,(CW(L),L=NK1,NK2)                     
      KT=MOD(M,10)                                                       
      IF(KT.EQ.0.AND.LTERM) WRITE(LOUT,8008)                             
      IF(KT.EQ.0.AND.LPOUT) WRITE(LOUT,7008)                             
      GOTO 450                                                           
460   IF(LTERM) WRITE(LOUT,8008)                                         
      IF(LPOUT) WRITE(LOUT,7008)                                         
470   CONTINUE                                                           
C                                                                        
480   IR2=0                                                              
      DO 485 I=1,NSP                                                     
485   RTMP(I)=ABS(RTMP(I)-RK(I))                                         
      DO 490 K=1,NCEQ                                                    
      U=RINT(K)*1.E2                                                     
      IL1=IR2+1                                                          
      IL2=PLR(K)                                                         
      IR2=PLR(NCEQ+K)                                                    
      DO 495 I=IL1,IR2                                                   
      LRI=LR(I)                                                          
      V=0.                                                               
      IF(RTMP(LRI).GT.0.) V=U/RTMP(LRI)                                  
495   IF(V.GT.TAUG) IMPORT(K)=1                                          
490   CONTINUE                                                           
C                                                                        
      IUNSIG=0                                                           
      DO 500 I=1,NCEQ                                                    
      IF(IMPORT(I).NE.0) GOTO 500                                        
      IUNSIG=IUNSIG+1                                                    
      IMPALL(IUNSIG)=I                                                   
500   CONTINUE                                                           
C                                                                        
      IF(IUNSIG.GT.0) WRITE(LOUT,8013) TAUG,(IMPALL(L),L=1,IUNSIG)       
      IF(IUNSIG.LE.0) WRITE(LOUT,8014) TAUG                              
C                                                                        
C----------------------------------------------------------------------- 
C  NORMAL RETURN , NO ERROR                                              
C----------------------------------------------------------------------- 
      LFLAG=0                                                            
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C  ERROR EXITS                                                           
C----------------------------------------------------------------------- 
199   WRITE(ITOUT,9000)                                                  
9000  FORMAT(/,' NO DATA FOR RATES OR DELTA-H AVAILABLE',/)              
      LFLAG=-1                                                           
      RETURN                                                             
C                                                                        
299   WRITE(ITOUT,9001) T0,T1                                            
9001  FORMAT(/,' INVALID TIME RANGE FOR TEST',/,                         
     & ' T0 = ',E15.8,3X,' T1 = ',E15.8,/)                               
      LFLAG=-1                                                           
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C                   FORMATS                                              
C----------------------------------------------------------------------- 
C                                                                        
C  FOR LOCAL TEST                                                        
C- - - - - - - - -                                                       
8000  FORMAT(//,1X,70('-'),/,1X,'*',14X,' TEST FOR INSIGNIFICANT',       
     &      ' REACTIONS',21X,'*',/,1X,70('-'),                           
     &      //,' A)    DUE TO LOCAL CRITERIUM')                          
8001  FORMAT(E9.2,1X,'!',60A1)                                           
7001  FORMAT(E9.2,1X,'!',110A1)                                          
8002  FORMAT(//,' INSIGNIFICANT REACTIONS (',F5.2,' % - LEVEL,LOCAL)'    
     & ,/,72(14I5,/))                                                    
8003  FORMAT(E15.8,/,15(72A1,/))                                         
8004  FORMAT(//,25X,' REACTIONS',I5,' TO',I5,/,                          
     & 10X,'!',6('....:....!'))                                          
7004  FORMAT(//,25X,' REACTIONS',I5,' TO',I5,/,                          
     & 10X,'!',11('....:....!'))                                         
8005  FORMAT(//,' NO INSIGNIFICANT REACTIONS (',F5.2,                    
     &          ' % - LEVEL,LOCAL)')                                     
8007  FORMAT(10X,'!',6('....:....!'))                                    
7007  FORMAT(10X,'!',11('....:....!'))                                   
8008  FORMAT(10X,'!',3(' . . . . : . . . . !'))                          
7008  FORMAT(10X,'!',5(' . . . . : . . . . !'))                          
C                                                                        
C  FOR CONSUMPTION AND FORMATION OUTPUT                                  
C- - - - - - - - - - - - - - - - - - - -                                 
8010  FORMAT(//,' B)    DUE TO INTEGRAL CRITERIUM FROM T = ',            
     &          E8.2,'    TO  T = ',E8.2)                                
8013  FORMAT(//,' INSIGNIFICANT REACTIONS (',F5.2,' % - LEVEL,',         
     & 'INTEGRAL)',/,72(14I5,/))                                         
8014  FORMAT(//,' NO INSIGNIFICANT REACTIONS (',F5.2,                    
     &          ' % - LEVEL,INTEGRAL)')                                  
8015  FORMAT(//,10X,' CONSUMPTION OF SPECIES IN % FROM T = ',E8.2,       
     &'    TO  T = ',E8.2,/)                                             
8016  FORMAT(//,10X,' FORMATION OF SPECIES IN % FROM T = ',E8.2,         
     &'    TO  T = ',E8.2,/)                                             
8019  FORMAT(' REAC.',I3,1X,'!',1X,30(A1,1X))                            
7019  FORMAT(' REAC.',I3,1X,'!',1X,50(A1,1X))                            
8020  FORMAT(//,20X,' SPECIES LIST',//,250(1X,4(I4,2X,10A1,2X),/))       
8021  FORMAT(//,28X,' SPECIES',I5,' TO',I5,/,                            
     & 10X,'!',3(' . . . . : . . . . !'))                                
7021  FORMAT(//,28X,' SPECIES',I5,' TO',I5,/,                            
     & 10X,'!',5(' . . . . : . . . . !'))                                
8022  FORMAT(I4,/,15(72A1,/))                                            
C                                                                        
C----------------------------------------------------------------------- 
C             END OF SUBROUTINE SIGNIF                                   
C----------------------------------------------------------------------- 
C                                                                        
      END                                                                
