      SUBROUTINE PLOTPC(XMI,XMA,YMI,YMA,XPLO,YPLO,XMPLO,YMPLO,
     +               NPLO,NMPLO,IMARK,NCURVE,
     +                 TEXT,SPNAME,IFLAG,XAMI,XAMA,YAMI,YAMA)

C************************************************************
C*** SUBROUTINE FOR USE OF THE HERCULES GRAPHIC CARD ********
C***                                                        *
C*** CONSTANT CHARHT: HEIGTH OF A CHARACTER ON THE SCREEN   *
C***          CHARWT: WIDTH  OF A CHARACTER ON THE SCREEN   *
C***          XTICKS: NUMBER OF THE TICKS ON THE X-AXIS     *
C************************************************************
      PARAMETER (CHARHT=9)
      PARAMETER (CHARWT=6)
      PARAMETER (XTICKS=5)

      IMPLICIT INTEGER (A-Z)

      REAL XMI,XMA,YMI,YMA,XPLO,YPLO,XMPLO,YMPLO
      REAL XMIN,XMAX,YMIN,YMAX
      REAL XT,YT,Y,A
      REAL XAMI,XAMA,YAMI,YAMA
      REAL XTT,XTTDEL,YTT,YTTDEL
      REAL TEXT,SPNAME
      REAL YEND

      CHARACTER*4  CXAX
      CHARACTER*8  C8
      CHARACTER*9  C9
      CHARACTER*11 CAXIS
      CHARACTER*12 CNAME,C12
      CHARACTER*32 CTEXT

      DIMENSION NPLO(8)
      DIMENSION XPLO(250,8),YPLO(250,8)
      DIMENSION XMPLO(125,8),YMPLO(125,8)
      DIMENSION TEXT(8),SPNAME(3,8),IFLAG(10)
      DIMENSION CNAME(8)
      DIMENSION YEND(8)

C*  EXTERNAL ASSEMBLER ROUTINES

      EXTERNAL GOPEN
C      open graphic
      EXTERNAL GCLOSE
C      close graphic
      EXTERNAL GCLEAR
C       clear screen
      EXTERNAL GPLOT
C      set point
C      arguments: 0ix719, 0iy346
      EXTERNAL GLINE
C      connect last point by a line
C      arguments: 0ix719, 0iy346
      EXTERNAL GTEXT
C      write text
C      arguments: ix,iy (position of the left low edge of the first
C                        character)
C                 1 (-1 for transparent)
C                 char (CHARACTER variable)

      COMMON/MINMAX/XMIN,XMAX,YMIN,YMAX

      XMIN=XMI
      XMAX=XMA
      YMIN=YMI
      YMAX=YMA
      IXORIG=FXTR(XMIN)
      IYORIG=FYTR(YMIN)
      IXMAX=FXTR(XMAX)
      IYMAX=FYTR(YMAX)

C***
C*** WORKSTATION IS OPENED
C***
      CALL GOPEN
      CALL GCLEAR

C***
C*** THE X- AND Y-AXIS ARE DRAWN
C***
      CALL GPLOT(IXORIG,IYORIG)
      CALL GLINE(IXORIG,IYMAX)
      CALL GPLOT(IXORIG,IYORIG)
      CALL GLINE(IXMAX,IYORIG)

C***
C*** THE TITLE IS WRITTEN
C***
      DO 10 I=1,8
        I1=1+(I-1)*4
        I2=I1+3
        WRITE (CTEXT(I1:I2),999) TEXT(I)
 10     CONTINUE
      IX=IXORIG+30*CHARWT
      IY=IYMAX + 2*CHARHT
         CALL GTEXT(IX,IY,-1,CTEXT)

C***
C*** THE TICKS AND THE NUMBERS FOR THE X-AXIS
C***
      XTT=XAMI
      XTTDEL=(XAMA-XAMI)/XTICKS
      IYH=IYORIG-CHARHT/3
      IYL=IYH-CHARHT
      DO 20 XT=XMIN,XMIN+(XMAX-XMIN)*1.01,(XMAX-XMIN)/XTICKS
        WRITE(C9,998) XTT
        XTT=XTT+XTTDEL
        IX=FXTR(XT)
        CALL GPLOT(IX,IYORIG)
        CALL GLINE(IX,IYH)
        IX=IX-5*CHARWT
        CALL GTEXT(IX,IYL,-1,C9)
  20    CONTINUE

C***
C*** THE TICKS AND THE NUMBERS FOR THE Y-AXIS
C***
      IXH=IXORIG-CHARWT
      IXL=IXH-12*CHARWT
      A=0
      IF (YAMA-YAMI.GT.1) THEN
 30     A=A+1
        IF ((YAMA-YAMI)/10**A.GE.1) GOTO 30
        A=A-1
      ELSE
 40     A=A-1
        IF ((YAMA-YAMI)/10**A.LE.1) GOTO 40
      ENDIF
 50   CONTINUE
      YTTDEL=10**A
      YTICKS=INT((YAMA-YAMI)/YTTDEL)+1
      IF (YTICKS.LT.3) THEN
        A=A-1
        GOTO 50
      ENDIF
      YTT=INT(YAMI/YTTDEL)*YTTDEL
      IF (YAMI.LT.0.AND.YAMI.NE.YTT)  YTT=YTT-YTTDEL
      Y=YTT*(YMAX-YMIN)/(YAMA-YAMI)
      YT=YTTDEL*(YMAX-YMIN)/(YAMA-YAMI)
      DO 60 I=1,YTICKS
        YTT=YTT+YTTDEL
        IF (YTT.GT.YAMA)  GOTO 60
        WRITE(C9,998) YTT
        Y=Y+YT
        IY=FYTR(Y)
        CALL GPLOT(IXORIG,IY)
        CALL GLINE(IXH,IY)
        IY=IY-CHARHT/2
        CALL GTEXT(IXL,IY,-1,C9)
        IF (I.EQ.1 .AND. IY.GT.IYORIG+CHARHT/2) THEN
          WRITE(C9,998) YAMI
          CALL GPLOT(IXORIG,IYORIG)
          CALL GLINE(IXH,IYORIG)
          IY=IYORIG-CHARHT/2
          CALL GTEXT(IXL,IY,-1,C9)
        ENDIF
 60     CONTINUE
      IF (IY.LT.IYMAX-2*CHARHT) THEN
        WRITE(C9,998) YAMA
        CALL GPLOT(IXORIG,IYMAX)
        CALL GLINE(IXH,IYMAX)
        IY=IYMAX-CHARHT/2
        CALL GTEXT(IXL,IY,-1,C9)
      ENDIF

C***
C*** THE TEXT ON THE X-AXIS
C***
      IX=IXMAX-8*CHARWT
      IY=IYORIG-3*CHARHT
      IF (IFLAG(3).NE.0) THEN
        CXAX='CONC'
      ELSE
        CXAX='TIME'
      ENDIF
      IF (IFLAG(1).EQ.0) THEN
        CAXIS=CXAX
      ELSE
        CAXIS='LOG OF '//CXAX
      ENDIF
      CALL GTEXT(IX,IY,-1,CAXIS)

C***
C*** THE TEXT ON THE Y-AXIS
C***
      IX=IXORIG-11*CHARWT
      IY=IYMAX+CHARHT
      IF (IFLAG(2).EQ.0) THEN
        CAXIS='CONC'
      ELSE
        CAXIS='LOG OF CONC'
      ENDIF
      CALL GTEXT(IX,IY,-1,CAXIS)

C***
C*** THE CURVES ARE DRAWN
C***
      DO 80 J=1,NCURVE
        IX=FXTR(XPLO(1,J))
        IY=FYTR(YPLO(1,J))
        CALL GPLOT(IX,IY)
        DO 70 I=1,NPLO(J)
          IX=FXTR(XPLO(I,J))
          IY=FYTR(YPLO(I,J))
          CALL GLINE(IX,IY)
 70       CONTINUE
        YEND(J)=YPLO(NPLO(J),J)
 80     CONTINUE

C***
C*** THE LEGEND IS WRITTEN
C***
      IF (IFLAG(3).EQ.0) THEN
        DO 120 J=1,NCURVE
          N=J
          YT=YEND(J)
          DO 90 I=J+1,NCURVE
            IF (YEND(I).LT.YT) THEN
              N=I
              YT=YEND(I)
            ENDIF
 90         CONTINUE
          DO 100 I=1,3
            I1=1+(I-1)*4
            I2=I1+3
            WRITE(CNAME(J)(I1:I2),999) SPNAME(I,N)
 100        CONTINUE
          YEND(N)=YEND(J)
          YEND(J)=YT
          DO 110 I=1,3
            SPNAME(I,N)=SPNAME(I,J)
 110        CONTINUE
 120      CONTINUE
        IX=IXMAX+CHARWT
        IY=FYTR(YEND(1))-CHARHT/2
        C12=CNAME(1)
        CALL GTEXT(IX,IY,-1,C12)
        DO 130 J=2,NCURVE
          IF (FYTR(YEND(J)).GE.IY+CHARHT) THEN
            IY=FYTR(YEND(J))-CHARHT/2
          ELSE
            IY=IY+CHARHT
          ENDIF
          C12=CNAME(J)
          CALL GTEXT(IX,IY,-1,C12)
 130      CONTINUE
      ELSE
        IX=IXORIG
        IY=IYORIG-3*CHARHT
        DO 140 I=1,3
          I1=1+(I-1)*4
          I2=I1+3
          WRITE(C12(I1:I2),999) SPNAME(I,1)
 140      CONTINUE
        CALL GTEXT(IX,IY,-1,C12)
        IY=IYORIG-4*CHARHT
        DO 150 I=1,3
          I1=1+(I-1)*4
          I2=I1+3
          WRITE(C12(I1:I2),999) SPNAME(I,2)
 150      CONTINUE
        CALL GTEXT(IX,IY,-1,C12)
        C8='(x-Axis)'
        IX=IXORIG+13*CHARWT
        IY=IYORIG-3*CHARHT
        CALL GTEXT(IX,IY,-1,C8)
        C8='(y-Axis)'
        IY=IYORIG-4*CHARHT
        CALL GTEXT(IX,IY,-1,C8)
      ENDIF

C***
C*** THE MARKS ON THE CURVES ARE DRAWN
C***
      IF (IMARK.NE.0) THEN
        DO 170 J=1,NCURVE
          DO 160 I=1,NMPLO
            IX=FXTR(XMPLO(I,J))
            IY=FYTR(YMPLO(I,J))
            IXH=IX-2
            CALL GPLOT(IXH,IY)
            IXH=IX+2
            CALL GLINE(IXH,IY)
            IYH=IY-2
            CALL GPLOT(IX,IYH)
            IYH=IY+2
            CALL GLINE(IX,IYH)
 160        CONTINUE
 170      CONTINUE
      ENDIF

C***
C*** WAITING FOR A CR AND CLOSING OF THE WORK STATION
C***
      PAUSE
      CALL GCLOSE
      RETURN
 998  FORMAT(1PG9.2)
 999  FORMAT(A4)
      END


      INTEGER FUNCTION FXTR(X)
C******************************************************************************
C***FUNCTION CONVERTS X INTO THE X-COORDINATE OF THE IMAGE POINT ON THE SCREEN*
C***
C*** CONSTANT XMAXSC: NUMBER OF IMAGE POINTS ON THE SCREEN IN X-DIRECTION     *
C******************************************************************************
      PARAMETER (XMAXSC=711)
      REAL X,XMIN,XMAX
      COMMON/MINMAX/XMIN,XMAX,YMIN,YMAX
      FXTR=NINT(0.12*XMAXSC+XMAXSC/(XMAX-XMIN)*(X-XMIN)*0.7)
      RETURN
      END


      INTEGER FUNCTION FYTR(Y)
C******************************************************************************
C***FUNCTION CONVERTS Y INTO THE Y-COORDINATE OF THE IMAGE POINT ON THE SCREEN*
C***
C*** CONSTANT YMAXSC: NUMBER OF IMAGE POINTS ON THE SCREEN IN Y-DIRECTION     *
C******************************************************************************
      PARAMETER (YMAXSC=338)
      REAL Y,YMIN,YMAX
      COMMON/MINMAX/XMIN,XMAX,YMIN,YMAX
      FYTR=NINT(0.1*YMAXSC+YMAXSC/(YMAX-YMIN)*(Y-YMIN)*0.8)
      RETURN
      END
