/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include "kask.h"
#include "kaskass.h"
#include "kaskcmd.h"

int SelInteg(cmd)
  COMMAND *cmd;
  {
    int index, type, qType, SF=3, qSF=6;
	char *par1 = (cmd->pars)[1];

	if (ParsCheck(cmd,0,1)) return false;
	if ((cmd->noOfPars)==0)
	  { type = LINIP; qType = QUADIP; }
	else
	  {
	    index = CheckName(&par1,cmd->names, nameClass);
		if (index==-1)
		  {
		    sprintf(globBuf, "Assemble: '%s' unknown parameter to %s\n",
					(cmd->pars)[1], (cmd->pars)[0]);
			ZIBStdOut(globBuf);
			return false;
		  }
		switch (index)
		  {
		    case 0:
			  type = QUADIP;
			  qType = QUADIP;
			  break;
			case 1:
			  type =  BANKIP;
			  qType = BANKIP;
			  break;
			case 2:
			  type = QUADIP;
			  qType = QUADIP;
			  break;
			case 3:
			  type = USERIP;
			  qType = USERIP;
			  break;
			case 4:
			  type = LINIP;
			  qType = QUADIP;
			  break;
		  }
	  }
    if (stdIData==nil)
	  stdIData = NewIData(type, SF, StdShape, actProblem->symP);
	else UpdateIData(stdIData, type, 3, StdShape, actProblem->symP);

    if (qStdIData==nil)
	  qStdIData = NewIData(qType, qSF, StdQShape, actProblem->symP);
    else UpdateIData(qStdIData, qType, qSF, StdQShape, actProblem->symP);

    if (lStdIData==nil)
	  lStdIData = NewIData(qType, qSF, StdShape, actProblem->symP);
    else UpdateIData(lStdIData, qType, qSF, StdShape, actProblem->symP);

	InitNumAss(N_STD);

	return true;
  }

int TestInteg(cmd)
  COMMAND *cmd;
  {
    int type;
	char *par1 = (cmd->pars)[1];

	if (ParsCheck(cmd,1,1)) return false;

	type = CheckName(&par1,cmd->names, nameClass);
	if (type==-1)
	  {
		sprintf(globBuf, "Assemble: '%s' unknown parameter to %s\n",
				(cmd->pars)[1], (cmd->pars)[0]);
		ZIBStdOut(globBuf);
		return false;
	  }
	InitNumAss(type);

    return false;
  }

int SetInteg(cmd)
  COMMAND *cmd;
  {
	int IP = (stdIData==nil)?-1:stdIData->noOfIPoints,
		qIP = (qStdIData==nil)?-1:qStdIData->noOfIPoints,
		k;
	REAL *iPX = (stdIData==nil)?nil:stdIData->integPointX,
		 *iPY = (stdIData==nil)?nil:stdIData->integPointY,
		 *iW = (stdIData==nil)?nil:stdIData->integWeight;
	REAL *qIPX = (qStdIData==nil)?nil:qStdIData->integPointX,
		 *qIPY = (qStdIData==nil)?nil:qStdIData->integPointY,
		 *qIW = (qStdIData==nil)?nil:qStdIData->integWeight;

	if (ParsCheck(cmd,0,0)) return false;

	if ((cmd->noOfPars)==0)
	  {
	    sprintf(globBuf, "Assemble: #IP=%d, #quadIP=%d, #userIP=%d\n",
				IP, qIP, userNoIP);
		ZIBStdOut(globBuf);

		if (IP>=0) ZIBStdOut("Assemble: standard integration points\n");
		for (k = 0; k<IP; k++)
		  {
		    sprintf(globBuf, "          (%7.4f,%7.4f) %7.4f\n", iPX[k], iPY[k], iW[k]);
			ZIBStdOut(globBuf);
		  }

		if (qIP>=0)
		  ZIBStdOut("Assemble: standard quadratic integration points\n");
		for (k = 0; k<qIP; k++)
		  {
		    sprintf(globBuf, "          (%7.4f,%7.4f) %7.4f\n", qIPX[k], qIPY[k], qIW[k]);
			ZIBStdOut(globBuf);
		  }
		
		return true;
	  }

	return false;
 }
