/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <math.h>
#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kaskcmd.h"

static REAL pConst, gConst;
  
int ConstAss(t)
  TR *t;
  {
    PT *p1 = t->p1,*p2 = t->p2,*p3 = t->p3;
    REAL f11, f12, f21, f22, a, b, c, d;
    REAL ab, bc, dfac;

    f11 = (p2->x)-(p1->x);
    f12 = (p3->x)-(p1->x);
    f21 = (p2->y)-(p1->y);
    f22 = (p3->y)-(p1->y);

    d = f11*f22-f12*f21;
    a = f12*f12+f22*f22;
    b = -f12*f11-f22*f21;
    c = f11*f11+f21*f21;

    if ((partP==P_STIFF)||(partP==P_ALL))
	  {
		switch (curAss)
		{
	      case N_STD:
			dfac =  pConst *0.5/d;
			a = a*dfac;	b = b*dfac;	c = c*dfac;
			ab = a+b; bc = b+c;
			assA[0][0] = ab+bc;
			assA[1][0] = -ab;  assA[1][1] = a;
			assA[2][0] = -bc;  assA[2][1] = b;	assA[2][2] = c;
			break;
		  case N_LQ:
		   	dfac =  pConst *0.666666666/d;
			a = a*dfac;	b = b*dfac;	c = c*dfac;
			ab = a+b; bc = b+c;
			assA[3][0] = -ab-bc; assA[3][1] = ab; assA[3][2] = bc;
			assA[4][0] = ab; assA[4][1] = -a; assA[4][2] = -b;
		        assA[5][0] = bc; assA[5][1] = -b; assA[5][2] = -c;
			break;
		  case N_QQ:
			dfac =  pConst *(a+b+c)/(0.75*d);
			assA[3][3] = dfac;
			assA[4][4] = dfac;
			assA[5][5] = dfac;
			break;
		  default:
		    break;
		}
	  }
    if ((partP==P_RHS)||(partP==P_ALL))
	  {
		dfac = d* gConst;
		switch (curAss)
		{
		  case N_STD:
			assB[0] = dfac/6.0; assB[1] = dfac/6.0; assB[2] = dfac/6.0;
			break;
		  case N_QQ:
			assB[3] = dfac/6.0; assB[4] = dfac/6.0; assB[5] = dfac/6.0;
			break;
		  default:
		    break;
		}
	  }
/*
	sprintf(globBuf, "assA:(%d,%d,%d)", (t->p1)->indexP,
			(t->p2)->indexP, (t->p3)->indexP);
	PrintMatFull(globBuf, assA, noOfShapeFunc, symP);
	PrintVecFull("assB", assB, noOfShapeFunc);
*/
    return true;
  }

int Laplace(cmd)
  COMMAND *cmd;
  {
	REAL *fVals=actProblem->fVals;
	int class=ZERO;

	if (ParsCheck(cmd,0,0)) return false;

	actProblem->NumAss = ConstAss;

	(actProblem->F)(ZERO,ZERO,class,fVals);
	pConst = fVals[0];
	gConst = fVals[3];
	return true;
  }
