/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <stdio.h>
#include <math.h>
#include <strings.h>

#include	<Quickdraw.h>
#include	<ToolUtils.h>
#include	<Fonts.h>
#include	<Events.h>
#include    <OSEvents.h>
#include	<Windows.h>
#include	<Dialogs.h>
#include	<Menus.h>
#include	<Desk.h>
#include	<TextEdit.h>
#include	<Palette.h>
#include	<Scrap.h>
 
#include "kask.h"

#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskgraph.h"
  
#define K180PI 57.29578

#define TRANSX(X) ((X)*(actDriver->xScal)+(actDriver->xTrans))
#define TRANSY(Y) ((Y)*(actDriver->yScal)+(actDriver->yTrans))

#define maxWindows 4

static char *fontName ="courier";
static char *windowTitle ="Kaskade Graphic";
static int PSize = SMALLSIZE, FSize = 12, PColor = BLUE;
static int macFirst = true;

static WindowRecord		wRecords[maxWindows];
static WindowPtr		myWindows[maxWindows], saveWind;
static Rect				screenRect;
static CursHandle		crossHdl = nil;

static int MacNewPict()
  {
	int ind = actDriver->windowNo;

	ComputeScaling(actGraph,actDriver);
/*	GetPort(&saveWind); */
	SetPort(myWindows[ind]);
	ClipRect(&(myWindows[ind]->portRect));
	EraseRect(&(myWindows[ind]->portRect));
	return true;
  }

static int MacShow()
  {
	int ind = actDriver->windowNo;
	EventRecord myEvent;
	myEvent.what = 0;

/*	SetPort(saveWind); */
	if ((actDriver->graph)!=nil) return true;
	FlushEvents(everyEvent, 0);
	while (true)
	  {
	    GetNextEvent(everyEvent,&myEvent);
		if (myEvent.what==mouseDown) break;
	  }
	return true;
  }

static int MacLine(rp1x,rp1y,rp2x,rp2y)
  REAL rp1x,rp1y,rp2x,rp2y;
  {
	int p1x = TRANSX(rp1x), p1y = TRANSY(rp1y),
	    p2x = TRANSX(rp2x), p2y = TRANSY(rp2y);
    if (PSize==BIGSIZE) { p1x--; p1y--; p2x--; p2y--; } 
 	PmForeColor(PColor);
    MoveTo(p1x,p1y);
    LineTo(p2x,p2y);
    return true;
  }
 
static int MacString(rpx,rpy,s)
  REAL rpx,rpy;
  char *s;
  {
	int px = TRANSX(rpx), py = TRANSY(rpy);
    PmForeColor(BLACK);
    MoveTo(px,py);
    drawstring(s);
    return true;
  }
 
static int MacFill(x,y,no,col)
  REAL *x,*y;
  int no,col;
  {
    int ix, iy, ix0, iy0;
	PolyHandle Tr;
    int k;

    PmForeColor(col);
	Tr = OpenPoly();
	ix0 = TRANSX(x[0]); iy0 = TRANSY(y[0]);
    MoveTo(ix0,iy0);
    for (k = 1; k<no; k++)
	  {
		ix = TRANSX(x[k]); iy = TRANSY(y[k]);
		LineTo(ix,iy);
	  }	  
    LineTo(ix0,iy0);
    ClosePoly();

    PaintPoly(Tr);
	KillPoly(Tr);
    return true;
  }
 
static int MacArc(rp1x,rp1y,rp2x,rp2y,rmx,rmy)
  REAL rp1x,rp1y,rp2x,rp2y,rmx,rmy;
  {
	int p1x = TRANSX(rp1x), p1y = TRANSY(rp1y),
	    p2x = TRANSX(rp2x), p2y = TRANSY(rp2y),
		mx = TRANSX(rmx), my = TRANSY(rmy);
    Rect r;
    Point p1,p2;
    int radius;
	short startangle,arcangle;
    long is,dx,dy;
    double s,rad;

    PmForeColor(PColor);
    dx = p1x-mx; dy = p1y-my;
    is = dx*dx+dy*dy; s = is;
    rad = sqrt(s); radius = rad;
    r.left = mx-radius; r.right = mx+radius;
    r.top = my-radius;  r.bottom = my+radius;
    p1.h = p1x; p1.v = p1y;
    p2.h = p2x; p2.v = p2y;
    pttoangle(&r,&p1,&startangle);
    pttoangle(&r,&p2,&arcangle);
    arcangle -= startangle;
    if (arcangle>180) arcangle -= 360;
    if (arcangle<-179) arcangle += 360;
    if (PSize==BIGSIZE) InsetRect(&r,-1,-1);
    FrameArc(&r,startangle,arcangle);
    return true;
  }
    
static int MacSettings(type,val)
  int type,val;
  {
    Boolean smallWindowP;

	switch (type)
     {
       case PENSIZE:
            PSize=val;
			smallWindowP = true;
            switch (val)
            {
              case SMALLSIZE:  PenSize(1,1); break;
              case MEDIUMSIZE: PenSize(smallWindowP?1:2,
			  						   smallWindowP?1:2); break;
              case BIGSIZE:    PenSize(smallWindowP?1:3,
			  						   smallWindowP?1:3); break;
            }
            break;
       case PENCOLOR:
            PColor=val;
 		    PmForeColor(PColor);
            break;
       case FONTSIZE:
            switch (val)
            {
              case SMALLSIZE:  TextSize(8); break;
              case MEDIUMSIZE: TextSize(12); break;
              case BIGSIZE:    TextSize(16); break;
            }
            break;
     }
     return true;
  }

static int MacClose()
  {
    int ind = actDriver->windowNo;
	CloseWindow(myWindows[ind]);
	myWindows[ind] = nil;

	SetPort(FrontWindow());
	SetCursor(&(qd.arrow));

	return true;
  }

static int MacOpenPort()
  {
	int free = -1;
	short font;

	if ((actDriver->windowNo)<0)
	  {
		for (free=0; free<maxWindows; free++) if (myWindows[free]==nil) break;
		if (free==maxWindows)
		  {
		    sprintf(globBuf,"MacWindow: too many windows, maximum is %d\n", free);
			ZIBStdOut(globBuf);
			return false;
		  }
		myWindows[free] = GetNewCWindow(501,(PTR)&wRecords[free],
		                                (WindowPtr) -1);
	  }
	else free = actDriver->windowNo;
	MoveWindow(myWindows[free], actDriver->left, (actDriver->top)+16, false);
	SizeWindow(myWindows[free], (actDriver->right)-(actDriver->left),
			   (actDriver->bottom)-(actDriver->top)-16, false),
	actDriver->top += 16;
	setwtitle(myWindows[free],actDriver->fileName);
	ShowWindow(myWindows[free]);
	SetPort(myWindows[free]);

	getfnum(actDriver->fontName,&font);
	TextFont(font);
	TextSize(12);

	if (crossHdl==nil) crossHdl = GetCursor(crossCursor);

	actDriver->windowNo = free;
	return true;
  }
 
DRIVER *WdDriver()
  {
	int k;
	DRIVER *newDriv = nil;

	newDriv = (DRIVER*) ZIBAlloc((long)sizeof(DRIVER));
	if (newDriv==nil)
	  {
	    ZIBStdOut("Not enough memory(MacDriver)\n");
		return nil;
	  }

	if (macFirst)
	  {
	    macFirst = false;
		for (k=0; k<maxWindows; k++) myWindows[k]=nil;
		InitGraf(&qd.thePort);
		InitFonts();
		FlushEvents(everyEvent, 0);
		InitWindows();
		screenRect = qd.screenBits.bounds;
	  }

    newDriv->Line = MacLine;
    newDriv->Arc = MacArc;
    newDriv->String = MacString;
    newDriv->Fill = MacFill;
    newDriv->Settings = MacSettings;
    newDriv->NewPict = MacNewPict;
    newDriv->Show = MacShow;
    newDriv->GetXY = nil;
    newDriv->GetRXY = nil;
    newDriv->OpenPort = MacOpenPort;
    newDriv->Close = MacClose;
    newDriv->maxBottom = screenRect.bottom;
    newDriv->maxLeft = screenRect.left;
    newDriv->maxTop = screenRect.top+20.0;
    newDriv->maxRight = screenRect.right;
    newDriv->resolution = 1.0;
    newDriv->fontSize = 12.0;
    newDriv->lineWidth = 1.0;
    newDriv->fillingP = false;
    newDriv->clippingP = true;
    newDriv->colorsP = true;
    newDriv->graysP = true;
    newDriv->noOfColors = 41;
    newDriv->firstGray = 9;
    newDriv->noOfGrays = 31;
    newDriv->bottom = screenRect.bottom;
    newDriv->left = screenRect.left;
    newDriv->top = screenRect.top+20.0;
    newDriv->right = screenRect.right;
    newDriv->bottomMargin = 0.0;
    newDriv->leftMargin = 0.0;
    newDriv->topMargin = 16.0;
    newDriv->rightMargin = 0.0;
	newDriv->fontName = fontName;
	newDriv->fileName = windowTitle;
	newDriv->windowNo = -1;
	newDriv->graph = nil;

	return newDriv;
  }
