/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include "kask.h"
#include "kaskcmd.h"

int InfPar(cmd)
  COMMAND *cmd;
  {
    int i, k, count, noOfLists, noOfValues, type;
	char **names;
	PTR values;

	count = 0;
	if ((cmd->noOfPars)==0)
	  {
	    names = (char**)GetListNames(&noOfLists);
		ZIBStdOut("Names of parameter lists:\n");
		for (k=0; k<noOfLists; k++)
		  {
		    if (names[k]==nil) continue;
			if (count==4) { ZIBNL(); count=0; }
			sprintf(globBuf," %15.15s", names[k]);
			ZIBStdOut(globBuf);
			count++;
		  }
		ZIBNL();
		return true;
	  }
	for (k=0; k<(cmd->noOfPars); k++)
	  {
	    if (GetParamList((cmd->pars)[k+1], &names, &values, &noOfValues,
						 &type))
		  {
		    count = 0;
			sprintf(globBuf, "%12.12s",(cmd->pars)[k+1]);
			ZIBStdOut(globBuf);
			for (i=0; i<noOfValues; i++)
			  {
			    if (count==4)
				  {
				    ZIBStdOut("\n            ");
					count = 0;
				  }
				if (names && (names[i]!=nil))
				  {
				    sprintf(globBuf," %11.11s", names[i]);
					ZIBStdOut(globBuf);
					count++;
				  }
				switch(type)
				{
				  case 0:  sprintf(globBuf," %11d", ((int*)values)[i]); ZIBStdOut(globBuf); break;
				  case 1:  sprintf(globBuf," %11.4e", ((REAL*)values)[i]); ZIBStdOut(globBuf); break;
				  default: ZIBStdOut("unknown type"); break;
				}
				count++;
			  }
			ZIBNL();
		  }
	  }
	return true;
  }

int SetPar(cmd)
COMMAND *cmd;
  {
	int k = 2, noOfValues, type, ivalue;
	double rvalue;
	REAL Rvalue;
	char **names;
	PTR values;

    if ((cmd->noOfPars)<3)
	  {
	    sprintf(globBuf,"%s needs at least 3 parameters\n",(cmd->pars)[0]);
		ZIBStdOut(globBuf);
		return false;
	  }
	if (!GetParamList((cmd->pars)[1], &names, &values, &noOfValues, &type))
	  return false;
	while (k<(cmd->noOfPars))
	{
	  switch (type)
	  {
	    case 0:
		  if (sscanf((cmd->pars)[k+1], "%d", &ivalue)!=1)
		    {
			  sprintf(globBuf,"'%s' of '%s' needs integer value, not '%s'\n",
			  		  (cmd->pars)[k],(cmd->pars)[1],(cmd->pars)[k+1]);
			  ZIBStdOut(globBuf);
			  break;
			}
		  ChangeParam((cmd->pars)[1], (cmd->pars)[k],&ivalue);
		  break;
	    case 1:
		  if (sscanf((cmd->pars)[k+1], "%le", &rvalue)!=1)
		    {
			  sprintf(globBuf,"'%s' of '%s' needs real value, not '%s'\n",
			  		  (cmd->pars)[k],(cmd->pars)[1],(cmd->pars)[k+1]);
			  ZIBStdOut(globBuf);
			  break;
			}
		  Rvalue = rvalue;
		  ChangeParam((cmd->pars)[1], (cmd->pars)[k],&Rvalue);
		  break;
		default:
		  sprintf(globBuf,"Unknown value type for list '%s'\n",(cmd->pars)[1]);
		  ZIBStdOut(globBuf);
		  break;
	  }
	  k += 2;
	}
	if (k==(cmd->noOfPars))
	  {
	    sprintf(globBuf,"Parameter list '%s', value missing\n",(cmd->pars)[1]);
		ZIBStdOut(globBuf);
		return false;
	  }
	return  true;
  }
