/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <stdio.h>
#include <math.h>
#include <strings.h>
 
#include "kask.h"

#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskgraph.h"
  
#define K180PI 57.29578

#define PTTOINCH 0.0139
#define INCHTOPT 72.0
#define PTTOCM 0.03527
#define CMTOPT 28.35

#define TRANSX(X) (REAL)((X)*(actDriver->xScal)+(actDriver->xTrans))
#define TRANSY(Y) (REAL)((Y)*(actDriver->yScal)+(actDriver->yTrans))
#define ABS(x)    (((x) <  0 ) ? -(x) : (x))
#define MAX(x,y)  (((x) < (y)) ?  (y) : (x))
#define MIN(x,y)  (((x) < (y)) ?  (x) : (y))

#define COLORS 0
#define GRAYS 23

extern REAL Arcus();

DRIVER *PSDriver();

static FILE *actFile = nil;
static REAL fontSize[3] =  { 8.0, 10.0, 14.0 };
static REAL lineWidth[3] = { 0.1, 0.8, 1.5 };
static REAL lineColor[32] = { 0.0, 1.0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
                              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };
static char *psFName = "PSKaskade0";
static char *fontName ="Palatino-Roman";
static char *driverShort = "PS";
static char *driverName = "postscript";
static int lineCount;
static DRIVER *psDriv = nil;

#define NEXTLINE xPos = actGraph->maxLeft;yPos -= yLine;

static REAL minX, maxX;
static PT *minPt, *maxPt;

static int FindMinMax(p)
  PT *p;
  {
    if (RA(p,R_SOL)>maxX)
	  { maxX = RA(p,R_SOL); maxPt = p; }
    if (RA(p,R_SOL)<minX)
	  { minX = RA(p,R_SOL); minPt = p; }
	return true;
  }

static int PrintLocalMinMax(p)
  PT *p;
  {
	int k, lng= p->noOfNeighbors, ipercent;
	NEIGHBOR*n;
	REAL sol = RA(p, R_SOL);

	for(k= 0;k<lng;k++)
	  {
		n= &((p->neighbors)[k]);
		if (RA(n->p, R_SOL)>=sol) break;
	  }
	if (k==lng)
	  {
		ipercent = 100.0*sol/maxX;
	    sprintf(globBuf, "Local  Maximum at (%5.2f,%5.2f) is %10.3e = %d%%",
				p->x, p->y, sol, ipercent);
	  }
	for(k= 0;k<lng;k++)
	  {
		n= &((p->neighbors)[k]);
		if (RA(n->p, R_SOL)<=sol) break;
	  }
	if (k==lng)
	  {
		ipercent = 100.0*sol/maxX;
	    sprintf(globBuf, "Local  Minimum at (%5.2f,%5.2f) is %10.3e = %d%%",
				p->x, p->y, sol, ipercent);
	  }
	return true;
  }

static void PSHeader()
  {
    REAL xPos, yPos, yLine, from, to, locPos;
	int levels, k, ipercent;

	ComputeScaling(actGraph, actDriver);

	yLine = ((actGraph->maxTop)-(actGraph->maxBottom))/30.0;	
	yPos = actGraph->maxTop+yLine;
	xPos = actGraph->maxLeft;
	sprintf(globBuf,"%s", actTriang->name);
	PSString(xPos, yPos, globBuf);

	yPos = actGraph->maxBottom-0.5*yLine;

	NEXTLINE;
	sprintf(globBuf,"Domain: [%5.2f,%5.2f]x[%5.2f,%5.2f] read from '%s'",
			actGraph->maxLeft, actGraph->maxRight,
			actGraph->maxBottom, actGraph->maxTop,
			actTriang->fileName);
	PSString(xPos, yPos, globBuf);

	NEXTLINE;
	sprintf(globBuf,"%d Points,    %d triangles",
			actTriang->noOfPoints, actTriang->noOfTriangles);
	PSString(xPos, yPos, globBuf);

	NEXTLINE; yPos -= 0.5*yLine; locPos = yPos;
	minPt = nil; maxPt = nil;
	maxX = RMIN; minX = RMAX;
	ApplyP(FindMinMax, all);
	ipercent = 100.0*minX/maxX;
	sprintf(globBuf, "Min at (%5.2f,%5.2f) is %10.3e = %d%%",
			minPt->x, minPt->y, minX, ipercent);
	PSString(xPos, yPos, globBuf);

	NEXTLINE;
	sprintf(globBuf, "Max at (%5.2f,%5.2f) is %10.3e",
			maxPt->x, maxPt->y, maxX);
	PSString(xPos, yPos, globBuf);

	if (actGraph->level)
	  {
		NEXTLINE;
		levels = 0;
		from = (actGraph->levelsAt)[0];
		to = (actGraph->levelsAt)[(actGraph->levels)-1];
		for (k=0; (((actGraph->levelsAt)[k])<=minX)&&(k<(actGraph->levels)); k++)
		  from = (actGraph->levelsAt)[k];
		for (; (((actGraph->levelsAt)[k])<=maxX)&&(k<(actGraph->levels)); k++)
		  {
		    levels++;
			to = (actGraph->levelsAt)[k];
		  }
		if (levels>0)
		  {
			sprintf(globBuf, "%d levels from %6.3f to %6.3f",
					levels, from, to);
			PSString(xPos, yPos, globBuf);
		  }
		else
		  {
			sprintf(globBuf, "No level lines in range");
			PSString(xPos, yPos, globBuf);
		  }
	  }
	yPos = locPos;
	xPos = (actGraph->maxLeft)+0.5*(actGraph->maxRight-actGraph->maxLeft);
	ILUPrepare();
	ApplyP(PrintLocalMinMax, all);
	PSShow();
	return;
  }

int PostScript(cmd)
  COMMAND *cmd;
  {
	int index, rc, k;
	char *s1 = globBuf, *s2= globBuf+128, *tp;
	double help1, help2;
	REAL hOffset, vOffset, width, height, aux;

	if (ParsCheck(cmd, 0, 99)) return false;

	if (actTriang==nil)
	  { ZIBStdOut("Graph: no triangulation - no graphic\n"); return false; }

	actDriver = PSDriver();
	if (actDriver==nil) return false;

	if ((cmd->noOfPars)==0)			/* informing */
	  {
	    sprintf(globBuf,"%s: current driver (%s) settings\n",
				driverShort, driverName);
		ZIBStdOut(globBuf);
		sprintf(s1, "(%.2fcm,%.2fcm)",
				((actDriver->right)-(actDriver->left))*PTTOCM,
				((actDriver->top)-(actDriver->bottom))*PTTOCM);
		sprintf(s2, "(%.2fcm,%.2fcm)",
				(actDriver->left)*PTTOCM, (actDriver->bottom)*PTTOCM);
		sprintf(globBuf,"%s:     picture size %s at %s\n", driverShort, s1, s2);
		ZIBStdOut(globBuf);
		sprintf(s1, "(%.2fcm,%.2fcm)",
				(actDriver->maxRight)*PTTOCM,
				(actDriver->maxTop)*PTTOCM);
		sprintf(globBuf,"%s:     page size %s\n", driverShort, s1);
		ZIBStdOut(globBuf);
		sprintf(globBuf,"%s:     resolution %e\n", driverShort, actDriver->resolution);
		ZIBStdOut(globBuf);
		sprintf(globBuf,"%s:     font '%s'\n", driverShort, actDriver->fontName);
		ZIBStdOut(globBuf);
		sprintf(globBuf,"%s:     (file)name '%s'\n", driverShort, actDriver->fileName);
		ZIBStdOut(globBuf);
		return true;
	  }

	for (k = 1; k<=(cmd->noOfPars); k++)
	  {
		tp = (cmd->pars)[k];
		index = CheckName(&tp, cmd->names, nameClass);
		if (index==-1)
		  {
		    sprintf(globBuf,"Graph: '%s' unknown parameter to %s\n",
					(cmd->pars)[k], (cmd->pars)[0]);
			ZIBStdOut(globBuf);
			return false;
		  }
		switch (index)
		{
		  case 0:						/* size */
	          if ((cmd->noOfPars)==k)
			    {
				  actDriver->top = actDriver->maxTop;
				  actDriver->right = actDriver->maxRight;
				}
			  else
				{
				  rc = sscanf((cmd->pars)[k+1], "(%le,%le)",
				  			  &help1, &help2);
						width  = help1;
						height = help2;
				  if (rc!=2)
				    {
					  sprintf(globBuf,"%s: syntax error reading size '%s'\n",
					  		  driverShort, (cmd->pars)[k+1]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  actDriver->right = actDriver->left+width*CMTOPT;
				  actDriver->top = actDriver->bottom+height*CMTOPT;
				  k++;
				}
			  break;
		  case 1:						/* origin */
	          if ((cmd->noOfPars)==k)
			    {
				  actDriver->bottom = actDriver->maxBottom;
				  actDriver->left = actDriver->maxLeft;
				}
			  else
				{
				  rc = sscanf((cmd->pars)[k+1], "(%le,%le)",
				  			  &help1, &help2);
						hOffset  = help1;
						vOffset = help2;
				  if (rc!=2)
				    {
					  sprintf(globBuf,"%s: syntax error reading origin '%s'\n",
					  		  driverShort, (cmd->pars)[k+1]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  height = actDriver->top-actDriver->bottom;
				  width = actDriver->right-actDriver->left;
				  actDriver->bottom = vOffset*CMTOPT;
				  actDriver->left = hOffset*CMTOPT;
				  actDriver->top = actDriver->bottom+height;
				  actDriver->right = actDriver->left+width;
				  k++;
				}
			  break;
		  case 2:						/* font */
			  actDriver->fontName =
			  	(char*)ZIBAlloc((long)(strlen((cmd->pars)[k+1])+1));
			  if ((actDriver->fontName)==nil)
			    {
				  sprintf(globBuf,"Graph: not enough memory (%s)\n", driverName);
				  ZIBStdOut(globBuf);
				  return false;
				}
			  strcpy(actDriver->fontName, (cmd->pars)[k+1]);
			  k++;
			  break;
		  case 3:						/* file */
			  actDriver->fileName =
			  	(char*)ZIBAlloc((long)(strlen((cmd->pars)[k+1])+1));
			  if ((actDriver->fileName)==nil)
			    {
				  sprintf(globBuf,"Graph: not enough memory (%s)\n", driverName);
				  ZIBStdOut(globBuf);
				  return false;
				}
			  strcpy(actDriver->fileName, (cmd->pars)[k+1]);
			  k++;
/*			  return PSOpenPort(actDriver);	*/
			  return PSOpenPort();
		  case 4:						/* header */
			  PSHeader();
			  return true;
		}

	  }
/* check window bounds and change left/right or top/bottom, if necessary */
    if ((actDriver->left) > (actDriver->right))
       {
        aux = (actDriver->left);
        (actDriver->left) = (actDriver->right);
        (actDriver->right) = aux;
       }
    if ((actDriver->left) < (actDriver->maxLeft))
        (actDriver->left) = (actDriver->maxLeft);
    if ((actDriver->right) > (actDriver->maxRight))
        (actDriver->right) = (actDriver->maxRight);
    if ((actDriver->top) < (actDriver->bottom))
       {
        aux = (actDriver->top);
        (actDriver->top) = (actDriver->bottom);
        (actDriver->bottom) = aux;
       }
    if ((actDriver->top) > (actDriver->maxTop))
        (actDriver->top) = (actDriver->maxTop);
    if ((actDriver->bottom) < (actDriver->maxBottom))
        (actDriver->bottom) = (actDriver->maxBottom);

	if (actFile==nil) return PSOpenPort();
	return true;
  }

static int PSOpenPort()
  {
   DRIVER *driv = psDriv;
   REAL   deltaGray;
   int    i;

   if (actFile!=nil) PSClose();

   actFile = fopen(driv->fileName,"w");
   if (actFile==nil)
      {
	    sprintf(globBuf, "PS: could not open file '%s'\n", driv->fileName);
		ZIBStdOut(globBuf);
		return false;
	  }
   fprintf(actFile, "%%!\n");
   fprintf(actFile, "/L {newpath moveto lineto stroke} def\n");
   fprintf(actFile, "/T {moveto show} def\n");
   fprintf(actFile, "/A {newpath moveto arc stroke} def\n");
   fprintf(actFile, "/Fb {newpath moveto lineto} def\n");
   fprintf(actFile, "/Fm {lineto} def\n");
   fprintf(actFile, "/Fe {closepath setgray fill 0 setgray} def\n");
   fprintf(actFile, "/%s findfont\n", driv->fontName);
   fprintf(actFile, "%3.1f scalefont setfont\n",
           fontSize[MEDIUMSIZE]);
   fprintf(actFile, "%3.1f setlinewidth\n", lineWidth[SMALLSIZE]);
   fprintf(actFile, "2 setlinejoin\n");
   lineCount += 11;

   deltaGray = 1.0 / GRAYS;
   for (i = 0; i < GRAYS; i++)
       lineColor[driv->firstGray+i] = 1.0 - i * deltaGray;
 
   return true;
  }
 
static int PSNewPict()
  {
	ComputeScaling(actGraph,actDriver);
	if ((actGraph->top != actGraph->maxTop)||
	    (actGraph->left != actGraph->maxLeft)||
		(actGraph->bottom != actGraph->maxBottom)||
		(actGraph->right != actGraph->maxRight))
	  {
		fprintf(actFile, "initclip\n");
		fprintf(actFile, "newpath %7.2f %7.2f moveto %7.2f %7.2f lineto\n",
				actDriver->left-1.5, actDriver->bottom-1.5,
				actDriver->right+1.5, actDriver->bottom-1.5);
		fprintf(actFile, "%7.2f %7.2f lineto %7.2f %7.2f lineto\n",
				actDriver->right+1.5, actDriver->top+1.5,
				actDriver->left-1.5, actDriver->top+1.5);
		fprintf(actFile, "closepath clip\n");
		lineCount += 4;
	  }
    return true;
  }
 
static int PSShow()
  {  
	fprintf(actFile, "showpage\n");
	lineCount++;
	sprintf(globBuf, "PS: %d lines written to %s\n", lineCount, actDriver->fileName);
	ZIBStdOut(globBuf);
    return true;
  }
 
static int PSClose()
  {
	fclose(actFile);
	actFile = nil;

    return true;
  }
 
static int PSLine(p1x, p1y, p2x, p2y)
  REAL p1x, p1y, p2x, p2y;
  {
    fprintf(actFile, "%7.2f %7.2f %7.2f %7.2f L\n",
			TRANSX(p1x), TRANSY(p1y), TRANSX(p2x), TRANSY(p2y));
	lineCount++;
    return true;
  }
 
static int PSString(px, py, s)
  REAL px, py;
  char *s;
  {
    fprintf(actFile, "(%s) %7.2f %7.2f T\n", s,
			TRANSX(px), TRANSY(py));
	lineCount++;
    return true;
  }
 
static int PSFill(x,y,no,col)
  REAL *x, *y;
  int  no, col;
  {
   int  i, NL;

   if (no > 2)
      {
       fprintf(actFile,"%7.2f %7.2f %7.2f %7.2f Fb\n",
               TRANSX(x[1]), TRANSY(y[1]), TRANSX(x[0]), TRANSY(y[0]));
       lineCount++;
       NL = false;
       for (i = 2; i < no; i++)
           {
            fprintf(actFile," %7.2f %7.2f Fm",TRANSX(x[i]), TRANSY(y[i]));
            if (NL) { fprintf(actFile,"\n"); lineCount++; }
            NL = !NL;
           }
       fprintf(actFile," %6.3f Fe\n",lineColor[col]);
       lineCount++;
      }
   return true;
  } /* PSFill */
 
static int PSArc(pp1x, pp1y, pp2x, pp2y, pmx, pmy)
  REAL pp1x, pp1y, pp2x, pp2y, pmx, pmy;
  {
    REAL radius, startAngle, endAngle, dx, dy;
	REAL p1x = TRANSX(pp1x), p1y = TRANSY(pp1y),
		 p2x = TRANSX(pp2x), p2y = TRANSY(pp2y),
		 mx  = TRANSX(pmx),  my  = TRANSY(pmy);
 
	dx = p1x-mx; dy = p1y-my;
    radius = sqrt(dx*dx+dy*dy);
    startAngle=Arcus(dx,dy)*K180PI;
    endAngle = Arcus(p2x-mx, p2y-my)*K180PI;
    if ((startAngle<89.0)&&(endAngle>269.0)) endAngle -= 360;    
    if ((endAngle<89.0)&&(startAngle>269.0)) startAngle -= 360;    
    if (startAngle<endAngle)
      fprintf(actFile,"%7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %7.2f A\n",
              mx, my, radius, startAngle, endAngle, p1x, p1y);
    else
      fprintf(actFile,"%7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %7.2f A\n",
              mx, my, radius, endAngle, startAngle, p2x, p2y);
	lineCount++;
    return true;
  }
 
static int PSSettings(type, val)
  int type, val;
  {
   switch (type)
     {
      case PENSIZE:
           fprintf(actFile, "%3.1f setlinewidth\n",
                   lineWidth[val]);
           lineCount++;
           break;
      case FONTSIZE:
           fprintf(actFile, "/%s findfont\n", fontName);
           fprintf(actFile, "%3.1f scalefont setfont\n",
                   fontSize[val]);
           lineCount += 2;
           break;
/*
	  fprintf(actFile, "%3.1f setgray\n",
                   lineColor[val]);
           lineCount++;
*/
           break;
     }
     return true;
  }
 
DRIVER *PSDriver()
  {
	if (psDriv!=nil) return psDriv;
	psDriv = (DRIVER*) ZIBAlloc((long)sizeof(DRIVER));
	if (psDriv==nil)
	  { ZIBStdOut("Graph: not enough memory (PSDriver)\n"); return nil; }

    psDriv->Line = PSLine;
    psDriv->Arc = PSArc;
    psDriv->String = PSString;
    psDriv->Fill = PSFill;
    psDriv->Settings = PSSettings;
    psDriv->NewPict = PSNewPict;
    psDriv->Show = PSShow;
    psDriv->OpenPort = PSOpenPort;
    psDriv->Close = PSClose;
    psDriv->maxBottom = 0.0;
    psDriv->maxLeft = 0.0;
    psDriv->maxTop = 840.6;
    psDriv->maxRight = 593.3;
    psDriv->resolution = 72.0/300.0;
    psDriv->fontSize = fontSize[MEDIUMSIZE];
    psDriv->lineWidth = lineWidth[SMALLSIZE];
    psDriv->fillingP = false;
    psDriv->clippingP = true;
    psDriv->colorsP = false;
    psDriv->graysP = true;
    psDriv->noOfColors = COLORS;
    psDriv->noOfGrays = GRAYS;
    psDriv->firstGray = 9;
    psDriv->bottomMargin = 2.0 * CMTOPT;
    psDriv->leftMargin = 3.0 * CMTOPT;
    psDriv->topMargin = 2.0 * CMTOPT;
    psDriv->rightMargin = 1.0 * CMTOPT;
    psDriv->bottom = 0.0;
    psDriv->left = 0.0;
    psDriv->top = 840.6;
    psDriv->right = 593.3;
    psDriv->fontName = fontName;
    psDriv->fileName = psFName;

 /*   if (actFile==nil) if (!PSOpenPort(psDriv)) return nil;	*/
    if (actFile==nil) if (!PSOpenPort()) return nil;

    return psDriv;
  }
