;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994




;; Support for *Sequent Nodes* and *Deduction* buffers to display the sequent
;;; nodes of a deduction-graph.

(require 'process-filter)
(require 'sqns)
(require 'imps-edit)
(provide 'deduction-graphs)


(defvar dg-display-hook nil)

;;; Here is a dg display hook that moves the point to the end of the buffer.
(defun dg-move-to-end-of-dg ()
  (goto-char (point-max)))
;;;;

(defun always (s) t)

(defun make-sqn-mode-map ()
  (let ((map (copy-keymap scheme-mode-map)))
    (define-key map ">" 'sqn-display-max)
    (define-key map "j" 'sqn-display-jump)
    (define-key map "n" 'sqn-display-next)
    (define-key map "p" 'sqn-display-previous)
    (define-key map "l" 'sqn-redisplay-last-seen)
    (define-key map "." 'sqn-display-dg-chunk)
    (define-key map "h" 'sqn-hide)
    (define-key map "x" 'sqn-xview)
    (define-key map "X" 'dg-xview-dg)
    (define-key map "d" 'dg-direct-inference)
    (define-key map "D" 'dg-direct-and-antecedent-inference-strategy)
    (define-key map "b" 'dg-backchain)
    (define-key map "m" 'dg-apply-macete)
    (define-key map "c" 'dg-contrapose)
    (define-key map "@" 'dg-incorporate-antecedent)
    (define-key map "a" 'dg-antecedent-inference)
    (define-key map "A" 'dg-antecedent-inference-strategy)
    (define-key map "w" 'dg-weaken)
    (define-key map "e" 'sqn-edit-sqn)
    (define-key map "i" 'dg-induction)
    (define-key map "u" 'dg-unfold-single-defined-constant)
    (define-key map "U" 'dg-unfold-single-defined-constant-globally)
    (define-key map "\C-cU" 'dg-unfold-defined-constants)

    (define-key map "~" 'dg-extensionality)
    (define-key map "&" 'dg-cut-with-single-formula)
    (define-key map "\C-cb" 'dg-beta-reduce-repeatedly)
    (define-key map "f" 'dg-force-substitution)
    (define-key map "r" 'dg-raise-conditional)

    (define-key map "\C-c\C-c" 'dg-post-cmpn)
    (define-key map "\C-c\C-s" 'dg-simplify)    
    (define-key map "\C-cs" 'dg-simplify)
    (define-key map "!" 'dg-apply-command)
    (define-key map "\C-c!" 'dg-apply-command-multiply)
    (define-key map "s" 'dg-apply-command)
    (define-key map "?" 'imps-command-menu)
    (define-key map "\C-c?" 'imps-macete-menu)
    ;; Tree-oriented motion commands -- temporary bindings
    ;; let's see how they work.
    ;;
    (define-key map "P" 'imps-parent)
    (define-key map "F" 'imps-first-unsupported-relative)
    (define-key map "C" 'imps-first-child)
    (define-key map "S" 'imps-next-sibling)
    map))

(defvar sqn-mode-map (make-sqn-mode-map))

(defun make-dg-mode-map ()
  (let ((map (copy-keymap scheme-mode-map)))
    (define-key map ">" 'sqn-display-max)
    (define-key map "j" 'sqn-display-jump)
    (define-key map "n" 'sqn-display-next)
    (define-key map "p" 'sqn-display-previous)
    (define-key map "l" 'sqn-redisplay-last-seen)
    (define-key map "." 'dg-display-sqn)
    (define-key map "x" 'dg-xview-sqn)
    (define-key map "X" 'dg-xview-dg)
    (define-key map "h" 'dg-hide)
    (define-key map "H" 'dg-hide-region)
    (define-key map "d" 'dg-direct-inference)
    (define-key map "D" 'dg-direct-and-antecedent-inference-strategy)
    (define-key map "b" 'dg-backchain)
    (define-key map "m" 'dg-apply-macete)
    (define-key map "c" 'dg-contrapose)
    (define-key map "@" 'dg-incorporate-antecedent)
    (define-key map "a" 'dg-antecedent-inference)
    (define-key map "A" 'dg-antecedent-inference-strategy)
    (define-key map "w" 'dg-weaken)
    (define-key map "i" 'dg-induction)
    (define-key map "\C-cU" 'dg-unfold-defined-constants)

    (define-key map "~" 'dg-extensionality)
    (define-key map "&" 'dg-cut-with-single-formula)
    (define-key map "\C-cb" 'dg-beta-reduce-repeatedly)
    (define-key map "f" 'dg-force-substitution)
    (define-key map "r" 'dg-raise-conditional)

    (define-key map "e" 'sqn-edit-sqn)
    (define-key map "\C-c\C-c" 'dg-post-cmpn)
    (define-key map "\C-c\C-s" 'dg-simplify)
    (define-key map "\C-cs" 'dg-simplify)
    (define-key map "!" 'dg-apply-command)
    (define-key map "\C-c!" 'dg-apply-command-multiply)
    (define-key map "s" 'dg-apply-command)
    (define-key map "?" 'imps-command-menu)
    (define-key map "\C-c?" 'imps-macete-menu)
    ;; Tree-oriented motion commands -- temporary bindings
    ;; let's see how they work.
    ;;
    (define-key map "P" 'imps-parent)
    (define-key map "F" 'imps-first-unsupported-relative)
    (define-key map "C" 'imps-first-child)
    (define-key map "S" 'imps-next-sibling)
    map))

(defvar dg-mode-map (make-dg-mode-map))

(defun sqn-buffer ()
  (dgrv-fn-at
   'dgr-sqn-buffer
   dg-number))

(defun dg-buffer ()
  (dgrv-fn-at
   'dgr-dg-buffer
   dg-number))

(defun sqn-mode (dgrv-index)
  "Major mode for interacting with IMPS sequents. 
Commands:
\\{sqn-mode-map}\n"
  (interactive "ndg-number: ")
  (kill-all-local-variables)
  (use-local-map sqn-mode-map)
  (setq major-mode 'sqn-mode)
  (setq mode-name "Seq Nodes")
  (setq buffer-read-only t)
  (setq dg-number dgrv-index)
  (sqn-set-current-sqn dg-number 0)
  (scheme-mode-variables)
  (setq mode-line-buffer-identification
	(list "  %1*>> %b <<%1*  "))
  (setq mode-line-format
	(list (dgrv-fn-at 'dgr-theory-name dg-number)
	      ": " 'mode-line-process "       " 'mode-line-buffer-identification "       "
	      'global-mode-string
	       "  %3p %1*%1*"))
  (run-hooks 'sqn-mode-hook))

(defun dg-mode (dgrv-index)
  "Major mode for interacting with IMPS deduction graphs.
Commands:
\\{dg-mode-map}\n"
  (interactive "ndg-number: ")
  (kill-all-local-variables)
  (use-local-map dg-mode-map)
  (setq major-mode 'dg-mode)
  (setq mode-name "Deduction Graph")
  (setq buffer-read-only t)
  (setq dg-number dgrv-index)
  (scheme-mode-variables)
  (run-hooks 'dg-mode-hook))

(defun dg-read-from-file (dg-buffer dg-file)
  (interactive "bdg-buffer: ")
  (let ((buffer-read-only nil))
    (set-buffer dg-buffer)
    (erase-buffer)
    (insert-file-contents
     (expand-file-name (substitute-in-file-name dg-file)))
    (if (not (null dg-display-hook))
	(run-hooks 'dg-display-hook))))

(defun dg-current-hash-no ()
  (interactive)
  (save-excursion
    (condition-case tmp
	(progn
	  (beginning-of-enclosing-list)
	  (goto-char (cdr (next-symbol-boundaries (point))))
	  (car (read-from-string (next-symbol-string (point)))))
      (error
       (read-from-minibuffer "Current sequent node hash-number: "
			     nil
			     nil
			     t)))))


(defun current-sqn-no ()
  (cond ((eq major-mode 'dg-mode)
	 (dg-current-hash-no))
	(t (sqn-current-hash-no dg-number))))

(defun dg-display-sqn (pos)
  "Display the sqn currently under the cursor in the sqn buffer."
  (interactive "d")
  (let ((hash (dg-current-hash-no)))
    (switch-to-buffer-other-window (sqn-buffer))
    (sqn-display dg-number (hash-no-to-sqn-index dg-number hash))))

;;;(defconst imps-primitive-inferences
;;;  '(("direct-inference")
;;;    ("insistent-direct-inference")
;;;    ("antecedent-inference" single-formula-retrieval-protocol)
;;;    ("contraposition" single-formula-retrieval-protocol)
;;;    ("simplification")
;;;    ("weak-simplification")
;;;    ("insistent-simplification")
;;;    ("simplification-with-minor-premises")
;;;    ("beta-reduction")
;;;    ("insistent-beta-reduction")
;;;    ("extensionality")
;;;    ("weakening" formula-list-by-index-retrieval-protocol)
;;;    ("global-defined-constant-unfolding" symbol-retrieval-protocol)
;;;    ("defined-constant-messy-unfolding"
;;;     symbol-locations-in-formula-retrieval-protocol)
;;;    ("defined-constant-unfolding"
;;;     symbol-locations-in-formula-retrieval-protocol)
;;;    ("macete-application" macete-retrieval-protocol)
;;;    ("macete-application-with-minor-premises" macete-retrieval-protocol)
;;;    ("macete-local-application" macete-and-expressions-in-formula-retrieval-protocol)
;;;    ("macete-local-application-with-minor-premises"
;;;     macete-and-expressions-in-formula-retrieval-protocol)
;;;    ("raise-conditional-inference" locations-in-formula-retrieval-protocol)
;;;    ("raise-conditional-messily-inference" locations-in-formula-retrieval-protocol)
;;;    ("iota-elimination")
;;;    ("alternate-iota-elimination")
;;;    ("backchain-inference" single-formula-retrieval-protocol)
;;;    ("backchain-backwards-inference" single-formula-retrieval-protocol)
;;;    ("implication-elimination" single-formula-retrieval-protocol)
;;;    ("cut" cut-retrieval-protocol)
;;;    ("cut-with-single-formula" cut-with-single-formula-retrieval-protocol)
;;;    ("disjunction-elimination" one-sequent-retrieval-protocol)
;;;    ("universal-instantiation" one-sequent-retrieval-protocol)
;;;    ("theorem-assumption" theorem-retrieval-protocol)
;;;    ("existential-generalization" one-sequent-retrieval-protocol)
;;;    ("definedness")
;;;    ("tautology")
;;;    ("sort-definedness")
;;;    ("force-substitution-messily" force-substitution-retrieval-protocol)
;;;    ("force-substitution"
;;;     force-substitution-retrieval-protocol)
;;;    ("unordered-conjunction-direct-inference")))

(defconst imps-inductors
  '(("integer-inductor")
    ("nonrecursive-integer-inductor")
    ("combinatorial-integer-inductor")))
    
;; User level procedures follow
  
(defun sqn-hide (sqn-no)
  "Hide sequent node SQN."
  (interactive (list (sqn-current-hash-no dg-number)))
  (tea-eval-and-update-sqn-and-dg
   (format "(sequent-node-hide (sequent-unhash %s))"
	   sqn-no)))
  
(defun dg-hide (sqn-no)
  "Hide sequent node SQN."
  (interactive (list (dg-current-hash-no)))
  (tea-eval-and-update-sqn-and-dg 
   (format "(sequent-node-hide (sequent-unhash %s))"
	   sqn-no)))
 
(defun dg-hide-region (start end)
  (interactive "r")
  (let ((sqn-nos (integers-within-region start end)))
    (tea-eval-and-update-sqn-and-dg 
     (format "(map
	       (lambda (n)
		 (sequent-node-hide (sequent-unhash n)))
	       '%s)"
	     sqn-nos))))
 

(defun sqn-unhide (sqn-no)
  "Unhide sequent node SQN."
  (interactive (list (sqn-current-hash-no dg-number)))
  (tea-eval-and-update-sqn-and-dg 
   (format "(sequent-node-unhide (sequent-unhash %s))"
	   sqn-no)))
  
(defun dg-unhide (sqn-no)
  "Unhide sequent node SQN."
  (interactive (list (dg-current-hash-no)))
  (tea-eval-and-update-sqn-and-dg 
   (format "(sequent-node-unhide (sequent-unhash %s))"
	   sqn-no)))

(defun sqn-xview (sqn-no)
  "Run xview on the current SQN."
  (interactive (list (sqn-current-hash-no dg-number)))
  (dg-xview-sqn sqn-no))
  
(defun dg-xview-sqn (sqn-no)
  "Run xview on the current SQN."
  (interactive
   (list (dg-current-hash-no)))
  (message "Starting xview...")
  (tea-eval-expression
   (format
    "(bind (((emacs-dg) (dgrv-index->dg %d)))(xview (sequent-unhash %d)))" dg-number sqn-no)))

(defun dg-xview-dg (dg-hash)
  "Run xview on the DG."
  (interactive
   (list (dgrv-fn-at 'dgr-dg-hash dg-number)))
  (message "Starting xview on deduction graph.")
  (tea-eval-expression (format "(xview (object-unhash %d))" dg-hash)))

(defun imps-current-sqn ()
;;;  (if (eq 'sqn-mode major-mode)
;;;      (sqn-current-hash-no dg-number)
;;;    (dg-current-hash-no))
  (current-sqn-no))


;; Tree-oriented motion commands--

(require 'backquote)
(defmacro def-imps-motion (emacs-name tea-proc)
  "Defun emacs-name to shift the *Sequent-nodes* display 
to the result of running tea-proc on the argument sqn-no."
  (let ((str (format "Display node produced by  %s  from argument sqn."
		     tea-proc)))
    (` (defun (, emacs-name) (sqn-no)
	 (, str)
	 (interactive (list (imps-current-sqn)))
	 (tea-eval-expression
	  (format "(bind (((emacs-dg) (dgrv-index->dg %s)))
			 (emacs-display-sqn %s (%s (sequent-unhash %s))))"
		  dg-number dg-number '(,  tea-proc) sqn-no))))))

(def-imps-motion imps-parent sequent-node-parent)
(def-imps-motion imps-first-child sequent-node-first-child)
(def-imps-motion imps-next-sibling sequent-node-next-sibling)
(def-imps-motion imps-first-unsupported-descendent sequent-node-first-unsupported-descendent)
(def-imps-motion imps-first-unsupported-relative sequent-node-first-unsupported-relative)
(defun imps-first-unsupported ()
  "Display node produced by  sequent-node-first-unsupported-descendent  from sequent node 1"
  (interactive)
  (imps-first-unsupported-descendent 1))

(defun dg-post-cmpn ()
  (interactive)
  (tea-eval-expression
   (format "(bind (((emacs-dg) (dgrv-index->dg %d)))
		  (emacs-display-cmpn
		   (post-computation-node
		    (sequent-unhash %d))))"
	   dg-number (imps-current-sqn))))


;;Special calls:

(defun dg-direct-inference ()
  (interactive)
  (dg-apply-command "direct-inference" (list (current-sqn-no))))

(defun dg-contrapose () (interactive)
  (dg-apply-command "contrapose"  (list (current-sqn-no))))

(defun dg-backchain () (interactive)
  (dg-apply-command "backchain" (list (current-sqn-no))))

(defun dg-apply-macete ()
  (interactive)
  (dg-apply-command
   (if current-prefix-arg
       "apply-macete"
     "apply-macete-with-minor-premises")
   (list (current-sqn-no))))

(defun dg-incorporate-antecedent () (interactive)
  (dg-apply-command "incorporate-antecedent" (list (current-sqn-no)) ))

(defun dg-antecedent-inference () (interactive)
  (dg-apply-command "antecedent-inference" (list (current-sqn-no)) ))

(defun dg-weaken () (interactive)
  (dg-apply-command "weaken" (list (current-sqn-no)) ))

(defun dg-unfold-single-defined-constant () 
  (interactive) 
  (dg-apply-command "unfold-single-defined-constant" (list (current-sqn-no))))

(defun dg-unfold-single-defined-constant-globally () (interactive)
  (dg-apply-command "unfold-single-defined-constant-globally" (list (current-sqn-no))))

(defun dg-unfold-defined-constants () (interactive)
  (dg-apply-command "unfold-defined-constants" (list (current-sqn-no))))

(defun dg-simplify () (interactive)
  (dg-apply-command "simplify" (list (current-sqn-no))))

(defun dg-direct-inference-strategy ()
  (interactive)
  (dg-apply-command "direct-inference-strategy" (list (current-sqn-no))))

(defun dg-direct-and-antecedent-inference-strategy ()
  (interactive)
  (dg-apply-command "direct-and-antecedent-inference-strategy" (list (current-sqn-no))))

(defun dg-antecedent-inference-strategy ()
  (interactive)
  (dg-apply-command "antecedent-inference-strategy" (list (current-sqn-no))))

(defun dg-induction ()
  (interactive)
  (dg-apply-command "induction" (list (current-sqn-no))))

(defun dg-edit-and-post ()
  (interactive)
  (dg-apply-command "edit-and-post-sequent-node" (list (current-sqn-no))))

(defun dg-force-substitution ()
  (interactive)
  (dg-apply-command "force-substitution" (list (current-sqn-no))))

(defun dg-raise-conditional ()
  (interactive)
  (dg-apply-command "raise-conditional" (list (current-sqn-no))))

(defun dg-cut-with-single-formula ()
  (interactive)
  (dg-apply-command "cut-with-single-formula" (list (current-sqn-no))))

(defun dg-beta-reduce ()
  (interactive)
  (dg-apply-command "beta-reduce" (list (current-sqn-no))))

(defun dg-beta-reduce-repeatedly ()
  (interactive)
  (dg-apply-command "beta-reduce-repeatedly" (list (current-sqn-no))))

(defun dg-extensionality ()
  (interactive)
  (dg-apply-command "extensionality" (list (current-sqn-no))))
  
;;;COMMANDS:

(defun dg-apply-command (command &optional sqn-nos args)
  (interactive
   (list (imps-completing-read "Command name: "
			       imps-commands
			       'always
			       nil
			       nil)))
	 
  (let ((dg-no dg-number))
    (catch 'apply-command-tag
      (let ((sqn-nos (if sqn-nos sqn-nos
		       (car (read-from-string (format "(%d)" (current-sqn-no))))))
	    (args (if args args
		    (save-excursion
		      (funcall (argument-retrieval-protocol command))))))
	(funcall (argument-transmission-protocol command) command dg-no sqn-nos args)))))

(defun dg-apply-command-multiply (command  &optional sqn-nos args)
  (interactive
   (list (imps-completing-read "Command name: "
			       imps-commands
			       'always
			       nil
			       nil)))
  (let ((dg-no dg-number))
    (catch 'apply-command-tag
      (let ((sqn-nos (if sqn-nos sqn-nos
		       (read-from-minibuffer "Sequent nodes: "
					     (format "(%d)" (current-sqn-no))
					     nil t)))
	    (args (if args args
		    (save-excursion
		      (funcall (argument-retrieval-protocol command))))))
	(funcall (argument-transmission-protocol command) command dg-no sqn-nos args)))))

(defun argument-retrieval-protocol (command)
  (let ((probe (assoc command imps-commands)))
    (if probe 
	(nth 0 (cdr probe))
      'default-argument-retrieval-protocol)))

(defun argument-transmission-protocol (command)
  (let ((probe (assoc command imps-commands)))
    (if probe 
	(nth 1 (cdr probe))
      'default-argument-transmission-protocol)))
    


;;;Argument retrieval protocols( from USER to EMACS)

(defun default-argument-retrieval-protocol ()
  "'()")

(defun general-argument-retrieval-protocol ()
  (format "(list %s)" (read-from-minibuffer "Command Arguments: " nil nil)))

(defun one-sequent-retrieval-protocol ()
  (format "(list (sequent-unhash-in-graph-by-number %d %d))"
	  (read-from-minibuffer "Major premise number: " nil nil t)
	  dg-number))

(defun cut-retrieval-protocol ()
  (format "(list (sequent-unhash-in-graph-by-number %d %d))"
	  (read-from-minibuffer "Major premise number: "
				(format "%s"
					(length (dgrv-fn-at 'dgr-sqn-vector dg-number)))
				nil t)
	  dg-number))

(defun imps-input-quote-string-if-needed (str)
  "Take a STRING and return \"STRING\", if not already of this form."
  (if (string-match "^\"[^\"]*\"$" str) ;;already quoted
		str
	      (format "\"%s\"" str)))

(defun cut-with-single-formula-retrieval-protocol ()
  "Cut with FORMULA-STR."
  (let ((formula-str
	 (imps-read-from-minibuffer "Formula to cut: " nil inferior-tea-minibuffer-map nil)))
    (format "(list %s)"
	    (imps-input-quote-string-if-needed formula-str))))

;;Remark: This is used only for the Nadel-Thayer extension.

(defun transfer-formula-retrieval-protocol ()
  "Cut with FORMULA-STR."
  (let ((formula-str
	 (imps-read-from-minibuffer "transfer-formula: " nil inferior-tea-minibuffer-map nil)))
    (format "(list %s)"
	    (imps-input-quote-string-if-needed formula-str))))

(defun formula-list-by-index-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((number (get-literal-from-tea
		    (format "(length (sequent-node-assumptions
      			                (sequent-unhash-in-graph-by-number %d %d)))"
			    sqn-no
			    dg-no))))

      (format
       "(list '(%s))"
       (cond ((= number 0) (error "Weakening impossible: no assumptions in sequent."))
	     ((= number 1) 0)
	     (t (let ((antecedent-formulas
		       (read-indices-from-minibuffer
			"List of formulas to omit: "
			nil nil nil)))
		  antecedent-formulas)))))))

;;;(defun formula-list-by-index-retrieval-protocol ()
;;;  (format "(list '(%s))"
;;;	  (read-indices-from-minibuffer "List of formula indices to omit (0-based): "
;;;				nil nil nil)))

;;;(defun selective-antecedent-inference-rp ()
;;;  (format "(list '%s)"
;;;	  (read-indices-from-minibuffer "List of formula indices for antecedent inferences (0-based): "
;;;				"(0)" nil nil)))

(defun selective-antecedent-inference-rp ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((assums (get-literal-from-tea
		    (format "(sqn-antecedent-inference-assumptions
			     (sequent-unhash-in-graph-by-number %d %d))"
			    sqn-no
			    dg-no)))
	   (number (length assums)))

      (format
       "(list '(%s))"
       (cond ((= number 0) (error "No antecedent inferences possible."))
	     ((= number 1) (car assums))
	     (t (let ((antecedent-formulas
		       (read-indices-from-minibuffer
			(concat "List of formula indices for antecedent inferences -- ("
				(mapconcat '(lambda (x) x) assums " ")
				"): ")
			nil nil nil)))
		  antecedent-formulas)))))))

(defun locations-in-formula-retrieval-protocol ()
  (let ((indices (read-from-minibuffer "Occurrences of conditionals to be raised (0-based): "
				       "" nil nil)))
    (format "(list '(%s))" indices)))

(defun macete-and-expressions-in-formula-retrieval-protocol ()
  (let ((macete-name
	 (or *we-already-know-the-macete-because-we-got-it-from-the-menu*
	     (read-macete)))

	(expr-str
	 (imps-read-from-minibuffer "Expression to apply macete: " nil inferior-tea-minibuffer-map nil))
	(indices (read-from-minibuffer "Occurrences of expression (0-based): " nil nil nil)))
    (format "(list '%s '(%s) %s)"
	    macete-name
	    indices
	    (imps-input-quote-string-if-needed expr-str))))

;;;(defun symbol-locations-in-formula-retrieval-protocol ()
;;;  (let ((constant (imps-read-from-minibuffer "Constant name: " "" nil t))
;;;	(indices (read-from-minibuffer "Occurrences to unfold (0-based): "
;;;				       nil nil nil)))
;;;    (format "(list '(%s) '%s)" indices constant)))

(defun symbol-locations-in-formula-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((constants (get-literal-from-tea
		      (format "(defined-constants-in-assertion 
			      (sequent-unhash-in-graph-by-number %d %d))"
			      sqn-no
			      dg-no))))
      (if (null constants)
	  (error "No defined constants in expression.")
	(let* ((constant
		(if (= (length constants) 1)
		    (car (car constants))
		  (completing-read-or-get-from-x-menu 
		   "Constant name: " constants nil nil nil)))
	       (positions (cdr (assoc constant constants)))
	  
	       (indices (if (= (length positions) 1)
			    "0"
			  (read-from-minibuffer "Occurrences to unfold (0-based): "
						"" nil nil))))
	  (format "(list '(%s) '%s)" indices constant))))))

(defvar *we-already-know-the-macete-because-we-got-it-from-the-menu* nil)

(defun macete-retrieval-protocol ()
  (format "(list '%s)"
	  (or *we-already-know-the-macete-because-we-got-it-from-the-menu*
	      (read-macete))))

(defun theorem-retrieval-protocol ()
  (let ((thm-name
	 (imps-completing-read "Theorem name: "
			  imps-obarray
			  'kind-is-theorem-p
			  nil
			  nil)))
    (format "(list '%s)" thm-name)))

(defun force-substitution-retrieval-protocol ();;(target-str replacement-str occurrence)
  "Force REPLACEMENT-STR to replace TARGET-STR at the OCCURRENCE'th occurrence."
  (let ((target-str
	 (imps-read-from-minibuffer "Expression to replace: " nil inferior-tea-minibuffer-map nil))
	(replacement-str
	 (imps-read-from-minibuffer "Replace it with: " nil inferior-tea-minibuffer-map nil))
	(occurrences
	 (read-from-minibuffer "0-based indices of occurrences to change: " nil nil nil)))
    (format "(list %s %s '(%s))" 
	    (imps-input-quote-string-if-needed target-str)
	    (imps-input-quote-string-if-needed replacement-str)
	    occurrences)))

;;;(defun single-formula-retrieval-protocol ()
;;;  (format "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
;;;	  (current-sqn-no)
;;;	  dg-number
;;;	  (read-from-minibuffer "0-based index of antecedent-formula: " nil nil t)))

(defun single-formula-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((number (get-literal-from-tea
		   (format "(length
			     (sequent-node-assumptions
			      (sequent-unhash-in-graph-by-number %d %d)))"
			   sqn-no
			   dg-no))))
      (format
       "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No assumptions in sequent node"))
	     ((= number 1) 0)
	     (t (read-indices-from-minibuffer "0-based index of antecedent-formula: " nil nil t)))))))
      

  
(defun existential-formula-and-variables-retrieval-protocol ()
  (let ((formula-index
	 (read-indices-from-minibuffer "0-based index of existential formula: " nil nil t))
	(variable-strs (collect-a-bunch-of-variables)))
    (format "(list '%s '(%s))" formula-index variable-strs)))

(defun one-sequent-argument-retrieval-protocol ()
  (format "(list (sequent-unhash-in-graph-by-number %d %d))"
	  (read-from-minibuffer "Auxiliary sequent number: " nil nil t)
	  dg-number))


(defun collect-a-bunch-of-variable-instantiations (variable-sorts)
  (let (terms new-string)
    (while variable-sorts
      (setq
       new-string
       (imps-read-from-minibuffer
	(format "%s%s%s%s%s: "
		"Instance for variable " (car variable-sorts)
		" of sort " (car (cdr variable-sorts)))
	nil nil nil))
      (setq terms (cons new-string terms))
      (setq variable-sorts (cdr (cdr variable-sorts))))
    (mapconcat (function
		(lambda (x) (format "%s" (imps-input-quote-string-if-needed x))))
	       (nreverse terms) "\n")))

(defun collect-a-bunch-of-terms ()
  (let (terms new-string)
    (setq new-string
	  (imps-read-from-minibuffer "First instance term: " nil nil nil))
    (while (not (string= "" new-string))
      (setq terms (cons new-string terms))
      (setq new-string (imps-read-from-minibuffer
			"Next instance term (<RET> if done): " nil nil nil)))
    (mapconcat (function
		(lambda (x) (format "%s" (imps-input-quote-string-if-needed x))))
	       (nreverse terms) "\n")))

(defun collect-a-bunch-of-variables ()
  (let (variables new-string)
    (setq new-string
	  (imps-read-from-minibuffer "First variable: " nil nil nil))
    (while (not (string= "" new-string))
      (setq variables (cons new-string variables))
      (setq new-string (imps-read-from-minibuffer
			"Next variable (<RET> if done): " nil nil nil)))
    (mapconcat (function
		(lambda (x) (format "%s" (imps-input-quote-string-if-needed x))))
	       (nreverse variables) "\n")))

(defun collect-a-bunch-of-formulas ()
  (let (terms new-string)
    (setq new-string
	  (imps-read-from-minibuffer "First formula: " nil nil nil))
    (while (not (string= "" new-string))
      (setq terms (cons new-string terms))
      (setq new-string (imps-read-from-minibuffer
			"Next formula (<RET> if done): " nil nil nil)))
    (mapconcat (function
		(lambda (x) (format "%s" (imps-input-quote-string-if-needed x))))
	       (nreverse terms) "\n")))

;;;(defun request-induction-variable ()
;;;    (let (terms new-string)
;;;      (setq new-string
;;;	    (imps-read-from-minibuffer
;;;	     "First variable to induct (<RET> to use IMPS default): " nil nil nil))
;;;      (while (not (string= "" new-string))
;;;	(setq terms (cons new-string terms))
;;;	(setq new-string (imps-read-from-minibuffer
;;;			  "Next variable to induct (<RET> if done): " nil nil nil)))
;;;      (mapconcat (function
;;;		  (lambda (x) (format "\"%s\"" x)))
;;;		 (nreverse terms) "\n")))
;;;

(defun request-induction-variable (induction-var-sorts)
  (if (= (length induction-var-sorts) 1)
      (format "%s" (imps-input-quote-string-if-needed (car (car induction-var-sorts))))
    (let* ((prompt-string
	    (if (and (boundp 'imps-mouse-call-p) imps-mouse-call-p)
		"Variable to induct on:"
	      "Variable to induct on (<RET> to use IMPS default): "))
	   (induction-var-sorts
	    (if (and (boundp 'imps-mouse-call-p) imps-mouse-call-p)
		(cons '("Use IMPS default.") induction-var-sorts)
	      induction-var-sorts))
	   (term-string
	    (completing-read-or-get-from-x-menu prompt-string induction-var-sorts nil nil nil)))
      (if (or (string= "" term-string)
	      (string= "Use IMPS default." term-string))
	  ""
	
	(format "%s" (imps-input-quote-string-if-needed term-string))))))
	
(defun theorem-instantiation-retrieval-protocol ()
  (let ((thm-name
	 (imps-completing-read "Theorem name: "
			  imps-obarray
			  'kind-is-theorem-p
			  nil
			  nil)))
    (let ((var-sorts (imps-get-theorem-var-sorts thm-name)))
      (format "(list '%s '(%s))"  
	      thm-name
	      (collect-a-bunch-of-variable-instantiations var-sorts)))))

(defun local-definition-retrieval-protocol ()
  (let ((variable-string (imps-read-from-minibuffer "Variable to define: "  nil nil nil))
	(term-string (imps-read-from-minibuffer "Defining term: "  nil nil nil)))
	 
    (format "(list '%s \"%s\")"  
	    variable-string
	    term-string)))


;;;(defun instantiate-existential-retrieval-protocol ()
;;;(format "'((%s))" (collect-a-bunch-of-terms)))


(defun instantiate-existential-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((existential-vars (get-literal-from-tea
			 (format "(sqn-existential-with-variable-sorts
			     (sequent-unhash-in-graph-by-number %d %d))"
				 sqn-no
				 dg-no))))
      (if (null existential-vars) (error "Assertion not an existential."))
      (format "'((%s))" (collect-a-bunch-of-variable-instantiations existential-vars)))))

(defun case-split-retrieval-protocol ()
  (format "'((%s))" (collect-a-bunch-of-formulas)))

;;;(defun instantiate-universal-retrieval-protocol ()
;;;  (let ((index (read-from-minibuffer "0-based index of antecedent-formula: " nil nil t)))
;;;    (format "(list '%s '(%s))"  
;;;	    index
;;;	    (collect-a-bunch-of-terms))))
;;;
(defun instantiate-universal-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((universals (get-literal-from-tea
		       (format "(sqn-univeral-assumptions-with-variable-sorts
			     (sequent-unhash-in-graph-by-number %d %d))"
			       sqn-no
			       dg-no))))

      (cond ((null universals) (error "No universal assumptions in sequent node."))
	    ((null (cdr universals))
	     (format "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d) '(%s))"
		     sqn-no
		     dg-no
		     (car (car universals))
		     (collect-a-bunch-of-variable-instantiations (cdr (car universals)))))
	    (t (let* ((indices (mapcar 'car universals))
		    
		      (index
		       (read-indices-from-minibuffer
			(concat "0-based index of universal antecedent formula -- ("
				(mapconcat '(lambda (x) x) indices " ")
				"): ")
			nil nil t))
		      (variable-sorts (cdr (assoc index universals))))

		 (if (null variable-sorts)
		     (error "Index must be one of %s" indices)
		   (format "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d) '(%s))"
			   sqn-no
			   dg-no
			   index
			   (collect-a-bunch-of-variable-instantiations variable-sorts)))))))))

(defun single-universal-formula-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((universals (mapcar 'car (get-literal-from-tea
				     (format "(sqn-univeral-assumptions-with-variable-sorts
			     (sequent-unhash-in-graph-by-number %d %d))"
					     sqn-no
					     dg-no))))
	   (number (length universals)))

      (format
       "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No universal assumptions in sequent node."))
	     ((= number 1) (car universals))
	     (t (let ((index
		       (read-indices-from-minibuffer
			(concat "0-based index of universal antecedent formula -- ("
				(mapconcat '(lambda (x) x) universals " ")
				"): ")
			nil nil t)))
		  (if (not (memq index universals))
		      (error "Index must be one of %s." universals))
		  index)))))))
		  

(defun instantiate-universal-multiply-retrieval-protocol ()
  (let ((index (read-indices-from-minibuffer "0-based index of antecedent-formula: " nil nil t))
	(terms-s (list (collect-a-bunch-of-terms))))
    (while (y-or-n-p "Input terms for another instance? ")
      (setq terms-s (cons (collect-a-bunch-of-terms) terms-s)))
    (format "(list '%s '((%s)))"  
	    index
	    (mapconcat (function
			(lambda (x) (format "%s" x)))
		       (nreverse terms-s) ")\n("))))

(defun antececent-formula-retrieval-protocol ()
  (let ((index (read-indices-from-minibuffer "0-based index of antecedent-formula: " nil nil t)))
    (format "(list '%s)" index)))

(defun antececent-inference-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((assums (get-literal-from-tea
		    (format "(sqn-antecedent-inference-assumptions
			     (sequent-unhash-in-graph-by-number %d %d))"
			    sqn-no
			    dg-no)))
	   (number (length assums)))

      (format
       "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No antecedent inferences possible."))
	     ((= number 1) (car assums))
	     (t (let ((index
		       (read-indices-from-minibuffer
			(concat "0-based index of antecedent formula -- ("
				(mapconcat '(lambda (x) x) assums " ")
				"): ")
			nil nil t)))
		  (if (not (memq index assums))
		      (error "Index must be one of %s." assums))
		  index)))))))

(defun repeated-backchain-rp ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((assums (get-literal-from-tea
		    (format "(sqn-backchain-inference-assumptions
			     (sequent-unhash-in-graph-by-number %d %d))"
			    sqn-no
			    dg-no)))
	   (number (length assums)))

      
      (format
       "(list
         (choose-list-entries
	  (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) '(%s)))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No backchain inferences possible."))
	     ((= number 1) (car assums))
	     (t (let ((indices
		       (read-indices-from-minibuffer
			(concat "0-based index of antecedent formulas -- ("
				(mapconcat '(lambda (x) x) assums " ")
				"): ")
			nil nil nil)))
		  indices)))))))

(defun backchain-inference-rp ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((assums (get-literal-from-tea
		    (format "(sqn-backchain-inference-assumptions
			     (sequent-unhash-in-graph-by-number %d %d))"
			    sqn-no
			    dg-no)))
	   (number (length assums)))

      
      (format
       "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No backchain inferences possible."))
	     ((= number 1) (car assums))
	     (t (let ((index
		       (read-indices-from-minibuffer
			(concat "0-based index of antecedent formula -- ("
				(mapconcat '(lambda (x) x) assums " ")
				"): ")
			nil nil t)))
		  (if (not (memq index assums))
		      (error "Index must be one of %s." assums))
		  index)))))))

(defun backchain-backwards-inference-rp ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let* ((assums (get-literal-from-tea
		    (format "(sqn-backchain-backwards-inference-assumptions
			     (sequent-unhash-in-graph-by-number %d %d))"
			    sqn-no
			    dg-no)))
	   (number (length assums)))

      
      (format
       "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
       sqn-no
       dg-no
       (cond ((= number 0) (error "No backchain backwards inferences possible."))
	     ((= number 1) (car assums))
	     (t (let ((index
		       (read-indices-from-minibuffer
			(concat "0-based index of antecedent formula -- ("
				(mapconcat '(lambda (x) x) assums " ")
				"): ")
			nil nil t)))
		  (if (not (memq index assums))
		      (error "Index must be one of %s." assums))
		  index)))))))


(defun force-substitution-at-occurrences-retrieval-protocol ();;(target-str replacement-str occurrence)
  "Force REPLACEMENT-STR to replace TARGET-STR at the OCCURRENCE'th occurrence."
  (let ((target-str
	 (imps-read-from-minibuffer "Expression to replace: " nil inferior-tea-minibuffer-map nil))
	(replacement-str
	 (imps-read-from-minibuffer "Replace it with: " nil inferior-tea-minibuffer-map nil))
	(occurrences
	 (read-from-minibuffer "0-based indices of occurrences to change: " "()" nil t)))
    (format "(list %s %s '%s)"
	    (imps-input-quote-string-if-needed target-str)
	    (imps-input-quote-string-if-needed replacement-str)
	    occurrences)))

;;;(defun simplify-antecedent-retrieval-protocol ()
;;;  (format "(list '%s)"  
;;;	  (read-from-minibuffer "0-based index of antecedent-formula: " nil nil t)))

(defun simplify-antecedent-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (format
     "(list (nth (sequent-node-assumptions (sequent-unhash-in-graph-by-number %d %d)) %d))"
     sqn-no
     dg-no
     (read-indices-from-minibuffer "0-based index of antecedent-formula: " nil nil t))))

(defun induction-arguments-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))

    (let ((possible-inductors 
	   (get-literal-from-tea
	    (format "(determine-applicable-inductors
			     (sequent-unhash-in-graph-by-number %d %d))"
		    sqn-no
		    dg-no))))
      (if (null possible-inductors) (error "No inductors applicable!"))
      (let ((inductor
	     (if (= (length possible-inductors) 1)
		 (car (car possible-inductors))
	       (completing-read-or-get-from-x-menu "Inductor: " possible-inductors nil nil nil))))
	(format
	 "(list '%s '(%s))"
	 inductor
	 (request-induction-variable (cdr (assoc inductor possible-inductors))))))))

;;;(defun induction-arguments-retrieval-protocol ()
;;;  (let ((inductor (imps-completing-read "Inductor: " imps-inductors (function (lambda (s) t)) nil nil)))
;;;    (format "(list (name->inductor '%s) '(%s))" inductor (request-induction-variable))))

(defun instantiate-transported-theorem-retrieval-protocol ()
  "Add to the context of SQN the instance of the translation of THM-NAME under 
   TRANSLATION-NAME in which the universally quantified variables are replaced by 
   TERM-STRINGS. "
  (let ((theorem-name (imps-completing-read "Theorem name: "
					    imps-obarray
					    'kind-is-theorem-p
					    nil
					    nil))
	(translation-name
	 (imps-completing-read "Theory interpretation (<RET> to let IMPS find one): "
			       imps-obarray
			       'kind-is-translation-p
			       nil
			       nil)))
    (let ((var-sorts (imps-get-theorem-var-sorts theorem-name)))
      (if (string= "" translation-name)
	  (format "(list '%s '() '(%s))"
		  theorem-name
		  (collect-a-bunch-of-variable-instantiations var-sorts))
	(format "(list '%s '%s '(%s))" 
		theorem-name 
		translation-name
		(collect-a-bunch-of-variable-instantiations var-sorts))))))
	       
;;;(defun instantiate-auto-transported-theorem-retrieval-protocol ()
;;;  "Add to the context of SQN the instance of the translation of THM-NAME under 
;;;   a suitable translation in which the universally quantified variables are replaced by 
;;;   TERM-STRINGS. "
;;;  (let ((theory (imps-completing-read "Source theory: "
;;;				 imps-obarray
;;;				 'kind-is-theory-p
;;;				 nil
;;;				 nil)))
;;;    (let ((theorem-name (imps-completing-read "Theorem name: "
;;;					 imps-obarray
;;;					 'kind-is-theorem-p
;;;					 nil
;;;					 nil)))
;;;      (let ((var-sorts (imps-get-theorem-var-sorts theorem-name)))
;;;	(format "(list '%s '(%s))"  
;;;		theorem-name
;;;		(collect-a-bunch-of-variable-instantiations (cdr available)))))))

;;;(defun symbol-retrieval-protocol ()
;;;  (format "(list '%s)" 
;;;	  (imps-read-from-minibuffer "Constant name: " "" nil t)))

(defun symbol-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((constants (get-literal-from-tea
		      (format "(defined-constants-in-assertion 
			      (sequent-unhash-in-graph-by-number %d %d))"
			      sqn-no
			      dg-no))))
      (if (null constants)
	  (error "No defined constants in expression.")
	(let ((constant
	       (if (= (length constants) 1)
		   (car (car constants))
		 (completing-read-or-get-from-x-menu 
		  "Constant name: " constants nil nil nil))))
	  (format "(list '%s)" constant))))))

(defun disable-quasi-constructor-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((qcs (get-literal-from-tea
		      (format "(quasi-constructors-in-sequent
			      (sequent-unhash-in-graph-by-number %d %d))"
			      sqn-no
			      dg-no))))
      (if (null qcs)
	  (error "No quasi-constructors in sequent.")
	(format "(list '%s)" 
	      (completing-read-or-get-from-x-menu 
	       "Quasi-constructor name: " qcs nil nil nil))))))

(defun enable-quasi-constructor-retrieval-protocol ()
  (let ((dg-no dg-number)
	(sqn-no (current-sqn-no)))
    (let ((qcs (get-literal-from-tea
		(format "(disabled-quasi-constructors
		      (sequent-unhash-in-graph-by-number %d %d))"
			sqn-no
			dg-no))))
      (if (null qcs)
	  (error "No disabled quasi-constructors.")
	(format "(list '%s)" 
		(completing-read-or-get-from-x-menu 
		 "Quasi-constructor name: " qcs nil nil nil))))))

(defun fixpoint-induction-rp ()
  (let* ((pred-symbol (imps-read-from-minibuffer "Recursive predicate name: " "" nil t))
	 (term-string
	  (imps-read-from-minibuffer
	   "Predicate of induction (<RET> to use IMPS default): " nil nil nil)))
    (if (string= "" term-string)   
	(format "(list '%s '())" pred-symbol)
      (format "(list '%s \"%s\")" pred-symbol term-string))))

(defun single-equation-retrieval-protocol ()
  (format "(list \"%s\")" (imps-read-from-minibuffer "Equality: " "" nil nil)))

(defun single-equation-or-inequality-retrieval-protocol ()
  (format "(list \"%s\")" (imps-read-from-minibuffer "Inequality or equality: " "" nil nil)))

(defun persistence-request-retrieval-protocol ()
  (format "(list %d)" 
	  (read-from-minibuffer "Backchaining persistence: " "3" nil t)))

(defun definition-names-retrieval-protocol ()
   (format "(list '(%s))" (imps-read-from-minibuffer "Definition names to use: "  nil nil nil)))

(defun sequent-edit-and-post-retrieval-protocol ()
  "Put current sqn into a buffer to edit.    "
  (interactive)
  (sqn-edit-sqn current-prefix-arg)
  (throw 'apply-command-tag nil))

;;;Argument transmission protocols (from EMACS to TEA)
 
(defun default-argument-transmission-protocol (command dg-no sqn-nos aux-args)
  (tea-eval-and-update-sqn-and-dg
     (format
      "(deduction-graph-apply-command-interface
        %d
       '%s
	'%s
	%s
        '())"
      dg-no command sqn-nos aux-args)))

;;;(defun dg-apply-command-at-current-sequent (command)
;;;  (dg-apply-command command (read (format "(%d)" (current-sqn-no)))))

(defun dg-update-sqn-and-dg (verbose)
  "Update the sqn and dg buffers by getting accurate info from IMPS."
  (interactive "P")
  (tea-eval-expression
   (format "(block (emacs-add-all-new-sqns (dgrv-index->dg %d))
		   (emacs-%supdate-dg (dgrv-index->dg %d)))"
	   dg-number (if verbose "verbose-" "") dg-number)))  

(fset 'update-sqn-and-dg 'dg-update-sqn-and-dg)

(defun tea-eval-and-update-sqn-and-dg (str)
  (message "Calling Tea...")
  (tea-eval-expression
   (format "(execute-call-from-emacs-and-update %d '%s)"
	   dg-number str)))

;;;(defun disable-quasi-constructors (qcs)
;;;  (interactive (list (read-from-minibuffer "Quasi-constructors to disable: "
;;;					   "()"
;;;			       nil t)))
;;;  (tea-eval-expression (format "(disable-qcs '%s)" qcs )))
;;;  
;;;(defun enable-quasi-constructors (qcs)
;;;  (interactive (list (read-from-minibuffer "Quasi-constructors to enable: "
;;;					   "()"
;;;			       nil t)))
;;;  (tea-eval-expression (format "(enable-qcs '%s)" qcs )))


(autoload 'imps-post "imps-edit"
	  "Send contents of buffer to IMPS process to post in deduction-graph"
	  t)

(autoload 'sequent-edit-mode "imps-edit"
	  "Major mode for editing sequent nodes for IMPS deduction graphs."
	  t)

(defun sqn-edit-sqn (fully-parenthesize)
  "Put current sqn into a buffer to edit.  Flag FULLY-PARENTHESIZE (prefix arg
if interactive) means put in all parentheses.  "
  (interactive "P")
  (if (and (not (eq major-mode 'sqn-mode))
	   (not (eq major-mode 'dg-mode)))
      (error "Not in sqn-mode"))
  (let ((the-dg-number dg-number)
	(the-hash-no (sqn-current-hash-no dg-number)))
    (setq imps-edit-window-configuration (current-window-configuration))
    (pop-to-buffer (get-buffer-create "*IMPS Sequent*"))
    (tea-eval-expression
     (format
      "(bind (((emacs-dg) (dgrv-index->dg %d)))
	  (emacs-send-sqn-to-edit %d (sequent-unhash %d) %s))"
      the-dg-number
      the-dg-number
      the-hash-no
      (if fully-parenthesize "'#t" "'#f")))))

(defun dg-edit-sqn (hash fully-parenthesize)
  "Put sequent node with hash-number HASH into a buffer to edit"
  (interactive  
   (list (dg-current-hash-no)
	 current-prefix-arg))
  (if (not (eq major-mode 'dg-mode))
      (error "Not in dg-mode"))
  (let ((the-dg-number dg-number))
    (setq imps-edit-window-configuration (current-window-configuration))
    (pop-to-buffer (get-buffer-create "*IMPS Sequent*"))
    (tea-eval-expression
     (format
      "(bind (((emacs-dg) (dgrv-index->dg %d)))
	  (emacs-send-sqn-to-edit %d (sequent-unhash %d) %s))"
      the-dg-number
      the-dg-number
      hash
      (if fully-parenthesize "'#t" "'#f")))))

(defun imps-start-deduction (arg)
  "Start an IMPS deduction, using sequent and deduction graph buffers numbered ARG 
 (normally 1)."     
  (interactive "p")
  ;;   (list current-prefix-arg
  ;;		     (imps-read-from-minibuffer "Formula: " nil
  ;;					   inferior-tea-minibuffer-map))
   
  (if (>= arg dgr-vector-length)
      (setq arg (dgrv-next-unused)))
  (let ((formula

	 ;;Allow grabbing of expressions with mouse (if desired!)

	 (let ((x-process-mouse-hook (if (and (or (featurep 'imps-x-support)
						  (featurep 'imps-lucid-support))
					      (boundp 'expression-grabber-mouse-hook))
					 expression-grabber-mouse-hook
				       nil)))

	   (imps-read-from-minibuffer "Formula or reference number: " nil
				      inferior-tea-minibuffer-map))))


    
    (pop-to-buffer (get-buffer-create (format "*Sequent-nodes-%d*" arg)))
    (let* ((ref-by-number-p
	    (and (not (string-match "^[ ]*#" formula))
		 (numberp (car (read-from-string formula))))))
      (tea-eval-expression
       (format "%s (start-emacs-deduction %s %d)"
	       (if (= arg 1) "(clear-em)" "")
	       (if (not ref-by-number-p)
		   (imps-input-quote-string-if-needed formula)
		 
		 ;;Remark: If "formula" is a string, tea will wrap a (qr ..) around it before
		 ;;evaluating it. Otherwise tea will evaluate it directly.

		 (concat "(imps-ref " formula ")"))
	       arg)))))

(defun imps-new-start-deduction ()
  "Start a new IMPS deduction, using the first unused deduction graph index, 
if any.  Otherwise blows away last deduction graph."  
  (interactive)
  (imps-start-deduction 15))

;;; (defun imps-step-through-proof-script (file)
;;;   (interactive "fFile: ")
;;;   (tea-eval-expression (format "(step-through-proof-script \"%s\")" file)))

(defvar imps-proof-directory "~/imps/"
  "Default directory to write an IMPS proof history.")

(defun imps-save-history (file)
  (interactive
   (list
    (expand-file-name
     (read-file-name
      "Proof file: "
      imps-proof-directory
      "tmp-proof.t"))))
  (setq imps-proof-directory (file-name-directory file))
  (tea-eval-expression
   (format
    "(deduction-graph-save-history %s \"%s\")"
    (format "(dgrv-index->dg %d)" dg-number)
    (expand-file-name
     (substitute-in-file-name
      file)))))

(defun imps-compress (file)
  (shell-command (concat "compress -f " file)))

  ;;(call-process "compress" nil 0 nil "-f" file)

(defun assume-transported-theorem-retrieval-protocol ()
  "Add to the context of SQN the translation of THM-NAME under TRANSLATION-NAME."
  (let ((theorem-name (imps-completing-read "Theorem name: "
					    imps-obarray
					    'kind-is-theorem-p
					    nil
					    nil))
	(translation-name
	 (imps-completing-read "Theory interpretation: "
			       imps-obarray
			       'kind-is-translation-p
			       nil
			       nil)))
    (let ((var-sorts (imps-get-theorem-var-sorts theorem-name)))
      (format "(list '%s '%s)" theorem-name translation-name))))



;; (defun imps-help ()
;;   (interactive)
;;   (let ((buffer (get-buffer-create "*IMPS Help*")))
;;     (set-buffer buffer)
;;     (insert
;;      (mapconcat
;;       (function (lambda (x) (format " %s\ " x)))
;;       (let ((theory (dgrv-fn-at 'dgr-theory-name dg-number)))
;; 	(append
;; 	 (cons " \n  MACETES: Press key m \n"
;; 	       (mapcar 'car (imps-theory-macetes theory)))
;; 	 (cons "\n  COMMANDS: Press key S \n"
;; 	       (mapcar 'car imps-commands))))
;;       " \n "))
;;     (pop-to-buffer buffer)
;;     (goto-char (point-min))))

(defconst usage-names '(("macete")
			("transportable-macete")
			("rewrite")
			("d-r-value")
			("processor")
			("recursive-unfolding")
			("d-r-convergence"))
  "list of names of usages")

(defun retrieve-usage-list ()
  (let (usages new-string)
    (setq new-string
	  (imps-completing-read "First usage: "
			   usage-names 'always nil nil))
    (while (not (string= "" new-string))
      (setq usages (cons new-string usages))
      (setq new-string
	    (imps-completing-read "Next usage (<RET> if done): "
			     usage-names 'always nil nil)))
    (mapconcat
     (function
      (lambda (x) (format "%s" x)))
     (nreverse usages)
     "\n")))

(defun dg-install-theorem (sqn-no thm-name usage-list)
  "Install sequent SQN-NO as a theorem with name THM-NAME and usage USAGE-LIST.
The theorem is the universal closure of the implication whose consequent is the
assertion of the sequent and whose antecedent is the conjunction of the
sequent's assumptions."
  (interactive
   (list (current-sqn-no)
	 (imps-read-from-minibuffer "Theorem name: " nil inferior-tea-minibuffer-map nil)
	 (retrieve-usage-list)))
  (tea-eval-expression
   (format
    "(dg-emacs-install-theorem %d %d '%s '(%s))"
    dg-number sqn-no thm-name usage-list)))
    
(defun sqn-display-dg-chunk (sqn-no)
  (interactive (list (sqn-current-hash-no dg-number)))
  (switch-to-buffer-other-window (dg-buffer))
  (goto-char (point-min))
  (word-search-forward (format "%s" sqn-no)))

(defun eliminate-defined-iota-expression-retrieval-protocol ()
  (let ((iota-expr-index 
	 (read-from-minibuffer 
	  "0-based index of iota expression occurrence: " "0" nil t))
	(new-variable-name
	 (imps-read-from-minibuffer 
	  "Name of replacement variable: " nil inferior-tea-minibuffer-map nil)))
    (format "(list '%s '%s)" iota-expr-index new-variable-name)))

(defun eliminate-iota-retrieval-protocol ()
  (let ((iota-expr-index 
	 (read-from-minibuffer 
	  "0-based index of iota expression occurrence: " "0" nil t)))
    (format "(list '%s)" iota-expr-index)))

(defvar imps-input-history '()
  "List of previously submitted IMPS inputs.")

(defconst imps-input-history-max 32
  "Maximum length of imps-input-history ring before oldest elements are thrown away.")

(defvar imps-input-history-offset 0
  "Offset of current entry within imps-input-history")


(defun imps-get-input ()
  (nth imps-input-history-offset imps-input-history))

(defun imps-push-input (str)
  (setq imps-input-history (cons str imps-input-history))
  (if (> (length imps-input-history) imps-input-history-max)
      (setcdr (nthcdr (1- imps-input-history-max) imps-input-history) nil)))

(defun imps-increment-history-offset ()
  (if (< (1+ imps-input-history-offset)
	 (length imps-input-history))
      (setq imps-input-history-offset (1+ imps-input-history-offset))))

(defun imps-decrement-history-offset ()
  (if (< 0 imps-input-history-offset)
      (setq imps-input-history-offset (1- imps-input-history-offset))))

(defun imps-reset-history-offset ()
  (setq imps-input-history-offset 0))

(defun imps-mb-insert-previous-input ()
  (interactive)
  (erase-buffer)
  (insert (imps-get-input))
  (imps-increment-history-offset))
  
(defun imps-mb-insert-next-input ()
  (interactive)
  (erase-buffer)
  (insert (imps-get-input))
  (imps-decrement-history-offset))
  
(defun imps-mb-return ()
  (interactive)
  (imps-reset-history-offset)
  (let ((str (buffer-string)))
    (or (string= str "")
	(imps-push-input str)))
  (exit-minibuffer))

(defun imps-read-from-minibuffer (prompt &optional initial-input keymap read)
  (let ((keymap (or keymap imps-minibuffer-map)))
    (read-from-minibuffer prompt initial-input keymap read)))

(defun abort-resetting-history-offset ()
  "Command to abort recursive-edit, resetting IMPS history offset."
  (interactive)
  (imps-reset-history-offset)
  (abort-recursive-edit))

(defun uncompress-file-if-necessary (from-file)
  (if (not (file-exists-p from-file))
      (error "No such file %s" from-file))
  (if (string-match "\\.Z$" from-file) 
      (let ((to-file (substring from-file 0 -2)))
	(call-process "uncompress" nil nil nil from-file)
	to-file)
    from-file))

(defun compress-file (file)
  (shell-command (format "compress -f %s" file)))


(defun imps-run-proof (from-file)
  "Run a proof uncompressing proof file if necessary."
  (interactive
   (list
    (expand-file-name
     (read-file-name "Proof file: " default-directory "" t))))
  (let ((compressed-p (string-match "\\.Z$" from-file))
	(from-file (uncompress-file-if-necessary from-file)))
    (tea-eval-expression (apply 'concat
				(append (list "(unwind-protect (load \"" from-file "\" )")
					(if compressed-p
					    (list "(system-please-compress \"" from-file "\" )") 


					  (list "'#t"))
					(list ")"))))))

(defconst *max-menu-size* 40)

(defun completing-read-or-get-from-x-menu (prompt table predicate require-match initial-input)
  (if (and (featurep 'imps-x-support)
	   (boundp 'imps-mouse-call-p)
	   imps-mouse-call-p
	   (listp table)
	   (<= (length table) *max-menu-size*))
      (let ((string (imps-popup-menu
		     '(0 0)
		     (list "Menu"
			   (cons (replace-chars-in-string prompt 58 32)
				 (mapcar
				  '(lambda (x)
				     (cons x x))
				  (mapcar 'car table)))))))
	(if string string (error "Command aborted.")))
    (completing-read prompt table predicate require-match initial-input)))


(defun read-indices-from-minibuffer (prompt initial keymap read)
  (let ((x-process-mouse-hook (if (and (or (featurep 'imps-x-support)
					   (featurep 'imps-lucid-support))
				       (boundp 'assumption-number-mouse-hook))
				  assumption-number-mouse-hook
				nil)))
    (let ((current-sequent-buffer (current-buffer)))
      (read-from-minibuffer prompt initial keymap read))))


(defun imps-display-entries (&optional sqn-no)
  (interactive)
  (let ((config (current-window-configuration))
	(buffer (get-buffer-create "*Context-Entries*"))
	(num (if sqn-no sqn-no
	       (car (read-from-string (format "%d" (current-sqn-no)))))))
    (let ((entries
	   (get-literal-from-tea
	    (format "(with-output-to-string p
                 (context-walk-entries
                    (lambda (s) (format p \"~A~%%~%%\" (qp s)))
                    (sequent-node-context (sequent-unhash-in-graph %d (dgrv-index->dg %d)))))"
	     num dg-number))))
      (set-buffer buffer)
      (setq buffer-read-only nil)
      (pop-to-buffer buffer)
      (erase-buffer)
      (goto-char (point-min))
      (insert entries)
      (setq buffer-read-only t))))

(defun annotate-protocol ()
  (let ((keyword
	 (completing-read-or-get-from-x-menu
	  "Keyword: " '(("begin-block")("end-block")) nil nil "begin-block")))
    (format "(list '%s)" keyword)))


(defun imps-comment-latest-entry ()
  (tea-eval-expression
   (format
    "(set (dg-history-entry-comments 
              (car (deduction-graph-history (dgrv-index->dg %d)))) (list \"%s\"))"
    dg-number
    (read-from-minibuffer "Comment: "))))
