;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(defun buffer-preferred-frame (buffer)
  "Return either a frame or nil: the preferred frame to display it if any.
May create a new frame if needed."
  (or (name-preferred-frame (buffer-name buffer))
      (and (buffer-file-name buffer)
	   (name-preferred-frame (buffer-file-name buffer)))
      (mode-preferred-frame
       (progn
	 (set-buffer buffer)
	 major-mode))))

(defvar name-preferred-frame-alist nil    
  "Alist of patterns and frames; for frames not yet created, a parameter-list instead.")

(defun name-preferred-frame (name)
  (let (done
	(alist name-preferred-frame-alist))
    (while (and (not done) alist)
      (if (and (string-match (car (car alist)) name)
	       (cdr (car alist)))
	  (setq done t)
	(setq alist (cdr alist))))
    (and
     alist 
     (let ((frame (cdr (car alist))))
       (cond ((frame-live-p frame) frame)
	     ((consp frame)
	      ;; should be parameter alist for make-frame
	      (let ((frame (make-frame frame)))
		(setcdr (car alist) frame)
		frame))
	     ((and (stringp frame)
		   (let ((f  (get-frame-from-pattern frame)))
		     (if f (progn (setcdr (car alist) f)
				  f)
		       nil))))
	     ((eq frame 'default)
	      ;; use default 
	      (let ((frame (make-frame)))
		(setcdr (car alist) frame)
		frame))
	     (t nil))))))

(defun mode-preferred-frame (mode)
  (let ((f (get mode 'preferred-frame)))
    (cond ((frame-live-p f) f)
	  ((consp f)
	   ;; should be parameter alist for make-frame
	   (let ((new-f (make-frame f)))
	     (put mode 'preferred-frame new-f)
	     new-f))
	  ((and (stringp f)
		(let ((f  (get-frame-from-pattern f)))
		  (if f (progn (put mode 'preferred-frame f)
			       f)
		    nil))))
	  ((or (eq f 'default)
	       (and (framep f)
		    (not (frame-live-p f))))
	   (let ((new-f (make-frame)))
	     (put mode 'preferred-frame new-f)
	     new-f))
	  (t nil))))

(defun put-mode-preferred-frame-parameters (mode param-alist)
  "Set preferred frame parameters for MODE to PARAM-ALIST unless frame already in use."
  (or (frame-live-p (get mode 'preferred-frame))
      (put mode 'preferred-frame param-alist)))
  

(or (fboundp 'pop-to-buffer-orig)
    (fset 'pop-to-buffer-orig (symbol-function 'pop-to-buffer)))
(or (fboundp 'switch-to-buffer-orig)
    (fset 'switch-to-buffer-orig (symbol-function 'switch-to-buffer)))

;; (fset 'pop-to-buffer (symbol-function 'pop-to-buffer-orig))
;; (fset 'switch-to-buffer (symbol-function 'switch-to-buffer-orig)) 




(defun display-buffer-in-preferred-frame (buffer)
  (let ((window (selected-window))
	(frame (selected-frame)))
    (pop-to-buffer buffer nil)
    (select-frame frame)
    (select-window window)))

;; (defun display-buffer-in-preferred-frame (buffer)
;;   (save-window-excursion (pop-to-buffer buffer nil)))


(or temp-buffer-show-function
    (setq temp-buffer-show-function 'display-buffer-in-preferred-frame))


(defun pop-to-buffer (buffer-or-name &optional other-window)
  "Select buffer BUFFER in some window, preferably on its preferred frame.
If BUFFER is nil, then some other buffer is chosen.
If `pop-up-windows' is non-nil, windows can be split to do this.
If optional second arg OTHER-WINDOW is non-nil, insist on finding another
window even if BUFFER is already visible in the selected window."
  (let* ((buffer (get-buffer buffer-or-name))
	 (preferred-frame
	  (and (bufferp buffer)
	       (buffer-preferred-frame buffer))))
    (if (frame-live-p preferred-frame)
	(progn
	  (select-frame preferred-frame)
	  (make-frame-visible)
	  (set-mouse-position (selected-frame) 0 0)
	  (unfocus-frame)
	  (switch-to-buffer-orig buffer))
      (pop-to-buffer-orig buffer-or-name other-window))))

(defun switch-to-buffer (buffer &optional norecord)
  "Select buffer BUFFER in its preferred frame, or in the current window.
BUFFER may be a buffer or a buffer name.
Optional second arg NORECORD non-nil means
do not put this buffer at the front of the list of recently selected ones.

WARNING: This is NOT the way to work on another buffer temporarily
within a Lisp program!  Use `set-buffer' instead.  That avoids messing with
the window-buffer correspondences."
  (interactive "BSwitch to buffer: \nP")
  (let* ((buffer (get-buffer-create buffer))
	 (preferred-frame
	  (and (bufferp buffer)
	       (buffer-preferred-frame buffer))))
    (if (frame-live-p preferred-frame)
	(progn
	  (select-frame preferred-frame)
	  (make-frame-visible)
	  (set-mouse-position (selected-frame) 0 0)
	  (unfocus-frame)
	  (switch-to-buffer-orig buffer norecord))
      (switch-to-buffer-orig buffer norecord))))

(defun frame-name (frame)
  (cdr (assq 'name (frame-parameters frame))))

(defun get-frame-from-pattern (frame-or-pattern)
  (if (frame-live-p frame-or-pattern)
      frame-or-pattern
    (let ((val nil)
	  (frames (frame-list)))
      (while (and (not val) frames)
	(if (and (string-match frame-or-pattern (frame-name (car frames)))
		 (frame-live-p (car frames)))
	    (setq val (car frames))
	  (setq frames (cdr frames))))
      val)))

;;;These two functions have to be redefined to get the frame stuff right:

(defun imps-assistant-execute-line ()
  "Execute a single form of a proof script in last visited scheme-mode buffer.
Cursor must be on the first line of the proof command form to be executed.
Cursor will automatically move to next command."
  (interactive)
  (select-frame (or (mode-preferred-frame 'scheme-mode)
		    (selected-frame)))
  (set-buffer (or (mode-last-visited-buffer 'scheme-mode)
		  (current-buffer)))
  (let* ((beg (progn (beginning-of-line) (point)))
	     (end (progn (forward-sexp) (point)))) ;;used to be  (end-of-line)
	(tea-eval-large-expression-and-update-sqn-and-dg
	 (format
	  "(execute-command-sequence (sequent-unhash-in-graph-by-number %d %d) '(%s))"
	  (current-sqn-no) dg-number (buffer-substring beg end)))
	(forward-line 1)))



(defun imps-assistant-execute-region ()
  "Execute all forms of a proof script in the last visited scheme-mode buffer
within that buffer's region. Cursor must be on the first line of the proof 
command form to be executed. Cursor will automatically move to the end of
the region."
  (interactive)
  (select-frame (or (mode-preferred-frame 'scheme-mode)
		    (selected-frame)))
  (set-buffer (or (mode-last-visited-buffer 'scheme-mode)
		  (current-buffer)))

  (let ((beg (region-beginning))
	(end (region-end)))
    (tea-eval-large-expression-and-update-sqn-and-dg
     (format "(execute-command-sequence (sequent-unhash-in-graph-by-number %d %d) '(%s))"
	     (current-sqn-no) dg-number (buffer-substring-if-balanced-defun beg end)))))

'(add-hook 'pre-command-hook
	  '(lambda () (raise-frame (get-frame-from-pattern "IMPS Minibuffer"))))

(provide 'frames)




