;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

;(defconst emacs-panes
;  '(("Edit"
;     ("Buffers" mouse-menu-bar-buffers)
;     ("Save Buffer"  save-buffer)
;     ("Open Directory..."  dired)
;     ("Open File..."  find-file)
;     ("Clear"  delete-region)
;     ("Choose Next Paste" mouse-menu-choose-yank)
;     ("Paste"  yank)
;     ("Copy"  kill-ring-save)
;     ("Cut"  kill-region)
;     ("Undo"  undo))))

(defun mouse-menu-bar-buffers (event)
  "Pop up a menu of buffers for selection with the mouse.
This switches buffers in the window that you clicked on,
and selects that window."
  (interactive "e")
  (let ((buffers (cdr (buffer-list)))
	;; I put in cdr, because it doesn't make seem to make much sense
	;; to select the buffer you are currently visiting.
	menu)
    ;; If requested, list only the N most recently selected buffers.
    (if (and (integerp buffers-menu-max-size)
	     (> buffers-menu-max-size 1))
	(if (> (length buffers) buffers-menu-max-size)
	    (setcdr (nthcdr buffers-menu-max-size buffers) nil)))
    (setq menu
	  (cons "Select Buffer"
		(let ((tail buffers)
		      (maxlen 0)
		      head)
		  
		  (setq tail buffers)
		  (while tail
		    (let ((elt (car tail)))
		      (if (not (string-match "^ "
					     (buffer-name elt)))
			  (setq head (cons
				      (cons
				       (format
					"%s"
					(buffer-name elt)
					)
				       elt)
				      head))))
		    (setq tail (cdr tail)))
		  (nconc (nreverse head)
			 '(("List All Buffers" . list-buffers))))))
    (setq menu (list menu))

    (setq menu (cons "Buffer Menu" menu))

    (let ((buf (x-popup-menu (if (listp event) event
			       (cons '(0 0) (selected-frame)))
			     menu))
	  (window (and (listp event) (posn-window (event-start event)))))
      (cond ((eq buf 'list-buffers)
	     (list-buffers))
	    (buf
	     (if complex-buffers-menu-p
		 (let ((action (x-popup-menu
				(if (listp event) event
				  (cons '(0 0) (selected-frame)))
				'("Buffer Action"
				  (""
				   ("Save Buffer" . save-buffer)
				   ("Kill Buffer" . kill-buffer)
				   ("Select Buffer" . switch-to-buffer))))))
		   (if (eq action 'save-buffer)
		       (save-excursion
			 (set-buffer buf)
			 (save-buffer))
		     (funcall action buf)))
	       (and (windowp window)
		    (select-window window))
	       (switch-to-buffer buf)))))))

(global-set-key [menu-bar edit emacs-top-level] '("Top Level" . top-level))

;;(global-set-key [menu-bar imps] '("Explain command" . explain-command))

(fset 'explain-command 'describe-key)

;(defun explain-command ()
;"This command provides documentation for any menu item."
;    (interactive)
;    (message "Choose menubar item.")
;    (let ((pre-command-hook 
;	   '(lambda () 
;	      (with-output-to-temp-buffer "*Help*"
;		(if (symbolp this-command)
;		    (progn (prin1 this-command)
;			   (princ ": ")
;			   (terpri)
;			   (terpri)))
;		(if (documentation this-command)
;		    (princ (documentation this-command))
;		  (princ "not documented")
;		  ))

;	      (throw 'exit nil))))
;      (recursive-edit)))

;(defun explain-command (key)
;  "Display documentation of the function invoked by KEY.  KEY is a string."
;  (interactive "kClick and choose menubar item: ")
;  ;; If this key seq ends with a down event, discard the
;  ;; following click or drag event.  Otherwise that would
;  ;; erase the message.
;  (let ((type (aref key (1- (length key)))))
;    (if (listp type) (setq type (car type)))
;    (and (symbolp type)
;	 (memq 'down (event-modifiers type))
;	 (read-event)))
;  (let ((defn (key-binding key)))
;    (if (or (null defn) (integerp defn))
;        (message "%s is undefined" (key-description key))
;      (with-output-to-temp-buffer "*Help*"
;	(prin1 (key-description key))
;	(princ " runs the interface command ")
;	(princ defn)
;	(princ ":\n\n")
;	(if (documentation defn)
;	    (princ (documentation defn))
;	  (princ "not documented"))
;	(print-help-return-message)))))

(provide 'idiotize-fsf-menubar)
