;; Copyright (c) 1990-1994 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(provide 'theory-information)
(defun make-obarray ()
  (make-vector 511 0))

(defconst imps-obarray (make-obarray))

(defconst imps-tags-file
  (expand-file-name
   (substitute-in-file-name
    "$IMPS/theories/TAGS")))
(defconst imps-user-tags-file
  (expand-file-name
   (substitute-in-file-name
    "~/theories/TAGS")))
(defconst tmp-tags-file
  (expand-file-name
   (substitute-in-file-name
    (format "/tmp/%s-theories/TAGS" (user-login-name)))))

(defun imps-intern-from-tags ()
  (interactive)
  (imps-intern-from-tags-1 imps-tags-file)
  (imps-intern-from-tags-1 imps-user-tags-file))

(defun imps-intern-from-tmp-tags ()
  (interactive)
  (imps-intern-from-tags-1 tmp-tags-file)) 

(defun imps-intern-from-tags-1 (filename)
  (and
   (file-readable-p filename)
   (let ((tags-buff (find-file-noselect filename)))
     (set-buffer tags-buff)
     (setq buffer-read-only t)
     (goto-char (point-min))
     (while (<
	     (progn (forward-page 1) (point))
	     (point-max))
       (narrow-to-page)
       (imps-intern-from-page)
       (widen)))))

(defun imps-intern-from-page ()
  (let ((fn (next-symbol-string (point))))
    (let ((dir (file-name-directory fn))
	  (file (file-name-nondirectory fn)))
      (goto-char (point-min))
      (while (search-forward "(def-" (point-max) t)
	(let* ((kind
		(intern
		 (buffer-substring (point)
				   (progn
				     (forward-sexp 1)
				     (point)))))
	       (sym (intern (next-symbol-string (point)) imps-obarray))
	       (line (progn (search-forward "")
			    (car (read-from-string (next-symbol-string (point)))))))
	  (put sym 'kind kind)
	  (put sym 'directory dir)
	  (put sym 'file file)
	  (put sym 'line line))))))
  
(defun imps-find-definition (sym)
  (interactive
   (list
    (intern-soft
     (completing-read  "Name: " imps-obarray 'always t nil)
     imps-obarray)))
  (find-file-other-window
   (expand-file-name
    (substitute-in-file-name
     (format "$THEORIES/%s%s.t"
	     (get sym 'directory)
	     (get sym 'file)))))
  (goto-line (get sym 'line)))

(defun imps-defining-file (theorem)
  (interactive
   (list (intern-soft
	  (completing-read "Theorem name: " imps-obarray
			   'always t nil)
	  imps-obarray)))
  (message "$THEORIES/%s%s.t"
	   (get theorem 'directory)
	   (get theorem 'file)))

(defun imps-loaded-p (thm-name)
  (let ((sym (intern-soft thm-name imps-obarray)))
    (not
     (not
      (get-literal-from-tea
       (format "(and (file-loaded? \"%s\" imps-implementation-env) 1)"
	       (expand-file-name
		(substitute-in-file-name
		 (format "$THEORIES/%s%s.t"
			 (get sym 'directory)
			 (get sym 'file))))))))))

(fset 'imps-theorem-loaded-p 'imps-loaded-p)

(defun imps-require-theorem (thm-name)
  (interactive
   (list
    (completing-read "Theorem name: " imps-obarray 'always t nil)))
  (let ((sym (intern-soft thm-name imps-obarray)))
    (if (y-or-n-p
	 (format "Really require file $THEORIES/%s%s? "
		 (get sym 'directory)
		 (get sym 'file)))
	(tea-eval-expression
	 (format "(*require nil '(theories %s%s) imps-implementation-env)"
		 (get sym 'directory)
		 (get sym 'file)))
      (error "Not requiring file $THEORIES/%s%s."
	     (get sym 'directory)
	     (get sym 'file)))))

(defun imps-get-theorem-var-sorts (thm-name)
  (let ((var-sorts
	 (get-literal-from-tea
	  (format
	   "(theorem-name->var-sort-list '%s)"
	   thm-name))))
    (put (intern thm-name imps-obarray)
	 'var-sorts
	 var-sorts)))

(defun kind-is-theorem-p (sym)
  (eq 'theorem (get sym 'kind)))

(defun kind-is-macete-p (sym)
  (let ((kind (get sym 'kind)))
    (or (eq 'theorem (get sym 'kind))
	(eq 'compound-macete kind)
	(eq 'schematic-macete kind))))

(defun kind-is-inductor-p (sym)
  (eq 'inductor (get sym 'kind)))
 
(defun complete-macete-name (str)
  (if (and (<= 3 (length str))
	   (string= "tr%" (substring str 0 3)))
      (let ((completion (try-completion (substring str 3) imps-obarray)))
	(if (stringp completion)
	    (concat "tr%" completion)
	  completion))
    (try-completion str imps-obarray 'kind-is-macete-p)))
	  
(defun all-macete-completions (str)
  (append
   (mapcar '(lambda (str2)
	      (concat "tr%" str2))
	   (and (<= 3 (length str))
		(string= "tr%" (substring str 0 3))
		(all-completions (substring str 3) imps-obarray)))
   (all-completions str imps-obarray 'kind-is-macete-p)))

(defun insert-complete-macete-name ()
  (interactive)
  (let ((str (buffer-string)))
    (let ((completion (complete-macete-name str)))
      (cond ((or (eq t completion)
		 (string= completion str))
	     (with-output-to-temp-buffer " *Completions*"
	       (display-completion-list (all-macete-completions str))))
	    ((stringp completion)
	     (erase-buffer)
	     (insert completion))
	    ((null completion)
	     (ding)
	     (message "No match."))))))
	   
(defconst macete-minibuffer-map (copy-keymap minibuffer-local-map))
(define-key macete-minibuffer-map " " 'insert-complete-macete-name)
  
(defun read-macete ()
  (interactive)
  (let ((minibuffer-local-map macete-minibuffer-map))
    (read-minibuffer "Macete name: ")))

(defun imps-intern-from-current-file ()
  (interactive)
  (balance-defuns-and-save nil)
  (call-process (expand-file-name
		 (substitute-in-file-name
		  "$IMPS/../src/current_tags"))
		nil nil nil (buffer-file-name))
  (imps-intern-from-tmp-tags))

(defvar imps-commands nil
  "*The IMPS commands known currently known to emacs, 
presented as a list suitable for completing-read.")
(defconst imps-commands-file
  (expand-file-name
	   (substitute-in-file-name "$IMPS/../tmp/imps-commands")))
(defun imps-read-commands-from-file ()
  (let ((tmp-buff (get-buffer-create " *imps-commands-tmp*")))
    (set-buffer tmp-buff)
    (erase-buffer)
    (if (file-readable-p imps-commands-file)
	(insert-file imps-commands-file)
      (error "IMPS command file unreadable.  Try executing (t-e-write-commands) in IMPS."))
    (goto-char (point-min))
    (setq imps-commands
	  (read (current-buffer)))))

(define-key scheme-mode-map "\C-c." 'imps-find-definition)
(define-key inferior-tea-mode-map "\C-c." 'imps-find-definition)


(message "Interning names from IMPS tags tables...")
(imps-intern-from-tags)
(imps-read-commands-from-file)
(message "Interning names from IMPS tags tables... Done.")
