/* Handles fatal errors and warnings. */

/* $Header: /usr/src/local/imps/src/xdg/RCS/error.c,v 1.1 90/11/02 11:33:00 ramsdell Exp $ */

#include <stdio.h>
#if defined __STDC__
# include <stdarg.h>
#else
# include <varargs.h>
#endif

#if defined __STDC__
void fatal(const char *format, ...)
#else
/*VARARGS0*/
void fatal(va_alist)
     va_dcl
#endif     
{
  va_list ap;

#if defined __STDC__
  va_start(ap, format);
#else
  char *format;
  va_start(ap);
  format = va_arg(ap, char *);
#endif

  fputs("; ", stderr);
  vfprintf(stderr, format, ap);

  va_end(ap);

  exit(1);
}

#if defined __STDC__
void warning(const char *format, ...)
#else
/*VARARGS0*/
void warning(va_alist)
     va_dcl
#endif     
{
  va_list ap;

#if defined __STDC__
  va_start(ap, format);
#else
  char *format;
  va_start(ap);
  format = va_arg(ap, char *);
#endif

  fputs("; ", stderr);
  vfprintf(stderr, format, ap);

  va_end(ap);
}
