/* $Header: /usr/src/local/imps/src/xdg/RCS/store.c,v 1.1 90/11/02 11:33:01 ramsdell Exp $ */

/* 
   A simple storage allocator.  
   Nodes are numbers, strings, and pairs.
   Space must be explicitly released with dispose.
 */

#include <stdio.h>
#if defined __STDC__
# include <stddef.h>
# include <stdlib.h>
#else
void *malloc();
void free();
void exit();
#endif
#include <string.h>
#include "error.h"
#include "store.h"

static void *alloc(size)
     int size;
{
  void *result;
  result = malloc(size);
  if (result == NULL)
    fatal("alloc failed, no free space available.\n");
  return result;
}

data make_number(n)
     int n;
{
  data d = (data) alloc(sizeof(cell));
  data_type(d) = NUMBER;
  data_number(d) = n;
  return d;
}

data make_string(s)
#if defined __STDC__
     const
#endif
     char *s;
{
  data d = (data) alloc(sizeof(cell));
  data_type(d) = STRING;
  data_string(d) = (char *) alloc(1+strlen(s));
  strcpy(data_string(d), s);
  return d;
}

data make_pair(h, t)
     data h, t;
{
  data d = (data) alloc(sizeof(cell));
  data_type(d) = PAIR;
  data_head(d) = h;
  data_tail(d) = t;
  return d;
}

void dispose(d)
     data d;
{
  if (is_nil(d)) return;
  switch (data_type(d)) {
  case NUMBER:
    free((void *) d);
    return;
  case STRING:
    free((void *) data_string(d));
    free((void *) d);
    return;
  case PAIR:
    dispose(data_head(d));
    dispose(data_tail(d));
    free((void *) d);
    return;
  default:
    fatal("Bad type %d in dispose.\n", data_type(d));
  }
}
