/* $Header: /usr/src/local/imps/src/xdg/RCS/store.h,v 1.1 90/11/02 11:33:04 ramsdell Exp $ */

typedef enum {NUMBER, STRING, PAIR} tag;

typedef struct x {
  tag type;
  union {
    int n;			/* NUMBER */
    char *s;			/* STRING */
    struct {			/* PAIR */
      struct x *h;
      struct x *t;
    } p;
  } u;
} cell, *data;
      
#define NIL ((data) NULL)
#define is_nil(d) ((d) == NIL)
#define is_number(d) ((!is_nil(d)) && (((d)->type ) == NUMBER))
#define is_string(d) ((!is_nil(d)) && (((d)->type ) == STRING))
#define is_pair(d) ((!is_nil(d)) && (((d)->type ) == PAIR ))
#define is_atom(d) (!is_pair(d))

#define data_type(d) ((d)->type)
#define data_number(d) ((d)->u.n)
#define data_string(d) ((d)->u.s)
#define data_head(d) ((d)->u.p.h)
#define data_tail(d) ((d)->u.p.t)

#if defined __STDC__
data make_number(int);
data make_string(const char *);
data make_pair(data, data);
void dispose(data);
#else
data make_number();
data make_string();
data make_pair();
void dispose();
#endif
