;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald (expressions gently))

(define (GENTLY-PUSH-NOT formula)
  (enforce formula? formula)
  (cond ((formal-symbol? formula) (negation formula))
	((expression-quasi-constructor-if-enabled formula)
	 =>
	 (lambda (qc)
	   (negation
	    (apply qc
		  (map
		   gently-flush-not
		   (expression-quasi-components-if-enabled formula))))))
	((atomic-formula? formula)
	 (negation
	  (apply (expression-constructor formula)
		 (map gently-flush-not (expression-components formula)))))
	(else
	 (select (expression-constructor formula)
	   ((the-true) falsehood)
	   ((the-false) truth)
	   ((negation)
	    (gently-flush-not				;CLASSICAL DOUBLE
	     (car (expression-components formula))))	;NEGATION ELIMINATION
	   ((disjunction)
	    (apply conjunction (map gently-push-not (expression-components formula))))
	   ((conjunction)
	    (conjunction-compute-gently-push-not formula))
	   ((implication)
	    (conjunction-simplifier
	     (append
	      (ultimate-conjuncts (list (gently-flush-not (implication-antecedent formula))))
	      (list (gently-push-not (implication-consequent formula))))))
	   ((if-form)
	    (if-form
	     (nth (expression-components formula) 0)	;test unchanged
	     (gently-push-not				;negate consequent
	      (nth (expression-components formula) 1)) 
	     (gently-push-not				;negate alternative
	      (nth (expression-components formula) 2))))
	   ((biconditional)
	    (biconditional (gently-push-not (car (expression-components formula)))
			   (cadr (expression-components formula))))
	   ((forall)
	    (apply forsome
		   (cons (gently-push-not (binding-body formula))
			 (binding-variables formula))))
	   ((forsome)
	    (apply forall
		   (cons (gently-push-not (binding-body formula))
			 (binding-variables formula))))
	   (else
	    (negation formula))))))

(define (CONJUNCTION-COMPUTE-GENTLY-PUSH-NOT formula)
  (imps-enforce conjunction? formula)
  (receive (last all-but)
    (last-&-all-but-last (expression-components formula))
    (if (negation? last)
	(implication
	 (conjunction-simplifier
	  (map gently-flush-not all-but))
	 (gently-push-not last))
	(disjunction-simplifier
	 (map
	  gently-push-not
	  (expression-components formula))))))

; FLUSH-NOT

(define (gently-FLUSH-NOT expr)
  (cond ((formal-symbol? expr) expr)
	((expression-quasi-constructor-if-enabled expr)
	 =>
	 (lambda (qc)
	   (apply
	    qc
	    (map
	     gently-flush-not
	     (expression-quasi-components-if-enabled expr)))))
	(else
	 (let ((constr (expression-constructor expr)))
	   (select constr
	     ((nil) expr)
	     ((negation) (gently-push-not (car (expression-components expr))))
	     ((the-true) truth)
	     ((the-false) falsehood)
	     (else
	      (apply constr (map gently-flush-not (expression-components expr)))))))))
