;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SOME-CONSTRUCTORS)


(define use-old-apply-operator-form?
  (make-simple-switch 'use-old-apply-operator-form? boolean? '#f))


; APPLY-OPERATOR applies an expression of a function or predicator sorting to
; argument lists with matching sortings.  

(define APPLY-OPERATOR
  (let ((constr
	 (make-constructor '#f apply-operator-checker 'apply-operator)))
    
    (if (use-old-apply-operator-form?)
	(set-sexp-builder constr omit-name-sexp-builder))
    constr))

; Additional constructors to build atomic formulas are EQUALITY, IS-DEFINED,
; and the truth-value constructors named the-true and the-false.  The latter
; should not be called directly; rather the atomic formulas TRUTH and FALSEHOOD
; got by applying them to no arguments once and for all should be used.

(define EQUALITY
  (make-constructor '#f equality-component-checker '=))

(define IS-DEFINED
  (make-constructor '#f formula-from-one-comp 'is-defined))

(define IS-DEFINED-IN-SORT
  (let ((constr 
	 (make-constructor binding-binder
			   is-defined-in-sort-component-checker
			   'is-defined-in-sort)) )
    (set-sexp-builder constr is-defined-in-sort-sexp-builder)
    (set-sexp-decoder constr is-defined-in-sort-sexp-decoder)
    constr))

(define (DEFINED-IN term sorting)
  (is-defined-in-sort
   term
   (new-variable sorting
		 *in-sort-preferred-varname*
		 (free-variables term)))) 

(define UNDEFINED-OF-SORT
  (let ((constr 
	 (make-constructor binding-binder
			   undefined-of-sort-component-checker
			   'undefined)) )
    (set-sexp-builder constr undefined-of-sort-sexp-builder)
    (set-sexp-decoder constr undefined-of-sort-sexp-decoder)
    constr))

(define (UNDEFINED sorting)
  (let ((var (find-variable *in-sort-preferred-varname* sorting)))
    (undefined-of-sort var var)))

(define THE-TRUE
  (let ((constr (make-constructor '#f no-formulas  'the-true))
	(decoder (lambda (sexp language alist)
		   (ignore sexp language alist)
		   nil))
	(builder (lambda (expr) (ignore expr) 'truth)))
    (set-sexp-decoder constr decoder)
    (set-sexp-builder constr builder)
    constr))


;; (crawl (the-environment))
    
(define truth (the-true))

(define THE-FALSE
  (let ((constr (make-constructor '#f no-formulas  'the-false))
	(decoder (lambda (sexp language alist)
		   (ignore sexp language alist)
		   nil))
	(builder (lambda (expr) (ignore expr) 'falsehood)))
    (set-sexp-decoder constr decoder)
    (set-sexp-builder constr builder)
    (define falsehood (constr))
    constr))

; The propositional connectives are CONJUNCTION, DISJUNCTION, IMPLICATION,
; BICONDITIONAL, and NEGATION.  CONJUNCTION and DISJUNCTION take any number of
; components.  The others take just two (one, for negation).

(define CONJUNCTION
  (make-constructor '#f only-formulas  'and))

(define DISJUNCTION
  (make-constructor '#f only-formulas  'or))

(define IMPLICATION
  (make-constructor '#f just-two-formulas  'implies))

(define BICONDITIONAL
  (make-constructor '#f just-two-formulas  'iff))

(define NEGATION
  (make-constructor '#f just-one-formula  'not))

; IF (a nonstrict-if) takes three arguments, one formula p and
; two expressions s and t of the same type.  Its result is an expression
; having as value s if p is true, and t otherwise.  The sort of the term
; is the common enclosing sort of the sort of s and the sort of t.

(define IF
  (make-constructor '#f expr-from-formula-and-two-like-exprs  'if))

(define if-term if)
(define if-pred if)
(set (symbol->constructor 'if-term) if)
(set (symbol->constructor 'if-pred) if)


; IF-FORM constructs an if-then-else formula given three formulas.  It has as
; truth value the value of the second or third argument, depending as the first
; arg is true or false.  

(define IF-FORM
  (make-constructor '#f formula-from-three-formulas  'if-form))




;;;IN-SORT is now defunct.  
;;;
;;;(define IN-SORT
;;;   (let ((constr
;;; 	 (make-quasi-constructor in-sort-constr-proc
;;; 				 in-sort-inverse
;;; 				 'in-sort)))
;;;     (set-sexp-builder constr in-sort-sexp-builder)
;;;     (set-sexp-decoder constr is-defined-in-sort-sexp-decoder)
;;;     constr))
;;; 
;;; (define (COERCE-INTO-SORT term sort)
;;;   (in-sort
;;;    term
;;;    (new-variable sort
;;; 		 *in-sort-preferred-varname*
;;; 		 (free-variables term))))

; The quantifiers are forall and forsome.  A printed form like
; (forall (((x y) nn) ((r) qq))
;	   body)
; will correspond to a lisp object formed by applying forall to the arguments
; <body> followed by the three variables <x>, <y>, and <z>.

(define FORALL
  (let ((constr 
	 (make-constructor binding-binder quantifier-component-checker
			   'forall)))
    (set-sexp-builder constr quantifier-sexp-builder)
    (set-sexp-decoder constr quantifier-sexp-decoder)
    constr))

(define for-all forall)

(define FORSOME
  (let ((constr 
	 (make-constructor binding-binder quantifier-component-checker
			   'forsome)))
    (set-sexp-builder constr quantifier-sexp-builder)
    (set-sexp-decoder constr quantifier-sexp-decoder)
    constr))

(define for-some forsome)

; LAMBDA extracts a function or predicator.  It requires a different component
; checker, but uses the same read/print syntax.  

(define LAMBDA
  (let ((constr 
	 (make-constructor binding-binder lambda-component-checker
			   'lambda)))
    (set-sexp-builder constr quantifier-sexp-builder)
    (set-sexp-decoder constr quantifier-sexp-decoder)
    constr))

; Of course LAMBDA doesn't read right through the lisp reader, so we also
; provide the name IMPS-LAMBDA for use when lisp is reading.   

(define IMPS-LAMBDA lambda)

; IOTA uses the same syntax, but of course a single variable is required.  The
; sorting of the resulting expression is the same as that of the variable.  For
; this reason, the variable must not be prop-sorted.  Our goal is that any
; prop-sorted expression should have a well-defined value, and there can be no
; guarantee that an iota expression will do so unless special measures are
; taken.

(define IOTA
  (let ((constr 
	 (make-constructor binding-binder iota-component-checker
			   'iota)))
    (set-sexp-builder constr quantifier-sexp-builder)
    (set-sexp-decoder constr quantifier-sexp-decoder)
    constr))

; IOTA-P corresponds to IOTA, except that it is designed for constructing
; definite descriptions of kind PROP.  Thus, the special measure taken in the
; semantics for IOTA-P is that its value is the falselike object of the
; associated sort if the description is not uniquely satisfied.

; NB.  It thereby follows that every *sort* of kind PROP contains the falselike
; object of the associated *type*.

(define IOTA-P
  (let ((constr 
	 (make-constructor binding-binder iota-p-component-checker
			   'iota-p)))
    (set-sexp-builder constr quantifier-sexp-builder)
    (set-sexp-decoder constr quantifier-sexp-decoder)
    constr))

(define (IOTA-OR-IOTA-P body var)
  (if (expression-of-category-ind? var)
      (iota body var)
      (iota-p body var)))



;;; ; Experimental set constructor.  
;;; 
;;; (define THOSE
;;;   (let ((constr 
;;; 	 (make-constructor binding-binder those-component-checker
;;; 			   'those)))
;;;     (set-sexp-builder constr those-sexp-builder)
;;;     (set-sexp-decoder constr those-sexp-decoder)
;;;     constr))
;;; 

; Hack for reading and printing

(define WITH
  (make-transparent-constructor  'with with-sexp-decoder with-sexp-builder))

; There follow some procedures that are specially connected with one or
; another constructor. 

(define (TRUTH? expression)
  (eq? expression truth))

(define (FALSEHOOD? expression)
  (eq? expression falsehood))

(define (TRUTH-VALUE? expression)
  (or (truth? expression)
      (falsehood? expression)))

(define (IMPLICATION? expression)
  (eq? (expression-constructor expression) implication))

(define (IMPLICATION-ANTECEDENT expression)
  (if (implication? expression)
      (car (expression-components expression))
      (imps-error "IMPLICATION-ANTECEDENT: ~A is not an implication"
		  expression)))

(define (IMPLICATION-CONSEQUENT expression)
  (if (implication? expression)
      (cadr (expression-components expression))
      (imps-error "IMPLICATION-CONSEQUENT: ~A is not an implication"
		  expression)))

(define (DISJUNCTION? expression)
  (eq? (expression-constructor expression) disjunction))

(define (CONJUNCTION? expression)
  (eq? (expression-constructor expression) conjunction))

(define (BICONDITIONAL? expression)
  (eq? (expression-constructor expression) biconditional))

(define (CONDITIONAL? expression)
  (eq? (expression-constructor expression) if))

(define (CONDITIONAL-TERM? expression)
  (eq? (expression-constructor expression) if-term))

(define (CONDITIONAL-TEST expression)
  (nth (expression-components expression) 0))

(define (CONDITIONAL-CONSEQUENT expression)
  (nth (expression-components expression) 1))

(define (CONDITIONAL-ALTERNATIVE expression)
  (nth (expression-components expression) 2))

(define (CONDITIONAL-FORMULA? expression)
  (eq? (expression-constructor expression) if-form))

(define (CONDITIONAL-PREDICATOR? expression)
  (eq? (expression-constructor expression) if-pred))

(define (EQUATION? expression)
  (eq? (expression-constructor expression) equality))

(define (CONVERGENCE? expression)
  (eq? (expression-constructor expression) is-defined))

(define (CONVERGENCE-IN-SORT? expression)
  (eq? (expression-constructor expression) is-defined-in-sort))

(define (CONVERGENCE-TERM expression)
  (car (expression-components expression)))

(define (CONVERGENCE-SORT expression)
  (if (convergence-in-sort? expression)
      (let ((var (cadr (expression-components expression))))
	(expression-sorting var))
      '#f))

(define (EXPRESSION-LHS expression)
  (let ((comps (expression-components expression)))
    (if (= 2 (length comps))
	(car (expression-components expression))
	(imps-error "EXPRESSION-LHS: ~A has too many components."
		    expression))))

(define (EXPRESSION-RHS expression)
  (let ((comps (expression-components expression)))
    (if (= 2 (length comps))
	(cadr (expression-components expression))
	(imps-error "EXPRESSION-RHS: ~A has too many components."  expression))))
	
; Close expr-list under the operation of adding conjuncts of (conjunctive)
; elements 

(define (REDUCE-CONJUNCTIONS expr-list)
  (iterate iter ((exprs expr-list) (conjunct-list nil))
    (cond
     ((null? exprs)
      (set-union conjunct-list expr-list))
     ((conjunction? (car exprs))
      (iter (cdr exprs)
	    (set-union
	     (reduce-conjunctions
	      (expression-components (car exprs)))
	     conjunct-list)))
     (else 
      (iter (cdr exprs)
	    conjunct-list)))))

(define (ULTIMATE-CONJUNCTS expr-list)
  (iterate iter ((exprs expr-list)
		 (ultimates nil))
    (cond ((null? exprs) (reverse! ultimates))
	  ((conjunction? (car exprs))
	   (iter
	    (append (expression-components (car exprs))
		    (cdr exprs))
	    ultimates))
	  (else
	   (iter (cdr exprs)
		 (add-set-element (car exprs) ultimates))))))
	     
(define (CONJUNCTIVE-COMPONENTS expr)
  (ULTIMATE-CONJUNCTS (list expr)))

(define (ULTIMATE-DISJUNCTS expr-list)
  (iterate iter ((exprs expr-list)
		 (ultimates nil))
    (if (null? exprs)
	ultimates
	(let ((first (car exprs)))
	  (cond ((disjunction? first)
		 (iter
		  (append (expression-components first)
			  (cdr exprs))
		  ultimates))
		((implication? first)
		 (iter
		  (cons (push-not (implication-antecedent first))
			(cons (implication-consequent first)
			      (cdr exprs)))
		  ultimates))
		((biconditional? first)
		 (destructure (((lhs rhs) (expression-components first)))
		   (iter (cdr exprs)
			 (cons (conjunction lhs rhs)
			       (cons (conjunction (push-not lhs) (push-not rhs))
				     ultimates)))))
		((conditional-formula? first)
		 (destructure (((test con alt) (expression-components first)))
		   (iter (cdr exprs)
			 (cons (conjunction test con)
			       (cons (conjunction (push-not test) alt)
				     ultimates)))))
		(else
		 (iter (cdr exprs)
		       (add-set-element first ultimates)))))))) 

(define (DISJUNCTIVE-CONSTRUCTOR? constr)
  (or (eq? constr implication)
      (eq? constr biconditional)
      (eq? constr if-form)
      (eq? constr disjunction)))

(define (DISJUNCTIVE-FORMULA? formula)
  (disjunctive-constructor? (expression-constructor formula)))

(define (DISJUNCTIVE-COMPONENTS formula)
  (if (disjunctive-formula? formula)
      (ultimate-disjuncts (list formula))
      nil))

; (LAMBDA-EXPRESSION? expression) is true if lambda is expression's principal
; constructor.  

(define (LAMBDA-EXPRESSION? expression)
  (and (expression? expression)
       (eq? (expression-constructor expression) lambda)))

; (LAMBDA-APPLICATION? expression) is true if expression is of the form
; ((lambda body vars) args)

(define (LAMBDA-APPLICATION? expression)
  (and (application? expression)
       (lambda-expression? (operator expression))))

; (LAMBDA-WRAP expr sortings) returns a lambda expression of sort
; `(,@sortings -> ,(expression-sorting expr)),
; with matrix expr.  The variables are named xx_0, ... xx_N.

(define (LAMBDA-WRAP expr sortings)
  (let ((old-variables (variables expr)))
    (apply imps-lambda 
	   expr
	   (do ((i 0 (1+ i))
		(sortings sortings (cdr sortings))
		(new-vars nil
			  (cons
			   (new-variable (car sortings) (symbol-append 'xx_ i) old-variables)
			   new-vars)))
	       ((null? sortings)
		(reverse! new-vars))))))

; If SUBST is a substitution having a replacement for each of the newly bound
; variables in VAR-LIST, then APPLY-OPERATOR-TO-SUBSTITUTION returns an
; application in which those replacements are the args, given in the same order
; as the variables in VAR-LIST.  

(define (apply-operator-to-substitution operator subst var-list)
  (or (every?
       (lambda (target)
	 (substitution-find-replacement subst target))
       var-list)
      (imps-error
       "apply-lambda-expr-to-substitution: missing substitution components --~&FOR~_~S~&IN SUBST ~S."
       (set-difference var-list (set-map target subst)) subst))
    (let ((subst (copy-list (set-separate
			     (lambda (subst-comp)
			       (memq? (target subst-comp) var-list))
			     subst)))
	  (less-than
	   (lambda (c1 c2)
	     (cond ((memq (target c1) var-list)
		    => (lambda (rest)
			 (memq? (target c2) rest)))
		   (else '#f)))))
      (apply apply-operator
	     operator
	     (map replacement (sort subst less-than)))))



; (UNIVERSAL? expr) is true if expr has forall as its principal
; constructor.  

(define (UNIVERSAL? expr)
  (eq? (expression-constructor expr) forall))

; (EXISTENTIAL? expr) is true if expr has forsome as its principal
; constructor.

(define (EXISTENTIAL? expr)
  (eq? (expression-constructor expr) forsome))

(define (QUANTIFIER? constr)
  (or (eq? constr forsome)
      (eq? constr forall)))

; (UNIVERSAL-CLOSURE expr . exoscopes) returns the result of universally
; quantifying all variables in expr other than those in exoscopes (presented as 
; a single list argument)

(define (UNIVERSAL-CLOSURE expr . exoscopes)
  (let* ((exoscopes (and exoscopes (car exoscopes)))
	 (vars (set-difference (free-variables expr)
			       exoscopes)))
    (if vars
	(apply forall (cons expr vars))
	expr)))


; (EXISTENTIAL-CLOSURE expr . exoscopes) returns the result of existentially
; quantifying all variables in expr other than those in exoscopes (presented as 
; a single list argument)

(define (EXISTENTIAL-CLOSURE expr . exoscopes)
  (let* ((exoscopes (and exoscopes (car exoscopes)))
	 (vars (set-difference (free-variables expr)
			       exoscopes)))
    (if vars
	(apply forsome (cons expr vars))
	expr)))

(define (CLEAN-UNIVERSAL-BODY expr avoid-vars)
  (let ((clean-substitution
	 (lambda (vars)
	   (imps-enforce is-set? vars)
	   (iterate loop ((new-avoid-vars avoid-vars) (components '()) (vars vars))
	     (if (null? vars)
		 components
		 (let* ((var (car vars))
			(new-var (new-variable
				  (expression-sorting var)
				  (expression-name var)
				  new-avoid-vars)))
		   (loop (add-set-element new-var new-avoid-vars)
			 (cons (make-subst-component
				var
				new-var)
			       components)
			 (cdr vars))))))))
    (if (universal? expr)
	(apply-substitution (clean-substitution (expression-newly-bound-variables expr))
			    (binding-body expr))
	expr)))

(define (QUANTIFICATION-MATRIX-1 quantifiers expr avoid-vars . respect-qcs?)
  (labels (((matrix-and-bound-vars expr vars-so-far)
	    (if (and (or (null? respect-qcs?)
			 (not (expression-quasi-constructor-if-enabled expr)))
		     (memq? (expression-constructor expr)
			    quantifiers))
		(matrix-and-bound-vars
		 (binding-body expr)
		 (set-union (binding-variables expr)
			    vars-so-far))
		(return expr vars-so-far)))
	   ((clean-substitution vars)
	    (imps-enforce is-set? vars)
	    (iterate loop ((new-avoid-vars avoid-vars) (components '()) (vars vars))
	      (if (null? vars)
		  components
		  (let* ((var (car vars))
			 (new-var (new-variable
				   (expression-sorting var)
				   (expression-name var)
				   new-avoid-vars)))
		    (loop (add-set-element new-var new-avoid-vars)
			  (cons (make-subst-component
				 var
				 new-var)
				components)
			  (cdr vars)))))))


;;;used to be:    

;;;
;;;	    (map
;;;	     (lambda (var)
;;;	       (make-subst-component
;;;		var 
;;;		(new-variable
;;;		 (expression-sorting var)
;;;		 (expression-name var)
;;;		 avoid-vars)))
;;;	     vars)
    ;;; but this does not keep track of new variables to avoid (to avoid them)
    
    (receive (matrix recently-bound)
      (matrix-and-bound-vars expr the-empty-set)
      (apply-substitution (clean-substitution recently-bound)
			  matrix))))

(define (UNIVERSAL-MATRIX expr avoid-vars)
  (quantification-matrix-1 (list forall) expr avoid-vars))

(define (UNIVERSAL-MATRIX-RESPECTING-QCS expr avoid-vars)
  (quantification-matrix-1 (list forall) expr avoid-vars '#t))

(define (EXISTENTIAL-MATRIX expr avoid-vars)
  (quantification-matrix-1 (list forsome) expr avoid-vars))

(define (QUANTIFICATION-MATRIX expr avoid-vars)
  (quantification-matrix-1 (list forall forsome) expr avoid-vars))

(define (nested-quantification-bound-variables-1 quantifiers expr)
  (iterate loop ((expr expr)
		 (bvs-so-far '()))
    (if (memq? (expression-constructor expr) quantifiers)
	(loop (binding-body expr)
	      (set-union bvs-so-far (binding-variables expr)))
	bvs-so-far)))

(define (nested-existentially-bound-variables expr)
  (nested-quantification-bound-variables-1 (list forsome) expr))

(define (nested-universally-bound-variables expr)
  (nested-quantification-bound-variables-1 (list forall) expr))

(define (nested-quantified-variables expr)
  (nested-quantification-bound-variables-1 (list forall forsome) expr))


;;;(define (NON-UNIVERSALLY-BOUND-VARIABLES-ON-PATH host path)
;;got rid of this JT,Wed Mar 14 13:08:29 EST 1990
;;;  (iterate iter ((host host)
;;;		 (path path)
;;;		 (pbvs nil))
;;;    (if (null? path)
;;;	pbvs
;;;	(receive (new-host new-path)
;;;	  (host-and-path-after-step host path)
;;;	  (iter
;;;	   new-host
;;;	   new-path
;;;	   (set-union pbvs (if (universal? host)
;;;			       '()
;;;			       (expression-newly-bound-variables host))))))))
;;;

; (IOTA-EXPRESSION? expression) is true if iota is expression's principal
; constructor.  

(define (IOTA-EXPRESSION? expression)
  (and (expression? expression)
       (eq? (expression-constructor expression) iota)))

(define (IOTA-P-EXPRESSION? expression)
  (and (expression? expression)
       (eq? (expression-constructor expression) iota-p)))

(define (NEGATION? expr)
  (eq? (expression-constructor expr) negation))

(define (NEGATION-BODY expr)
  (imps-enforce negation? expr)
  (car (expression-components expr)))

(define (NEGATED-EQUATION? expr)
  (and (negation? expr)
       (equation? (car (expression-components expr)))))

(define (NEGATED-CONVERGENCE? expr)
  (and (negation? expr)
       (convergence? (car (expression-components expr)))))

; (APPLICATION? expr) is true if expr has apply-operator as its principal
; constructor 

(define (APPLICATION? expr)
  (eq? (expression-constructor expr) apply-operator))

; (OPERATOR expr) returns the operator (first component) of an application.  It
; is an error to call this on a non-application. 

(define (OPERATOR expr)
  (car (expression-components expr)))

; (OPERATOR-DEGREE operator) returns the degree (arity) of an operator of an
; application.  It is an imps-error to call this on a non-operator.

(define (OPERATOR-DEGREE operator)
  (length
   (higher-sort-domains 
    (expression-sorting operator))))

; (ARGUMENTS expr) returns the arguments (all components but the first) of an
; application.  It is an error to call this on a non-application. 

(define (ARGUMENTS expr)
  (cdr (expression-components expr)))

; Select particular arguments in an application.  It is an imps-error to call these
; on a non-application.   

(define (1STARG x) (car (arguments x)))
(define (2NDARG x) (cadr (arguments x)))
(define (BUT1STARGS x) (cdr (arguments x)))

(define (INSISTENTLY-APPLY-OPERATOR operator argument-list . exact?)
  (iterate iter ((operator operator)
		 (argument-list argument-list))
    (receive (immediate-args deferred-args)
      (first-n-cars-&-rest argument-list (operator-degree operator))
      (let ((partial-application
	     (apply apply-operator operator immediate-args)))
	(cond ((and (null? deferred-args)
		    (base-sort? (expression-sorting partial-application)))
	       partial-application)
	      ((and exact?
		    (or (null? deferred-args)
			(base-sort? (expression-sorting partial-application))))
	       (imps-error "INSISTENTLY-APPLY-OPERATOR: wrong length argument-list:~%remaining args ~S,~%current-sorting: ~S" deferred-args (expression-sorting partial-application)))
	      ((or (null? deferred-args)
		   (base-sort? (expression-sorting partial-application)))
	       partial-application)
	      (else 
	       (iter partial-application deferred-args))))) ))
  

; Returns the set of subterms that are known to be defined if TERM is, in
; virtue of the fact that apply-operator yields a defined term only if all
; components are defined.

(define (SUBTERMS-CONSEQUENTLY-DEFINED term)
  (iterate iter ((subterms nil)
		 (to-explore (list term)))
    (cond ((null? to-explore) subterms)
	  ((let* ((first (car to-explore))
		  (comps (expression-components first)))
	     (and (application? first)
		  (function? (car comps))
		  (set-separate
		   (lambda (e)
		     (not (necessarily-defined? e)))
		   (if (lambda-application? first)
		       (cons (beta-reduce first)
			     comps)
		       comps))))
	   => (lambda (new)
		(iter (set-union new subterms)
		      (set-union new (cdr to-explore)))))
	  (else (iter subterms (cdr to-explore))))))


(define (IMMEDIATELY-CONSEQUENT-CONVERGENCES term expected-sort)
  (labels
      (((collect term expected-sort already-seen convergences)
	(cond
	 ((necessarily-defined? term)
	  (return already-seen convergences))
	 ((memq? term already-seen)
	  (return already-seen convergences))
	 ((application? term)
	  (let ((op (operator term)))
	    (receive (already-seen convergences)
	      (collect op (expression-sorting op) already-seen convergences)
	      (receive (already-seen convergences)
		(iterate iter ((args (arguments term))
			       (domains (expression-domains op))
			       (already-seen already-seen)
			       (convergences convergences))
		  (if (null? args)
		      (return already-seen convergences)
		      (receive (already-seen convergences)
			(collect (car args) (car domains) already-seen convergences)
			(iter (cdr args)
			      (cdr domains)
			      already-seen
			      convergences))))
		(one-layer-immediately-consequent-convergences
		 term already-seen convergences)))))
	 ((conditional-term? term)
	  (let ((consequent (conditional-consequent term))
		(alternative (conditional-alternative term)))
	    (receive (already-seen-1 convergence-1)
	      (collect consequent expected-sort '()
		       (list (defined-in consequent expected-sort)))
	      (receive (already-seen-2 convergence-2)
		(collect alternative expected-sort '()
			 (list (defined-in alternative expected-sort)))
		(return
		 (set-union already-seen-2
			    (set-union already-seen-1 already-seen))
		 (set-union (set-intersection convergence-1 convergence-2)
			    convergences))))))
	 (else (return already-seen convergences)))))
    (receive (() convergences)
      (collect term expected-sort '() '())
      convergences)))
	    
(define (ONE-LAYER-IMMEDIATELY-CONSEQUENT-CONVERGENCES term already-seen convergences)
  ;;
  ;; assume term is application !!
  ;;
  (let ((op (operator term))
	(args (arguments term)))
    (iterate iter ((args args)
		   (domains (expression-domains op))
		   (already-seen already-seen)
		   (convergences
		    (if (or (necessarily-defined? op)
			    (memq? op already-seen))
			convergences
			(cons (is-defined op) convergences))))
      (if (null? args)
	  (return already-seen convergences)
	  (let ((first (car args)))
	    (cond ((memq? first already-seen)
		   (iter (cdr args) (cdr domains) already-seen convergences))
		  ((necessarily-defined-in-sort? first (car domains))
		   (iter (cdr args) (cdr domains) already-seen convergences))
		  (else
		   (iter (cdr args)
			 (cdr domains)
			 (cons first already-seen)
			 (cons (defined-in first (car domains)) convergences)))))))))

(define (IMMEDIATELY-CONSEQUENT-CONVERGENCES-old term)
  (if (not (application? term))
      '()
      (let ((op (operator term))
	    (args (arguments term)))
	(let ((convergences 
	       (cons
		(is-defined op)
		(map
		 (lambda (e s)
		   (defined-in e s))
		 args
		 (expression-domains op)))))
	  (if (lambda-expression? op)
	      (cons (is-defined (beta-reduce term))
		    convergences)
	      convergences)))))
  

(define (REDUCE-CONJUNCTIONS-AND-UNIVERSALS expr-list avoid-vars)
  (labels
      (((ITER conjunctions universals others)
	(if (and (null? conjunctions)
		 (null? universals))
	    others
	    (receive (conjunctions universals new-others)
	      (sort-formulas (set-union
			      (ultimate-conjuncts conjunctions)
			      (map (lambda (e) (universal-matrix e avoid-vars))
				   universals))
			     nil nil nil)
	      (iter conjunctions universals
		    (set-union new-others others)))))
       ((SORT-FORMULAS exprs conjunctions universals others)
	(if (null? exprs)
	    (return conjunctions universals others)
	    (let* ((first (car exprs))
		   (others
		    (if (null? (expression-quasi-constructors first))
			others
			(add-set-element first others))))
	      (cond ((conjunction? first)
		     (sort-formulas (cdr exprs)
				    (cons first conjunctions)
				    universals others))
		    ((universal? first)
		     (sort-formulas (cdr exprs) conjunctions
				    (cons first universals) others))
		    (else
		     (sort-formulas (cdr exprs) conjunctions universals
				    (cons first others))))))))
    (receive (conjunctions universals others)
      (sort-formulas expr-list nil nil nil)
      (iter conjunctions universals others))))

(define (JOIN-PREDICATES constructor p1 p2)
  (let ((bv1 (binding-variables p1))
	(bv2 (binding-variables p2))
	(sensitive (set-union (free-variables p1)
			      (free-variables p2))))
    (if (not (eq? (expression-type p1)
		  (expression-type p2)))
	(imps-error "JOIN-PREDICATES: predicates don't match: ~S~_~S" p1 p2))
    (let ((vars (if (every?
		     (lambda (v1 v2)
		       (equal-sortings? (expression-sorting v1)
					(expression-sorting v2)))
		     bv1
		     bv2)
		    (var-list->new-variables bv1 sensitive)
		    
		    (SORTS->NEW-VARIABLES (map expression-type bv1)
					  'x
					  sensitive))))
      (apply imps-lambda
	     (recursive-constructor-simplify
	      (constructor
	       (apply apply-operator p1 vars)
	       (apply apply-operator p2 vars)))
	     vars))))
      
(define (CONJOIN-PREDICATES p1 p2)
  (join-predicates conjunction p1 p2))

(define (DISJOIN-PREDICATES p1 p2)
  (join-predicates disjunction p1 p2))

;;; If P1 and P2 are predicators of the same type, then PREDICATOR-EQUIVALENCE
;;; constructs a formula asserting that they the results of applying them to
;;; enough arguments are equivalent formulas, for all choices of the arguments.
;;; 

(define (PREDICATOR-EQUIVALENCE p1 p2)
  (if (not (and (sorts-may-overlap? p1 p2)
		(predicator? p1)))
      (imps-error "PREDICATOR-EQUIVALENCE: bad predicators ~S~_~S" 
		  p1 p2))
  (let* ((vars
	  (sorts->new-variables
	   (hereditary-type-domains (expression-sorting p1))
	   'xx
	   (set-union (variables p1) (variables p2)))))
    (apply
     forall
     (recursive-constructor-simplify
      (biconditional
       (insistently-apply-operator p1 vars 'exact)
       (insistently-apply-operator p2 vars 'exact))) 
     vars)))

; PUSH-NOT applies to a formula and returns the result of first negating the
; formula and then pushing the negation inward until it either cancels another
; negation sign (this is classical) or else reaches an atomic formula.  This
; operation is used enough that it is worth caching the results in a field of
; the expression for later use.   



(define (PUSH-NOT formula)
  (or (expression-pushed-not formula)    
      (let ((p-n (compute-push-not formula)))
	(set (expression-pushed-not formula) p-n)
	p-n)))

(define (COMPUTE-PUSH-NOT formula)
  (let ((constr (expression-constructor formula)))
    (cond
     ((eq? the-true constr) falsehood)
     ((eq? the-false constr) truth)
     ((eq? negation constr) 
      (flush-not					;CLASSICAL DOUBLE
       (car (expression-components formula))))		;NEGATION ELIMINATION 
     ((atomic-formula? formula) (negation formula))
     (else
      (select constr
	((disjunction)
	 (apply conjunction (map push-not (expression-components formula))))
	((conjunction)
	 ;;
	 ;; Used to be the simpler
	 ;; (apply disjunction (map push-not (expression-components formula)))
	 ;; 
	 (conjunction-compute-push-not formula))
	((implication)
	 (conjunction-simplifier
		(append
		 (ultimate-conjuncts (list (flush-not (implication-antecedent formula))))
		 (list (push-not (implication-consequent formula))))))
	((if-form)
	 (if-form
	  (nth (expression-components formula) 0)	;test unchanged
	  (push-not					;negate consequent
	   (nth (expression-components formula) 1)) 
	  (push-not					;negate alternative
	   (nth (expression-components formula) 2))))
	((biconditional)
	 (biconditional (push-not (car (expression-components formula)))
			(cadr (expression-components formula))))
	((forall)
	 (apply forsome
		(cons (push-not (binding-body formula))
		      (binding-variables formula))))
	((forsome)
	 (apply forall
		(cons (push-not (binding-body formula))
		      (binding-variables formula))))
	(else
	 (negation formula)))))))

(define (CONJUNCTION-COMPUTE-PUSH-NOT formula)
  (imps-enforce conjunction? formula)
  (receive (last all-but)
    (last-&-all-but-last (expression-components formula))
    (if (negation? last)
	(implication
	 (conjunction-simplifier (map flush-not all-but))
	 (push-not last))
	(disjunction-simplifier (map push-not (expression-components formula))))))

; FLUSH-NOT applies to a formula and returns the result of pushing all its
; negation inward until each either cancels another negation sign (this is
; classical) or else reaches an atomic formula.  It differs from PUSH-NOT in
; that formula is not first negated.  

(define (FLUSH-NOT expr)
  (cond ((or (not (formula? expr))
	     (atomic-formula? expr))
	 expr)
	((expression-flushed-not expr))
	(else
	 (let ((f-n (compute-flush-not expr)))
	   (set (expression-flushed-not expr) f-n)
	   f-n))))
	       
(define (compute-flush-not expr)
  (let ((constr (expression-constructor expr)))
    (select constr
      ((nil) expr)
      ((negation) (push-not (car (expression-components expr))))
      ((the-true) truth)
      ((the-false) falsehood)
      (else
       (apply constr (map flush-not (expression-components expr)))))))

(define (propositional-constructor? constr)
  (memq? constr
	 (list conjunction disjunction implication biconditional negation if-form)))



; An expression is necessarily defined--that is, known to be defined purely in
; virtue of its form--if it is a variable or constant, a lambda expression, or
; if it is prop-sorted.  Where does this really belong? 

(define (NECESSARILY-DEFINED? expr)
  (or
   (variable? expr)
   (constant? expr)
   (lambda-expression? expr)
   (formula-or-predicator? expr)
   (and (eq? (expression-constructor expr) if-term)
	(necessarily-defined? (nth (expression-components expr) 1)) ;consequent
	(necessarily-defined? (nth (expression-components expr) 2))))) ;alternative

(define (NECESSARILY-DEFINED-IN-SORT? expr sort)
  (and
   (necessarily-defined? expr)
   (or
    (sorting-leq (expression-sorting expr) sort)
    (and
     (constant? expr)
     (let ((n (name expr))
	   (num-type (numerical? sort)))
       (and
	(numerical-object? n)
	num-type
	(cond ((numerical-type? num-type)
	       ((numerical-type-recognizer num-type) n))
	      ((procedure? num-type)(num-type n))
	      (else '#f))))))))

(define (NECESSARILY-UNDEFINED? expr)
  (let ((current (expression-necessarily-undefined? expr))
	(compute-necessarily-defined
	 (lambda (expr)
	   (let ((constr (expression-constructor expr)))
	     (cond ((necessarily-defined? expr)
		    (set (expression-necessarily-undefined? expr) '#f)
		    '#f)
		   ((eq? constr undefined-of-sort)
		    (set (expression-necessarily-undefined? expr) '#t)
		    '#t)
		   ((eq? constr apply-operator)
		    (set (expression-necessarily-undefined? expr)
			 (any?
			  necessarily-undefined?
			  (expression-components expr)))
		    (expression-necessarily-undefined? expr))
		   ((eq? constr if-term)
		    (set (expression-necessarily-undefined? expr)
			 (every?
			  necessarily-undefined?
			  (cdr (expression-components expr))))
		    (expression-necessarily-undefined? expr))
		   (else (set (expression-necessarily-undefined? expr) '#f)
			 '#f))))))

    (if (uncomputed? current)
	(compute-necessarily-defined expr)
	current)))

(define (necessarily-false? expr)
  (or (falsehood? expr)
      (and (formula? expr)
	   (application? expr)
	   (any?
	    necessarily-undefined?
	    (expression-components expr)))))

(define (strict-subexpression? expr1 expr2)
  (or (eq? expr1 expr2)
      (and (application? expr2)
	   (any?
	    (lambda (e)
	      (strict-subexpression? expr1 e))
	    (expression-components expr2)))))
	    
;;;(define (disjunctive-component? subexpr expr)
;;;  (and (fx< (expression-height subexpr)			;small enough?
;;;	    (expression-height expr))
;;;       (or (and (eq? (expression-constructor expr) disjunction)
;;;		(any?					;any disjunct? 
;;;		 (lambda (c)(eq? subexpr c))
;;;		 (expression-components expr)))
;;;	   (and (eq? (expression-constructor expr)	;in implication,
;;;		     implication)			;negated antecedent 
;;;		(or (eq? (push-not subexpr)		;or consequent?     
;;;			 (nth (expression-components expr) 0))
;;;		    (eq? subexpr
;;;			 (nth (expression-components expr) 1)))))))





(define (NEGATED-ATOMIC-FORMULA? expr)
  (and (negation? expr)
       (atomic-formula? (car (expression-components expr)))))

;;;(define (NEGATED-STRONG-ATOMIC-FORMULA? expr)
;;;  (and (negation? expr)
;;;       (strong-atomic-formula? (car (expression-components expr)))))

