;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SOME-QUASI-CONSTRUCTORS)


(define QUASI-EQUALITY
  (make-quasi-constructor quasi-equation-constr-proc
			  quasi-equation-inverse
			  '(((0 0 0) (1 0))
			    ((0 1 0) (1 1)))
			  '==))

(define (QUASI-EQUALITY-OR-EQUALITY lhs rhs)
  (if (expression-of-category-ind? lhs)
      (quasi-equality lhs rhs)
      (equality lhs rhs)))

(define FALSELIKE-OF-SORT
  (let ((constr
	 (make-quasi-constructor falselike-of-sort-constr-proc
				 falselike-of-sort-inverse
				 '(())
				 'falselike)))
    (set-sexp-builder constr falselike-of-sort-sexp-builder)
    (set-sexp-decoder constr falselike-of-sort-sexp-decoder)
    constr))

(define (FALSELIKE sorting)  
  (if (eq? sorting prop)
      falsehood
      (falselike-of-sort (find-variable *in-sort-preferred-varname* sorting))))

(define (UNDEFINED-OR-FALSELIKE expr)
  (if (term-or-fn? expr)
      (undefined (expression-sorting expr))
      (falselike (expression-sorting expr))))



;;; SUB-FUNCTION is a quasi-constructor.  It applies to a pair of expressions f
;;; and g.  These are required to be of the same higher type, which may not be
;;; prop-sorted.  (See below: SUB-PREDICATE for predicates).  (SUB-FUNCTION f g)
;;; expands to:
;;;    for all xx, #(f(xx)) implies f(xx)=g(xx),
;;; where xx stands for a list of variables in the domain types associated with
;;; f and g.  

(define SUB-FUNCTION
  (make-quasi-constructor sub-function-constr-proc
 			  sub-function-inverse
 			  '(((0 0 0 0) (0 1 0 0))
 			    ((0 1 1 0)))
 			  'sub-function))

(disable-quasi-constructor SUB-FUNCTION)

;;; SUB-PREDICATE is a quasi-constructor.  It applies to a pair of expressions
;;; f and g.  These are required to be predicates of the same type, and must
;;; not be predicators of higher range sort.  (SUB-PREDICATE f g) expands to:
;;;    for all xx, f(xx) implies g(xx),
;;; where xx stands for a list of variables in the domain types associated with
;;; f and g.  

(define SUB-PREDICATE
  (make-quasi-constructor sub-predicate-constr-proc
 			  sub-predicate-inverse
 			  '(((0 0 0))
 			    ((0 1 0)))
 			  'sub-predicate))

(disable-quasi-constructor SUB-PREDICATE)



; (define RANGE
;   (make-quasi-constructor range-constr-proc
; 			  range-inverse
; 			  '(((0 0 0 0)))
; 			  'range))

(define DOMAIN
  (make-quasi-constructor domain-constr-proc
 			  domain-inverse
 			  '(((0 0 0)))
 			  'domain))

(disable-quasi-constructor DOMAIN)

(define TOTAL?
  (make-quasi-constructor total?-constr-proc
			  total?-inverse
			  '(((0 0 0)))
			  'total?))

(define (TOTALITY-FORMULA fun)
  (or (function? fun)
      (imps-error "TOTALITY-FORMULA: ~S ~A."
		  fun "is not a function"))
  (let ((var (find-variable *in-sort-preferred-varname* (expression-sorting fun))))
    (total? fun var)))

;; (define TOTAL-IN-SORT?
;;   (make-quasi-constructor total-in-sort?-constr-proc
;; 			  total-in-sort?-inverse
;; 			  '(((0 0 0)) ())
;; 			  'total-in-sort?))

(define NONVACUOUS?
  (make-quasi-constructor nonvacuous?-constr-proc
			  nonvacuous?-inverse
			  '(((0 0)))
			  'nonvacuous?))

;; This is never used for read/print, but only as a hook to hang a
;; simplification transform off of.   

(define LAMBDA-APPLICATION
  (let ((la
	 (make-quasi-constructor lambda-application-constructor-proc
				 lambda-application-inverse
				 '(((0))
				   ((1)))
				 'lambda-application)))
    (disable-quasi-constructor la)
    la))

(define (quasi-equation? formula)
  (memq? quasi-equality (expression-quasi-constructors formula)))

(define (quasi-equation lhs rhs)
  (quasi-equality lhs rhs))

(define (equation->quasi-equation equation)
  (if (equation? equation)
      (apply quasi-equation (expression-components equation))
      equation))
  
(define (quasi-equation-lhs formula)
  (enforce quasi-equation? formula)
  (expression-lhs (expression-rhs formula)))

(define (quasi-equation-rhs formula)
  (enforce quasi-equation? formula)
  (expression-rhs (expression-rhs formula)))

