;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald DG-PRIMITIVE-INFERENCES)


(define (DG-PRIMITIVE-INFERENCE-DIRECT-INFERENCE sqn)
  (let ((di-method
	 (constructor-direct-inference
	  (or
	   (expression-quasi-constructor-if-enabled
	    (sequent-assertion (sequent-node-sequent sqn)))
	   (expression-constructor
	    (sequent-assertion (sequent-node-sequent sqn)))))))
    (if (direct-inference? di-method)
	(deduction-graph-apply-rule di-method (list sqn))
	(fail))))

(define (DG-PRIMITIVE-INFERENCE-INSISTENT-DIRECT-INFERENCE sqn)
  (let ((di-method
	 (or
	  (constructor-direct-inference
	   (expression-quasi-constructor-if-enabled
	    (sequent-assertion (sequent-node-sequent sqn))))
	  (constructor-direct-inference
	   (expression-constructor
	    (sequent-assertion (sequent-node-sequent sqn)))))))
    (if (direct-inference? di-method)
	(deduction-graph-apply-rule di-method (list sqn))
	(fail))))

(define (DG-PRIMITIVE-INFERENCE-ANTECEDENT-INFERENCE sqn antecedent-formula);;changed
  (let ((antecedent-formula
	 (any (lambda (ass)
		(and (alpha-equivalent? ass antecedent-formula)
		     ass))
	      (sequent-node-assumptions sqn))))
    (if antecedent-formula
	(let ((rule ((constructor-antecedent-inference 
		      (expression-constructor antecedent-formula))
		     antecedent-formula)))
	  (if (antecedent-inference? rule)
	      (deduction-graph-apply-rule rule (list sqn))
	      (fail)))
	(fail))))

(define (DG-PRIMITIVE-INFERENCE-CONTRAPOSITION sqn antecedent-formula)
  (let ((antecedent-formula
	 (any (lambda (ass)
		(and (alpha-equivalent? ass antecedent-formula)
		     ass))
	      (sequent-node-assumptions sqn))))
    (if antecedent-formula
	(deduction-graph-apply-rule (contraposition-rule antecedent-formula)
				    (list sqn))
	(fail))))

;;;(define (DG-PRIMITIVE-INFERENCE-WEAK-SIMPLIFICATION sqn)
;;;  (deduction-graph-apply-rule weak-node-simplification (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-SIMPLIFICATION sqn)
  (deduction-graph-apply-rule node-simplification (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-INSISTENT-SIMPLIFICATION sqn)
  (bind (((simplify-quasi-constructors-messily?) '#t))
    (deduction-graph-apply-rule node-simplification (list sqn))))

(define (DG-PRIMITIVE-INFERENCE-SIMPLIFICATION-WITH-MINOR-PREMISES sqn)
  (deduction-graph-apply-rule node-simplification-with-minor-premises (list sqn)))

;;;(define (DG-PRIMITIVE-INFERENCE-BETA-REDUCTION sqn)
;;;  (deduction-graph-apply-rule beta-reduction-rule (list sqn)))
;;;
;;;(define (DG-PRIMITIVE-INFERENCE-INSISTENT-BETA-REDUCTION sqn)
;;;  (bind (((simplify-quasi-constructors-messily?) '#t))
;;;    (deduction-graph-apply-rule beta-reduction-rule (list sqn))))

(define (DG-PRIMITIVE-INFERENCE-EXTENSIONALITY sqn)
  (let ((rule
	 (if (negated-atomic-formula? (sequent-node-assertion sqn))
	     inverse-extensionality
	     extensionality)))
    (deduction-graph-apply-rule rule (list sqn))))

(define (DG-PRIMITIVE-INFERENCE-WEAKENING sqn formulas)
  (let ((graph (sequent-node-graph sqn))
	(hyp-seq (build-sequent (context-omit-assumptions
				 (sequent-node-context sqn)
				 (set-separate
				  (lambda (ass)
				    (any?
				     (lambda (f)
				       (and (alpha-equivalent? f ass)
					    ass))
				     formulas))
				    (sequent-node-assumptions sqn)))
				(sequent-node-assertion sqn))))
    (let ((hyp-sqn (post hyp-seq graph)))
      (deduction-graph-apply-rule weakening-rule (list hyp-sqn sqn)))))
    
(define (DG-PRIMITIVE-INFERENCE-DEFINED-CONSTANT-UNFOLDING sqn paths constant)
     (let* ((theory (deduction-graph-theory (sequent-node-graph sqn)))
	    (definition (theory-get-constant-definition theory (name constant))))

       (or definition
	   (imps-error "DG-PRIMITIVE-INFERENCE-DEFINED-CONSTANT-UNFOLDING: ~S ~A"
		       constant-name "is not the name of a defined constant."))
       (if (implicit-definition? definition)
	   (dg-primitive-inference-macete-application-at-paths
	    sqn
	    paths
	    (definition-implicit-unfolding-macete definition))
	   (deduction-graph-apply-rule
	    (unfold-defined-constant-rule constant definition paths)
	    (list sqn)))))

;;;(define (DG-PRIMITIVE-INFERENCE-MACETE-APPLICATION sqn macete)
;;;  (let ((graph (sequent-node-graph sqn)))
;;;    (if (macete-sound-in-theory? macete (deduction-graph-theory graph))
;;;	(deduction-graph-apply-rule
;;;	 (apply-macete-rule macete)
;;;	 (list sqn))
;;;;;;	(fail))))
;;;
;;;(define DG-PRIMITIVE-INFERENCE-MACETE-APPLICATION dg-primitive-inference-macete-application)

(define (DG-PRIMITIVE-INFERENCE-MACETE-APPLICATION-AT-PATHS sqn paths macete)
  (deduction-graph-apply-rule
   (macete-at-paths-rule-generator macete paths)
   (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-MACETE-APPLICATION-WITH-MINOR-PREMISES-AT-PATHS sqn paths macete)
  (deduction-graph-apply-rule
   (macete-at-paths-with-minor-premises-rule-generator macete paths)
   (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-FORCE-SUBSTITUTION sqn paths replacements)
  (deduction-graph-apply-rule
   (force-substitution replacements '#f paths)
   (list '#f sqn)))

(define (DG-PRIMITIVE-INFERENCE-RAISE-CONDITIONAL-INFERENCE sqn paths)
  (deduction-graph-apply-rule
   (raise-conditionals paths)
   (list sqn)))

;;;(define (DG-PRIMITIVE-INFERENCE-OBSOLETE-IOTA-ELIMINATION sqn path)
;;;  (let ((rule
;;;	 (if (negated-atomic-formula? (sequent-node-assertion sqn))
;;;	     (obsolete-inverse-iota-rule-generator path)
;;;	     (obsolete-iota-rule-generator path))))
;;;    (deduction-graph-apply-rule rule (list sqn))))

(define (DG-PRIMITIVE-INFERENCE-IOTA-ELIMINATION sqn path)
  (let ((rule
	 (if (negated-atomic-formula? (sequent-node-assertion sqn))
	     (inverse-iota-rule-generator path)
	     (iota-rule-generator path))))
    (deduction-graph-apply-rule rule (list sqn))))

(define (DG-PRIMITIVE-INFERENCE-BACKCHAIN-INFERENCE sqn antecedent-formula)
  (let ((antecedent-formula
	 (any (lambda (ass)
		(and (alpha-equivalent? ass antecedent-formula)
		     ass))
	      (sequent-node-assumptions sqn))))
    (if antecedent-formula
	(let ((rule (backchain-rule antecedent-formula)))
	  (if (rule? rule)
	      (deduction-graph-apply-rule rule (list sqn))
	      (fail)))
	(fail))))

(define (DG-PRIMITIVE-INFERENCE-BACKCHAIN-BACKWARDS-INFERENCE
	 sqn antecedent-formula)
  (bind (((backchain-forwards-through-expression?) '#f))
    (let ((antecedent-formula
	   (any (lambda (ass)
		  (and (alpha-equivalent? ass antecedent-formula)
		       ass))
		(sequent-node-assumptions sqn))))
      (if antecedent-formula
	  (let ((rule (backchain-rule antecedent-formula)))
	    (if (rule? rule)
		(deduction-graph-apply-rule rule (list sqn))
		(fail)))
	  (fail)))))

(define (DG-PRIMITIVE-INFERENCE-BACKCHAIN-THROUGH-FORMULA-INFERENCE
	 sqn antecedent-formula)
  (bind (((backchain-through-expression?) '#f))
    (let ((antecedent-formula
	   (any (lambda (ass)
		  (and (alpha-equivalent? ass antecedent-formula)
		       ass))
		(sequent-node-assumptions sqn))))
      (if antecedent-formula
	  (let ((rule (backchain-rule antecedent-formula)))
	    (if (rule? rule)
		(deduction-graph-apply-rule rule (list sqn))
		(fail)))
	  (fail)))))

(define (DG-PRIMITIVE-INFERENCE-IMPLICATION-ELIMINATION sqn antecedent-formula)
  (let ((antecedent-formula
	 (any (lambda (ass)
		(and (alpha-equivalent? ass antecedent-formula)
		     ass))
	      (sequent-node-assumptions sqn))))
    (if antecedent-formula
	(let ((dg (sequent-node-graph sqn)))
	  (deduction-graph-apply-rule
	   implication-elimination
	   (list (post
		  (build-sequent
		   (context-omit-assumption (sequent-node-context sqn)
					    antecedent-formula)
		   (implication antecedent-formula (sequent-node-assertion sqn)))
		  dg)
		 sqn)))
	(fail))))

(define (DG-PRIMITIVE-INFERENCE-CUT sqn major-premise)
  (deduction-graph-apply-rule cut-rule (list major-premise sqn)))

(define (DG-PRIMITIVE-INFERENCE-DISJUNCTION-ELIMINATION sqn major-premise)
  (deduction-graph-apply-rule disjunction-elimination (list major-premise sqn)))

(define (DG-PRIMITIVE-INFERENCE-UNIVERSAL-INSTANTIATION sqn major)
  (deduction-graph-apply-rule
   universal-instantiation
   (list major sqn)))

(define (DG-PRIMITIVE-INFERENCE-EXISTENTIAL-GENERALIZATION sqn major)
  (deduction-graph-apply-rule
   existential-generalization
   (list major sqn)))

(define (DG-PRIMITIVE-INFERENCE-DEFINEDNESS sqn)
  (deduction-graph-apply-rule definedness-rule (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-SORT-DEFINEDNESS sqn)
  (deduction-graph-apply-rule sort-definedness-rule (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-THEOREM-ASSUMPTION sqn formula)
  (deduction-graph-apply-rule
   (theorem-discharge-rule formula)
   (list sqn)))

(define (DG-PRIMITIVE-INFERENCE-UNORDERED-CONJUNCTION-DIRECT-INFERENCE sqn)
  (deduction-graph-apply-rule
   unordered-conjunction-direct-inference
   (list sqn)))

;;;(define (DG-PRIMITIVE-INFERENCE-TAUTOLOGY sqn)
;;;  (deduction-graph-apply-rule tautology-rule (list sqn)))
;;;

(define (DG-PRIMITIVE-INFERENCE-CHOICE sqn)
  (deduction-graph-apply-rule choice-principle (list sqn)))

