;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(let ((def-form-displayer-alist '()))
  (define (add-def-form-body-displayer def-form-name proc)
    (push def-form-displayer-alist (cons def-form-name proc)))

  (define (def-form-body-displayer def-form-name)
    (let ((look-up (assq def-form-name def-form-displayer-alist)))
      (if look-up 
	  (cdr look-up)
	  default-def-form-body-displayer))))


(lset *display-header-formula-in-tex* '#f)

(define (display-verbatim obj port)
  (format port "\\begin{quote}")
  (begin-verbatim port)
  (format port "\\begin{verbatim}")
  (format port "~A" obj)
  (format port "\\end{verbatim}")
  (end-verbatim port)
  (format port "\\end{quote}")))


(define (display-string-verbatim-as-expression str port)
  (let ((str (if (string? str) str
		 (if (symbol? str) (string-downcase (symbol->string str))
		     (imps-error "Bad..")))))
  (format port "\\begin{quote}")
  (begin-verbatim port)
  (format port "\\begin{verbatim}")
  (format port "~A" (sexp->output-string *form* (parse-top-level *parse* str)))
  (format port "\\end{verbatim}")
  (end-verbatim port)
  (format port "\\end{quote}")))

(define (display-string-verbatim-as-sort str port)
  (begin-verbatim port)
  (format port " \\verb\\")
  (format port "~A" (sort-list->string (if (string? str)
					   (parse-top-level *parse* str)
					   str)))
  (format port "\\ ")
  (end-verbatim port))

(define (keyword-cases form keywords)
  (and (list? form)
       (memq? (car form) keywords)))

(define (default-def-form-body-displayer forms port)
  (format port "~%\\begin{itemize}")
  (walk (lambda (x)
	  (format port "~%\\item ")
	  (display-sexp-as-itemized x port))
	forms)
  (format port "\\end{itemize}"))

(define (def-theorem-body-displayer forms port)
  (if *display-header-formula-in-tex*
      (block
        (format port "~%\\begin{center}~%\\framebox{\\begin{minipage}{5in}")

	(display-sexpression-in-tex-format (parse-top-level *parse* (car forms)) port)
	(format port "~%\\end{minipage}}\\end{center}"))
      (display-sexp-as-itemized (car forms) port))
    
  (format port "~%\\begin{itemize}")
  (walk (lambda (x)
	  (format port "~%\\item ")
	  (display-sexp-as-itemized x port))
	(cdr forms))
  (format port "\\end{itemize}"))

(define (def-translation-body-displayer forms port)
  (format port "~%\\begin{itemize}")
  (walk (lambda (x)
	  (format port "~%\\item ")
	  (display-translation-sexps x port))
	forms)
  (format port "\\end{itemize}"))

(define (display-translation-sexps object port)
  (cond ((symbol? object) (format port " ~A " (backslash-special-chars object)))
	((string? object) (display-string-verbatim-as-expression object port))
	((number? object) (format port " ~A " object))
	((null? object) (format port "()"))
	((keyword-cases object '(sort-alist sorts))
	 (display-sexp-as-itemized (car object) port)
	 (format port "~%\\begin{enumerate}")
	 (walk (lambda (x)
		 (format port "~%\\item ")
		 (walk (lambda (z) (display-string-verbatim-as-sort z port)) x))
	       (cdr object))
	 (format port "~%\\end{enumerate}~%"))
	((keyword-cases object '(constant-alist constants))
	 (display-sexp-as-itemized (car object) port)
	 (format port "~%\\begin{enumerate}")
	 (walk (lambda (x)
		 (format port "~%\\item ")
		 (walk (lambda (z) (display-string-verbatim-as-expression z port)) x))
	       (cdr object))
	 (format port "~%\\end{enumerate}~%"))
	((list? object)
	 (display-sexp-as-itemized (car object) port)
	 (and (cdr object)
	      (if (null? (cddr object))
		  (display-sexp-as-itemized (cadr object) port)
		(block
		 (format port "~%\\begin{itemize}")
		 (walk (lambda (x)
			 (format port "~%\\item ")
			 (display-sexp-as-itemized x port))
		       (cdr object))
		 (format port "~%\\end{itemize}~%")))))
	(t (imps-error "Cannot display this object."))))


(walk (lambda (x) (add-def-form-body-displayer x def-theorem-body-displayer))
      '(def-theorem def-constant def-recursive-constant))

(add-def-form-body-displayer
 'def-script 
 (lambda (forms port)
   (format port " ~A " (car forms))
   (format port "~%\\begin{itemize}")
   (walk (lambda (x)
	   (format port "~%\\item ")
	   (display-sexp-as-itemized x port))
	 (cadr forms))
   (format port "\\end{itemize}")))

(add-def-form-body-displayer
 'def-theory-ensemble-instances
 def-translation-body-displayer)

(define (display-sexp-as-itemized object port)
  (cond ((symbol? object) (format port " ~A " (backslash-special-chars object)))
	((string? object) (display-string-verbatim-as-expression object port))
	((number? object) (format port " ~A " object))
	((null? object) (format port "()"))
	((keyword-cases object '(proof))
	 (display-sexp-as-itemized (car object) port)
	 (format port "~%\\begin{enumerate}")
	 (walk (lambda (x)
		 (format port "~%\\item ")
		 (display-sexp-as-itemized x port))
	       (cadr object))
	 (format port "~%\\end{enumerate}~%"))
	((keyword-cases object '(sorts constants))
	 (display-sexp-as-itemized (car object) port)
	 (format port "~%\\begin{enumerate}")
	 (walk (lambda (x)
		 (format port "~%\\item ")
		 (display-sexp-as-itemized (car x) port)
		 (walk (lambda (z) (display-string-verbatim-as-sort z port)) (cdr x)))
	       (cdr object))
	 (format port "~%\\end{enumerate}~%"))
	((keyword-cases object '(token))
	 (display-sexp-as-itemized (car object) port)
	 (display-verbatim (cadr object) port))
	
	((list? object)
	 (display-sexp-as-itemized (car object) port)
	 (and (cdr object)
	      (if (null? (cddr object))
		  (display-sexp-as-itemized (cadr object) port)
		  (block
		    (format port "~%\\begin{itemize}")
		    (walk (lambda (x)
			    (format port "~%\\item ")
			    (display-sexp-as-itemized x port))
			  (cdr object))
		    (format port "~%\\end{itemize}~%")))))
	(t (imps-error "Cannot display this object."))))

(define (recursively-backslash-special-chars sexp)
  (if (list? sexp) (map recursively-backslash-special-chars sexp)
      (string->symbol (string-upcase (backslash-special-chars sexp)))))

(define (display-def-form-in-tex-format form port)
  (let ((def-form-name (car form))
	(def-form-tag  (or (recursively-backslash-special-chars (cadr form))  'anonymous)))
    (format port
	    (string-downcase (format nil "~%~%\\iffalse~%~A~%~%\\fi~%~%\\paragraph{~A}{\\it ~A}"
				     def-form-tag
				     def-form-name 
				     def-form-tag)))
    (or (null? (cddr form))
	((def-form-body-displayer def-form-name) (cddr form) port))))


(define (tex-and-display-def-form def-form)
  (initialize-tex-port-and-apply
   (lambda (xtv-port)
     (display-def-form-in-tex-format def-form xtv-port))))
  

(define (read-file-as-sexp file)
  (with-open-ports ((port (open file '(in))))
      (iterate loop ((forms '()))
	(let ((obj (read port)))
	  (if (eof? obj)
	      (reverse! forms)
	      (loop (cons obj forms)))))))


(define (tex-and-display-def-forms-in-file file)
  (let ((def-forms (read-file-as-sexp file)))
    (initialize-tex-port-and-apply
     (lambda (xtv-port)
       (walk (lambda (x) (display-def-form-in-tex-format x xtv-port))
	     def-forms)))))

