;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(define (PRESENT-TEX-QUANTIFICATION-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op))
	(top-level-form
	 (if (list? (presentation-format formatter op))
	     (car (presentation-format formatter op))
	     (presentation-format formatter op)))
	(nested-form (if (list? (presentation-format formatter op))
			 (cadr (presentation-format formatter op))
			 (presentation-format formatter op))))
    (destructure (((typing body) args))
      (cond
       ((not (> (maximum-nesting-for-logical-expressions) 0))
	(parenthesize-conditionally
	 (> bp weight)
	 `(,nested-form 
	   ,(present-tex-parameter-list typing)
	   " \\quad "
	   ,(present-tree formatter body 0))))
       ((and (eq? op 'forall)
	     (list? body)
	     (eq? (car body) 'implies)
	     (short-sexp? (cadr body)))
	(format-forall-such-that formatter top-level-form typing body))
       (else 
	`(,top-level-form
	  ,(present-tex-parameter-list typing)
	  ," \\quad "
	  ,(present-tree formatter body 0)))))))

(define (format-forall-such-that formatter top-level-form typing body)
  (destructure (((() antecedent consequent) body))
    `(,top-level-form
      ,(present-tex-parameter-list typing)
      " \\quad \\mbox\{s. t.\} \\quad "
      ,(bind (((maximum-nesting-for-logical-expressions) 0))
	(present-tree formatter antecedent 0))
      " , \\newline\\phantom\{X\}"
      ,(present-tree formatter consequent 0))))

  
(define (PRESENT-TEX-LAMBDA-ABSTRACTION formatter op args bp)
  (ignore bp)
  (if (<= (maximum-nesting-for-logical-expressions) 0)
      `(    " [ \\," 

	    ,(present-tex-parameter-list (car args))
	    " \\, " " \\mapsto " " \\, "

	    ,(present-tree formatter (cadr args) 0)

	    "\\, ] ")
      (bind (((maximum-nesting-for-logical-expressions)
	      (-1+ (maximum-nesting-for-logical-expressions)))
	     ((current-indentation)
	      (string-append (current-indentation) "XX")))
	`(    " [ \\," 

	      ,(present-tex-parameter-list (car args))
	      " \\, " " \\mapsto " " \\newline "
	      ,(format nil " \\phantom\{~a\} " (current-indentation))
	    
	      ,(present-tree formatter (cadr args) 0)
	    
	      "\\, ] "))))

(lset *small-tex-expression-cutoff* 50)

(define (short-sexp? expr)
  (< (tex-expression-width expr) *small-tex-expression-cutoff*))

(define (TEX-EXPRESSION-WIDTH expr)
  (string-length (format '() "~A" expr)))



(define (PRESENT-TEX-CONDITIONAL-FORMULA formatter op args bp)
  (ignore bp)
  (let ((newlines? (> (maximum-nesting-for-logical-expressions) 0)))
    (bind (((current-indentation) (string-append (current-indentation) "X"))
	   ((current-bullet-symbol) (cdr (current-bullet-symbol)))
	   ((maximum-nesting-for-logical-expressions) 0))

	
      (receive (last args)
	(iterate loop ((args args) (accum '()))
	  (let ((1st (present-tree formatter (car args) 0))
		(2nd (present-tree formatter (cadr args) 0))
		(3rd (caddr args)))
	    (if (and (list? 3rd)
		     (eq? (car 3rd) op))
		(loop (cdr 3rd) `(( ,1st ,2nd ) ,@accum))
		(return 
		 (present-tree formatter 3rd 0) 
		 (reverse `(( ,1st ,2nd ) ,@accum))))))
	(cond ((not newlines?)
	       `( ,(map-alternate-insert
		    '\,
		    (lambda (x)
		      (list " \\mbox{ if }" (car x)
			    " \\mbox{ then }" (cadr x)))
		    args)
		  " \\mbox{ else }"
		  ,last))
	      ((= (length args) 1)
	       `(" \\mbox{ conditionally, if }  "
		 ,(caar args)
		 " \\newline "
		 ,(format nil " \\phantom\{~a\} " (current-indentation))
		 ,(car (current-bullet-symbol))
		 " \\mbox{ then }"
		 ,(cadar args)
		 " \\newline "
		 ,(format nil " \\phantom\{~a\} " (current-indentation))
		 ,(car (current-bullet-symbol))
		 " \\mbox{ else }"
		 ,last))
	      (else 
	       `( " \\mbox{ conditionally }  "
		  " \\newline "
		  ,(format nil " \\phantom\{~a\} " (current-indentation))
		  ,(car (current-bullet-symbol))
		  ,(map-alternate-insert
		    (list 
		     " \\newline "
		     (format nil " \\phantom\{~a\} " (current-indentation))
		     (car (current-bullet-symbol)))
		    (lambda (x) (list " \\mbox{ if }" (car x) " \\mbox{ then }" (cadr x)))
		    args)
		  " \\newline "
		  ,(format nil " \\phantom\{~a\} " (current-indentation))
		  ,(car (current-bullet-symbol))
		  " \\mbox{ otherwise }"
		  ,last)))))))


(make-presentation-format
 *tex-form* 'forall
 (list " \\forall " "\\forall ")
 present-tex-quantification-operator 50)

(make-presentation-format *tex-form* 'lambda " \\lambda "   
			  present-tex-lambda-abstraction 50)

(make-presentation-format *tex-form* 'if 'if  present-tex-conditional-formula 50)


(define (sexp-lambda-abstraction? sexp)
  (and (pair? sexp)
       (eq? (car sexp) 'lambda)))




(define (composite-presentation-method-for-tex
	 formatter op args binding-power)
  (if (and (sexp-lambda-abstraction? op)
	   (> (maximum-nesting-for-logical-expressions) 0))
      (present-let formatter op args binding-power)
      (present-application formatter op args binding-power)))

(define (present-application formatter op args binding-power)
  (if (every? short-sexp? args)
      (parenthesize-conditionally
       (> binding-power 200)
       `(,(present-tree formatter op 200)
	 \(
	 ,(alternate-insert
	   '\, (map (lambda (z) (present-tree formatter z 0)) args))
	 \) ))
      (parenthesize-conditionally
       (> binding-power 200)
       `(,(present-tree formatter op 200)
	 \(
	 " \\newline "
	 ,(map-alternate-insert
	   (format nil ", \\newline \\phantom\{~a\} " (current-indentation))
	   (lambda (z)(present-tree formatter z 0))
	   args)
	 \)))))
	   



(define (present-let-gather-typed-vars op)
  (let ((typing (cadr op)))
    (iterate iter ((typing typing)
		   (vars nil))
      (if (null? typing)
	  vars
	  (let ((type (caar typing)))
	    (iter (cdr typing)
		  (append
		   vars
		   (map
		    (lambda (v)
		      (cons v type))
		    (cdar typing)))))))))


(define (present-let formatter op args binding-power)
  (let ((vars-w-types (present-let-gather-typed-vars op)))
    `(" \\mbox\{ let \} "
      ,(alternate-insert
	"\\mbox\{  and \} "
	(map
	 (lambda (v+t arg)
	   (list
	    (car v+t)
	    " : "
	    (present-tex-sorting (cdr v+t) '#t)
	    "\\mbox\{  be \} "
	    (present-tree formatter arg 0)))
	 vars-w-types args))
      " \\mbox\{  in \} \\newline "
      ,(format nil " \\phantom\{~a\} " (current-indentation))
      ,(present-tree formatter (caddr op) 0))))

(set
 (composite-presentation-method *tex-form*)
 composite-presentation-method-for-tex)

(make-tex-correspondence "pi" "\\pi")
