;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald FP-PRINT)


(define fp-formatter (make-tree-formatter))

(define (define-fp-presentation name translation
	  presentation-method precedence)
  (make-presentation-format fp-formatter name translation
			    presentation-method precedence))

;;; Binders

(define (PRESENT-fp-BINDING-OPERATOR formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op)
    \{ ,(present-insert-commas (map present-fp-in-sort (car args)))
    " |~&",(present-tree formatter (cadr args) 0)
    \}))

(define (present-insert-commas l)
  (if (not (pair? l))
      l
      (iterate loop ((l (cdr l)) (x (list (car l))))
	(if (not (pair? l))
	    (reverse! x)
	    (loop (cdr l) (cons (car l) (cons '\, x)))))))

(define (present-fp-in-sort varsublist)
  (let ((vars (cdr varsublist))
	(sorting (car varsublist)))
    (list (present-insert-commas vars) ': (present-fp-sort sorting))))

;;; Add support for pairs.
(define (present-fp-sort sorting)
  (cond ((not (pair? sorting))		; Base sorts.
	 (if (eq? 'unit%sort sorting)
	     (list '\( '\) )
	     sorting))
	((null? (cddr sorting))		; Unary functions.
	 (let* ((domain (car sorting))
		(left (present-fp-sort domain)))
	   (list (if (and (pair? domain)
			  (null? (cddr domain)))
		     (list '\( left '\))
		     left)
		 '-> (present-fp-sort (cadr sorting)))))
	((and (null? (cdddr sorting))	; Pairs.
	      (eq? 'unit%sort (caddr sorting)))
	 (list '\( (present-insert-commas (present-pair-sort sorting)) '\)))
	(else
	 (list '\{ (present-insert-commas
		    (map present-fp-sort sorting)) '\}))))

(define (present-pair-sort s)
  (cons
   (present-fp-sort (car s))
   (let ((s (cadr s)))
     (if (and (pair? s)
	      (not (null? (cddr s)))
	      (null? (cdddr s))
	      (eq? 'unit%sort (caddr s)))
	 (present-pair-sort s)
	 (list (present-fp-sort s))))))

(define (define-fp-binding-presentation name translation)
  (define-fp-presentation name translation
    present-fp-binding-operator 190))

(define-fp-binding-presentation 'forall 'for_all)
(define-fp-binding-presentation 'forsome 'for_some)
(define-fp-binding-presentation 'lambda 'lambda)
(define-fp-binding-presentation 'with 'with)
(define-fp-binding-presentation 'iota 'iota)
(define-fp-binding-presentation 'iota-p 'iota_p)
(define-fp-binding-presentation 'undefined-of-sort 'undefined_of_sort)
(define-fp-binding-presentation 'is-defined-in 'is_defined_in)

;;; Condize

(define (PRESENT-fp-if formatter op args bp)
  (ignore bp)
  (iterate loop ((args args)(accum '()))
    (let ((1st (present-tree formatter (car args) 0))
	  (2nd (present-tree formatter (cadr args) 0))
	  (3rd (caddr args)))
      (if (and (list? 3rd)
	       (eq? (car 3rd) op))
	  (loop (cdr 3rd) `( (,1st \, " " ,2nd ) ,@accum))
	  (let ((accum `( ,(present-tree formatter 3rd 0) 
			  (,1st \, " " ,2nd) ,@accum)))
	    (if (= (length accum) 2)
		`(,(car (presentation-format formatter op))
		  \{ ,@(map-alternate-insert  (list '\, " ") identity (reverse! accum)) \})
		`("~&" ,(cadr (presentation-format formatter op))
		       \{ "~&  ",(map-alternate-insert
				  (list '\, "~&  ")
				  identity
				  (reverse! accum)) \} "~&")))))))

(define (define-fp-if-presentation name translation)
  (define-fp-presentation name translation
    present-fp-if 190))
(define-fp-if-presentation 'if-form '(if_form if_form))
;; (define-fp-if-presentation 'if-term '(if if))
(define-fp-if-presentation 'if '(if if))
(define-fp-if-presentation 'if-pred '(if if))
;; formerly
;; (define-fp-if-presentation 'if-pred '(if_pred if_pred))
;; 
(define-fp-presentation '++ '++ present-non-associative-infix-operator 90)
;; true, false, and an%individual not done.

(define-fp-presentation 'not 'not present-prefix-operator 70)
(define-fp-presentation 'and " and "  present-nary-infix-operator 65)
(define-fp-presentation 'or " or "  present-nary-infix-operator 60)
(define-fp-presentation 'implies  " ~& implies~&"
  present-non-associative-infix-operator 55)
(define-fp-presentation 'iff  " iff "
  present-non-associative-infix-operator 55)

(define-fp-presentation '^ '^  present-non-associative-infix-operator 140)
(define-fp-presentation '* '* present-binary-infix-operator 120)
(define-fp-presentation '/ '/ present-non-associative-infix-operator 120)

(define-fp-presentation '+ '+ present-binary-infix-operator 100)
(define-fp-presentation '- '- present-loglike-operator 100)
(define-fp-presentation 'sub '- present-subtraction-operator  100)

(define-fp-presentation '= '= present-non-associative-infix-operator 80)
(define-fp-presentation '> '> present-non-associative-infix-operator 80)
(define-fp-presentation '< '< present-non-associative-infix-operator 80)
(define-fp-presentation '>= '>= present-non-associative-infix-operator 80)
(define-fp-presentation '<= '<= present-non-associative-infix-operator 80)
(define-fp-presentation '== '== present-non-associative-infix-operator 80)

(define (PRESENT-fp-is-DEFINED-IN-SORT formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally
     (> bp weight)
     (list
      (present-tree formatter (car args) 0)
      ':
      (present-fp-sort (cadr args))))))

(define-fp-presentation 'is-defined-in-sort ':
  present-fp-is-defined-in-sort 75)
(define-fp-presentation 'is-defined ':* present-postfix-operator 75)

;;; Pairs

(define (present-fp-pair formatter op args bp)
  (ignore op bp)
  (list '\( (present-insert-commas
	     (present-pairs formatter args)) '\)))
  
(define (present-pairs formatter args)
  (cons (present-tree formatter (car args) 0)
	(let ((rest (cadr args)))
	  (if (and (pair? rest)
		   (eq? 'pairs (car rest)))
	      (present-pairs formatter (cdr rest))
	      (list (present-tree formatter rest 0))))))

(define-fp-presentation 'pair 'pair present-fp-pair 180)

;;; Sequences

(define (present-fp-cons formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (cond ((sequence-sort (cadr args))
	   => (lambda (sort)
		(list '\[
		      (present-insert-commas
		       (present-sequence formatter args))
		      '\]
		      (parenthesize-conditionally
		       (> bp weight)
		       (present-fp-sort sort)))))
	  (else
	   (list 'cons '\(
		 (present-tree formatter (car args) 0) '\,
		 (present-tree formatter (cadr args) 0) '\))))))

(define (sequence-sort obj)		; => #f or sort
  (and (pair? obj)
       (or (and (eq? 'nil (car obj))
		(cadr obj))
	   (and (eq? 'cons (car obj))
		(sequence-sort (caddr obj))))))

(define (present-sequence formatter args)
  (cons (present-tree formatter (car args) 0)
	(let ((rest (cadr args)))
	  (if (eq? 'nil (car rest))
	      '()
	      (present-sequence formatter (cdr rest))))))

(define-fp-presentation 'cons 'cons present-fp-cons 180)

(define (present-fp-nil formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (list '\[ '\] 
	  (parenthesize-conditionally (>= bp weight)
				      (present-fp-sort (car args))))))

(define-fp-presentation 'nil 'nil present-fp-nil 180)


(define-fp-presentation 'total? 'is_total
  present-prefix-operator 160)
(define-fp-presentation 'vacuous? 'is_vacuous
  present-prefix-operator 160)
(define-fp-presentation 'reflexive? 'is_reflexive
  present-prefix-operator 160)
(define-fp-presentation 'transitive? 'is_transitive
  present-prefix-operator 160)
(define-fp-presentation 'antisymmetric? 'is_antisymmetric
  present-prefix-operator 160)
(define-fp-presentation 'comparable? 'is_comparable
  present-prefix-operator 160)
(define-fp-presentation 'partial-order? 'is_partial_order
  present-prefix-operator 160)
(define-fp-presentation 'linear-order? 'is_linear_order
  present-prefix-operator 160)
(define-fp-presentation 'upper-bound? 'is_upper_bound
  present-prefix-operator 160)
(define-fp-presentation 'chain? 'is_chain
  present-prefix-operator 160)
(define-fp-presentation 'cpo? 'is_cpo
  present-prefix-operator 160)
(define-fp-presentation 'monotone? 'is_monotone
  present-prefix-operator 160)
(define-fp-presentation 'continuous? 'is_continuous
  present-prefix-operator 160)
(define-fp-presentation 'sub-function 'sub_function
  present-prefix-operator 160)

(define (fp-print sexp port)
  (write (output-port->imps-output-port port fp-formatter) sexp)
  (write-char port #\;))
