;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



; "Optional problem"  
;
; You may want to try the generalized power rule, about the derivative of
; f(x)^n.  The proof is similar, except that you will have to take cases (using
; the command case-split) on whether #(f(x)) at a couple points in the proof.
; You will also need to use "eta-reduction" to reduce lambda(x:rr,f(x)) to f a
; few times.  You will find it in the macete menu under the name
; tr%unary-eta-reduction (it is "transportable" to any logical theory, but
; handles only "unary" or one-place functions).  

(def-theorem GENERALIZED-POWER-RULE
  "forall(n:zz,f:[rr,rr], x:rr, 
     #(D(f)(x)) and 2<=n implies D(lambda(x:rr,f(x)^n))(x)=n*f(x)^(n-1)*D(f)(x))"
  (theory calculus-theory)
  (proof
   (
    direct-and-antecedent-inference-strategy
    (induction integer-inductor ("n"))
    (force-substitution "f(x)^2" "lambda(x:rr,f(x))(x)*lambda(x:rr,f(x))(x)" (0))
    (apply-macete-with-minor-premises product-rule)
    (apply-macete-with-minor-premises tr%unary-eta-reduction)
    (cut-with-single-formula "#(f(x))")
    simplify
    (apply-macete-with-minor-premises definedness-of-differentiable-fns)
    (apply-macete-with-minor-premises tr%unary-eta-reduction)
    (case-split ("#(f(x))"))
    simplify
    simplify
    (force-substitution "f(x)^(1+t)" "f(x)^t*f(x)" (0))
    (force-substitution "f(x)^t" "lambda(x:rr,f(x)^t)(x)" (0))
    (apply-macete-with-minor-premises product-rule)
    beta-reduce-repeatedly
    simplify
    simplify
    (case-split ("#(f(x))"))
    simplify
    simplify


    )))


; PART IV: Build a Macete for Symbolic Differentiation
;
; The remainder of this exercise is devoted to showing how to use macetes to
; carry out symbolic computations.  In particular, we will build a macete to 
; perform symbolic differentiation of polynomials.
;
; We first introduce a pair of "non-directional, schematic" macetes.  They use
; matching and substitution procedures which do not respect the normal scoping
; rules for binding operators.  Hence, the result is not necessarily logically 
; related to the argument.  How can such a macete possibly be useful?  See below.

(def-schematic-macete ABSTRACTION-FOR-DIFF-SUM
  "with(a,b:rr,y:rr,D(lambda(x:rr,a+b))(y)
	=D(lambda(x:rr,lambda(x:rr,a)(x)+lambda(x:rr,b)(x)))(y))"
  ;; 
  ;; non-directional:
  null
  (theory calculus-theory))

(def-schematic-macete ABSTRACTION-FOR-DIFF-PROD
  "with(a,b:rr,y:rr,D(lambda(x:rr,a*b))(y)
	=D(lambda(x:rr,lambda(x:rr,a)(x)*lambda(x:rr,b)(x)))(y))"
  ;; 
  ;; non-directional:
  null					
  (theory calculus-theory))

; Given a context C and an expression E_0, the macetes
;
; ABSTRACTION-FOR-DIFF-PROD
; ABSTRACTION-FOR-DIFF-SUM
;
; applied in series construct an "abstracted expression" E_1.
;
; To make this logically safe, we supply a pair of macetes that *are* guaranteed
; to preserve value:  They serve as "checks".  One is applied to E_0, and the
; other is E_1.  If the results are equal, then we have validated that E_0=E_1.
; Hence in the case, the safe macete can return E_1; otherwise, it returns E_0,
; which is certainly safe.
;
; For these two macetes, the checks are simply to beta reduce repeatedly.  

(def-compound-macete ABSTRACTION-FOR-DIFF-SAFE
  (sound
   (series abstraction-for-diff-prod abstraction-for-diff-sum)
   beta-reduce-repeatedly
   beta-reduce-repeatedly))


(def-compound-macete CALCULUS-RULES
  (series
    (repeat
     diff-constant
     diff-identity
     power-rule
     sum-rule
     product-rule
     abstraction-for-diff-safe
     sum-rule
     product-rule)
    simplify
    definedness-of-differentiable-fns))

; Example: compute the value of with(y:rr, y=D(lambda(x:rr,6*x^3+7*x+5))(12)).
; To do this start a deduction with this goal:
 
(view-expr "with(y:rr, y=D(lambda(x:rr,6*x^3+7*x+5))(12))" tex)

;
; Apply the macete "calculus-rules". This should produce new subgoals:
;
;  (a) One of the goals is "with(y:rr, y=SOME-NUMBER)"
;      where SOME-NUMBER stands for a numeral.
;
;  (b) The remaining goals are definedness assertions which can themselves be
;      knocked off with "calculus-rules".
;
; Note that we are NOT trying to prove that any y:rr has the same value
; as D(lambda(x:rr,6*x^3+7*x+5))(12).  Rather, we're REDUCING the assertion that
; y=D(lambda(x:rr,6*x^3+7*x+5))(12) to the assertion that y=SOME-NUMBER.


; PART V: Optional Exercise
; 
; The following exercise is somewhat more difficult than the preceding ones.
; Prove:

(def-theorem ()
  "forall(n:zz,a:[zz,rr],1<=n and forall(j:zz,1<=j and j<=n implies #(a(j))) 
              implies 
            D(lambda(z:rr,sum(1,n,lambda(j:zz,a(j)*z^j))))=
              lambda(z:rr,a(1)+sum(2,n,lambda(j:zz,j*a(j)*z^(j-1)))))"
  (theory calculus-theory)
  (proof
   (
    (induction integer-inductor ("n"))
    direct-and-antecedent-inference-strategy
    extensionality
    (apply-macete-with-minor-premises calculus-rules)
    (apply-macete-with-minor-premises calculus-rules)
    (apply-macete-with-minor-premises calculus-rules)
    extensionality
    (apply-macete-with-minor-premises calculus-rules)
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=t implies #(a(j)))
   implies 
  d(lambda(z:rr,sum(1,t,lambda(j:zz,a(j)*z^j))))
  =lambda(z:rr,
     a(1)+sum(2,t,lambda(j:zz,a(j)*z^([-1]+j)*j))));")
    direct-and-antecedent-inference-strategy
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=1+t implies #(a(j))));")
    simplify
    simplify
    simplify
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=1+t implies #(a(j))));")
    simplify
    (apply-macete-with-minor-premises calculus-rules)
    (apply-macete-with-minor-premises diff-constant)
    beta-reduce-repeatedly
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=t implies #(a(j)))
   implies 
  d(lambda(z:rr,sum(1,t,lambda(j:zz,a(j)*z^j))))
  =lambda(z:rr,
     a(1)+sum(2,t,lambda(j:zz,a(j)*z^([-1]+j)*j))));")
    direct-and-antecedent-inference-strategy
    simplify
    direct-and-antecedent-inference-strategy
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=t implies #(a(j))));")
    simplify
    definedness
    direct-and-antecedent-inference-strategy
    definedness
    definedness
    (backchain "with(a:[zz,rr],t:zz,
  forall(j:zz,1<=j and j<=t implies #(a(j))));")
    simplify
    simplify
    (apply-macete-with-minor-premises calculus-rules)


    )))




