;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald LCT-OBLIGATIONS)


(def-theorem LCT-OBLIGATION-1
  "#(restrict2{mul,b,b},[b%sort,b%sort,b%sort])"
  lemma
  (theory lct-theory)
  (proof
   (
    sort-definedness
    simplify
    (apply-macete-with-minor-premises b%sort-defining-axiom_lct-theory)
    (apply-macete-with-minor-premises lct-macete)
    )))

(def-theorem LCT-OBLIGATION-2
  "#(restrict{inv,b},[b%sort,b%sort])"
  lemma
  (theory lct-theory)
  (proof
   (
    sort-definedness
    simplify
    (apply-macete-with-minor-premises b%sort-defining-axiom_lct-theory)
    (apply-macete-with-minor-premises lct-macete)
    )))

(def-theorem LCT-OBLIGATION-3
  "#(restrict2{right%trans,a%cosets,b},[a%cosets%sort,b%sort,a%cosets%sort])"
  lemma
  (theory lct-theory)
  (proof
   (
    sort-definedness
    direct-inference
    (case-split ("#(xx_0,sets[gg])"))
    simplify
    (unfold-single-defined-constant-globally a%cosets)
    simplify
    direct-and-antecedent-inference-strategy
    (apply-macete-with-minor-premises a%cosets%sort-defining-axiom_lct-theory)
    simplify
    (unfold-single-defined-constant-globally a%cosets)
    simplify
    (backchain "with(g:gg,xx_0:sets[gg],xx_0=right%trans(a,g))")
    (instantiate-existential ("g mul xx_1"))
    (apply-macete-with-minor-premises lct-macete)
    (apply-macete-with-minor-premises simplify-set-translations)
    simplify
    )))

(def-theorem LCT-OBLIGATION-4
  "forall(x:b%sort,if(x in b, x, ?gg)=x)"
  lemma
  (theory lct-theory)
  (proof
   (
    (raise-conditional (0))
    direct-and-antecedent-inference-strategy
    (contrapose "with(x:b%sort,not(x in b))")
    (apply-macete-with-minor-premises b%sort-members-are-in-b)
    )))

(def-theorem LCT-OBLIGATION-5
  "forall(x:b%sort,
     restrict2{mul,b,b}(if(x in b, inv(x), ?gg),x)=e)"
  lemma
  (theory lct-theory)
  (proof
   (

    simplify
    direct-and-antecedent-inference-strategy
    (block 
     (script-comment 
      "node added by `direct-and-antecedent-inference-strategy' at (0)")
     insistent-direct-inference
     (apply-macete-with-minor-premises b%sort-members-are-in-b))
    (apply-macete-with-minor-premises lct-macete)

    ;; (raise-conditional (0))
    ;; simplify
    ;; (raise-conditional (0))
    ;; direct-and-antecedent-inference-strategy
    ;; insistent-direct-inference
    ;; (apply-macete-with-minor-premises b%sort-members-are-in-b)
    ;; (contrapose "with(x:b%sort,not(inv(x) in b))")
    ;; (apply-macete-with-minor-premises lct-macete)

    )))

(def-theorem LCT-OBLIGATION-6
  "forall(x:b%sort,
     restrict2{mul,b,b}(x,if(x in b, inv(x), ?gg))=e)"
  lemma
  (theory lct-theory)
  (proof
   (

    simplify
    direct-and-antecedent-inference-strategy
    (block 
     (script-comment 
      "node added by `direct-and-antecedent-inference-strategy' at (0)")
     insistent-direct-inference
     (apply-macete-with-minor-premises b%sort-members-are-in-b))
    (apply-macete-with-minor-premises lct-macete)

    ;; (raise-conditional (0))
    ;; simplify
    ;; (raise-conditional (0))
    ;; direct-and-antecedent-inference-strategy
    ;; insistent-direct-inference
    ;; (apply-macete-with-minor-premises b%sort-members-are-in-b)
    ;; (contrapose "with(x:b%sort,not(inv(x) in b))")
    ;; (apply-macete-with-minor-premises lct-macete)

    )))

(def-theorem LCT-OBLIGATION-7
  "forall(x,y,z:b%sort,
     restrict2{mul,b,b}(if(x in b and y in b, x mul y, ?gg),z)
     =restrict2{mul,b,b}(x,if(y in b and z in b, y mul z, ?gg)))"
  lemma
  (theory lct-theory)
  (proof
   (

    simplify
    direct-and-antecedent-inference-strategy
    (block 
     (script-comment 
      "node added by `direct-and-antecedent-inference-strategy' at (0)")
     insistent-direct-inference
     (apply-macete-with-minor-premises b%sort-members-are-in-b))
    (apply-macete-with-minor-premises lct-macete)

    ;; direct-inference
    ;; (case-split-on-conditionals (0))
    ;; (case-split-on-conditionals (0))
    ;; (case-split-on-conditionals (0))
    ;; (contrapose "with(p:prop, not(p))")
    ;; (apply-macete-with-minor-premises lct-macete)
    ;; (contrapose "with(p:prop, not(p))")
    ;; (apply-macete-with-minor-premises lct-macete)
    ;; (apply-macete-with-minor-premises b%sort-members-are-in-b)
    ;; (contrapose "with(p:prop, not(p))")
    ;; (apply-macete-with-minor-premises b%sort-members-are-in-b)

    )))

(def-theorem LCT-OBLIGATION-8
  "forall(alpha:a%cosets%sort,
     if(alpha in a%cosets, alpha, ?sets[gg])=alpha)"
  lemma
  (theory lct-theory)
  (proof
   (
    (raise-conditional (0))
    direct-and-antecedent-inference-strategy
    (contrapose "with(p:prop, not(p))")
    (apply-macete-with-minor-premises a%cosets%sort-members-are-in-a%cosets)
    )))

(def-theorem LCT-OBLIGATION-9
  "forall(alpha:a%cosets%sort,g,h:b%sort,
     restrict2{right%trans,a%cosets,b}(alpha,if(g in b and h in b, g mul h, ?gg))
     =restrict2{right%trans,a%cosets,b}
        (if(alpha in a%cosets and g in b,right%trans(alpha,g),?sets[gg]),h))"
  lemma
  (theory lct-theory)
  (proof
   (
    direct-inference
    (raise-conditional (0))
    (raise-conditional (0))
    (raise-conditional (0))
    simplify
    (raise-conditional (0))
    (raise-conditional (0))
    simplify
    direct-and-antecedent-inference-strategy
    (apply-macete-with-minor-premises b%sort-members-are-in-b)
    (apply-macete-with-minor-premises b%sort-members-are-in-b)
    (apply-macete-with-minor-premises a%cosets%sort-members-are-in-a%cosets)
    (apply-macete-with-minor-premises lct-macete)
    (incorporate-antecedent "with(alpha:a%cosets%sort,alpha in a%cosets)")
    (unfold-single-defined-constant-globally a%cosets)
    simplify
    direct-and-antecedent-inference-strategy
    (backchain "with(g_$0:gg,alpha:a%cosets%sort,alpha=right%trans(a,g_$0))")
    (instantiate-existential ("g_$0 mul g"))
    (apply-macete-with-minor-premises lct-macete)
    (apply-macete-with-minor-premises simplify-set-translations)
    (apply-macete-with-minor-premises simplify-set-translations)
    )))



