;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald ORDER)


;Transforms for simplification of expressions involving order.
;we are assuming scalars-type of processor is a basic-numerical-type
;with order relations <,<=.
;This makes sense only for certain numerical data types and if
;(processor-faithful-numeral-representation processor) is '#t.

(define-operation (PROCESSOR-DISCRETE-SORTS processor)
  (enforce processor? processor)
  '())

(define-integrable discrete-sorts processor-discrete-sorts)
 
(define-structure-type ORDER-PROCESSOR
  <=r
  <r
  discrete-sorts
  sum-partitioner
  algebraic-processor
  handled-operators
  reduced-terms 
  (((algebraic-sub-processor soi) (order-processor-algebraic-processor soi))
   ((processor-simplify processor expr params)
    (order-processor-simplify processor expr params))
   ((processor-discrete-sorts processor) (order-processor-discrete-sorts processor))
   ((processor-reduced-terms soi) (order-processor-reduced-terms soi))
   ((partition-summation processor expr params)
    ((order-processor-sum-partitioner processor) processor expr params))
   ((processor-validity-conditions processor)
    (append (order-processor-validity-conditions processor)
	    (processor-validity-conditions (order-processor-algebraic-processor processor))))
   ((processor? soi) '#t)))


(define (ORDER-PROCESSOR-SIMPLIFY processor expr params)
  (if (processor-reduced? processor expr params) expr
      (select (operator expr)
	(((<r processor))
	 (annotate-expression-as-reduced processor (simp< processor expr params) params))
	(((<=r processor))
	 (annotate-expression-as-reduced processor (simp<= processor expr params) params))
	(else (simplify-by-transforms 
	       (processor-parameters-context params)
	       expr
	       (processor-parameters-persistence params))))))

(define (ORDER-PROCESSOR-SIMPLIFY-WITH-REQUIREMENTS processor context expr persist)
  (if (and (application? expr)
	   (memq (operator expr)
		 (order-processor-handled-operators processor)))
      (let ((pars (make-processor-parameters)))
	(set (processor-parameters-persistence pars) persist)
	(set (processor-parameters-context pars) context)
	;;    (set (processor-parameters-base-sort pars) (base-sort processor))
	(let ((simplified
	       (order-processor-simplify processor expr pars)))
	  (return simplified (processor-parameters-requirements pars) '#t)))
      (return expr '() '#f)))

(define (<r processor) (order-processor-<r processor))
(define (<=r processor) (order-processor-<=r processor))

(define (BUILD-ORDER-PROCESSOR-FROM-ALGEBRAIC-PROCESSOR
	 algebraic-processor operations-alist discrete-sorts) 	 
  (let ((<r-op (cadr (assq '< operations-alist)))	
	(<=r-op (cadr (assq '<= operations-alist)))
	(processor (make-order-processor)))
    (set (order-processor-reduced-terms processor) (make-table))
    (set (order-processor-algebraic-processor processor) algebraic-processor)
    (set (order-processor-<r processor) <r-op)
    (set (order-processor-<=r processor) <=r-op)
    (set (order-processor-sum-partitioner processor) default-summation-partitioner)
    (set (order-processor-discrete-sorts processor) discrete-sorts)
    (set (order-processor-handled-operators processor)
	 (let ((accum '()))
	   (if <r-op (push accum <r-op))
	   (if <=r-op (push accum <=r-op))
	   accum))
    processor))

(define (ASSERT-SORT-DISCRETENESS processor sort)
  (let* ((n (find-variable 'n sort))
	 (m (find-variable 'm sort))
	 (1-sort (number->scalar-constant processor 1))
	 (formula (biconditional
			(apply-operator (<r processor) m n)
			(apply-operator
			 (<=r processor)
			 (apply-operator (+r processor) m 1-sort)
			 n))))
    formula))

(define (ORDER-PROCESSOR-VALIDITY-CONDITIONS processor)
  (let* ((0-sort (number->scalar-constant processor 0))
	 (formulas '())
	 (sort (car (higher-sort-domains (expression-sorting (+r processor)))))
	 (x (find-variable 'x sort))
	 (y (find-variable 'y sort))
	 (z (find-variable 'z sort))
	 (+op (lambda (a b) (apply-operator (+r processor) a b)))
	 (*op (lambda (a b) (apply-operator (*r processor) a b)))
	 (<=op (lambda (a b) (apply-operator (<=r processor) a b)))
	 (<op (lambda (a b) (apply-operator (<r processor) a b))))
    (or (and  (*r processor)
	      (or (sub-r processor) (-r processor))
	      (processor-cancellation-valid? processor))
	(imps-error "Algebraic structure is not a commutative integral domain containing an isomorphic copy of the integers."))
    (if (<r processor)
	(block
	  (push formulas (equality (*op x y) (*op y x)))
	  (push formulas (disjunction (<op x y) (equality x y) (<op y x)))
	  (push formulas (implication (conjunction (<op x y) (<op y z))
				      (<op x z)))
	  (push formulas (biconditional (<op x y) (<op (+op x z) (+op y z))))
	  (push formulas (implication (conjunction (<op 0-sort x) (<op 0-sort y))
				      (<op 0-sort (*op x y))))
	  (push formulas (negation (<op 0-sort 0-sort)))))
    
    ;;;In case the subtraction operator exists, this also implies
    ;;;that 0<x and y<0 implies x*y<0.
    ;;;Thus 
    ;;;      0<x implies 0<x*y iff 0<y
    ;;;      0<x implies x*y<0 iff y<0

    (if (<=r processor)
	(block
	  (push formulas (implication (conjunction (<=op x y) (<=op y z))
				      (<=op x z)))
	  (push formulas (biconditional (<=op x y) (<=op (+op x z) (+op y z))))
	  (push formulas (implication (conjunction (<=op 0-sort x) (<=op 0-sort y))
				      (<=op 0-sort (*op x y))))
	  (if (not (<r processor))
	      (block
		(push formulas (biconditional (equality x y)
					    (conjunction (<=op x y) (<=op y x))))
		(push formulas (disjunction (<=op x y) (equality x y) (<=op y x)))))
							 
	  (if (<r processor)
	      (push formulas
		    (biconditional (<=op x y) (disjunction (equality x y) (<op x y)))))))
    (if (and (<=r processor) (<r processor))
	(walk
	 (lambda (x) (push formulas (assert-sort-discreteness processor x)))
	 (processor-discrete-sorts processor)))
    formulas))

;;; Prior processing of expressions:


(define (remove-factor-from-list elt a-list)
  (iterate loop ((rem-list a-list) (accum '()))
    (if (null? rem-list)
	a-list
	(if (alpha-equivalent? (car rem-list) elt)
	    (append (reverse! accum) (cdr rem-list))
	    (loop (cdr rem-list) (cons (car rem-list) accum))))))
	
(define (factor-in-list? factor a-list)
  (mem? alpha-equivalent? factor a-list))

(define (context-immediately-entails-sign? processor context expr)

  ;;;returns +1,-1,0 or '#f



  (let ((0-elt (number->scalar-constant processor 0)))
    (let ((pos? (apply-operator (<r processor) 0-elt expr)))

	(if (context-immediately-entails? context pos?) 1
	  (let ((0? (equality 0-elt expr)))
	    (if (context-immediately-entails? context 0?) 0
		(let ((neg? (apply-operator (<r processor) expr 0-elt)))
		  (if (context-immediately-entails? context neg?)
		      -1
		      '#f))))))))


(define (simplify-and-list-factors processor term params)
  (apply append
	 (map (lambda (mon)
		(let ((simp (algebraic-processor-simplify
			     (algebraic-sub-processor processor)
			     mon
			     params)))
		  (if (multiplication? processor simp)
		      (associative-arguments simp)
		      (list simp))))
	      (if (multiplication? processor term)
		  (associative-arguments term)
		  (list term)))))

(define (subtract-rh-summands-from-lh-summands processor arg1 arg2)
  (let ((neg-1 (number->scalar-constant processor -1))
	(accum '()))
    (walk (lambda (x) (if (not (scalar-constant-=0? processor x))
			  (push accum x)))
	  (if (addition? processor arg1)
	      (associative-arguments arg1)
	      (list arg1)))
    
    (walk (lambda (f) (if (not (scalar-constant-=0? processor f))
			  (push accum (apply-operator (*r processor) neg-1 f))))
	  (if (addition? processor arg2)
	      (associative-arguments arg2)
	      (list arg2)))
    (reverse! accum)))


(define (REMOVE-COMMON-FACTORS processor exprs params)

  ;;;returns an EXPR and a SIGN (+1 -1 0)

  (let ((context (processor-parameters-context params))
	(sum-prods (map (lambda (x) (simplify-and-list-factors processor x params)) exprs)))
  
    (iterate loop ((common-factors '())
		   (total-sign 1)
		   (factored sum-prods)
		   (possible-factors (car sum-prods)))
      (if (null? possible-factors)
	  (return
	   (form-sum-expression
	    processor
	    (map (lambda (x) (form-product-expression processor x)) factored))
	   total-sign)
	  (if (and (not (scalar-constant? processor (car possible-factors)))
		   (every? (lambda (x)
			(factor-in-list? (car possible-factors) x)) factored))
	      (let ((sign (context-immediately-entails-sign? processor context (car possible-factors))))
		(if sign
		    (loop (cons (car possible-factors) common-factors)
			  (fx* sign total-sign)
			  (map (lambda (x) (remove-factor-from-list (car possible-factors) x))				 factored)
			  (cdr possible-factors))
		    (loop common-factors total-sign factored (cdr possible-factors))))
	      (loop common-factors total-sign factored (cdr possible-factors)))))))



(define (SIMP< processor expr params)

  ;;Will only be called if (<r processor) is non-nil.
  (if (sub-r processor)
      (let ((exprs (subtract-rh-summands-from-lh-summands processor (1starg expr) (2ndarg expr))))
	(receive (lhs sign)
	  (remove-common-factors processor exprs params)
	  (let ((lhs (algebraic-processor-simplify
		      (algebraic-sub-processor processor)
		      lhs
		      params)))
	    (if (scalar-constant? processor lhs)
		(if (< (* sign (scalar-constant->numerical-object processor lhs)) 0)
		    truth falsehood)
		(if (zero? sign) falsehood;;no need to worry about definedness

		    (block
;;;		      (if (< 0 (processor-parameters-persistence params))
;;;			  (enrich-context-with-inequality-instances-containing-hot-subterms
;;;			   processor
;;;			   lhs
;;;			   params))
		      (cond ((context-entails-linear-inequality?
			      processor
			      (if (< 0 sign)
				  (apply-operator (<r processor)
						  lhs
						  (number->scalar-constant processor 0))

				;;;unless the sign was negative

				  (apply-operator (<r processor)
						  (number->scalar-constant processor 0)
						  lhs))
			      params)
			     truth)
			    ((context-entails-linear-inequality?
			      processor
			      (if (< 0 sign)
				  (apply-operator (<=r processor)
						  (number->scalar-constant processor 0)
						  lhs)
				  (apply-operator (<=r processor)
						  lhs
						  (number->scalar-constant processor 0)))
			      params)
			     falsehood)
			    ((< 0 sign)
			     (apply-invariant-binop processor (<r processor) lhs params))
			    (else 
			     (apply-invariant-binop-reverse processor (<r processor) lhs params)))))))))
      expr))

(define (SIMP<= processor expr params)
  ;;Will only be called if (<=r processor) is non-nil.
  (if (sub-r processor)
      (let ((exprs (subtract-rh-summands-from-lh-summands processor (1starg expr) (2ndarg expr))))
	(receive (lhs sign)
	  (remove-common-factors processor exprs params)
	  (let ((lhs (algebraic-processor-simplify
		      (algebraic-sub-processor processor)
		      lhs
		      params)))
	    (if (scalar-constant? processor lhs)

		;;if sign = 0 can't conclude truth because of pending definedness issues.

		(if (<= (* sign (scalar-constant->numerical-object processor lhs)) 0)
		    truth falsehood)
	
		(block
;;;		  (if (< 0 (processor-parameters-persistence params))
;;;		      (enrich-context-with-inequality-instances-containing-hot-subterms
;;;		       processor
;;;		       lhs
;;;		       params))
;;;	      
		  (cond ((context-entails-linear-inequality?
			  processor
			  (if (< 0 sign)
			      (apply-operator (<=r processor)
					      lhs
					      (number->scalar-constant processor 0))
			      (apply-operator (<=r processor)
					      (number->scalar-constant processor 0)
					      lhs))
			  
			  params)
			 truth)
			((context-entails-linear-inequality?
			  processor
			  (if (< 0 sign)
			      (apply-operator (<r processor)
					      (number->scalar-constant processor 0)
					      lhs)
			      (apply-operator (<r processor)
					      lhs
					      (number->scalar-constant processor 0)
					      ))
			  params)

			 ;;if sign happens to be zero, then clearly
			 ;;simp<= should return truth.
			      
			 (if (zero? sign)
			     truth
			     falsehood))
			((< 0 sign) (apply-invariant-binop processor (<=r processor) lhs params))

			(else (apply-invariant-binop-reverse processor (<=r processor) lhs params))

			))))))
      expr))

;In the following, expr is assumed to be a simplified expression. 
;Partition-summation returns two values, each being a
;list of terms: the immediate arithmetic+ subterms of expr with positive 
;coefficients, the immediate arithmetic+ subterms of expr with negative coefficients.
;op is a binary operator with the property that op(a,b)=op(a-b,0)
;expr is a simplified expression with positive and negative coefficients.

(define (APPLY-INVARIANT-BINOP processor op expr params)
  (receive (args1 args2) (partition-summation processor expr params)
	   (apply-operator op args1 args2)))

(define (APPLY-INVARIANT-BINOP-REVERSE processor op expr params)
  (receive (args1 args2) (partition-summation processor expr params)
	   (apply-operator op args2 args1)))

;;;(define (DEFAULT-SUMMATION-PARTITIONER processor expr)
;;;  
;;;  (let ((args (if (addition? processor expr) (associative-arguments expr)
;;;		  (list expr))))
;;;    (iterate loop ((args args) (pos '()) (neg '()))
;;;
;;;      ;pos, neg are lists each element of which is either
;;;      ; (a) a term
;;;      ; (b) a list (num t) where num is a lisp number and t is a term.
;;;      ;     These lists are obtained by walking through
;;;      ;     the immediate arithmetic+ subterms of expr and
;;;      ;     collecting terms with positive coefficients into pos,
;;;      ;     and those with negative coefficients into neg, separating
;;;      ;     the coefficient of a term from the remainder of the term.
;;;
;;;	(cond ((null? args)
;;;	       (receive (pos neg)
;;;		 (normalize-coefficients processor pos neg)
;;;		 (return
;;;		  (insistently-apply-handler-transforms
;;;		   (processor-handler processor) pos)
;;;		  (insistently-apply-handler-transforms
;;;		  (processor-handler processor) neg))))
;;;	      ((scalar-constant? processor (car args))
;;;	       (if (< (scalar-constant->numerical-object processor (car args)) 0)
;;;		   (loop (cdr args)
;;;			 pos
;;;			 (cons (number->scalar-constant processor
;;;							(* -1 (scalar-constant->numerical-object processor (car args))))
;;;			       neg))
;;;		   (loop (cdr args)
;;;			 (cons (car args) pos)
;;;			 neg)))
;;;	       ((and (multiplication? processor (car args))
;;;		     (scalar-constant? processor (car (associative-arguments (car args)))))
;;;		
;;;		 ;(scalar-constant? processor (1starg (car args))) won't work
;;;		 ;because simplifier left associates multiplication. So
;;;		 ;if (car args) is a multiplication const*a*b const will not be
;;;		 ;a term at the top level.
;;;		(let* ((assoc-args (associative-arguments (car args)))
;;;		       (coeff (car assoc-args)))
;;;		  (if (< (scalar-constant->numerical-object processor coeff) 0)
;;;		      (loop (cdr args)
;;;			    pos
;;;			    (cons (if (= (scalar-constant->numerical-object processor coeff) -1)
;;;				      (form-product-expression
;;;				       processor (cdr assoc-args))
;;;				      (list
;;;				       (* -1 (scalar-constant->numerical-object processor coeff))
;;;				       (form-product-expression processor
;;;								(cdr assoc-args))))
;;;				  neg))
;;;		      
;;;			     (loop (cdr args)
;;;				   (cons (list (scalar-constant->numerical-object processor coeff)
;;;					       (form-product-expression
;;;						processor
;;;						(cdr assoc-args)))
;;;					 pos)
;;;				   neg))))
;;;	      (else (loop (cdr args) (cons (car args) pos) neg))))))
;;;
;;;;pos neg are lists of elements each of which is a term or a list (scalar term)
;;;;In case of a list, this represents the expression scalar * term.
;;;;Normalize tries to represent the comparison POS NEG in the simplest way possible.
;;;
;;;(define (NORMALIZE-COEFFICIENTS processor pos neg)
;;;  (let ((cd 1) ;number to multiply denominators.
;;;	(cn '())
;;;	;number to divide numerators by (starts off as infinity which we are representing as '())
;;;	(norm 1)
;;;	(lcm (lambda (a b) (/ (* a b) (gcd a b))))) ;least common multiple. 
;;;
;;;    ;each element x of pos or neg is either a term or a list of the form (num term).
;;;    ;where num is a rational (i.e., lisp) coefficient a/b.
;;;    ;In case x is a term which is not a numerical constant, we consider that
;;;    ;it has coefficient 1.
;;;
;;;    ;find the appropriate normalization constant NORM:
;;;    (walk (lambda (x) (cond ((list? x)
;;;			     (if cn (set cn (gcd (numerator (car x)) cn))
;;;				 (set cn (numerator (car x))))
;;;			     (set cd (lcm (denominator (car x)) cd)))
;;;			    ((not (scalar-constant? processor x)) (set cn 1))))
;;;	  (append pos neg))
;;;    (set norm (if cn (/ cd cn) cd))
;;;
;;;    ;multiply everything in POS and NEG by NORM (and in the process make them all
;;;    ;lists, if need be with the lisp number 1 as a coefficient)
;;;
;;;    (set pos (map! (lambda (x) (cond ((list? x) (list (* norm (car x)) (cadr x)));
;;;				    ;if x is not a list, x is a term which could
;;;				    ;be a scalar
;;;				    ((scalar-constant? processor x)
;;;				     (list 1 (number->scalar-constant
;;;					      processor
;;;					      (* norm (scalar-constant->numerical-object processor x)))))
;;;				    (else (list norm x))))
;;;		  pos))
;;;    (set neg (map! (lambda (x) (cond ((list? x) (list (* norm (car x)) (cadr x)));
;;;				    ((scalar-constant? processor x)
;;;				     (list 1 (number->scalar-constant
;;;					      processor
;;;					      (* norm (scalar-constant->numerical-object processor x)))))
;;;v				    (else (list norm x)))) 
;;;		    neg))
;;;    (set pos (map! (lambda (x) (if (= (car x) 1) (cadr x)
;;;				  (apply-operator (*r processor)
;;;						  (number->scalar-constant processor (car x))
;;;						  (cadr x)))) pos))
;;;    (set neg (map! (lambda (x) (if (= (car x) 1) (cadr x)
;;;				  (apply-operator (*r processor)
;;;						  (number->scalar-constant processor (car x))
;;;						  (cadr x)))) neg))
;;;
;;;    ;;(return (form-sum-expression processor pos) (form-sum-expression processor neg))
;;;
;;;    (let ((pos (sort pos quick-compare))
;;;	  (neg (sort neg quick-compare)))
;;;      (return (form-sum-expression processor pos) (form-sum-expression processor neg)))))


(define (ALTERNATE-SUMMATION-PARTITIONER processor expr params)
  (ignore params)
  (return expr (number->scalar-constant processor 0)))


(define-integrable (BUILD-MONOMIAL coeff expr)
  (cons expr coeff))

(define-integrable (MONOMIAL-COEFFICIENT x)
  (cdr x))

(define-integrable (MONOMIAL-BASE x)
  (car x))

(define (DEFAULT-SUMMATION-PARTITIONER processor expr params)
  (let ((args (if (addition? processor expr) (associative-arguments expr)
		  (list expr))))
    (iterate loop ((args args) (pos '()) (neg '()))
      (cond ((null? args)
	     (receive (pos neg)
	       (normalize-coefficients processor pos neg)
	       (return
		(algebraic-processor-simplify
		 (algebraic-sub-processor processor)
		 pos
		 params)
		(algebraic-processor-simplify
		 (algebraic-sub-processor processor)
		 neg
		 params))))
	    ((scalar-constant? processor (car args))
	     (if (< (scalar-constant->numerical-object processor (car args)) 0)
		 (loop (cdr args)
		       pos
		       (cons (build-monomial
			      1
			      (number->scalar-constant
			       processor
			       (* -1 (scalar-constant->numerical-object processor (car args)))))
			     neg))
		 (loop (cdr args)
		       (cons (build-monomial 1 (car args)) pos)
		       neg)))
	    ((and (multiplication? processor (car args))
		  (scalar-constant? (coefficient-processor processor)
				    (car
				     (multiplicative-associative-arguments
				      processor
				      (car args)))))
		
	     ;;(scalar-constant? processor (1starg (car args))) won't work
	     ;;because simplifier left associates multiplication. So
	     ;;if (car args) is a multiplication const*a*b const will not be
	     ;;a term at the top level.
	     (let* ((assoc-args (multiplicative-associative-arguments processor (car args)))
		    (coeff (car assoc-args)))
	       (if (< (scalar-constant->numerical-object (coefficient-processor processor) coeff) 0)
		   (loop (cdr args)
			 pos
			 (cons (if (= (scalar-constant->numerical-object
				       (coefficient-processor processor) coeff) -1)
				   (build-monomial
				    1
				    (form-external-product-expression processor (cdr assoc-args)))
				   (build-monomial
				    (* -1 (scalar-constant->numerical-object
					   (coefficient-processor processor) coeff))
				    (form-external-product-expression processor
							     (cdr assoc-args))))
			       neg))
		      
		   (loop (cdr args)
			 (cons (build-monomial
				(scalar-constant->numerical-object
				 (coefficient-processor processor) coeff)
				(form-external-product-expression
				 processor
				 (cdr assoc-args)))
			       pos)
			 neg))))
	    (else (loop (cdr args) (cons (build-monomial 1(car args)) pos) neg))))))



(define (NORMALIZE-COEFFICIENTS processor pos neg)
  (let ((cd 1)
	;;number to multiply denominators to eliminate fractions.
	(cn '#f)
	;;Number to divide numerators by to reduce coefficients to lowest terms
	;;(starts off as infinity which we are representing as '#f)
	(norm 1)
	(lcm (lambda (a b) (/ (* a b) (gcd a b))))) ;least common multiple. 

    ;;each element x of pos or neg is a pair (term . num) 
    ;;where num is a rational (i.e., lisp) coefficient a/b.
    ;;In case x is a term which is not a numerical constant, we consider that
    ;;it has coefficient 1.

    ;;find the appropriate normalization constant NORM:

    (walk (lambda (x) (if (not (scalar-constant? processor (monomial-base x)))
			  (block
			    (if cn (set cn (gcd (numerator (monomial-coefficient x)) cn))
				(set cn (numerator (monomial-coefficient x))))
			    (set cd (lcm (denominator (monomial-coefficient x)) cd)))))
			    
	  (append pos neg))
    (set norm (if (processor-cancellation-valid? (coefficient-processor processor))
		  (if cn  (/ cd cn) cd)
		  1))
    
    (set pos (map! (lambda (x)
		     (if (not (scalar-constant? processor (monomial-base x )))
			 (build-monomial (* norm (monomial-coefficient x))
					 (monomial-base x))
			 (build-monomial
			  1
			  (number->scalar-constant
			   processor
			   (* norm (scalar-constant->numerical-object processor (monomial-base x)))))))
		   pos))
    (set neg (map! (lambda (x)
		     (if (not (scalar-constant? processor (monomial-base x)))
			 (build-monomial (* norm (monomial-coefficient x))
					 (monomial-base x))
			 (build-monomial
			  1
			  (number->scalar-constant
			   processor
			   (* norm (scalar-constant->numerical-object processor (monomial-base x)))))))
		   neg))


    (set pos (map! (lambda (x) (if (= (monomial-coefficient x) 1)
				   (monomial-base x)
				   (apply-operator (*r processor)
						   (number->scalar-constant
						    (coefficient-processor processor)
						    (monomial-coefficient x))
						   (monomial-base x))))
		   pos))
    (set neg (map! (lambda (x) (if (= (monomial-coefficient x) 1)
				   (monomial-base x)
				   (apply-operator (*r processor)
						   (number->scalar-constant
						    (coefficient-processor processor)
						    (monomial-coefficient x))
						   (monomial-base x))))
		   neg))

;;;    (return (form-sum-expression processor pos)
;;;	    (form-sum-expression processor neg))

    (let ((pos (sort pos quick-compare))
	  (neg (sort neg quick-compare)))
      (return (form-sum-expression processor pos) (form-sum-expression processor neg)))))
