;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald REDUCTIONS)


; It should be emphasized that the procedures in this file do not check for the
; definedness of their arguments and are thus not generally valid.  They may
; legitimately be called only in contexts where it is known that substituends
; will in fact be well-defined.  

(define (SIMPLE-SUBSTITUTION expr var-term-alist)
  (labels
      (((make-simple-substitution expr var-term-alist)
	(cond ((variable? expr)
	       (cond ((assq expr var-term-alist)
		      => cdr)
		     (else expr)))
	      ((any? (lambda (v)
		       (assq v var-term-alist))
		     (free-variables expr))
	       (compound-expression
		(expression-constructor expr)
		(map (lambda (c)
		       (make-simple-substitution c var-term-alist))
		     (expression-components expr))))
	      (else expr))))
    (cond ((not (check-simple-substitution var-term-alist))
	   (imps-error "simple-substitution : bogus substitution ~S." var-term-alist))
	  ((every?					;check no b-v clashes
	     (lambda (var-term)				;return nil if clash
	       (destructure (((var . term) var-term))
		 (free-for? term var expr)))
	     var-term-alist)
	   (make-simple-substitution expr var-term-alist))
	  (else
	   (make-simple-substitution
	    (change-bound-variables
	     expr
	     (collect-set free-variables (map cdr var-term-alist)))
	    var-term-alist)))))


; Must check that var-term-alist does not have multiple occurernces of any
; variable,
;;;    why not also that it is an alist of vars and terms, and that every pair has
;;;    matching sortings. 

(define (CHECK-SIMPLE-SUBSTITUTION var-term-alist)
  (is-set? (map car var-term-alist)))

(define (BETA-REDUCE-RECKLESSLY expression)
  (if (lambda-application? expression)
      (destructure* (((lambda-term . args) (expression-components expression))
		     ((body . vars)  (expression-components lambda-term))
		     (substitution (map cons vars args)))
	(apply-substitution-fastidiously substitution body))
      expression))

(define (BETA-REDUCE expression)
  (if (lambda-application? expression)
      (destructure* (((lambda-term . args) (expression-components expression))
		     ((body . vars)  (expression-components lambda-term)))
	(if (every? 
	     (lambda (arg var)
	       (necessarily-defined-in-sort? arg (expression-sorting var)))
	     args
	     vars)
	    (apply-substitution-fastidiously 
	     (map cons vars args)
	     body)
	    expression))
      expression))

(define (RECURSIVELY-BETA-REDUCE expression)
  (cond ((not (expression? expression)) expression)
	((null? (expression-constructor expression))
	 expression)
	((lambda-application? expression)
	 (destructure* (((lambda-term . args) (expression-components expression))
			((reduced-body . vars)  (map recursively-beta-reduce
						     (expression-components lambda-term)))
			(substitution (map cons vars (map insistent-beta-reduce args))))
	   (simple-substitution reduced-body substitution)))
	(else
	 (compound-expression
	  (expression-constructor expression)
	  (map recursively-beta-reduce (expression-components expression))))))

(define (INSISTENTLY-BETA-REDUCE expression)
  (let ((beta-reduced (recursively-beta-reduce expression)))
    (cond ((not (expression? beta-reduced)) expression)
	  ((eq? expression beta-reduced) expression)
	  (else 
	   (insistently-beta-reduce beta-reduced)))))
      

(define INSISTENT-BETA-REDUCE insistently-beta-reduce)

;;;

(define (ETA-REDUCIBLE? expression)
  (and (lambda-expression? expression)
       (application? (binding-body expression))
       (equal? (binding-variables expression) (arguments (binding-body expression)))
       (eq? (expression-sorting expression)
	    (expression-sorting (operator (binding-body expression))))
       (null? (intersection (binding-variables expression)
			    (free-variables (operator (binding-body expression)))))))

(define (ETA-REDUCE expression)
  (if (eta-reducible? expression)
      (operator (binding-body expression))
      expression))

(define (INSISTENTLY-ETA-REDUCE expression)
  (if (eta-reducible? expression)
      (insistently-eta-reduce (operator (binding-body expression)))
      expression))

(define (INSISTENTLY-REDUCE expression)
  (let ((reduct (beta-reduce-recklessly (eta-reduce expression))))
    (if (eq? reduct expression) expression
	(insistently-reduce reduct))))
