;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald UNFOLDING-STRATEGIES)


;;;This unfolding strategies for definitions.

(define (PATHS-TO-DEFINED-OPERATOR-APPLICATION-TERMS theory pred expr const)


  (let* ((def (theory-get-recursive-definition theory (name const)))
	 (param? (and def (parameterized-recursive-definition? def)))
	 (modified-pred
	  (if param?
	      (lambda (s) (and (application? s)
			       (application? (operator s))
			       (eq? (operator (operator s)) const)
			       (pred s)))
	      (lambda (s) (and (application? s)
			       (eq? (operator s) const)
			       (pred s)))))
	 (appendage (if param? '(0 0) '(0))))
			       
    (map (lambda (x) (append x appendage))
	 (paths-to-satisfaction expr modified-pred -1))))

;;;(define (DEDUCTION-GRAPH-UNFOLD-CONSTANT-DEFINITION-AT-PATHS sqn paths constant)
;;;  (iterate loop ((sqn sqn) (paths paths) (last-inference (fail)))
;;;    (if (null? paths)
;;;	last-inference
;;;	(let ((next-inference 
;;;	       (deduction-graph-unfold-constant-definition-at-path sqn (car paths) constant)))
;;;	  (if (succeed? next-inference)
;;;	      (loop (inference-node-1st-hypothesis next-inference) (cdr paths) next-inference)
;;;	      (loop sqn (cdr paths) last-inference))))))

(define (DEDUCTION-GRAPH-UNFOLD-DEFINITIONS-ONCE pred constants sqn)
  ;;;constants is a list of defined constants.
  ;;;pred is a predicate of EXPR.
  ;;;walks through definitions expanding constants
  ;;;satisfying pred producing a sequence
  ;;;of linear inferences.


  (let ((assertion (sequent-node-assertion sqn)))
    (iterate loop ((sqn sqn)
		   (paths-to-constants
		    (map (lambda (const)
			   (paths-to-satisfaction
			    assertion
			    (lambda (s) (and (pred s) (eq? const s)))
			    -1))
			 constants))
		   (constants constants)
		   (last-inference (fail)))
      (if (null? constants) last-inference
	  (let ((paths (car paths-to-constants)))
	    (let ((next-inference
		   (dg-primitive-inference-defined-constant-unfolding
		    sqn
		    (reverse! (sort-paths! paths))
		    (car constants))))
		  
	      (if (fail? next-inference)
		  (loop sqn (cdr paths-to-constants) (cdr constants) last-inference)
		  (loop (inference-node-1st-hypothesis next-inference)
			(cdr paths-to-constants)
			(cdr constants)
			next-inference))))))))

(define (DEDUCTION-GRAPH-UNFOLD-DEFINITIONS pred constants sqn)
  ;;;constants is a list of defined constants.
  ;;;pred is a predicate of EXPR.
  ;;;walks through recursive definitions expanding subexpressions
  ;;;satisfying pred producing a sequence
  ;;;of linear inferences.
  (let ((theory (deduction-graph-theory (sequent-node-graph sqn))))
    (iterate loop ((sqn sqn)
		   (constants constants)
		   (last-inference (fail)))
      (if (null? constants) last-inference ;;;used to be (null? (car constants))
	  (let ((paths
		 (paths-to-defined-operator-application-terms
		  theory
		  pred
		  (sequent-node-assertion sqn)
		  (car constants))))
	    (let ((next-inference
		   (dg-primitive-inference-defined-constant-unfolding
		    sqn
		    (reverse! (sort-paths! paths))
		    (car constants))))
		  
	      (if (fail? next-inference)
		  (loop sqn (cdr constants) last-inference)
		  (loop (inference-node-1st-hypothesis next-inference)
			(cdr constants)
			next-inference))))))))


(define (DEDUCTION-GRAPH-REPEATEDLY-UNFOLD-DEFINITIONS pred constants sqn)
  (iterate loop ((sqn sqn) (last-inference (fail)))
    (let* ((expansion-inference
	    (deduction-graph-unfold-definitions pred constants sqn))
	   (sqn-1 (if (succeed? expansion-inference)
		      (inference-node-1st-hypothesis expansion-inference)
		      sqn))
	   (simplification-inference
	    ((deduction-graph-strategy-simplification-procedure)  sqn-1))
	   (next-inference (if (succeed? simplification-inference)
			       simplification-inference
			       expansion-inference)))
				  
      (cond ((or (fail? next-inference)
		 (eq? sqn
		      (inference-node-1st-hypothesis next-inference)))
	     last-inference)
	    ((inference-node-1st-hypothesis next-inference)
	     =>
	     (lambda (new-sqn)
	       (loop new-sqn next-inference)))
	    (else last-inference)))))


(define (DEDUCTION-GRAPH-REPEATEDLY-UNFOLD-RECURSIVE-DEFINITIONS pred dont-unfold sqn)
  (if (eq? dont-unfold '#t)
      (fail)
      (deduction-graph-repeatedly-unfold-definitions
       pred
       (set-diff (theory-recursively-defined-constants
		  (deduction-graph-theory (sequent-node-graph sqn)))
		 dont-unfold)
       sqn)))

;;;;;;Tables of heuristics for expanding definitions
;;;
;;;(define (TABLE-UNFOLD-DEFINITION-CONSTANT? table context expr)
;;;  (let ((entries (table-entry table (expression-lead-constant expr))))
;;;    (any?
;;;     (lambda (x)
;;;       (let ((subst (match expr (car x))))
;;;	 (and (succeed? subst)
;;;	      ((cdr x) context subst))))
;;;     entries)))
;;;
;;;(define (TABLE-ADD-UNFOLDING-HEURISTIC table expr pred)
;;;  (set (table-entry table (expression-lead-constant expr))
;;;       (cons (cons expr pred) (table-entry table (expression-lead-constant expr)))))
;;;
;;;(define (TABLE-UNFOLD-DEFINITIONS table sqn)
;;;  (let ((constants '()))
;;;    (walk-table (lambda (key val) (ignore val) (push constants key)) table)
;;;    (deduction-graph-repeatedly-unfold-definitions 
;;;     (lambda (s) (table-unfold-definition-constant? table (sequent-node-context sqn) s))
;;;     constants
;;;     sqn)))


;;;similar things for macetes:

;;;(define (DEDUCTION-GRAPH-APPLY-MACETE-AT-PATH sqn macete path)
;;;  (let* ((assertion (sequent-node-assertion sqn))
;;;	 (context (sequent-node-context sqn))
;;;	 (local-context (local-context-at-path context assertion path))
;;;	 (local-expression (follow-path assertion path))
;;;	 (replacement (apply-macete macete local-context local-expression)))
;;;    (if (eq? replacement local-expression) (fail)
;;;	(let* ((force-subst
;;;		(deduction-graph-force-backward-substitution 
;;;		 sqn
;;;		 path
;;;		 replacement))
;;;	       (side-assumption (if (succeed? force-subst)
;;;				    (cadr (inference-node-hypotheses force-subst))
;;;				    '#f))
;;;	       (justify-inference
;;;		(if side-assumption
;;;		    (deduction-graph-apply-macete
;;;		     side-assumption
;;;		     macete)
;;;		    (fail)))
;;;	       (justify-sqn
;;;		(if (succeed? justify-inference)
;;;		    (inference-node-1st-hypothesis justify-inference)
;;;		    '#f)))
;;;
;;;	  ;;;If macete leaves justify-sqn an equivalence, go ahead
;;;	  ;;;and simplify.
;;;
;;;	  (if justify-sqn
;;;	      (let ((assertion (sequent-node-assertion justify-sqn)))
;;;		(if (or (and (quasi-equation? assertion)
;;;			     (eq? (quasi-equation-lhs assertion)
;;;				  (quasi-equation-rhs assertion)))
;;;			(and (or (equation? assertion)
;;;				 (biconditional? assertion))
;;;			     (eq? (expression-lhs assertion)
;;;				  (expression-rhs assertion))))
;;;		    ((deduction-graph-strategy-simplification-procedure) justify-sqn))))
;;;
;;;		    
;;;	  force-subst))))
;;;	  
;;;
;;;
;;;(define (DEDUCTION-GRAPH-APPLY-MACETE-AT-PATHS sqn macete paths)
;;;  (iterate loop ((sqn sqn) (paths paths) (last-inference (fail)))
;;;    (if (null? paths)
;;;	last-inference
;;;	(let ((next-inference 
;;;	       (deduction-graph-apply-macete-at-path sqn macete (car paths))))
;;;	  (if (succeed? next-inference)
;;;	      (loop (inference-node-1st-hypothesis next-inference)
;;;		    (cdr paths)
;;;		    next-inference)
;;;	      (loop sqn (cdr paths) last-inference))))))

(define (DEDUCTION-GRAPH-APPLY-MACETE-CONDITIONALLY sqn macete pred)
  (let ((paths 
	 (paths-to-satisfaction
	  (sequent-node-assertion sqn)
	  (lambda (s) (and (application? s) (pred s)))
	  -1)))
    (dg-primitive-inference-macete-application-at-paths sqn paths macete)))


(define (DEDUCTION-GRAPH-REPEATEDLY-APPLY-MACETE-CONDITIONALLY
	 sqn
	 macete
	 pred)
  (iterate loop ((sqn sqn) (last-inference (fail)))
    (let ((next-inference
	   (deduction-graph-apply-macete-conditionally sqn macete pred)))
				  
      (cond ((or (fail? next-inference)
		 (eq? sqn
		      (inference-node-1st-hypothesis next-inference)))
	     last-inference)
	    ((inference-node-1st-hypothesis next-inference)
	     =>
	     (lambda (new-sqn)
	       (loop new-sqn next-inference)))
	    (else last-inference)))))


(define GLOBAL-INDUCTION-STEP-HOOK
  (make-simple-switch
   'global-induction-step-hook
   (lambda (x) (or (macete? x) (false? x)))
   (build-and-install-macete-from-sexp '(series) 'trivial-unfolding-macete)))


;;;Definition expansion:

(define (DEFINITION-EXPANSION-STRATEGY constants sqn)
  (deduction-graph-unfold-definitions-once
   (always '#t)
   constants
   sqn))

(define (REPEATED-DEFINITION-EXPANSION-STRATEGY constants sqn)
  (deduction-graph-repeatedly-unfold-definitions
   (always '#t)
   constants
   sqn))


;;; COMMANDS

(build-universal-command
 (lambda (sqn occurrences constant-name)
   (let ((infn (deduction-graph-unfold-defined-constant sqn occurrences constant-name)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-single-defined-constant
 (always '#t)
 'symbol-locations-in-formula-retrieval-protocol)

(build-universal-command
 (lambda (sqn constant-name)
   (let ((infn (deduction-graph-unfold-defined-constant-globally sqn constant-name)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-single-defined-constant-globally
 (always '#t)
 'symbol-retrieval-protocol)

(build-universal-command
 (lambda (sqn)
   (let ((infn (definition-expansion-strategy
		 (theory-nonrecursively-defined-constants
		  (context-theory (sequent-node-context sqn)))
		 sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-directly-defined-constants
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (let ((infn (repeated-definition-expansion-strategy
		(theory-nonrecursively-defined-constants
		 (context-theory (sequent-node-context sqn)))
		sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-directly-defined-constants-repeatedly
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (let ((infn (definition-expansion-strategy
		 (theory-recursively-defined-constants
		  (context-theory (sequent-node-context sqn)))
		 sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-recursively-defined-constants
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (let ((infn (repeated-definition-expansion-strategy
		(theory-recursively-defined-constants
		 (context-theory (sequent-node-context sqn)))
		sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-recursively-defined-constants-repeatedly
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (let ((infn (definition-expansion-strategy
		 (theory-defined-constants
		  (context-theory (sequent-node-context sqn)))
		 sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-defined-constants
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (let ((infn (repeated-definition-expansion-strategy
	       (theory-defined-constants
		(context-theory (sequent-node-context sqn)))
	       sqn)))
     (if (succeed-without-grounding? infn)
	 (deduction-graph-beta-reduce-repeatedly (inference-node-1st-hypothesis infn))
	 infn)))
 'unfold-defined-constants-repeatedly
 (always '#t))


