;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

;; Copyright (c) 1990,1991,1992,1993 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES ON WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;; Copyright (c) 1990-1993 The MITRE Corporation
;; 
;; Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;;   
;; The MITRE Corporation (MITRE) provides this software to you without
;; charge to use, copy, modify or enhance for any legitimate purpose
;; provided you reproduce MITRE's copyright notice in any copy or
;; derivative work of this software.
;; 
;; This software is the copyright work of MITRE.  No ownership or other
;; proprietary interest in this software is granted you other than what
;; is granted in this license.
;; 
;; Any modification or enhancement of this software must identify the
;; part of this software that was modified, by whom and when, and must
;; inherit this license including its warranty disclaimers.
;; 
;; MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;; OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;; OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;; FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;; SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;; SUCH DAMAGES.
;; 
;; You, at your expense, hereby indemnify and hold harmless MITRE, its
;; Board of Trustees, officers, agents and employees, from any and all
;; liability or damages to third parties, including attorneys' fees,
;; court costs, and other related costs and expenses, arising out of your
;; use of this software irrespective of the cause of said liability.
;; 
;; The export from the United States or the subsequent reexport of this
;; software is subject to compliance with United States export control
;; and munitions control restrictions.  You agree that in the event you
;; seek to export this software or any derivative work thereof, you
;; assume full responsibility for obtaining all necessary export licenses
;; and approvals and for assuring compliance with applicable reexport
;; restrictions.
;; 
;; 
;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SECTIONS)


;;; T primitives

(define IMPS-FILESPEC? (*value t-implementation-env 'filespec?))
(define IMPS-GET-DEFAULT-FILENAME (*value t-implementation-env 'get-default-filename))
(define IMPS-EXPAND-FILENAME (*value t-implementation-env 'expand-filename))
(define IMPS-FILENAME->STRING (*value t-implementation-env 'filename->string))

(define (IMPS-FILESPEC->STRING spec)
  (imps-filename->string (imps-expand-filename (imps-get-default-filename spec))))

(define (IMPS-FILESPEC-EQUAL? spec1 spec2)
  (string-equal? (imps-filespec->string spec1)
		 (imps-filespec->string spec2)))


;;; Tables

(lset *NAME-SECTION-TABLE* (make-table '*name-section-table*))

(define (NAME->SECTION the-name)
  (table-entry *name-section-table* the-name))

(lset *LOADED-FILES-TABLE* (make-string-table '*loaded-files-table*))

(define (IMPS-FILE-LOADED? spec)
  (table-entry *loaded-files-table* 
	       (imps-filespec->string spec)))


;;; Sections

(define-structure-type SECTION
  name					; symbol-form
  component-names			; list of symbol-forms
  filespecs				; list of file specs
  aux-filespec				; file spec
  loaded?				; boolean

  (((name self)
    (section-name self))
   ((print self port)
    (format port 
	    "#{Imps-section ~A: ~S}"
	    (object-hash self)
	    (section-name self)))))

(define (BUILD-SECTION the-name component-names filespecs aux-filespec)
  (or (symbol? the-name)
      (imps-error "BUILD-SECTION: ~A ~S ~A"
		  "the section name" the-name "is not a symbol."))
  (map 
   (lambda (comp-name)
     (or (symbol? comp-name)
	 (imps-error "BUILD-SECTION: ~A ~S ~A"
		     "the component section name" comp-name "is not a symbol.")))
   component-names)
  (map 
   (lambda (spec)
     (or (imps-filespec? spec)
	 (imps-error "BUILD-SECTION: ~S ~A"
		     spec "is not a file specification.")))
   (if aux-filespec
       (cons aux-filespec filespecs)
       filespecs))
  (let ((old-section (name->section the-name)))
    (if old-section
	(block (or (and (every? 
			 eq? 
			 (section-component-names old-section)
			 component-names)
			(every?
			 imps-filespec-equal?
			 (if (section-aux-filespec old-section)
			     (cons (section-aux-filespec old-section)
				   (section-filespecs old-section))
			     (section-filespecs old-section))
			 (if aux-filespec
			     (cons aux-filespec filespecs)
			     filespecs)))
		   (imps-error "BUILD-SECTION: ~A ~S."
			       "there is already a section named" the-name))
	       old-section)
	(let ((new-section (make-section)))
	  (set (table-entry *name-section-table* the-name) new-section)
	  (set (section-name new-section) the-name)
	  (set (section-component-names new-section) component-names)
	  (set (section-filespecs new-section) filespecs)
	  (set (section-aux-filespec new-section) aux-filespec)
	  (set (section-loaded? new-section) '#f)
	  new-section))))


;;; Loading sections and files

(define (LOAD-IMPS-SECTION the-name reload-files-only? reload? quick?)
  (let ((section (name->section the-name)))
    (or section
	(imps-error "LOAD-IMPS-SECTION: ~A ~S."
		    "there is no section named" the-name))
    (bind (((quick-load?) quick?)
	   ((*value t-implementation-env '*load-level*)
	    (1+ (*value t-implementation-env '*load-level*))))
      (if (and (section-loaded? section)
	       reload-files-only?)
	  (block
	    (format-imps-load-message (standard-output) "~A ~S.~%"
		    "Reloading files of IMPS section" the-name)
	    (load-imps-section-files section '#t)
	    (format-imps-load-message (standard-output) "~S ~A.~%"
		    the-name "files are reloaded"))
	  (load-imps-section-aux section reload?)))))

(define (LOAD-IMPS-SECTION-AUX section reload?)
  (cond ((and (section-loaded? section)
	      (not reload?))
	 (format-imps-load-message (standard-output) "~A ~S.~%"
		 "Already loaded IMPS section" (section-name section)))
	((and (section-loaded? section)
	      reload?)
	 (format-imps-load-message (standard-output) "~A ~S.~%"
		 "Reloading IMPS section" (section-name section))
	 (load-imps-component-sections section reload?)
	 (load-imps-section-files section reload?)
	 (set (section-loaded? section) '#t)
	 (format-imps-load-message (standard-output) "~S ~A.~%"
				   (section-name section) "is reloaded"))
	(else 
	 ;; (not (section-loaded? section))
	 (format-imps-load-message (standard-output) "~A ~S.~%"
				   "Loading IMPS section" (section-name section))
	 (load-imps-component-sections section reload?)
	 (load-imps-section-files section reload?)
	 (set (section-loaded? section) '#t)
	 (format-imps-load-message (standard-output) "~S ~A.~%"
				   (section-name section) "is loaded"))))
	 
(define (LOAD-IMPS-COMPONENT-SECTIONS section reload?)
  (bind (((*value t-implementation-env '*load-level*)
	  (1+ (*value t-implementation-env '*load-level*))))
    (walk
     (lambda (comp-name)
       (let ((comp (name->section comp-name)))
	 (load-imps-section-aux comp reload?)))
     (section-component-names section))))

(define (LOAD-IMPS-SECTION-FILES section reload?)
  (load-imps-files (section-filespecs section)  reload?))

(define (LOAD-IMPS-FILES filespecs reload?)
  (walk
   (lambda (filespec)
     (load-imps-file filespec reload?))
   filespecs)
  (return))

(define (LOAD-IMPS-FILE spec reload?)
  (if 
   (or (not (imps-file-loaded? spec))
       reload?)
   (block
     (push-current-theory)
     (push-current-syntax)
     (format-imps-load-message (standard-output) "~A ~S.~%"
			       (if reload?
				   "  Reloading IMPS file"
				   "  Loading IMPS file")
			       (imps-filespec->string spec))
     ;;
     ;; ((*value t-implementation-env 'load-silently) spec imps-implementation-env)
     ;;
     (load-imps-file-load-port spec)
     (format-imps-load-message (standard-output) "~A.~%" "  File is loaded")
     (pop-current-syntax)
     (pop-current-theory)
     (set 
      (table-entry *loaded-files-table* (imps-filespec->string spec))
      '#t))))

(define (format-imps-load-message port format-string . args)
  ((*value t-implementation-env 'COMMENT-INDENT)
      (standard-output)
      (fx* (*value t-implementation-env '*load-level*) 2))
  (apply format port format-string args))

(define-predicate line-numbered-port?)
(define-operation port-line-number)

(define (port->line-numbered-port port)
  (let ((newline-recently? '#f)
	(current-line-number 0))
    (join 
      (object '()
	((port-name self)
	 (format nil "~a" (port-name port)))
	((line-numbered-port? self) '#t)
	((port-line-number self) current-line-number)
	((read-char self)
	 (let ((ch (read-char port)))
	   (cond ((eq? ch '#\newline)
		  (increment current-line-number)
		  (set newline-recently? '#t))
		 (else (set newline-recently? '#f)))
	   ch))
	((unread-char self)
	 (if newline-recently? (decrement current-line-number))
	 (unread-char port)))
      port)))

(define current-imps-port
  (make-simple-switch
   'current-imps-port
   (lambda (val)(or (not val) (port? val)))
   '#f))

(define (current-imps-directory)
  (string-append
   (filename-dir
    (imps-expand-filename
     (->filename
      (port-name
       (current-imps-port)))))
   "/"))
   
(define (current-imps-filename-nondirectory)
  (let ((fn (imps-expand-filename
	     (->filename
	      (port-name
	       (current-imps-port))))))
    (string-append
     (filename-name fn)
     "."
     (filename-type fn))))

(define (load-imps-file-load-port spec)
  (bind (((print-load-message?) nil)
         ((print-env-warnings?) nil)
	 ((*value t-implementation-env '+load-noisily?+) '#f))
    (with-open-ports
	((port
	  (port->line-numbered-port
	   ((*value t-implementation-env 'open-default-filename)
	    spec '#t))))
      (bind (((current-imps-port) port))
	(cond ((port? port) 
	       ((*value t-implementation-env 'load-port)
		port imps-implementation-env))
	      (else nil))))))

(define-structure-type imps-obarray-entry
  name
  kind
  directory
  file
  line

  (((print self port)
    (format port "~%~a ~a ~s ~s ~a"
	    (imps-obarray-entry-name self)
	    (imps-obarray-entry-kind self)
	    (imps-obarray-entry-directory self)
	    (imps-obarray-entry-file self)
	    (imps-obarray-entry-line self)))))

(define (build-imps-obarray-entry name kind directory file line)
  (let ((entry (make-imps-obarray-entry)))
    (set (imps-obarray-entry-name entry) (string-downcase (symbol->string name)))
    (set (imps-obarray-entry-kind entry) (string-downcase (symbol->string kind)))
    (set (imps-obarray-entry-directory entry) directory)
    (set (imps-obarray-entry-file entry) file)
    (set (imps-obarray-entry-line entry) line)
    entry))

(define (maybe-register-imps-obarray-entry the-name kind)
  (ignore the-name kind)
  '#f)
