/******************************************************************************
  anf_ceiling_delete.c
******************************************************************************/
 
#include "kant.h"

void
anf_ceiling_delete WITH_2_ARGS(
	order,		ord,
	anf_ceiling *,	ceil
)
/*******************************************************************************
 
Description:
 
	Deletes a ceiling.
  
Calling sequence:
 
	anf_ceiling_delete(ord, &ceil);

	order		ord	= order over which ceil is defined
	anf_ceiling	ceil	= ceiling to delete

History:
 
	92-06-04  JS    first version
 
*******************************************************************************/
{       
	block_declarations;
        t_handle          R, Z;

	if (!block_has_other_refs(*ceil))
	{                   
                R = order_reals(ord);
                Z = m_z_str_incref(structure_z);
 
                vec_delete(R, &anf_ceiling_lambdas(*ceil));
                vec_delete(Z, &anf_ceiling_rexps(*ceil));

                ring_delete(&Z);
	}
 
	block_decref_delete(*ceil);

	*ceil = MEM_NH;
 
	return;
}
