#include "kant.h" 


t_logical
anf_ceiling_fincke_next  WITH_2_ARGS( 
	order,		ord,
	anf_ceiling *,	ceil
)
/*******************************************************************************
 
Description:
 
	The function returns the next vector for the ellipsoid method of U. Fincke.

 
Calling sequence:
 
	log= anf_ceiling_fincke_next(ord, ceil);
 
      	order  	        ord      = t_handle of an order 
      	anf_ceiling     ceil     = t_handle of an ceiling
	t_logical		log	 = 1, if there is a next vector
                                   0, if there is no next vector			
 
History:
 
	92-06-11 AJ    written
 
*******************************************************************************/
{  
	block_declarations;

	integer_small	i, j, n, r1, r2, sum, neqnum, h1, h2, test;
	t_handle		R;

          
/*** Initialisation  **********************************************************/

	n= order_abs_degree(ord);
	R= order_reals(ord);            
	r1= order_r1(ord);
	r2= order_r2(ord);
                  

/*** Enumeration of the next vector ******************************************/

	i= 1;                       
	sum= 0;

        while (i<=n)
	 {  
	  if (anf_ceiling_rexp(*ceil,i) > 0)
	   {
	    sum= sum - 2*anf_ceiling_rexp(*ceil,i);  
	    anf_ceiling_rexp(*ceil,i) = -anf_ceiling_rexp(*ceil,i);

	    if ( (anf_ceiling_rexp(*ceil,i)>=-order_fincke_rbound(ord,i))
	          &&(sum==0) ) 
	     { 
	      neqnum= 0;
	      test= 1;
	      for (j= r1+1; j<=r1+r2; j++)
	       {
		if ( ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))<0) ||
	             ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))>1)  )  
	         {
		  test= 0;
	          break;
		 }
	        if ( (anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))!=0 ) 
 	          neqnum= neqnum+1;
	       }
  
	      if (anf_print_level>=10)
	       {
	        printf("local: ");
                for (j=1; j<=n;j++)
	          printf(" %d\t ", anf_ceiling_rexp(*ceil,j));
	        printf("         sum= %d", sum);
	        printf("\n");
 	        printf("neqnum= %d, test= %d \n\n", neqnum, test);
	       }

	      if ( (neqnum<=1) && (test) ) 
               {
	        for (j= 1; j<=n; j++)
	         {
	          real_delete(&anf_ceiling_lambda(*ceil,j));
	          anf_ceiling_lambda(*ceil,j)= 
	             real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	         }
	        
		return 1;
	       }
	     }

             
	    if (  anf_ceiling_rexp(*ceil,i)>=-order_fincke_rbound(ord,i) )
	     {
	      i=1;
	      continue;           
	     }
 
	    sum= sum - 2* anf_ceiling_rexp(*ceil,i) + 1; 
	    anf_ceiling_rexp(*ceil,i) = -anf_ceiling_rexp(*ceil,i) + 1;	

	    if ( (anf_ceiling_rexp(*ceil,i)<= order_fincke_rbound(ord,i))
	          &&(sum==0) ) 
	     {
	      neqnum= 0;
	      test= 1;
	      for (j= r1+1; j<=r1+r2; j++)
	       {
		if ( ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))<0) ||
	             ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))>1)  )  
	         {
		  test= 0;
	          break;
		 }
	        if ( (anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))!=0 ) 
		  neqnum= neqnum+1;
	       }  

	      if (anf_print_level>=10)
	       {
	        printf("local: ");
                for (j=1; j<=n;j++)
	          printf(" %d\t ", anf_ceiling_rexp(*ceil,j));
	        printf("         sum= %d", sum);
	        printf("\n");
 	        printf("neqnum= %d, test= %d \n\n", neqnum, test);
	       }

	      if ( (neqnum<=1) && (test) ) 
               {
	        for (j= 1; j<=n; j++)
	         {
	          real_delete(&anf_ceiling_lambda(*ceil,j));
	          anf_ceiling_lambda(*ceil,j)= 
	             real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	         }
	        
		return 1;
	       }
	     }

	    if (  anf_ceiling_rexp(*ceil,i)<= order_fincke_rbound(ord,i) )
	     {
	      i=1;
	      continue;
	     }
	   }
	  else
	   {
	    sum= sum - 2* anf_ceiling_rexp(*ceil,i) + 1; 
	    anf_ceiling_rexp(*ceil,i) = -anf_ceiling_rexp(*ceil,i) + 1;	

	    if ( (anf_ceiling_rexp(*ceil,i)<= order_fincke_rbound(ord,i))
	          &&(sum==0) ) 
	     {
	      neqnum= 0;
	      test= 1;
	      for (j= r1+1; j<=r1+r2; j++)
	       {
		if ( ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))<0) ||
	             ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))>1)  )  
	         {
		  test= 0;
	          break;
		 }
	        if ( (anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))!=0 ) 
	          neqnum= neqnum+1;
	       }  

	      if (anf_print_level>=10)
	       {
	        printf("local: ");
                for (j=1; j<=n;j++)
	          printf(" %d\t ", anf_ceiling_rexp(*ceil,j));
	        printf("         sum= %d", sum);
	        printf("\n");
 	        printf("neqnum= %d, test= %d \n\n", neqnum, test);
	       }

	      if ( (neqnum<=1) && (test) ) 
               {
	        for (j= 1; j<=n; j++)
	         {
	          real_delete(&anf_ceiling_lambda(*ceil,j));
	          anf_ceiling_lambda(*ceil,j)= 
	             real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	         }
	        
		return 1;
	       }
	     }

	    if (  anf_ceiling_rexp(*ceil,i)<= order_fincke_rbound(ord,i) )
	     {
	      i=1;
	      continue;
	     }

	    sum= sum - 2*anf_ceiling_rexp(*ceil,i);
	    anf_ceiling_rexp(*ceil,i) = -anf_ceiling_rexp(*ceil,i);

	    if ( (anf_ceiling_rexp(*ceil,i)>=-order_fincke_rbound(ord,i))
	          &&(sum==0) ) 
	     {
	      neqnum= 0;
	      test= 1;
	      for (j= r1+1; j<=r1+r2; j++)
	       {
		if ( ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))<0) ||
	             ((anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))>1)  )  
	         {
		  test= 0;
	          break;
		 }
	        if ( (anf_ceiling_rexp(*ceil,j+r2)-anf_ceiling_rexp(*ceil,j))!=0 ) 
	          neqnum= neqnum+1;
	       }  

	      if (anf_print_level>=10)
	       {
	        printf("local: ");
                for (j=1; j<=n;j++)
	          printf(" %d\t ", anf_ceiling_rexp(*ceil,j));
	        printf("         sum= %d", sum);
	        printf("\n");
 	        printf("neqnum= %d, test= %d \n\n", neqnum, test);
	       }

	      if ( (neqnum<=1) && (test) ) 
               {
	        for (j= 1; j<=n; j++)
	         {
	          real_delete(&anf_ceiling_lambda(*ceil,j));
	          anf_ceiling_lambda(*ceil,j)= 
	             real_power(R, order_fincke_lambda(ord), anf_ceiling_rexp(*ceil,j));
	         }
	        
		return 1;
	       }
	     }
            
	    if (  anf_ceiling_rexp(*ceil,i)>=-order_fincke_rbound(ord,i) )
	     {
	      i=1;
	      continue;
	     }
	   }
          
	  sum= sum - anf_ceiling_rexp(*ceil,i);
	  anf_ceiling_rexp(*ceil,i)= 0;

          i= i+1;
         }
              
/*** No vector found **********************************************************/

	return 0;

} 

