/******************************************************************************
  anf_create.c
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "structure.e" 
#ifndef KANT
#include "alg.e" 
#endif 


anf
anf_create WITH_NO_ARGS(
)
/*******************************************************************************
 
Description:
 
	Allocating space for an algebraic number field
 
	The task of this routine is to allocate sufficient space for the table
	which describes an algebraic number field. On exit, the user is provided
	with a t_handle to the field.
 
	The invariants of the field are set to void.
 
  
Calling sequence:
 
	field = anf_create();


History:
 
	92-03-19 JS	MEM_NH instead of 0
	91-10-11 JS	minor changes
	91-08-10 MB/JS	first version
 
*******************************************************************************/
{
	anf	field;

        field = structure_alloc(sizeof(t_anf_table),RING_BLOCK_TYPE, 1, REP_ANF, FALSE);
        ring_put_type(field, RING_ANF); 
        ring_set_is_field_true(field); 
 


	anf_abs_degree(field) 	= -1;
	anf_r1(field) 		= -1;
	anf_r2(field) 		= -1;
	anf_r(field) 		= -1;

	anf_polys_z(field) 	=  MEM_NH;
	anf_polys_order(field) 	=  MEM_NH;
	anf_order_info(field) 	=  MEM_NH;

	return field;
}
