/******************************************************************************
  anf_elt_power_product.c
******************************************************************************/

#include "kant.h"

anf_elt
anf_elt_power_product WITH_3_ARGS(
	order,		ord,
	vector,		b,
	vector,		e
)
/******************************************************************************
 
Description:	Computes the power product 

		b[1]^{e[1]} * ... * b[n]^{e[n]}

		where b[1],...,b[n] are algebraic numbers.
		The exponents e[1],...,e[n] must be integers.
 
Calling sequence:

	alpha = anf_elt_power_product(ord,b,e)

	alpha	=	result
	ord	=	order over which the entries of b are given
	b	=	vector whose entries are algebraic numbers
	e	=	vector whose entries are integer_bigs	 
 
History:
 
	92-05-26 KW	minor changes
	92-05-05 KW	vectors instead of dynamical arrays
	92-04-23 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha,beta,den,num,tempa,tempb;
	integer_big	e1,e2;
	integer_small	i,c,n;

	n = vec_length(b);

	for (c=0,i=1;i<=n;i++) if (anf_elt_is_con(vec_entry(b,i))) c++;
	if (c && (c<n)) error_internal("anf_elt_power_product: different types...");

	den = num = 1;

	for (i=1;i<=n;i++)
	{
		e1 = vec_entry(e,i);
		if (integer_compare(e1,0) == -1)
		{
			e2  = integer_negate(e1);
			tempa = den;
			tempb = anf_power(ord,vec_entry(b,i),e2);
			den = anf_mult(ord,tempa,tempb);
			anf_elt_delete(ord,&tempa);
			anf_elt_delete(ord,&tempb);
			integer_delref(e2);
		}
		else
		{
			tempa = num;
			tempb = anf_power(ord,vec_entry(b,i),e1);
			num = anf_mult(ord,tempa,tempb);
			anf_elt_delete(ord,&tempa);
			anf_elt_delete(ord,&tempb);
		}
	}
	if (den != 1)
	{
		alpha = anf_div(ord,num,den);
		beta  = anf_elt_simplify(ord,alpha);

		anf_elt_delete(ord,&alpha);
		anf_elt_delete(ord,&den);
		anf_elt_delete(ord,&num);

		return beta;
	}
	else return(num);
}
