#include "kant.h"
#include "integer.e"
#include "mat.h"
#include "anf.h"

anf_elt
anf_elt_trans WITH_4_ARGS(
	order,		ord,
	anf_elt,	alpha,
	matrix,		trans,
	integer_big,	den

)
/*******************************************************************************
 
anf_elt_trans.c
 
JS September 1991 
Last modification: 26.09.91
 
alpha is given via a basis of ord. The coefficient vector of alpha
is multiplied from the left by trans (with denominator den).
trans must be either an integer matrix or a matrix over the coefficient
order of ord.
 
*******************************************************************************/
{
	block_declarations;

	anf_elt		beta;
	integer_small	deg;
        order		ordcoef;
	integer_big	accu, temp0, temp1;
 	integer_small	i, j;
                   
  
	deg = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
 
	anf_elt_alloc(beta, deg);
 
/*	
    first the denominator
*/
	anf_elt_den(beta) = integer_mult(anf_elt_den(alpha), den);
 
/*
    now trans * coefficient vector of alpha
*/
	for (i=1; i<=deg; ++i)
	{
		accu = 0;
		for (j=1; j<=deg; ++j)
		{
			temp0 = accu;
			temp1 = anf_mult(ordcoef, anf_elt_coef(alpha, j),
						  mat_elt(trans, i, j)); 
			accu  = anf_add(ordcoef, temp0, temp1);
			anf_elt_delete(ordcoef, &temp0);
			anf_elt_delete(ordcoef, &temp1);
		}
		anf_elt_coef(beta, i) = accu;
	}
 
	return beta;
 
}
