/*******************************************************************************
anf_ideal_add_to_faclst.c
*******************************************************************************/
 

#include "kant.h"        


t_void 
anf_ideal_add_to_faclst WITH_4_ARGS ( order         , ord     ,
                                      t_handle *    , fac     ,
                                      anf_ideal     , ideal   ,
                                      integer_small , power    )
/*******************************************************************************
 
Description:
                                                         
    Adds an new factor to a factorization. NO CHECK is done whether or not
    the new ideal is already part of the factorization. The new ideal
    is only appended to the old faclst. In case the faclst does not ex.
    it will be created.

 
Calling sequence:
 
 
      	order  	      ord         : Maximal order of a field.
        faclst        fac         : The treated faclst.

        anf_ideal     ideal       : The new ideal for the faclst.
        integer_small power       : The exp. for the new ideal.

  

        anf_ideal_add_to_faclst (ord,&fac,ideal,power);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/
{   


              block_declarations;

              integer_small     m,j;  

  if (power > 0)
  {


    if (*fac == MEM_NH) 
      m = 1;
    else
      m = m_poly_z_faclst_len (*fac) + 1;

    if (m == 1) /* Everything is new -- create all data */ 
    {                        
      *fac = m_poly_z_faclst_alloc (1); 
      m_poly_z_faclst_power (*fac,0)  = power;
      m_poly_z_faclst_factor (*fac,0) = anf_ideal_incref (ideal);
      m_poly_z_faclst_len_put (*fac,1);
    }      
    else /* We already created the needed structures */
      {
        m_poly_z_faclst_assure_space (*fac,m);
        m_poly_z_faclst_power (*fac,m-1)  = power;
        m_poly_z_faclst_factor (*fac,m-1) = anf_ideal_incref (ideal);
        m_poly_z_faclst_len_put (*fac,m);         
      }                             
      


    if (anf_print_level > 4)
    {
      printf ("ADD - FACTOR : (new factor list)\n");
      for (j=0;j<m_poly_z_faclst_len (*fac);j++)
      {
        anf_ideal_2_write (ord,m_poly_z_faclst_factor (*fac,j));
        printf("^%d\n",m_poly_z_faclst_power (*fac,j));
      }
    }
  }
}
  
