/*******************************************************************************
  anf_ideal_mult_ring.c 
********************************************************************************/

#include <stdio.h>             
#include "kant.h"
#include "anf.h"
#include "mat.h"

order
anf_ideal_mult_ring WITH_3_ARGS (order       ,  act_ord,
                             anf_ideal   ,  act_ideal,
                             integer_big ,  modul   )
/*******************************************************************************

Description:

     Computes the ring of multipliers of a given ideal (act_ideal). 
     All data is interpreted through the order act_ord. 
     
     For reasons of speed also a modul is given.


Calling sequence:

             order        act_ord   : The main order for this function. For all
                                      data it is provided that it is defined  
                                      through this order.
             anf_ideal    act_ideal : We are calculating a ring of multipliers
                                      for a given ideal.
             integer_big  modul     : A modul for hermite reductions.
                                      If modul equals one no modular hermite  
                                      reduction is used. Instead the normal 
                                      red. is used.

             order        mult_ring : We have to compute some hermite - normal 
                                      forms. Therefor we (should) use a modul.

        mult_ring  = anf_ideal_mult_ring (act_ord,act_ideal,modul);               

History:

    JS 92-02-10 renaming to anf_ideal_mult_ring
    MD 91-11-20 first version

********************************************************************************/
{                              
     block_declarations;           

     order            Z,mult_ring;
                     


     matrix           trans_mat;
     
     matrix           radical;          /* the transformations matrix of act_ideal */
     matrix           inv_radical;      /* the inverse mat. of inv_radical         */
     integer_big      den_inv_radical;  /* the denominator for the matrix inv_rad. */

     matrix           mat1,mat2; 

     integer_big      a;
     anf_elt          alpha; 
                     
     integer_small    degree;
     integer_small    i,k,l,row,col;
 
/**************************************************************************/
/*                              Memory clean                              */
/*                                   \/                                   */


/* Der Fall, den man schon kann */

    if (!anf_ideal_is_2 (act_ideal))
    {
      Z          = order_coef_order (act_ord);
      degree     = order_rel_degree (act_ord);    

      radical =  anf_ideal_tran (act_ideal);
      mat_z_inverse_den (Z, radical, &inv_radical, &den_inv_radical);

      if (anf_print_level > 3) 
      {    
        cay_print ("Inverse : %d\n",den_inv_radical); 
        mat_anf_write (Z,inv_radical);   
        cay_print ("\n\n\n Modul fuer die Hermite - Red. : %d \n",modul);
      }


      for (i=1;i<=degree;i++)
      {
        alpha       =  mat_order_col_to_anf_elt (act_ord,radical,i);                                                   
        if (modul != 1)   
          mat2      =  anf_rep_mat_mod (act_ord, modul,alpha);
        else
          mat2      = anf_rep_mat (act_ord,alpha);
        anf_elt_delete (act_ord,&alpha);

        mat1 = mat_ring_mult (Z,inv_radical,mat2);
        mat_delref (Z,&mat2);
          

/* divide all matrixentries  byden_inv_radical         */
      row = mat_row (mat1);
      col = mat_col (mat1);      
      for (k=1;k<=row;k++)
        for (l=1;l<=col;l++) 
        { 
          a = mat_elt (mat1,k,l);
          mat_elt (mat1,k,l) = integer_div (a,den_inv_radical);
          integer_delref (a);
        }         
/* End of division */                                  

        if (anf_print_level > 3) 
        {    
          printf ("Darstellungsmatrix von Spalte %d  mult. mit Inverser\n",i);
          mat_anf_write (Z,mat1);
        }

/* Hermite reduction of the generating system. (only if two matrizen were already computed */
        if (i==1)
        {
          mat2 = mat_new (2*degree,degree);

          trans_mat = mat_ring_insert (Z,mat2,mat1,1,1);
          mat_delref (Z,&mat2);
        }
        else
        {             
          mat2 = mat_ring_insert (Z,trans_mat,mat1,degree+1,1);
          mat_delref (Z,&trans_mat);
          if (modul != 1 )  
            trans_mat = mat_z_row_hnf_mod (Z,mat2,modul);
          else
            trans_mat = mat_ring_hnf_row (Z,mat2);
          mat_delref (Z,&mat2);
          if (anf_print_level > 3) 
          {    
            puts ("HERMITE : ");
            mat_anf_write (Z,trans_mat);
          }
        }   
/* End of Hermite - reduction */

        mat_delref (Z,&mat1);
      }
   
      mat1 = mat_ring_submat (Z,trans_mat,1,1,degree,degree);
      mat_delref (Z,&trans_mat);
      mat_delref (Z,&inv_radical);
      integer_delref (den_inv_radical);

      mat_z_inverse_den (Z , mat1, &mat2, &a);
      mat_delref (Z,&mat1);                           

      mult_ring = order_trans (act_ord,mat2,a);   
      mat_delref (act_ord,&mat2);
      integer_delref (a);


      return mult_ring; 
/*                                   /\                                   */
/*                              Memory clean                              */
/**************************************************************************/
    }
}

                                  
