/******************************************************************************
  anf_trace.c
******************************************************************************/
#include "kant.h"
#include "anf.h"

integer_big
anf_trace WITH_2_ARGS (
	order,		ord,
	anf_elt,	alpha
)
/******************************************************************************
 
Description:	Calculates the trace of an algebraic number.
 
Calling sequence:

		tr = anf_trace(ord,alpha)

		integer_big	tr	= t_handle of the trace 
		order		ord	= t_handle of order
		anf_elt		alpha	= t_handle of anf_elt
 
History:
 
	92-02-27 KW    written
 
******************************************************************************/
{
	block_declarations;

	integer_big	tempa,tempb,tempc,tempd;
	integer_small	deg;
	integer_small	i;
	order		ordcoef;

	deg = order_rel_degree(ord);
	ordcoef = order_coef_order(ord);
/*
*	Trivial case
*/
	if (anf_elt_is_integer(alpha)) return(integer_mult(alpha,deg));

/*
*	We calculate the trace of alpha using the traces
*	of the multiplication-matrices
*/
	order_must_be_over_z(ord);
        order_mult_assure(ord);

	tempa = 0;
	for(i=1;i<=deg;i++)
	{
		tempb = tempa;
		tempc = mat_ring_trace(ordcoef,order_mult_matrix(ord,i));
		tempd = integer_mult(anf_elt_coef(alpha,i),tempc);
		tempa = integer_add(tempa,tempd);
		
		integer_delref(tempb);
		integer_delref(tempc);
		integer_delref(tempd);
	}

	return(tempa);
}
