/*******************************************************************************
  conv_dyn_arr_to_vec.c 
********************************************************************************/


#include <stdio.h>
#include "kant.h"



void
conv_dyn_arr_to_vec WITH_3_ARGS (t_handle       , cring ,
                                 dyn_arr_handle , d ,
                                 vector *       , v      )
/*******************************************************************************

Description:
  
      Transfers a dynamic array structure into a vector structure.

                                                                                            
Calling sequence:       
                                                                  
         t_handle        cring  : The coeff.ring for the elements in the dynamic
                                  array.
         dyn_arr_handle  d      : the dynamic array.
         vector          v      : the vector (which will be allocated in this
                                  function.

         
              conv_dyn_arr_to_vec (cring,d,&v);                                                     

History:
                                
      MD 93-02-12  first version                                       					

********************************************************************************/
{                         
     block_declarations;

     integer_small    i,j,n;
                        
   n = dyn_arr_curr_length (d);

   *v = vec_new (n);


   for (i=1;i<=n;i++)      
     vec_entry (*v,i) = dyn_arr_element (d,i-1);


   vec_incref_entries (cring,*v);


   return;
}
