
#include "kant.h"
#include "integer.e"
#include "inthdl.e"

integer_big
integer_read WITH_1_ARG(
	char *,	str
)
/*
** Reads one integer from string str.
** str of format -?[0-9]+
*/
{
	integer_small	i;
	t_handle		build_context;
	t_logical		negate;
	integer_big	result;
        block_declarations;       

	i = 0;

	negate = FALSE;
	if ( str[i] == '-' )
	{
		++i;
		negate = TRUE;
	}

	if ( str[i] == '\0' )
	{
		return 0;
	}

	if ( str[i] < '0' || str[i] > '9' )
	{
		error_internal( "non-digit passed to integer_read" );
	}

	build_context = integer_build_first( str[i] - '0' );

	while ( str[ ++i ] != '\0' )
	{
		if ( str[i] < '0' || str[i] > '9' )
		{
			error_internal( "non-digit passed to integer_read" );
		}

		integer_build_next( build_context, str[i] - '0' );
	}

	result = integer_build_end( build_context );

	if ( negate )
	{
		integer_big	temp;

		temp = integer_negate( result );
		integer_delete( &result );

		return temp;
	}

	return result;
}
