/******************************************************************************
  mat_real_orthonormal.c
******************************************************************************/
#include "kant.h"

t_void
mat_real_orthonormal WITH_4_ARGS (
	t_handle,	rrng,
	matrix,		mat,
	matrix*,	ortho,
	matrix*,	trans	
)

/******************************************************************************
 
Description:	Computes the orthonormal form of a (regular) real matrix
		using the algorithm from E.Schmidt.
 
Calling sequence:
 
	mat_real_orthonormal(rrng,mat,&ortho,&trans)

	t_handle	rrng	: the real ring of the coefficients
	matrix		mat	: the matrix to be orthonormalized
	matrix		ortho	: orthonormal form of mat
	matrix		trans	: transformation matrix from mat to ortho,
				  i.e. ortho = mat*trans
 
History:
 
	92-06-25 KW	transformation matrix
	92-05-06 KW	written
 
******************************************************************************/
{
	block_declarations;

	dyn_arr_handle	v;
	integer_small	i,j;
	integer_small	col,row;
	t_real		tempu,tempv,tempw;
	vector		tempa,tempb;

	col = mat_col(mat);
	row = mat_row(mat);
	
	*ortho = mat_ring_copy(rrng,mat);
	*trans = mat_ring_create_id(rrng,col);

	for (i=1;i<=col;i++)
	{
		tempa = mat_ring_col_to_vector(rrng,mat,i);
		for (j=1;j<=i-1;j++)
		{
			tempb = mat_ring_col_to_vector(rrng,*ortho,j);
			tempu = vec_ring_dot_product(rrng,tempa,tempb);
			tempv = real_negate(rrng,tempu);
			mat_ring_col_add(rrng,*ortho,j,i,tempv,1,row);
			mat_ring_col_add(rrng,*trans,j,i,tempv,1,col);
			vec_delete(rrng,&tempb);
			real_delete(&tempu);
			real_delete(&tempv);
		}
		vec_delete(rrng,&tempa);

		tempa = mat_ring_col_to_vector(rrng,*ortho,i);
		tempu = vec_ring_dot_product(rrng,tempa,tempa);
		tempv = real_inverse(rrng,tempu);
		tempw = real_sqrt(rrng,tempv);
		mat_ring_col_mult(rrng,*ortho,i,tempw,1,row);
		mat_ring_col_mult(rrng,*trans,i,tempw,1,col);
		vec_delete(rrng,&tempa);
		real_delete(&tempu);
		real_delete(&tempv);
		real_delete(&tempw);
	}
}
