/******************************************************************************
  mat_z_max.c
******************************************************************************/
 
#include "kant.h"
#include "integer.e"
#include "mat.h"

integer_big
mat_z_max WITH_1_ARG(
	matrix,		mat
)
/*******************************************************************************
 
Description:
 
	Computes the maximal entry (absolute value) of the matrix mat.
 
    
Calling sequence:
 
	max = mat_z_max(mat);

	matrix		mat	= matrix under consideration
        integer_big     max     = maximum of absolute values of entries
 
 
History:
 
	92-05-07 JS     integer_sign instead of _compare(.,0)
	91-10-01 JS     first version
  
*******************************************************************************/
{
	block_declarations;
 
	integer_big	temp0, temp1, temp2, maxi;
	integer_small	i, num;
 
	maxi = 0;           
	num = mat_row(mat) * mat_col(mat);
 
	for (i=1; i<=num; ++i)
	{
		temp0 = mat_entry(mat, i);
		temp1 = (integer_sign(temp0) < 0)
			? integer_negate(temp0)
			: integer_incref(temp0);
		if (integer_compare(temp1, maxi) > 0)
		{
			temp2 = maxi;
			maxi  = integer_incref(temp1);
			integer_delref(temp2);
		}
		integer_delref(temp1);
	}
 
	return maxi;
}
