/******************************************************************************
  order_equation_create.c
******************************************************************************/
 
#include "kant.h"
#include "z.e"
#include "poly.h"
#include "anf.h"

order
order_equation_create WITH_2_ARGS(
	order,		ordcoef,
	t_poly,	pol
)
/*******************************************************************************
 
Description:
 
	Creates the equation order given by the polynomial pol over the
        order ordcoef. This routine also generates the power base as
        ordcoef-basis for the order.


Calling sequence:
 
	ord = order_equation_create(Z, p);
 
      	order       ordcoef  = t_handle of coefficient order (e.g. Z)
      	t_poly   matr     = polynomial over coefficient order (monic)
 
  
History:
 
	92-03-06 JS    anf_delete
	92-02-26 JS    written
 
*******************************************************************************/
{                 
        anf     	field;
        integer_small   deg, npol;
        order           ord;
        t_handle          polh = m_poly_poly_to_handle(pol);
	t_handle	pring;
 
/*
    creating the quotient field and initializing the polynomial as first
    generating polynomial
*/                           
 
 
	field = anf_create();
 
	if (ring_type(ordcoef) == RING_Z) 
	{
	        deg = m_poly_expt(polh, m_poly_nterms(polh)-1);
		anf_abs_degree(field) = deg; 
		anf_poly_z_count_set(field, 1);
		anf_poly_z_poly(field, 1) = m_poly_z_incref(structure_pring_z, pol);
                npol = 1;
        }
        else
        {
                deg = 0;
		anf_poly_order_count_set(field, 1);
		pring = poly_str_create(ordcoef, 1);
		anf_poly_order_poly(field, 1) = poly_elt_incref(pring, pol);
		poly_str_delete(0, &pring);
                npol = -1;
        }
 
/*
    now we create the equation order over ordcoef
*/
 
	ord = order_create(field, ordcoef, deg, npol);
 
        anf_delete(&field);
 
        return ord;
}
 

