/*******************************************************************************
  order_fac_basis_create.c 
 
  This file contains:
  order_fac_basis_create
  we_can_take_it                    (check for nasty index divisors)
********************************************************************************/
                                                             
#include "kant.h"
                                
/* no index divisor over this number will be decomposed */
#define IND_DIV_MAX_P     50
/* also deg**p should not exceed this number */
#define IND_DIV_MAX_POW   100000

t_void     
order_fac_basis_create WITH_2_ARGS (order       , ord,
                                    integer_big , bound)
/*******************************************************************************
 
Description:
   
   Computes a factor basis of prime ideals. All these prime ideals have a  
   norm <= bound.
   The factor basis will be stored within the structure of ord.


Calling sequence:
                                                           
          order       ord   :  The order start has to be the ring of integers 
                               of a number field.
                               
          integer_big bound :  The upper bound for the norm of the ideals that 
                               will be stored 

      fac_basis_create (ord,bound);                       

                            
History:                                 
           
   92-09-16 JS	  index divisor now possible
   91-10-01 JS	  deletion of stripped_list also if empty
   MD 09.04.92    written                    

********************************************************************************/
{
	block_declarations;         

        dyn_arr_handle    prime_list,fac_basis;
        t_handle            fclst,stripped_list; 
        anf_ideal         ideal;


        integer_small     i,j,primes_in_fac,ideals_in_fac;
        integer_small     len,len_fac,len_stripped;
        integer_big       norm,den;
 
        t_logical           we_can_take_it();
                            

/* Get all primes below bound */
  prime_list = integer_read_primes (bound);

 
/* Now compute all prime ideals lying above these rational primes    */ 
/* We check if a prime is a index divisor, since we cant decompose  */
/* ideals above such numbers                                         */

  len = dyn_arr_curr_length (prime_list); /* total no. of primes                     */
  primes_in_fac = 0;                      /* no. of primes added to the factor basis */                  
  ideals_in_fac = 0;                      /* no. of prime - ideals added to the      */
                                          /* factor basis                            */

  order_fac_basis_alloc (ord,len);        /* We already know how much space */
                                          /* we need  (in worst case)       */


  for (i=len-1;i>=0;i--)  
  {                                                        
    if (we_can_take_it(ord,dyn_arr_element (prime_list,i)))  /* Now check for "index divisors" */
    { 
      fclst = order_prime_factorize (ord,dyn_arr_element (prime_list,i));     
               

/* We only want the prime ideals with norm below bound. So we have */
/* to check each ideal in fclst                                   */
   
      len_fac = m_poly_z_faclst_len  (fclst);

      len_stripped = 0;
      stripped_list = m_poly_z_faclst_alloc (len_fac);
      m_poly_z_faclst_len_put (stripped_list,len_stripped);

      for (j=0;j<len_fac;j++)
      {

/* Now take an ideal from fclst and compute it`s norm */

        ideal = m_poly_z_faclst_factor (fclst,j);
        anf_ideal_norm (ord,ideal,&norm,&den);
                      
        if (integer_compare (norm,bound) <=0)
        {                    
/* Adding a new prime to the factor basis   */       

          m_poly_z_faclst_factor (stripped_list,len_stripped) = anf_ideal_incref (ideal); 
          m_poly_z_faclst_power (stripped_list,len_stripped) = 
                                        integer_incref (m_poly_z_faclst_power (fclst,j)); 
          len_stripped++;
          m_poly_z_faclst_len_put (stripped_list,len_stripped);
        }                 

        integer_delref (norm);
        integer_delref (den);
      }                      
                      
      anf_ideal_faclst_delete (ord,&fclst);

      if (len_stripped >0)             /* There are prime-ideals                         */
      {                                            
        primes_in_fac++;               /* We have to add a new prime to the factor basis */
        ideals_in_fac += len_stripped; /* Update of the total no. of ideals in fac. bas. */


/* Add prime number and ideal to the factor basis */

        order_fac_basis_prime (ord,primes_in_fac)  = 
                               integer_incref (dyn_arr_element (prime_list,i));
        order_fac_basis_ideals (ord,primes_in_fac) = stripped_list;

        order_fac_basis_len_set (ord,primes_in_fac);
      }
      else
      {
        anf_ideal_faclst_delete (ord, &stripped_list);
      }

    }
    else
      if (anf_print_level >2)
        cay_print ("sorry index div.:  %d\n",dyn_arr_element (prime_list,i));
  
    integer_delref (dyn_arr_element (prime_list,i));

  }

  order_fac_basis_ideals_count_set (ord,ideals_in_fac);  /* Store the total number of ideals */
                                                         /* in the factor basis              */

  dyn_arr_delete (&prime_list); 
 
 
	if(anf_print_level > 0)
        {
		printf("Factor basis created: %d primes below %d (%d ideals).\n",
                        order_fac_basis_len(ord), bound,
			order_fac_basis_ideals_count(ord));
        }
} 

 
 
t_logical we_can_take_it(ord, p)
        order 		ord;
        integer_big     p;
{
        block_declarations;
 
        integer_big     poww;
 
        if (!is_index_divisor(ord, p)) return TRUE;
 
        if (integer_compare(p, IND_DIV_MAX_P) > 0) return FALSE;
 
        poww = integer_power(p, order_abs_degree(ord));
 
        if (integer_compare(poww, IND_DIV_MAX_POW) > 1)
        {
                integer_delref(poww);
                return FALSE;
        }          
 
        return TRUE;
}
