/*******************************************************************************
  order_fac_basis_delete.c 
********************************************************************************/

                                                             
#include <stdio.h>
#include "kant.h"
#include "integer.e" 
#include "dyn_arr.h"
#include "poly.h"      /* Kein Wort darueber */
#include "poly_z_faclst.h"
#include "anf.h"

void     
order_fac_basis_delete WITH_1_ARG (order       , ord)
/*******************************************************************************
Description:
   
   Deletes all fac_basis entries in the structure of order.

Calling sequence:
                                                           
          order       ord   :  The order ord has to be the ring of integers 
                               of a number field.
                               

      order_fac_basis_delete (ord);                       

                            
History:                                 
           

   JS 12.05.92    immediate return if no fac_basis is given
   MD 07.05.92    written                    

********************************************************************************/
{
	block_declarations;         

        t_handle            fclst; 
        dyn_arr_handle    fac_bas;
       
        int               i,len;
 
/*
    nothing to do?
*/
 
        if (!order_fac_basis(ord)) return;

/* We are not going to delete the entry order_fac_basis_ideals_count (ord), */
/* since this is obviously always a small integer.                          */

  len = order_fac_basis_len (ord);
  for (i=1;i<=len;i++)
  {
    integer_delref (order_fac_basis_prime (ord,i));  /* Deletion of the prime */

    fclst = order_fac_basis_ideals (ord,i);
    anf_ideal_faclst_delete (ord,&fclst);           /* Deletion of the ideal list */
  }                               
 

/* Now delete the "empty" dynamic array  */
 
  fac_bas = order_fac_basis (ord);                         
  dyn_arr_delete (&fac_bas);
 
  order_fac_basis(ord) = MEM_NH;

}




