/*******************************************************************************
  order_fincke_rbounds_calc.c 
********************************************************************************/


#include "kant.h"




t_void
order_fincke_rbounds_calc WITH_1_ARG (order , ord)
/*******************************************************************************
 
Description:
 
     Computes the bounds r_i for Finckes algorithm and stores the values in the 
     structure of ord.
 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 

          order_fincke_rbounds_calc (ord);
 
History:
 
        93-02-11 MD     LLL reduction of units added
	92-07-22 MD     written
 
*******************************************************************************/
{
  	 block_declarations;

                          
         t_handle          R;

         t_real          lambda_log,bound;
         t_real          temp1,temp2,two;
         
         matrix          units_logs;         

         integer_small   n,r,r2,r1,i,j;



    if (!order_units_known (ord))
      order_units_calc (ord);


    if (!order_units_logs_known (ord))  
      order_units_logs_calc (ord);                  

    order_units_lll_reduce (ord);  


    if (!order_fincke_rbounds_known (ord))
      order_fincke_rbounds_assure (ord);
      

    n  = order_abs_degree (ord);                           
    
    r1 = order_r1 (ord);
    r2 = order_r2 (ord);
    r  = order_r1 (ord) + order_r2 (ord) - 1;

    R = order_reals (ord);

    lambda_log = real_log (R,order_fincke_lambda (ord));
    two        = conv_int_to_real (R,2);

    units_logs = order_units_logs (ord);




    for (i=1;i<=r+1;i++)
    {
       bound  = conv_int_to_real (R,0);

/*       printf (" bound (%d)  in steps :  ",i); */

       for (j=1;j<=r;j++)
       {    
                                                        
         temp1  = real_abs (R,mat_elt (units_logs,i,j));

         temp2  = bound;
         bound  = real_add (R,temp1,temp2);
         
/*         printf ("--->");real_write (R,bound,5);printf ("\n"); */


         real_delete (&temp1);
         real_delete (&temp2);
       }                                           
        
       temp1  = bound;
       bound = real_divide (R,temp1,lambda_log);
       real_delete (&temp1);

       integer_delref (order_fincke_rbound (ord,i));


/*       printf ("bound (%d) = ",i);real_write (R,bound,10);puts (""); */
  
                   order_fincke_rbound (ord,i)    = conv_real_to_int_ceil (R,bound);
       if (i > r1) order_fincke_rbound (ord,i+r2) = conv_real_to_int_ceil (R,bound);
                  


                   
       real_delete (&bound);
    }                  
 
    real_delete (&lambda_log);
    real_delete (&two);
}

