/*******************************************************************************
  order_maximal_get_index_factors.c 
********************************************************************************/

                                                             
#include <stdio.h>
#include "kant.h" 
#include "anf.h" 
#include "faclst.e" 
#include "faclst.h"

t_logical
order_maximal_get_index_factors WITH_2_ARGS (order   , start,
                                             faclst* , facs   )
/*******************************************************************************

Description:
                       
    Computes all primes p with R(p) <>ZZ[a] (possibly) and returns these
    primes with an upper bound for 
                 
                        | Index(R(p)) |         (p-adic-val. of the index)
                                       p                                  
    The function returns true if there are any primes.

                                                      
Calling sequence:

               order    start             : We want to compute the maximal order 
                                            starting with the order start.
               faclst   facs              : The primes with a "real" p-maxx. 
                                            overorder and upper bounds for the 
                                            index.

               t_logical  there_are_factors : the equation order is (or is not)
                                            maximal.

                                                    
       there_are_factors = order_maximal_get_index_factors (start,&facs);
       
                            
History:                                 
 
 	92-06-05 JS    slightly changed output
 	92-05-07 MD    first version

********************************************************************************/
{
	block_declarations;         

        anf             field;
        t_handle          Z; 

	faclst		r_facs;                 
        t_logical         disc_factors,rdisc_factors,
                        there_are_factors;

        integer_big     prime,red_disc;
        integer_small   i;
        integer_small   maxx;

                

  Z      = order_coef_order(start);  /* We will need Z for some function calls */
  field  = order_anf (start);

  order_disc_assure (start);


  if (order_basis_is_power (start))   /* We are starting with the equation order   */
  {                                   /* So we are using the red. disc, too        */

  /* Diese 1 muesste noch passend ersetzt werden. (Nr. des Polynoms in der Liste)  */

    anf_rdisc_calc (field,1);                 /* Compute the red. disc.            */
    anf_rdisc_factors_get (field,1);          /* Now factorize it                  */
    r_facs = anf_poly_z_rdisc_fac (field,1);  /* Get the t_handle                    */          
                           

    disc_factors_get ( start,facs,r_facs);    /* Factorize the disc with           */
                                              /* information gained by the rdisc   */

/* Check for square factors and run Dedekind test */       
    there_are_factors  = disc_factors_strip (start,facs); 
  
            
  }  
  else
    {                              
      r_facs = MEM_NH;
      disc_factors_get (start,facs,r_facs);               


/* Check for square factors and run Dedekind test */       
      there_are_factors = disc_factors_strip (start,facs);
    }


  if (anf_print_level > 0) /* Do some general output */
  {                         
    cay_print ("Order discriminant:   %d\n",order_disc (start));         
    cay_print ("Reduced discriminant: %d\n",anf_poly_z_rdisc(field,1));

    if  (there_are_factors)
    {                                        
      printf("Factors of discriminant with (possibly) R(p) != ZZ[a] : ");
      faclst_print(*facs); 
    } 
    else               
      {
        printf ("There are no factors with (possibly) R(p) != ZZ[a] !\n");
      }       
  }           


   return there_are_factors; 
}

